 /********************************************************************/
 /*                                                                  */
 /* Special Characters: () OR, (^) NOT.                             */
 /*                                                                  */
 /* Module:      archive_key_: Generate Archive keys                 */
 /*                                                                  */
 /* Author:      Peter Flass <Peter_Flass@Yahoo.com>                 */
 /*              June, 2001                                          */
 /*                                                                  */
 /* Function:    Generate array of keys and codes for use by the     */
 /*              archive command.                                    */
 /*                                                                  */
 /* Description: This is a PL/I version of archive_key_.alm          */
 /*              to support the archive port to non-Multics systems. */
 /*              'BGN' and 'END' keys added to table to simplify     */
 /*              PL/I macro generation. Code bitstring expanded      */
 /*              to 32 bits from the original 18.                    */
 /*                                                                  */
 /* ============>                                                    */
 /*              This code was written to be preprocessed by         */
 /*              MVS PL/I 1.1 and the preprocessor output            */
 /*              transferred to OS/2 and compiled (don't ask).       */
 /* ============>                                                    */
 /*                                                                  */
 /* Exports:     archive_key_$begin_table:  start of keys table      */
 /*              archive_key_$last_index:   number of key entries    */
 /*                                                                  */
 /* declare 1  archive_key_$begin_table(archive_key_$last_index)     */
 /*                         unaligned external,                      */
 /*       2 key    char(4),                                          */
 /*       2 type   bit(2),  0=table, 1=replace, 2=extract, 3=delete  */
 /*       2 update bit(1),                                           */
 /*       2 append bit(1),                                           */
 /*       2 copy   bit(1),                                           */
 /*       2 delete bit(1),                                           */
 /*       2 force  bit(1),                                           */
 /*       2 long   bit(1),                                           */
 /*       2 zero_arg_ok bit(1),                                      */
 /*       2 star_ok     bit(1),                                      */
 /*       2 empty_ok    bit(1),                                      */
 /*       2 no_orig_ok  bit(1),                                      */
 /*       2 brief       bit(1),                                      */
 /*       2 *           bit(19);                                     */
 /*                                                                  */
 /********************************************************************/
 archive_key_: PROC;
   %declare last_index fixed;
   %last_index=0;
   %deactivate last_index;

   %k: procedure(key,type,opt) statement returns(character);
     declare key  character;
     declare type character;
     declare opt  character;
     declare b    character;
     declare r    character;
     declare n    fixed;
     declare t    character;
     b = '00000000000000000000000000000000';
     r='';
     if key='BGN' then do;
       r = ' dcl 1 archive_key_$begin_table' 
           ' static external unaligned';
       last_index=0;
       return(r);
       end;
     if key='END' then do;
       r = r  ';' ;
       r = r  ' dcl archive_key_$last_index' 
                ' static external fixed bin(31)' 
                ' init('  last_index  ');' ;
       return(r);
       end;

     key = substr(key,2,length(key)-2);
     if length(key)<4 then key = key  substr('    ',1,4-length(key));
     key = ''''  key  '''';
     last_index = last_index+1;
     if      type='REPLACE' then b = '01'  substr(b,3);
     else if type='EXTRACT' then b = '10'  substr(b,3);
     else if type='DELETE'  then b = '11'  substr(b,3);
     else if type='TABLE'   then b = '00'  substr(b,3);
     else do;
       note( 'Invalid type '  type, 8 );
       r='';
       end;
     if length(opt)=0 then goto NOOPT;
     if substr(opt,1,1)='(' then opt=substr(opt,2,length(opt)-1);

 GOPT:
     n = index(opt,',');
     if n^=0 then do;
       t = substr(opt,1,n-1);
       opt = substr(opt,n+1);
       end;
     else do;
       t = opt;
       opt='';
       end;
     if t='UPDATE'
       then b = substr(b,1,2)  '1'  substr(b,4);
     else if t='APPEND'
       then b = substr(b,1,3)  '1'  substr(b,5);
     else if t='COPY'
       then b = substr(b,1,4)  '1'  substr(b,6);
     else if t='DEL'
       then b = substr(b,1,5)  '1'  substr(b,7);
     else if t='FORCE'
       then b = substr(b,1,6)  '1'  substr(b,8);
     else if t='LONG'
       then b = substr(b,1,7)  '1'  substr(b,9);
     else if t='ZARG'
       then b = substr(b,1,8)  '1'  substr(b,10);
     else if t='STAR'
       then b = substr(b,1,9)  '1'  substr(b,11);
     else if t='EMPTY'
       then b = substr(b,1,10)  '1'  substr(b,12);
     else if t='NORIG'
       then b = substr(b,1,11)  '1'  substr(b,13);
     else if t='BRIEF'
       then b = substr(b,1,12)  '1'  substr(b,14);
     else note( 'Invalid option '  t, 8 );
     if length(opt)>0 then goto GOPT;

 NOOPT:
     r = r  ', 2 f'  counter  ',';
     r = r  ' 3 k char(4) init('  key   '),' ;
     r = r  ' 3 b bit(32) init('''  b  '''b)';
     return(r);
     %end k;

   %activate k;
   k key(BGN);
   k key('r')    type(replace) opt(empty,norig,zarg);
   k key('rd')   type(replace) opt(del,empty,norig,zarg);
   k key('rdf')  type(replace) opt(del,force,empty,norig,zarg);
   k key('cr')   type(replace) opt(copy,empty,norig,zarg);
   k key('crd')  type(replace) opt(copy,del,empty,norig,zarg);
   k key('crdf') type(replace) opt(copy,del,force,empty,norig,zarg);
   k key('u')    type(replace) opt(update,zarg);
   k key('ud')   type(replace) opt(update,zarg,del);
   k key('udf')  type(replace) opt(update,zarg,del,force);
   k key('cu')   type(replace) opt(copy,update,zarg);
   k key('cud')  type(replace) opt(copy,update,zarg,del);
   k key('cudf') type(replace) opt(copy,update,zarg,del,force);
   k key('a')    type(replace) opt(append,empty,norig);
   k key('ad')   type(replace) opt(append,empty,norig,del);
   k key('adf')  type(replace) opt(append,empty,norig,del,force);
   k key('ca')   type(replace) opt(copy,append,empty,norig);
   k key('cad')  type(replace) opt(copy,append,empty,norig,del);
   k key('cadf') type(replace) opt(copy,append,empty,norig,del,force);
   k key('d')    type(delete);
   k key('cd')   type(delete)  opt(copy);
   k key('x')    type(extract) opt(zarg,star);
   k key('xd')   type(extract) opt(zarg,star,del);
   k key('xdf')  type(extract) opt(zarg,star,del,force);
   k key('xf')   type(extract) opt(zarg,star,force);
   k key('t')    type(table)   opt(star,zarg);
   k key('tl')   type(table)   opt(long,star,zarg);
   k key('tb')   type(table)   opt(star,zarg,brief);
   k key('tlb')  type(table)   opt(long,star,zarg,brief);
   k key(END);

   end archive_key_;
