/****************************************************************************/
/* LDBkup is a REXX application to backup multiple large system drives      */
/* on a LAN. LDBkup uses RAR with the "Volume-splitting" feature to         */ 
/* create multi-part archives.                                              */
/*                                                                          */
/* RAR is copyrighted by Eugene Roshal and must be purchased                */
/* separately.  Download the OS/2 - DOS trial version from                  */
/* http://www.rarlabs.com/download.htm .                                    */
/****************************************************************************/

DEBUG=VALUE(LD_DEBUG,,'OS2ENVIRONMENT')

IF DEBUG = 1 THEN TRACE ?i

CALL LoadRexxUtil                              /* Load Rexx System Library */

NEWDIRECTORY=VALUE(LD_HOME,,'OS2ENVIRONMENT')
OutputDrive = '\\SERVER\WDRIVE'                /* Default backup location */

IF NEWDIRECTORY='' THEN
   OldDirectory = DIRECTORY('G:\LDBkup')
ELSE
   OldDirectory = Directory(NEWDIRECTORY)   

IF DEBUG = 1 THEN TRACE ?i

NewDrive=VALUE(LD_OUTPUT,,'OS2ENVIRONMENT')

IF NewDrive <> '' THEN OutputDrive = NewDrive 

"@IF EXIST log.txt ERASE log.txt"
"@IF EXIST err.txt ERASE err.txt"

IF (STREAM('W:\','c','query exists') = '') THEN
   DO
      "NET USE W: "||OutputDrive
   END

IF RC == 2 THEN
DO
   SAY "Unable to make a connection with the Backup Drive."
   SAY "Program aborted."
   RETURN
   EXIT
END

crlf = '0D0A'x;

RRC = 0

/* Type of Backup */

IF DEBUG=1 THEN trace ?i

BackupType = '';

DriveLetters. = '' ;
DriveLetters.0 = 0 ;

ARG BackupType Drives 

/***********************************************************************/
/*                                                                     */
/*                        MAIN PROCEDURE                               */
/*                                                                     */
/***********************************************************************/


GetDriveLetters:

IF DEBUG=1 THEN trace ?i

   k = 1 ;
   PARSE VAR Drives DriveLetters.1 Drives  

IF DriveLetters.k <> '' THEN 
      DO WHILE DriveLetters.k <> ''
         DriveLetters.0 = DriveLetters.0 + 1
         CALL VolumeBkup
   		IF DEBUG=1 THEN trace ?i
         IF RRC > 1 THEN EXIT
         k = k + 1
         PARSE VAR Drives DriveLetters.k Drives
      END
   ELSE
      DO
			RRC = 251                 /* Set error code for invalid parameters */
         CALL DisplayErrorCode RC, RRC, FilesTemp.0

   IF DEBUG=1 THEN trace ?i

         EXIT
      END
      
EXIT

/******************************************/
/*  Procedure to handle a single volume   */
/******************************************/


VolumeBkup:  PROCEDURE EXPOSE BackupType DriveLetters. k RRC

   DriveLetter1 = SUBSTR(DriveLetters.k,1,1)

   BaseBkupFile = BackupType ||'_'DriveLetter1'_'

   SourcePath = "'"DriveLetters.k"'"

	BadFile = 'FALSE'

/* Determine the type of backup and execute the appropriate procedure */

IF DEBUG=1 THEN trace ?i

   		SELECT 
      		WHEN  BackupType = 'FULL' THEN
						DO
	            		RARCMD1 = "RAR 'a -r -dh -agYYYYMMDD-NN -cfg- -s -v2000000k -ds -m4 -ierr.txt ' ||  'W:\' || BaseBkupFile  || ' @FilesList.lst -x wp?root.?sf >> log.txt'"
							BackupTypeDesc = 'FULL'
						END
      		WHEN  BackupType = 'DIFF' THEN
						DO
            			RARCMD1 = "RAR 'a -r -dh -agYYYYMMDD-NN -cfg- -s -v2000000k -ds -m4 -ierr.txt ' ||  'W:\' || BaseBkupFile  || ' @FilesList.lst -x wp?root.?sf >> log.txt'"
							BackupTypeDesc = 'DIFFERENTIAL'
						END
      		WHEN  BackupType = 'UPDATE' THEN
						DO
            			RARCMD1 = "RAR 'u -r -dh -agYYYYMMDD-NN -cfg- -v2000000k -ds -m4 -ao -ierr.txt ' || 'W:\' || BaseBkupFile  || ' @FilesList.lst -x wp?root.?sf >> log.txt'"
							BackupTypeDesc = 'UPDATE'
						END
   		OTHERWISE
      		SAY 'Invalid backup type specified.  Valid backup types are FULL, DIFF, UPDATE.'
      		EXIT
			END

	IF DEBUG=1 THEN trace ?i

   CALL BkupProc              /* Call the actual backup procedure */

	IF DEBUG=1 THEN trace ?i

   SIGNAL DisplayErrorCode

   RETURN  RRC

   

END VolumeBkup

/***************************************************************************/
/*  Finally we actually backup the drive and reset the Archive attributes  */
/*  RARCMD1 *must* set to the correct value before calling this procedure! */
/***************************************************************************/
BkupProc:

IF DEBUG=1 THEN trace ?i

CALL BuildListFiles  DriveLetters. k FilesList.lst 

/* The following code will skip the RAR command on a differential backup */
/* IF there are no files to backup (excluding EA?DATA. SF .)     */

CALL LINEOUT 'STDOUT:',''                 /* Generate a blank line on the screen   */
CALL LINEOUT 'STDOUT:',''                 /* Generate another blank line */



say 'Initiating a '||BackupTypeDesc|| ' backup of Logical Drive '|| DriveLetters.k||'.'

'@echo off'
   IF RC = 0 THEN
      DO
         INTERPRET RARCMD1
         RRC = RC
      END
'@echo on'

   CALL STREAM LOG.TXT,'c','close'

   i = 1                         /* Initialize file count index. */

   DO WHILE i <= FilesTemp.0
      IF (SysFileTree(FilesTemp.i, ArchTemp.,'BSO','+****','-****') <> 0) THEN
         DO
            RRC=253      
            SIGNAL DisplayErrorCode
         END

      i = i + 1
   END

   RETURN RRC         
END

/***********************************************************************/

BuildListFiles: PROCEDURE EXPOSE DriveLetters. k FilesList.lst FilesTemp. BackupType rrc rc BadFile

   "@IF EXIST FilesList.lst ERASE FilesList.lst"
   CALL STREAM FilesList.lst,'c','open'
   CALL STREAM FilesList.lst,'s'

   IF result='READY' THEN result=0
   
   SELECT 
      WHEN BackupType = 'FULL' THEN
         rc = SysFileTree(DriveLetters.k || '\*',FilesTemp.,'BSO','*****')
      WHEN BackupType = 'DIFF' THEN
         rc = SysFileTree(DriveLetters.k || '\*',FilesTemp.,'BSO','+****')
      OTHERWISE
         CALL LINEOUT log.txt,'Internal error: Invalid Backup Type error encountered in BuildListFiles.'
         RRC = 252
         SIGNAL DisplayErrorCode
      
   END
   
   IF (result = 0) & (rc = 0) THEN
      DO  i=1 TO FilesTemp.0

      /* This section copies the filenames from FilesTemp. to the hard drive */
      /* It watches for the files "EA DATA. SF" and "SWAPPER.DAT", which RAR */
      /* is unable to backup. If either one is encountered, it will not be   */
      /* written out, and the file count will be reduced by 1. In addition,  */
      /* the "BadFile" flag is set for DisplayErrorCode to examine.          */

         TempFName = FILESPEC('n',FilesTemp.i)
         IF (TempFName <> 'EA DATA. SF') & (TempFName <> 'SWAPPER.DAT') THEN 
            DO
               CALL LINEOUT FilesList.lst,FilesTemp.i
            END
         ELSE
				DO
            	FilesTemp.0 = FilesTemp.0 - 1     /* Adjust file count */
            	BadFile = "TRUE"
				END

         CALL STREAM  FilesList.lst,'s'
         IF (Result='READY') THEN 
            DO 
               Result=0
               rc = 0 
            END
         IF (Result<>0) | (rc<>0) THEN
            DO
               SAY 'Internal error while building list of files.'
               SAY 'Backup of drive ' || DriveLetters.k || ' will be skipped.'
               CALL LINEOUT log.txt,'Error occurred while attempting to construct ListFiles.1st for Drive ' || DriveLetters.k
               IF rc = 2 THEN 
                  DO
                     SAY 'Insufficient memory was available to construct list in memory.'
                     CALL LINEOUT log.txt,'Insufficient memory was available to construct list in memory.'
                     RETURN 254
                  END
            END
      END

      CALL STREAM FilesList.lst,'c','close'  /* Close output file */

      IF result = 'READY:' THEN 
         DO
            result = 0
            rc = 0
            rrc = 0
         END

   RETURN RRC

END

/*******************************/
/*  Error Handling Procedure   */
/*******************************/

DisplayErrorCode:


IF DEBUG=1 THEN trace ?i


   CALL LINEOUT 'STDOUT:',''                 /* Generate blank line on the screen */

   /*  The next group of statements filter out warnings caused by no changes on a differential backup */

   IF (RRC = 1) & (BadFile = 'TRUE')  THEN SIGNAL SUCCESS 
   IF (RRC = 1) & (BackupType = 'DIFF') THEN 
      DO 
         rc = SysFileTree(DeviceLetters.k||'\EA DATA. SF', ArchTemp.,'BSO', '+****')
         rc1 = SysFileTree(DeviceLetters.k||'\SWAPPER.DAT', Archtemp1.,'BSO', '+****')
         IF (rc = 0) & (rc1 = 0) & (ArchTemp.0 = 0) & (ArchTemp1.0 = 0) THEN SIGNAL SUCCESS
      END
         

   IF RRC = 255 THEN SAY "User stopped the process."
   IF RRC = 254 THEN SAY "INTERNAL WRITE ERROR: Error while creating FileList.lst; Drive DrivesLetter.k will be skipped."
   IF RRC = 253 THEN SAY "ARCHIVE FLAGS ERROR: Error encountered while resetting Archive attributes."
   IF RRC = 252 THEN SAY "BACKUP TYPE ERROR: Program error: Invalid Backup Type encountered in BuildListFiles.  Contact author."
	IF RRC = 251 THEN SAY "INVALID PARAMETERS: At least one drive must be specified."
   IF (RRC>9)&(RRC<251) THEN SAY "UNKNOWN: Error is undocumented or unknown." 
   IF RRC = 9   THEN SAY "FILE CREATE ERROR: File Create' error"
   IF RRC = 8   THEN SAY "MEMORY ERROR:      Not enough memory for operation."
   IF RRC = 7   THEN SAY "USER ERROR:        Command line option error."
   IF RRC = 6   THEN SAY "OPEN ERROR:        Open file error."
   IF RRC = 5   THEN SAY "WRITE ERROR:       Write to disk error."
   IF RRC = 4   THEN SAY "LOCKED ARCHIVE:    Attempt to modify an archive previously locked by the 'k' command."
   IF RRC = 3   THEN SAY "CRC ERROR:         A CRC error occurred when unpacking."
   IF RRC = 2   THEN SAY "FATAL ERROR:       A fatal error occurred."
   IF RRC = 1   THEN SAY "WARNING:           Non-fatal error(s) occurred." 

WARNING:
      IF RRC = 0 THEN 
         SIGNAL SUCCESS

/*      SAY 'The return code from RAR is ' RRC ' .  Check the logs for more information.' */

      IF RRC = 1 THEN
         DO
            SAY 'The return code from RAR is ' RRC '.  Check the logs for more information.'
            RETURN RRC
         END               

ERROR:
      IF RRC <> 253 THEN
         DO
            SAY "Aborting the program."     
            EXIT                            /* Exit the program */
         END
      ELSE
         RETURN RRC

SUCCESS:

      SAY "SUCCESSFUL backup.  No errors or warnings."
      SAY ""
      SAY "Check the logs for additional information."

      RRC = 0
      RC  = 0
      Result = 0
      RETURN RRC
END   BuildListFiles

         
/* Function to load Rexx Utility library if not registered */

LoadRexxUtil:
   IF RxFuncQuery("SysLoadFuncs") THEN
      DO
         IF RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs") THEN
            DO
               SAY "Error:  Couldn't load RexxUtil library."
               RETURN 1
            END

         CALL SysLoadFuncs
      END

   RETURN 0
END   

