/* --------------------------------------------------------------------------
 app_msgs.h :

 16 Jun 2006 - Alessandro Felice Cantatore

- Notes : french translation by Guillaume Gay - 2006-12-30
- Contents: french messages for fsj v1.0

-------------------------------------------------------------------------- */


#ifndef _APP_MSGS_H_
   #define _APP_MSGS_H_

// error message prefixes/suffixes

#define SZ_ERRPREFIX \
   "Erreur : "

#define SZ_READHELP \
   "\r\nTapez \"FSJ ?\" pour obtenir des dtails sur l'utilisation du programme.\r\n"

#define SZ_SUFFIX \
   ".\r\n"

// generic errors

#define SZERR_ALLOCATION \
   "chec  l'allocation de %u octets (DosAllocMem a retourn %d)"

// argument parsing and initialization errors

#define SZERR_INVALIDCOMMAND \
   "commande incorrecte :\r\n%s\r\n%s"

#define SZERR_INVALIDOPTION \
   "option incorrecte :\r\n%s.\r\n%s"

#define SZERR_VALIDCMDLIST \
   "Les seules commandes correctes sont : ? (aide), S (dcoupage) et J (recomposition)."

#define SZERR_NOSPLITCOUNT \
   "La taille ou le nombre de parties du fichier n'a pas t indiqu"

#define SZERR_CANTSPLIT01  \
   "Un fichier ne peut pas tre dcoup en moins de 2 parties"

#define SZERR_TOOMANYPIECES \
   "Trop grand nombre de parties de fichier (%u)"

#define SZERR_SPLITUNIT \
   "Unit de mesure de dcoupage inconnue"

#define SZERR_MAXPRMEM \
   "chec  l'obtention du maximum de mmoire allouable"

#define SZERR_BUFFSIZENOTNUM \
   "la valeur de la taille de tampon doit tre donne en chiffres dcimaux"

#define SZERR_INVALIDOPT_ONJOIN \
   "option incorrecte :\r\n%s\r\n"\
   "n'est pas compatible avec la recomposition de fichier"

#define SZERR_OPTDUP \
   "l'option % .2s a dj t donne.\r\n"\
   "Les valeurs prcdentes de l'option ont t annules"

#define SZERR_OPTDUP2 \
   "l'option % .2s a dj t donne."\

#define SZERR_INVALIDOPT_ONSPLIT \
   "option incorrecte :\r\n%s\r\n"\
   "n'est pas compatible avec la dcoupe de fichier"

#define SZERR_MISSPATH \
   "aucun chemin indiqu pour l'option % .2s"

#define SZERR_INCOMPATIBLEOPT \
   "cette option (% .2s) n'est pas compatible avec /%c"

#define SZERR_MISSINGLISTFILE \
   "le nom du fichier contenant la liste des parties du fichier\r\n"\
   "n'a pas t indiqu"

#define SZERR_INVALIDLISTFILE \
   "la liste des parties du fichier ne contient qu'une ou aucune entre"

#define SZERR_LISTFILETOOLARGE \
   "la taille de fichier de la liste des parties du fichier excde %u Mo (%llu)"

#define SZERR_LISTFILETOOMANYENTRIES \
   "la liste des parties du fichier contient trop d'entres (%u)"

#define SZERR_INVALIDPIECESCOUNT \
   "nombre de parties du fichier non prcis ou incorrect"

#define SZERR_MISSOPTPARMS \
   "Certains paramtres d'option requis n'ont pas t indiqus ou sont incorrects"

#define SZERR_MASKEDPATH \
   "le caractre joker ('?') n'est pas autoris dans le chemin :\r\n"\
   "(%s)\r\n"

#define SZERR_INVALID_FILE_PART_NAME \
   "le masque indiquant les noms des parties du fichier :\r\n%s\r\n"\
   "ne contient pas un nombre correct de chiffres.\r\n"\
   "Utilisez un bloc de caractres '?' correspondant au nombre de chiffres\r\n"\
   " utiliser pour le numro d'index de chaque partie du fichier"

#define SZERR_OPTPRIORITY \
   "le paramtre de modification de priorit de processus est incorrect"

#define SZERR_SETPRIORITY \
   "chec  la modification de la priorit de processus.\r\n"\
   "DosSetPriority() a retourn %d"

#define SZERR_OPTPAUSE \
   "aucune confirmation ne sera demande avant de lire/crire\r\n"\
   "une partie de fichier"

#define SZERR_OPTPAUSE2 \
   "cette option est ignore puisqu'incompatible avec /U"

#define SZERR_UNEXPECTEDPARM \
   "paramtre inattendu :\r\n%s\r\n%s"

#define SZERR_DUPSPLITFILE \
   "paramtre doublon (nom du fichier  dcouper)"

#define SZERR_DUPFILEPIECES \
   "paramtre doublon (spcification des parties du fichier)"

#define SZERR_TOOMANYPARMS \
   "trop de paramtres de ligne de commandes"

#define SZERR_UNSPEC_SPLITFILE \
   "le nom du fichier  dcouper n'a pas t indiqu"

#define SZERR_SPLIT_EMPTYFILE \
   "la taille du fichier :\r\n"\
   "%s\r\n"\
   "est de %lld octet.\r\n"\
   "Aucune opration de dcoupage n'est possible"

#define SZERR_PIECE_GT_WHOLE \
   "rien  faire.\r\n" \
   "la taille de la partie du fichier est plus grande que\r\n"\
   "celle du fichier tout entier"

#define SZERR_PIECESGT_SIZE \
   "la taille de l'ensemble des parties du fichier est plus grande\r\n"\
   "que celle du fichier tout entier"

#define SZERR_CREATE_JOIN_CMD \
   "chec  la cration du fichier de batch :\r\n%s\r\npour la recomposition du fichier"

#define SZERR_MISSJOINPIECES \
   "aucun fichier  recomposer n'a t indiqu"

#define SZERR_JOINONLY1 \
   "seul un fichier  t indiqu pour la recomposition"

#define SZERR_PATHCONFLICT \
   "utilisation des 2 options /%c et /%c impossible.\r\n"\
   "Le chemin des fichiers  joindre doit tre donn avec l'option /%c"

#define SZERR_QUERYFREESPACE \
   "chec  l'obtention de la quantit d'espace disponible sur l'unit %c:.\r\n"\
   "DosQueryFSInfo() a retourn %d"

#define SZERR_DISKFULL \
   "espace disque insuffisant pour l'opration demande"

// initialization messages

#define SZ_READINGLISTFILE \
   "Obtention de la liste des parties du fichier dans :\r\n%s."

#define SZ_CALCWHOLEFILESIZE \
   "Calcul de la taille de :\r\n"\
   "%s\r\n"\
   " crer  partir de la concatnation des %d fichiers..."

// text message
#define SZ_OPENSPLITFILE \
   "Ouverture de :\r\n %s..."

#define SZ_SPLITTING \
   "Dcoupage de\r\n %s\r\nen %u parties de %ll octets..."

#define SZ_JOINING \
   "Rassemblement de %d parties de %lld octets pour former :\r\n%s..."

#define SZ_OPENFILEPART \
   "criture de la partie de fichier % 5u\r\n"\
   "(%s)...\r\n"

#define SZ_READFILEPART \
   "Lecture de la partie de fichier % 5u\r\n"\
   "(%s)...\r\n"

#define SZ_READPARTSIZE \
   "Vrification de la taille de %s..."

#define SZ_ALLOCBUF \
   "Allocation de %u octets pour le tampon de lecture/criture de fichier"

#define SZ_SPLITOK \
   "%s\r\n a t dcoup avec succs en %d parties"

#define SZ_JOINOK \
   "%s\r\n a t recompos avec succs  partir des %d fichiers"

#define SZ_SPLITFAILED \
   "chec au dcoupage de\r\n%s\r\nen %d parties"

#define SZ_JOINFAILED  \
   "chec  la cration de\r\n%s\r\n partir des %d fichiers"

// menu messages
#define SZ_RETRY \
   "   [%c] ... Ressayer"

#define SZ_TERMINATE \
   "   [%c] ... Quitter le programme."

#define SZ_DISKFULL \
   "Il n'y a pas assez d'espace disque...\r\n"\
   SZ_RETRY" (aprs avoir libr de l'espace disque),\r\n"SZ_TERMINATE

// array of characters used to [R]etry or [T]erminate the program
#define ACH_RETRYABORT       "RQ"
#define DISKFULL_RETRY        0
#define DISKFULL_ABORT        1

// message used on non-critical error conditions
#define SZ_IGNOREABORT \
   "Cette erreur n'est pas critique...\r\n" \
   "   [%c] ... Ignorer l'erreur et continuer,\r\n"SZ_TERMINATE

// array of characters used to [I]gnore an error or [T]erminate the program
#define ACH_IGNOREABORT      "IQ"
#define ERROR_IGNORE         0
#define ERROR_ABORT          1

// message displayed when a file part was not found
#define SZ_PARTNOTFOUND \
   "chec  l'obtention de la taille du fichier...\r\n" \
   SZ_RETRY" (aprs avoir insr le mdia contenant le fichier manquant)\r\n"\
   SZ_TERMINATE

#define ACH_RETRY_ABORT     "RQ"
#define NOCBFILE_RETRY        0
#define NOCBFILE_ABORT        1


// message displayed when a file part could not be opened
#define SZ_PARTNOOPENED \
   "chec  l'ouverture du fichier...\r\n"\
   SZ_RETRY",\r\n"SZ_TERMINATE

// file I/O errors

#define SZERR_TYPEHELPSYS \
   "Taper \'HELP SYS%04d\' pour plus de dtails sur la cause du problme.\r\n"

#define SZERR_OPENFILE \
   "chec  l'ouverture du fichier :\r\n%s.\r\n"

#define SZERR_READFILE \
   "chec de l'opration de lecture de fichier%s.\r\n"

#define SZERR_WRITEFILE \
   "chec de l'opration d'criture de fichier%s.\r\n"

#define SZERR_WRITEFILE2 \
   "chec de l'opration d'criture (%u octets  crire, %u octets crits)"

#define SZERR_FILESIZE \
   "chec  l'obtention la taille du fichier%s.\r\n"

#define SZERR_FILESIZE2 \
   "chec  l'obtention de la taille de :\r\n%s. \r\n"

// file I/O debug
#define SZ_FOPEN \
   "Ouverture du fichier:\r\n%s\r\ndescripteur :%d - code retour :%d"

#define SZ_FCLOSE \
   "Fermeture du fichier : hf:%d"

#define SZ_FREAD \
   "Lecture du fichier : hf:%d - cbRead:%d - cbReadDone:%d - code retour :%d"

#define SZ_FWRITE \
   "criture du fichier : hf:%d - cbWrite:%d - cbWriteDone:%d - code retour :%d"

// showhelp.c messages

#define SZ_TBHEADER \
   " Touches flches et page pour faire dfiler le texte, chap pour quitter."

#define SZ_TBSTATUS \
   " Ligne %4d sur %4d"

#define SZ_TBFILESTART \
   " [ Dbut du fichier ]"

#define SZ_TBFILEEND \
   " [ Fin du fichier ]"

#define SZERR_GETSCREENSIZE \
   "taille d'cran inconnue (VioGetMode a retourn %d)"

// ordinary messages --------------------------------------------------------

#define SZ_PRESSANYKEY \
   "Appuyez sur une touche pour continuer...\r\n"

// other messages
#define SZ_PROGRESS \
   "tat actuel : % 6.2f %%"



#endif // #ifndef _APP_MSGS_H_
