/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         CN_1_DragDrop
*/
CN_1_DragDrop:
    say "CN_1 DragDrop"
    call DumpDDInfo
    call MoveRecord
return

/*:VRX         CN_2_DragDrop
*/
CN_2_DragDrop:
    say "CN_2 DragDrop"
    call DumpDDInfo
    call MoveRecord
return

/*:VRX         DumpDDInfo
*/
DumpDDInfo:
    srcCtn = VRInfo( "SourceObject" )
    srcRec = VRInfo( "SourceRecord" )
    srcFile = VRInfo( "SourceFile" )
    targetCtn = VRInfo( "TargetObject" )
    targetRec = VRInfo( "TargetRecord" )
    left = VRInfo( "Left" )
    bottom = VRInfo( "Bottom" )
    operation = VRInfo( "Operation" )

    if( srcFile <> "" ) then do
        say "  Source file =" srcFile
    end
    else do
        say "  SrcCtn =" srcCtn "--" VRGet( srcCtn, "Name" ) 
        say "  SrcRecord =" srcRec
    end

    say "  TargetCtn =" targetCtn "--" VRGet( targetCtn, "Name" )
    say "  TargetRecord =" targetRec
    say "  Left =" left " Bottom =" bottom
    say "  Operation =" operation
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure 
    do i = 1 to 4
        record = VRMethod( "CN_1", "AddRecord", , , "Record1" || i, "Information" )
    end
    call VRMethod "CN_1", "Arrange"

    do i = 1 to 4
        record = VRMethod( "CN_2", "AddRecord", , , "Record2" || i, "Question" )
    end
    call VRMethod "CN_2", "Arrange"

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return
/*:VRX         MN_ProdInfo_Click
*/
MN_ProdInfo_Click:
    call About VRWindow()
return

/*:VRX         MoveRecord
*/
MoveRecord:
/**********
    As the result of a drag drop operation, move a record from 
    one container to another
*/
    /*  Get information about the source and target of the
        drag and drop operation
    */
    srcCtn = VRInfo( "SourceObject" )
    srcRec = VRInfo( "SourceRecord" )
    srcFile = VRInfo( "SourceFile" )
    targetCtn = VRInfo( "TargetObject" )
    targetRec = VRInfo( "TargetRecord" )
    left = VRInfo( "Left" )
    bottom = VRInfo( "Bottom" )

    /*  If a Workplace Shell File object was dropped onto the
        container, don't do anything.
    */
    if( srcFile <> "" ) then do
        signal MoveDone
    end

    /*  If the source record is no longer in the source container,
        then do nothing. This condition can arise if the record
        was deleted after the user did the drag drop, but before
        the DragDrop event routine was called.
    */
    if( VRMethod( srcCtn, "ValidateRecord", srcRec ) = 0 ) then do
        signal MoveDone
    end


    /*  Add the record to the target container, then remove it from
        the source container.
    */
    ret = VRMethod( targetCtn, "AddSharedRecord", srcRec )
    if( ret = 1 ) then do
        call VRMethod targetCtn, "SetRecordAttr", srcRec, "Left", left,,
                        "Bottom", bottom
        call VRMethod srcCtn, "RemoveRecord", srcRec
    end

MoveDone:
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

