/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         DisplayNotebooks
*/
DisplayNotebooks: procedure expose InitArgs.
    call VRMethod "LB_Objects", "GetSelectedList", "stem."
    do i = 1 to stem.0
        object = VRMethod( "LB_Objects", "GetItemData", stem.i )
        call VRMethod InitArgs.2, "NotebookOpen", object
    end
    call Quit
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
/*  Assume invoked as a VRXEDIT macro so
        InitArgs.0 = 2
        InitArgs.1 = <object>
        InitArgs.2 = <editWindow>
*/
Init: procedure expose InitArgs.  
    window = VRWindow()
    call VRMethod window, "CenterWindow"

    call VRMethod InitArgs.2, "ListChildren", "objects."
    do i = 1 to objects.0
        position = VRMethod( "LB_Objects", "AddString", VRGet(objects.i, "Name") )
        call VRMethod "LB_Objects", "SetItemData", position, objects.i  
    end

    call VRSet "LB_Objects", "Selected", 1
    call VRSet window, "Caption", "Object list for" VRGet( InitArgs.2, "Name" )
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return


/*:VRX         LB_Objects_DoubleClick
*/
LB_Objects_DoubleClick:
    call DisplayNotebooks
return

/*:VRX         PB_Open_Click
*/
PB_Open_Click:
    call DisplayNotebooks
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

