#--------------------------------------------------------------------------#
#                                                                          #
#                                                                          #
#      ------------         Bit-Bucket Software, Co.                       #
#      \ 10001101 /         Writers and Distributors of                    #
#       \ 011110 /          Freely Available<tm> Software.                 #
#        \ 1011 /                                                          #
#         ------                                                           #
#                                                                          #
#              (C) Copyright 1987-96, Bit Bucket Software Co.              #
#                                                                          #
#                                                                          #
#            Makefile for BinkleyTerm (Microsoft NMAKE version)            #
#                                                                          #
#                                                                          #
#                       BinkleyTerm Licensing Terms                        #
#                                                                          #
#                                                                          #
#               (C) Copyright 1987-96 Bit Bucket Software Co.              #
# ALL RIGHTS RESERVED. COMMERCIAL DISTRIBUTION AND/OR USE PROHIBITED       #
# WITHOUT WRITTEN PERMISSION FROM BIT BUCKET SOFTWARE CO.                  #
#                                                                          #
# Non-Commercial distribution and/or use is permitted under the following  #
# terms:                                                                   #
#                                                                          #
#                                                                          #
# 1. You may copy and distribute verbatim copies of BinkleyTerm source,    #
# documentation, and executable code as you receive it, in any medium,     #
# provided that you conspicuously and appropriately publish on each copy a #
# valid copyright notice "(C) Copyright 1987-96, Bit Bucket Software Co."; #
# keep intact the notices on all files that refer to this License          #
# Agreement and to the absence of any warranty;  PROVIDE UNMODIFIED COPIES #
# OF THE DOCUMENTATION AS PROVIDED WITH THE PROGRAM; and give any other    #
# recipients of the BinkleyTerm program a copy of this License Agreement   #
# along with the program.  You may charge a distribution fee for the       #
# physical act of transferring a copy, but no more than is necessary to    #
# recover your actual costs incurred in the transfer. Under no             #
# circumstances is BinkleyTerm to be distributed in such a way as to be    #
# construed as "value added" in a sales transaction, such as, but not      #
# limited to, software bundled with a modem or CD-ROM software             #
# collections.                                                             #
#                                                                          #
# 2. You may modify your copy or copies of BinkleyTerm or any portion of   #
# it, and copy and distribute such modifications under the terms of        #
# Paragraph 1 above, provided that you also do the following:              #
#                                                                          #
#     a) cause the modified files to carry prominent notices stating       #
#     that you changed the files and the date of any change;               #
#                                                                          #
#     b) cause the executable code of such modified version to clearly     #
#     identify itself as such in the course of its normal operation;       #
#                                                                          #
#     c) if the modified version is not a "port", but operates in the      #
#     same hardware and/or software environment as the original            #
#     distribution, make the original version equally available,           #
#     clearly identifying same as the original, unmodified version;        #
#                                                                          #
#     d) cause the whole of any work that you distribute or publish,       #
#     that in whole or in part contains or is a derivative of              #
#     BinkleyTerm or any part thereof, to be licensed at no charge to      #
#     all third parties on terms identical to those contained in this      #
#     License Agreement (except that you may choose to grant more          #
#     extensive warranty protection to some or all third parties, at       #
#     your option); and                                                    #
#                                                                          #
#     e) send the complete source code modifications to Bit Bucket         #
#     Software Co. at one of the addresses listed below,  for the          #
#     purpose of evaluation for inclusion in future releases of            #
#     BinkleyTerm.  Should your source code be included in BinkleyTerm,    #
#     Bit Bucket Software Co. retains all rights for redistribution of     #
#     the code as part of BinkleyTerm and all derivative works, with       #
#     appropriate credit given to the author of the modification.          #
#                                                                          #
#     f) You may charge a distribution fee for the physical act of         #
#     transferring a copy, but no more than is necessary to recover        #
#     your actual costs incurred in the transfer, and you may at your      #
#     option offer warranty protection in exchange for a fee.              #
#                                                                          #
# 3. Mere aggregation of another unrelated program with this program and   #
# documentation (or derivative works) on a volume of a storage or          #
# distribution medium does not bring the other program under the scope of  #
# these terms.                                                             #
#                                                                          #
# 4. You may copy and distribute BinkleyTerm and its associated            #
# documentation (or a portion or derivative of it, under Paragraph 2) in   #
# object code or executable form under the terms of Paragraphs 1 and 2     #
# above provided that you also do one of the following:                    #
#                                                                          #
#     a) accompany it with the complete corresponding machine-readable     #
#     source code, which must be distributed under the terms of            #
#     Paragraphs 1 and 2 above; or,                                        #
#                                                                          #
#     b) accompany it with a written offer, valid for at least three       #
#     years, to give any third party free (except for a nominal            #
#     shipping charge) a complete machine-readable copy of the             #
#     corresponding source code, to be distributed under the terms of      #
#     Paragraphs 1 and 2 above; or,                                        #
#                                                                          #
#     c) accompany it with the information you received as to where        #
#     the corresponding source code may be obtained.  (This                #
#     alternative is allowed only for noncommercial distribution and       #
#     only if you received the program in object code or executable        #
#     form alone.)                                                         #
#                                                                          #
# For an executable file, complete source code means all the source code   #
# for all modules it contains; but, as a special exception, it need not    #
# include source code for modules which are standard libraries that        #
# accompany the operating system on which the executable file runs.        #
#                                                                          #
# 5. You may not copy, sublicense, distribute or transfer BinkleyTerm and  #
# its associated documentation  except as expressly provided under this    #
# License Agreement.  Any attempt otherwise to copy, sublicense,           #
# distribute or transfer BinkleyTerm is void and your rights to use the    #
# program under this License agreement shall be automatically terminated.  #
# However, parties who have received computer software programs from you   #
# with this License Agreement will not have their licenses terminated so   #
# long as such parties remain in full compliance, and notify Bit Bucket    #
# Software Co. of their intention to comply with this Agreement.           #
#                                                                          #
# 6. If you wish to incorporate parts of BinkleyTerm into other free       #
# programs whose distribution conditions are different, please contact     #
# Bit Bucket Software Co. at one of the addresses listed below.  We have   #
# not yet worked out a simple rule that can be stated here, but we will    #
# usually permit this.  We will be guided by the two goals of preserving   #
# the free status of all derivatives of our free software (as it pertains  #
# to Non-Commercial use as provided by this Agreement) and of promoting    #
# the sharing and reuse of software.                                       #
#                                                                          #
# 7. For the purposes of this document, "COMMERCIAL USE" is defined as     #
# operation of the software on four or more computers or data lines owned  #
# by the same for-profit organization. Any organization may operate this   #
# software under the terms of this Non-Commercial Agreement if operation   #
# is limited to three or less computers or data lines.                     #
#                                                                          #
#                                                                          #
#                                NO WARRANTY                               #
#                                                                          #
# BECAUSE BINKLEYTERM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY NO #
# WARRANTY.  EXCEPT WHEN OTHERWISE STATED IN WRITING, BIT BUCKET SOFTWARE  #
# CO. AND/OR OTHER PARTIES PROVIDE BINKLEYTERM "AS IS" WITHOUT WARRANTY OF #
# ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,    #
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR   #
# PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF           #
# BINKLEYTERM, AND THE ACCURACY OF ITS ASSOCIATED DOCUMENTATION, IS WITH   #
# YOU.  SHOULD BINKLEYTERM OR ITS ASSOCIATED DOCUMENTATION PROVE           #
# DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR     #
# CORRECTION.                                                              #
#                                                                          #
# IN NO EVENT WILL BIT BUCKET SOFTWARE CO. BE RESPONSIBLE IN ANY WAY FOR   #
# THE BEHAVIOR OF MODIFIED VERSIONS OF BINKLEYTERM. IN NO EVENT WILL       #
# BIT BUCKET SOFTWARE CO. AND/OR ANY OTHER PARTY WHO MAY MODIFY AND        #
# REDISTRIBUTE BINKLEYTERM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR        #
# DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,      #
# INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY  #
# TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED #
# INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE      #
# PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) BINKLEYTERM, EVEN IF YOU     #
# HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM   #
# BY ANY OTHER PARTY.                                                      #
#                                                                          #
#                                                                          #
# You can contact Bit Bucket Software Co. at any one of the following      #
# addresses:                                                               #
#                                                                          #
# Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             #
# P.O. Box 460398                AlterNet 7:42/1491                        #
# Aurora, CO 80046               Internet f491.n343.z1.fidonet.org         #
#                                                                          #
#                                                                          #
# Please feel free to contact us at any time to share your comments about  #
# our software and/or licensing policies.                                  #
#                                                                          #
# Our thanks to Richard Stallman and the Free Software Foundation, Inc.,   #
# for most of the wording of this License.                                 #
#                                                                          #
#--------------------------------------------------------------------------#

#
# Definitions
#

SRC_DIR  = ..\src
INCL_DIR = ..\include

# C Compiler variables:

cc = cl

!IF "$(DEBUG)" != ""
cdebug = -Zi -Od -DDEBUG
linkdebug = -debug:full -debugtype:both
!ELSE
cdebug = -Zi -Oagtyb1 -Gs -G5
linkdebug =
!ENDIF

cflags = -c
cclcl = -Zp -I $(INCL_DIR)
ccnopk = -I $(INCL_DIR)
cvars = -D_X86_=1 -D_WIN32

!IF "$(WARNINGS)" != ""
cwarn = -W4
!ELSE
cwarn = -W3
!ENDIF

# Linker variables:

link = link
conflags = -align:0x1000 -subsystem:console -entry:mainCRTStartup
conlibs    = libc.lib kernel32.lib

#
# Object files that MSVC++ (2.X, 4.X etc) is responsible for generating:
#

# First those for the main BinkleyTerm module
#
btobj = bt.obj       btconfig.obj langload.obj timer.obj    misc.obj     \
        b_help.obj   file_dos.obj dosfuncs.obj keymap.obj   b_today.obj  \
        mdm_proc.obj b_script.obj b_fuser.obj  nodeproc.obj version7.obj \
		b_proto.obj  b_bbs.obj    b_search.obj b_sessio.obj recvbark.obj \
		yoohoo.obj   b_wazoo.obj  b_wzsend.obj ftsc.obj     mailer.obj   \
		sendbark.obj sched.obj    fossil.obj   b_passwo.obj b_frproc.obj \
		zreceive.obj zsend.obj    zmisc.obj    sendsync.obj recvsync.obj \
        data.obj     b_termov.obj b_banner.obj b_initva.obj b_faxrcv.obj \
        b_sbinit.obj b_flofil.obj mailovly.obj evtparse.obj b_whack.obj  \
        sbuf.obj     b_spawn.obj  b_rspfil.obj b_term.obj   \
		xmsend.obj   m7send.obj   bsend.obj    brec.obj     xmrec.obj    \
		m7rec.obj    janus.obj    statetbl.obj outbound.obj squish.obj   \
        mailroot.obj upload.obj   download.obj emsi.obj

bwobj = async_nt.obj vfos_nt.obj

INCL_FILES = $(INCL_DIR)\includes.h $(INCL_DIR)\bink.h                   \
             $(INCL_DIR)\defines.h $(INCL_DIR)\com.h                     \
             $(INCL_DIR)\com_nt.h $(INCL_DIR)\xfer.h                     \
             $(INCL_DIR)\msgs.h $(INCL_DIR)\zmodem.h $(INCL_DIR)\keybd.h \
             $(INCL_DIR)\keyfncs.h $(INCL_DIR)\sbuf.h                    \
             $(INCL_DIR)\sched.h $(INCL_DIR)\timer.h                     \
             $(INCL_DIR)\vfossil.h $(INCL_DIR)\externs.h                 \
             $(INCL_DIR)\prototyp.h $(INCL_DIR)\squish.h

# Next those for BTCTL, the program that makes a dummy OMMM CTL file
#
cobj1 = btctl.obj

# Then those for BTLNG, Bink's language compiler
cobj2 = btlng.obj get_lang.obj put_lang.obj

#
# Dependency list for regular and debug version, and LINK
# command lines
#

all :	binkley.lng bt32.exe btctl32.exe btlng32.exe

clean :
	!del *.obj
	!del *.pch
	!del *.pbi
	!del *.pbt
	!del *.pcf
	!del *.sym
	!del *.pdb
	!del *.map
	!del *.exe

bt32.exe:  $(btobj) $(bwobj)
    $(link) @<<file.lrf
$(linkdebug) $(conflags) $(btobj: = ^
)
$(bwobj)
includes.obj
$(conlibs) winmm.lib -out:bt32.exe -map
<<

btctl32.exe: $(cobj1)
    $(link) $(conflags) $(cobj1) $(conlibs) -out:btctl32.exe

btlng32.exe: $(cobj2)
    $(link) $(conflags) $(cobj2) $(conlibs) -out:btlng32.exe

binkley.lng: btlng32.exe $(SRC_DIR)\english.txt
    btlng32 $(SRC_DIR)\english.txt binkley.lng

clean:
	-del *.obj
	-del *.pch
	-del *.map
	-del *.exe
	-del binkley.lng

goal:	all

#
# Dependencies for .C files and compiler line to generate 'em.
#

$(btobj): $(SRC_DIR)\$*.c includes.pch
    $(cc) $(cdebug) $(cflags) $(cwarn) $(cclcl) $(cvars) -Yuincludes.h $(SRC_DIR)\$*.c 

includes.pch: $(INCL_FILES)
    $(cc) $(cdebug) $(cflags) $(cwarn) $(cclcl) $(cvars) -Ycincludes.h $(SRC_DIR)\includes.c

$(bwobj): $(SRC_DIR)\$*.c
    $(cc) $(cdebug) $(cflags) $(cwarn) $(ccnopk) $(cvars) $(SRC_DIR)\$*.c

$(cobj1): $(SRC_DIR)\$*.c $(INCL_DIR)\com.h $(INCL_DIR)\xfer.h $(INCL_DIR)\bink.h
    $(cc) $(cdebug) $(cflags) $(cwarn) $(cclcl) $(cvars) $(SRC_DIR)\$*.c

$(cobj2): $(SRC_DIR)\$*.c $(INCL_DIR)\language.h
    $(cc) $(cdebug) $(cflags) $(cwarn) $(cclcl) $(cvars) $(SRC_DIR)\$*.c
#
# Modules with special includes here
#
langload.obj: $(INCL_DIR)\msgs.h
