/* Worker Task REXX script
 * 20.7.94 by Thomas Waldmann
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

'@set TASKS=1 2 3 4 5 6'
'@set MAILER=h:\bt'
'@set BT=h:\bt'
'@set NL=h:\nodelist'
'@set LOG=%MAILER%\log\all'
'@set PATH=%BT%\bin;%BT%;%BT%\itrack;%BT%\fmail;h:\os2\bin'

start     = 'sp i0 '
inbound   = 'e:\in'
inboundp  = inbound'\protect'
inboundk  = inbound'\known'
inboundu  = inbound'\unknown'
inboundf  = inbound'\fax'
inboundl  = inbound'\local'
outbound  = 'e:\out\out'
semaphor  = 'e:\semaphor'
flag      = 'h:\bt\flags\task.??'

requestp  = inboundp'\????????.r0?'
requestk  = inboundk'\????????.r0?'
requestu  = inboundu'\????????.r0?'
maxactive = 'h:\max\active??.bbs'

do forever
  call SysSleep 10
  call SysCls
  todo = 0
  call searchactive flag 'MAILER   ' outbound 'OUTBOUND ' requestp requestk requestu 'REQUEST  ' maxactive 'BBS      '
  call searchsema   semaphor 'SEMAPHOR '
  call searchfax    inboundf 'FAX      '
  call searchunproc inboundu 'UNKNOWN  '
  call searchunproc inboundk 'KNOWN    '
  call searchunproc inboundp 'PROTECTED'
  todo = RESULT
  pktc = pktcount
  ticc = ticcount
  bundlec = bundlecount
  call searchunproc inboundl 'LOCAL    '
  todo = todo + RESULT  
  pktc = pktc + pktcount
  bundlec = bundlec + bundlecount
  if (todo>0) & (actcount=0) then do
    if pktc+bundlec > 0 then
      call InMail
    else if ticc > 0 then
      call InTic
  end
end
exit


searchunproc: Procedure Expose pktcount bundlecount seccount dstcount ticcount 

  days.0 = 7
  days.1 = 'MO'
  days.2 = 'TU'
  days.3 = 'WE'
  days.4 = 'TH'
  days.5 = 'FR'
  days.6 = 'SA'
  days.7 = 'SU'

  arg inbpath inbname
      
  pktcount = FilesReceived(inbpath'\*.pkt')
  
  bundlecount = 0
  do i=1 to days.0
    bundlecount= bundlecount + FilesReceived(inbpath'\*.'days.i'?')
  end

  seccount = FilesReceived(inbpath'\*.sec')
  
  dstcount = FilesReceived(inbpath'\*.dst')

  ticcount = FilesReceived(inbpath'\*.tic')
  
  say inbname ' PKTs: ' right(pktcount,3) ' Bundles:' right(bundlecount,3) ' TICs:' right(ticcount,3) ' DSTs:' right(dstcount,3) ' SECs:' right(seccount,3)
  
return pktcount + bundlecount + ticcount

searchfax: Procedure Expose faxcount

  arg inbpath inbname
      
  call SysFileTree inbpath'\FREC????.???', 'fax', 'FO'
  faxcount = fax.0
  
  say inbname ' FAX:    ' faxcount
  
return faxcount

InMail: Procedure
  arg sigfile
  if sigfile\='' then
    '@del ' sigfile
    
  say 'Invoking FMail/2 ...'
  /* 'h:\bt\bin\sp i31 o ' */
  '@call h:\bt\fmail\fmail2t.cmd'
  
  say 'Invoking ITrack ...'
  '@h:'
  '@cd \bt\itrack'
  '@itrack'
return

InTic: Procedure
  say 'Invoking Ticker ...'
  '@h:'
  '@cd \bt\ftick'
  '@call ftickc.cmd'
return

searchactive: Procedure Expose actcount
  arg flag flagname outbound outname reqpp reqkp requp reqname maxp maxname
  call SysFileTree flag, 'mlr', 'FO'
  mlrcount = mlr.0
  call SysFileTree maxp, 'bbs', 'FO'
  bbscount = bbs.0
  actcount = mlrcount
  reqcount=0
  call SysFileTree outbound'\*.bsy', 'bsy', 'FSO'
  bsycount = bsy.0
  say left(flagname,9) ' MLR:    ' mlrcount
  say left(maxname,9)  ' BBS:    ' bbscount
  say left(outname,9)  ' BSY:    ' bsycount
  say left(reqname,9)  ' R0?:    ' reqcount
return


searchsema: Procedure
  arg sema semaname
  sig1 = 0
  if stream(sema'\mymail.sig', 'c', 'query exists')<>'' then
    do
      sig1 = 1
      call MyMail sema'\mymail.sig'
    end

  sig2 = 0
  if stream(sema'\wrkrexit.sig', 'c', 'query exists')<>'' then
    do
      sig2 = 1
      call Terminate sema'\wrkrexit.sig'
    end

  sig3 = 0
  if stream(sema'\dotoss.sig', 'c', 'query exists')<>'' then
    do
      sig3 = 1
      /* call InMail sema'\dotoss.sig'  */
    end

  sigcount = sig1+sig2+sig3
  say semaname ' SIG:    ' sigcount
  
return

Terminate: Procedure
  arg sigfile
  say 'Terminating ...'
  '@del ' sigfile
  exit
return 

MyMail: Procedure
  arg sigfile
  say 'Invoking ITrack / MyMail ...'
  '@h:'
  '@cd \bt\itrack'
  '@itrack MoveFromMyMail'
  '@del ' sigfile
return 

FilesReceived: procedure
  arg Filespec
  call SysFileTree Filespec, 'FileFound', 'FO'
  if FileFound.0 = 0 then return 0
  FReceived = 0
  do i = 1 to FileFound.0
    FReceived = FReceived + FileAvail(FileFound.i)
  end  
  return FReceived
  
FileAvail: procedure
  arg FileName
  Status = stream(FileName,'c','open write')
  X = stream(FileName,'c','close') 
  if left(Status,5) = 'READY' then return 1 
  return 0
  

