/********************************************************copyrite.xmc***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This module is "Restricted Materials of IBM":                     */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xmc***/
/*
 * Copyright (c) 1983, 1987 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *      @(#)resolv.h    5.6 (Berkeley) 9/20/88
 */

/*
 * Global defines and variables for resolver stub.
 */
#ifndef __32BIT__
#define _Packed
#define _Seg16
#define _Far16
#define _Cdecl
#endif
#define MAXNS           3               /* max # name servers we'll track */
#define MAXDNSRCH       3               /* max # default domain levels to try */
#define LOCALDOMAINPARTS 2              /* min levels in name that is "local" */

#define RES_TIMEOUT     4               /* seconds between retries */

_Packed struct state {
        short     retrans;                /* retransmition time interval */
        short     retry;                  /* number of times to retransmit */
        long    options;                /* option flags - see below. */
        short     nscount;                /* number of name servers */
        struct  sockaddr_in nsaddr_list[MAXNS]; /* address of name server */
#define nsaddr  nsaddr_list[0]          /* for backward compatibility */
        u_short id;                     /* current packet id */
        char    defdname[MAXDNAME];     /* default domain */
        char    * _Seg16 dnsrch[MAXDNSRCH+1];   /* components of domain to search */
};

/*
 * Resolver options
 */
#define RES_INIT        0x0001          /* address initialized */
#define RES_DEBUG       0x0002          /* print debug messages */
#define RES_AAONLY      0x0004          /* authoritative answers only */
#define RES_USEVC       0x0008          /* use virtual circuit */
#define RES_PRIMARY     0x0010          /* query primary server only */
#define RES_IGNTC       0x0020          /* ignore trucation errors */
#define RES_RECURSE     0x0040          /* recursion desired */
#define RES_DEFNAMES    0x0080          /* use default domain name */
#define RES_STAYOPEN    0x0100          /* Keep TCP socket open */
#define RES_DNSRCH      0x0200          /* search up local domain tree */

#define RES_DEFAULT     (RES_RECURSE | RES_DEFNAMES | RES_DNSRCH)

extern _Packed struct state _res;
#if 0
extern char * _Seg16 _Far16 _Cdecl p_cdname();
extern char * _Seg16 _Far16 _Cdecl p_rr();
extern char * _Seg16 _Far16 _Cdecl p_type();
extern char * _Seg16 _Far16 _Cdecl p_class();
#endif
