/********************************************************copyrite.xmc***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This module is "Restricted Materials of IBM":                     */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xmc***/
/*
 * Copyright (c) 1980,1983,1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *      @(#)netdb.h     5.9 (Berkeley) 4/5/88
 */

/*
 * Structures returned by network
 * data base library.  All addresses
 * are supplied in host order, and
 * returned in network order (suitable
 * for use in system calls).
 */
#ifndef INCL_NETDB
#define INCL_NETDB
#ifndef __32BIT__
#define _Packed
#define _Seg16
#define _Far16
#define _Cdecl
#endif

struct  hostent {
        char    * _Seg16 h_name;        /* official name of host */
        char    * _Seg16 * _Seg16 h_aliases;    /* alias list */
        short   h_addrtype;     /* host address type */
        short   h_length;       /* length of address */
        char    * _Seg16 * _Seg16 h_addr_list;  /* list of addresses from name server */
#define h_addr  h_addr_list[0]  /* address, for backward compatiblity */
};

/*
 * Assumption here is that a network number
 * fits in 32 bits -- probably a poor one.
 */
typedef _Packed struct  netent {
        char            * _Seg16 n_name;        /* official name of net */
        char            * _Seg16 * _Seg16 n_aliases;    /* alias list */
        short           n_addrtype;     /* net address type */
        unsigned long   n_net;          /* network # */
} NETENT;

typedef _Packed struct  servent {
        char    * _Seg16 s_name;        /* official service name */
        char    * _Seg16 * _Seg16 s_aliases;    /* alias list */
        short   s_port;         /* port # */
        char    * _Seg16 s_proto;       /* protocol to use */
} SERVENT;

typedef _Packed struct  protoent {
        char    * _Seg16 p_name;        /* official protocol name */
        char    * _Seg16 * _Seg16 p_aliases;    /* alias list */
        short   p_proto;        /* protocol # */
} PROTOENT;

struct hostent * _Seg16 _Far16 _Cdecl gethostbyname( char * _Seg16 );
struct hostent * _Seg16 _Far16 _Cdecl gethostbyaddr( char * _Seg16, short, short);
struct hostent * _Seg16 _Far16 _Cdecl gethostent( void );
void _Far16 _Cdecl endhostent(void);
NETENT * _Seg16 _Far16 _Cdecl getnetbyname( char * _Seg16);
NETENT * _Seg16 _Far16 _Cdecl getnetbyaddr( unsigned long, short );
NETENT * _Seg16 _Far16 _Cdecl getnetent( void );
void _Far16 _Cdecl endnetent(void);
SERVENT * _Seg16 _Far16 _Cdecl getservbyname( char *, char * );
SERVENT * _Seg16 _Far16 _Cdecl getservbyport( short, char * );
SERVENT * _Seg16 _Far16 _Cdecl getservent( void );
void _Far16 _Cdecl endservent(void);
PROTOENT * _Seg16 _Far16 _Cdecl getprotobyname( char * );
PROTOENT * _Seg16 _Far16 _Cdecl getprotoent( void );
void _Far16 _Cdecl endprotoent(void);
short _Far16 _Cdecl sethostent( short);
short _Far16 _Cdecl setnetent( short );
short _Far16 _Cdecl setprotoent( short );
short _Far16 _Cdecl setservent( short );

/*
 * Error return codes from gethostbyname() and gethostbyaddr()
 * (left in extern int h_errno).
 */

#ifdef __32BIT__
#define h_errno _h_errno
#endif
extern short h_errno;

#define HOST_NOT_FOUND  1 /* Authoritative Answer Host not found */
#define TRY_AGAIN       2 /* Non-Authoritive Host not found, or SERVERFAIL */
#define NO_RECOVERY     3 /* Non recoverable errors, FORMERR, REFUSED, NOTIMP */
#define NO_DATA         4 /* Valid name, no data record of requested type */
#define NO_ADDRESS      NO_DATA         /* no address, look for MX record */
#endif
