/********************************************************copyrite.xmc***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This module is "Restricted Materials of IBM":                     */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xmc***/
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*      @(#)clnt.h 1.1 86/02/03 SMI      */

/*
 * clnt.h - Client side remote procedure call interface.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */
#ifndef INCL_RPC_CLNT_H
#define INCL_RPC_CLNT_H
#ifndef __32BIT__
#define _Packed
#define _Seg16
#define _Far16
#define _Cdecl
#endif


#ifdef __32BIT__
#define rpc_cerr _rpc_cerr
#endif


/*
 * Rpc calls return an enum clnt_stat.  This should be looked at more,
 * since each implementation is required to live with this (implementation
 * independent) list of errors.
 */
enum clnt_stat {
        RPC_SUCCESS=0,                  /* call succeeded */
        /*
         * local errors
         */
        RPC_CANTENCODEARGS=1,           /* can't encode arguments */
        RPC_CANTDECODERES=2,            /* can't decode results */
        RPC_CANTSEND=3,                 /* failure in sending call */
        RPC_CANTRECV=4,                 /* failure in receiving result */
        RPC_TIMEDOUT=5,                 /* call timed out */
        /*
         * remote errors
         */
        RPC_VERSMISMATCH=6,             /* rpc versions not compatible */
        RPC_AUTHERROR=7,                /* authentication error */
        RPC_PROGUNAVAIL=8,              /* program not available */
        RPC_PROGVERSMISMATCH=9,         /* program version mismatched */
        RPC_PROCUNAVAIL=10,             /* procedure unavailable */
        RPC_CANTDECODEARGS=11,          /* decode arguments error */
        RPC_SYSTEMERROR=12,             /* generic "other problem" */

        /*
         * callrpc errors
         */
        RPC_UNKNOWNHOST=13,             /* unknown host name */

        /*
         * _ create errors
         */
        RPC_PMAPFAILURE=14,             /* the pmapper failed in its call */
        RPC_PROGNOTREGISTERED=15,       /* remote program is not registered */
        /*
         * unspecified error
         */
        RPC_FAILED=16
#ifdef __32BIT__
        ,
        RPC_DUMMY=32767
#endif
};


/*
 * Error info.
 */
_Packed struct rpc_err {
        enum clnt_stat re_status;
        union {
                short RE_errno;           /* realated system error */
                enum auth_stat RE_why;  /* why the auth error occurred */
                struct {
                        u_long low;     /* lowest verion supported */
                        u_long high;    /* highest verion supported */
                } RE_vers;
                struct {                /* maybe meaningful if RPC_FAILED */
                        long s1;
                        long s2;
                } RE_lb;                /* life boot & debugging only */
        } ru;
#define re_errno        ru.RE_errno
#define re_why          ru.RE_why
#define re_vers         ru.RE_vers
#define re_lb           ru.RE_lb
};


/*
 * Client rpc handle.
 * Created by individual implementations, see e.g. rpc_udp.c.
 * Client is responsible for initializing auth, see e.g. auth_none.c.
 */
typedef _Packed struct {
        AUTH    * _Seg16 cl_auth;                       /* authenticator */
        struct clnt_ops {
                enum clnt_stat  (* _Seg16 _Far16 _Cdecl cl_call)(void * _Seg16,u_long,xdrproc_t,void * _Seg16,xdrproc_t,void * _Seg16,struct timeval);   /* call remote procedure */
                void            (* _Seg16 _Far16 _Cdecl cl_abort)(void * _Seg16);  /* abort a call */
                void            (* _Seg16 _Far16 _Cdecl cl_geterr)(void * _Seg16,_Packed struct rpc_err * _Seg16); /* get specific error code */
                bool_t          (* _Seg16 _Far16 _Cdecl cl_freeres)(void * _Seg16, xdrproc_t,void * _Seg16); /* frees results */
                void            (* _Seg16 _Far16 _Cdecl cl_destroy)(void * _Seg16);/* destroy this structure */
        } * _Seg16 cl_ops;
        char * _Seg16         cl_private;     /* private stuff */
} CLIENT;


/*
 * client side rpc interface ops
 *
 * Parameter types are:
 *
 */

/*
 * enum clnt_stat
 * CLNT_CALL(rh, proc, xargs, argsp, xres, resp, timeout)
 *      CLIENT *rh;
 *      u_long proc;
 *      xdrproc_t xargs;
 *      caddr_t argsp;
 *      xdrproc_t xres;
 *      caddr_t resp;
 *      struct timeval timeout;
 */
#define CLNT_CALL(rh, proc, xargs, argsp, xres, resp, secs)     \
        ((*(rh)->cl_ops->cl_call)(rh, proc, xargs, argsp, xres, resp, secs))
#define clnt_call(rh, proc, xargs, argsp, xres, resp, secs)     \
        ((*(rh)->cl_ops->cl_call)(rh, proc, xargs, argsp, xres, resp, secs))

/*
 * void
 * CLNT_ABORT(rh);
 *      CLIENT *rh;
 */
#define CLNT_ABORT(rh)  ((*(rh)->cl_ops->cl_abort)(rh))
#define clnt_abort(rh)  ((*(rh)->cl_ops->cl_abort)(rh))

/*
 * struct rpc_err
 * CLNT_GETERR(rh);
 *      CLIENT *rh;
 */
#define CLNT_GETERR(rh,errp)    ((*(rh)->cl_ops->cl_geterr)(rh, errp))
#define clnt_geterr(rh,errp)    ((*(rh)->cl_ops->cl_geterr)(rh, errp))


/*
 * bool_t
 * CLNT_FREERES(rh, xres, resp);
 *      CLIENT *rh;
 *      xdrproc_t xres;
 *      caddr_t resp;
 */
#define CLNT_FREERES(rh,xres,resp) ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))
#define clnt_freeres(rh,xres,resp) ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))

/*
 * void
 * CLNT_DESTROY(rh);
 *      CLIENT *rh;
 */
#define CLNT_DESTROY(rh)        ((*(rh)->cl_ops->cl_destroy)(rh))
#define clnt_destroy(rh)        ((*(rh)->cl_ops->cl_destroy)(rh))


/*
 * RPCTEST is a test program which is accessable on every rpc
 * transport/port.  It is used for testing, performance evaluation,
 * and network administration.
 */

#define RPCTEST_PROGRAM         ((u_long)1)
#define RPCTEST_VERSION         ((u_long)1)
#define RPCTEST_NULL_PROC       ((u_long)2)
#define RPCTEST_NULL_BATCH_PROC ((u_long)3)

/*
 * By convention, procedure 0 takes null arguments and returns them
 */

#define NULLPROC ((u_long)0)

/*
 * Below are the client handle creation routines for the various
 * implementations of client side rpc.  They can return NULL if a
 * creation failure occurs.
 */

/*
 * Memory based rpc (for speed check and testing)
 * CLIENT *
 * clntraw_create(prog, vers)
 *      u_long prog;
 *      u_long vers;
 */
#if 0
extern CLIENT * _Seg16 _Far16 _Cdecl clntraw_create();
#endif

/*
 * TCP based rpc
 * CLIENT *
 * clnttcp_create(raddr, prog, vers, sockp, sendsz, recvsz)
 *      struct sockaddr_in *raddr;
 *      u_long prog;
 *      u_long version;
 *      register int *sockp;
 *      u_int sendsz;
 *      u_int recvsz;
 */
#if 0
extern CLIENT * _Seg16 _Far16 _Cdecl clnttcp_create(void);
#endif

/*
 * UDP based rpc.
 * CLIENT *
 * clntudp_create(raddr, program, version, wait, sockp)
 *      struct sockaddr_in *raddr;
 *      u_long program;
 *      u_long version;
 *      struct timeval wait;
 *      int *sockp;
 *
 * Same as above, but you specify max packet sizes.
 * CLIENT *
 * clntudp_bufcreate(raddr, program, version, wait, sockp, sendsz, recvsz)
 *      struct sockaddr_in *raddr;
 *      u_long program;
 *      u_long version;
 *      struct timeval wait;
 *      int *sockp;
 *      u_int sendsz;
 *      u_int recvsz;
 */
#if 0
extern CLIENT * _Seg16 _Far16 _Cdecl clntudp_create();
extern CLIENT * _Seg16 _Far16 _Cdecl clntudp_bufcreate();
#endif

/*
 * If a creation fails, the following allows the user to figure out why.
 */
_Packed struct rpc_createerr {
        enum clnt_stat cf_stat;
        _Packed struct rpc_err cf_error; /* useful when cf_stat == RPC_PMAPFAILURE */
};

extern _Packed struct rpc_createerr rpc_createerr;


#define UDPMSGSIZE      8800    /* rpc imposed limit on udp msg size */
#define RPCSMALLMSGSIZE 400     /* a more reasonable packet size */

/* from here on lint stuff O.V. */
void _Far16 _Cdecl clnt_perror( CLIENT * _Seg16, char * _Seg16);
void _Far16 _Cdecl clnt_perrno( enum clnt_stat);
short _Far16 _Cdecl clnt_pcreateerror( char * _Seg16);
CLIENT * _Seg16 _Far16 _Cdecl clntraw_create( u_long, u_long);
short _Far16 _Cdecl callrpc(char * _Seg16, u_long, u_long, u_long, xdrproc_t, char * _Seg16, xdrproc_t, char * _Seg16);
CLIENT * _Seg16
_Far16 _Cdecl clnttcp_create( struct sockaddr_in * _Seg16, u_long, u_long, short * _Seg16, u_short, u_short);
CLIENT * _Seg16
_Far16 _Cdecl clntudp_bufcreate( struct sockaddr_in * _Seg16, u_long, u_long, struct timeval, short * _Seg16,
                   u_short, u_short);
CLIENT * _Seg16
_Far16 _Cdecl clntudp_create( struct sockaddr_in * _Seg16, u_long, u_long, struct timeval, short * _Seg16);
#endif
