/*
 * Decompiled with CFR 0.152.
 */
package com.os2.comm;

import com.os2.comm.OS2SerialNative;
import java.io.IOException;
import java.io.OutputStream;

class OS2SerialOutputStream
extends OutputStream {
    OS2SerialNative port;
    byte[] buff;

    public OS2SerialOutputStream(OS2SerialNative oS2SerialNative) {
        this.port = oS2SerialNative;
        this.buff = new byte[4];
    }

    public void write(int n) throws IOException {
        this.buff[0] = (byte)(n < 128 ? n : (n = n - 256));
        if (this.port.spwriteArray(this.buff, 0, 1) < 0) {
            throw new IOException("Could not write to serial port");
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.port.spwriteArray(byArray, 0, byArray.length) < 0) {
            throw new IOException("Could not write to serial port");
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length > n + n2) {
            throw new IOException("Length too long");
        }
        if (this.port.spwriteArray(byArray, n, n2) < 0) {
            throw new IOException("Could not write to serial port");
        }
    }

    public void flush() throws IOException {
        if (this.port.spflush() < 0) {
            throw new IOException("Could not flush serial port");
        }
    }
}

