
%TRUNC
%BIN 16
%PCNT 4
%TABSIZE 8
%PAGESIZE 55, 140

Vmajor	equ	0		;version 0.93  (remember to change sign-on msg too)
Vminor	equ	93

;   PI2DRVR.ASM    (C) Copyright 1994 Dale Heatherington WA4DSY
;   OS/2 Driver source for the Ottawa PI card.
;
;   Portions (C) Copyright 1993 David G Perry
; 
;   Portions (C) Copyright, 1988, 1989, 1990, 1991 Russell Nelson
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
;--------------------------------------------------------------------------
; Conversion of David Perrys' DOS Packet driver code to OS/2 2.x device driver
;   ....Little remains of the original now...
;
; Bug reports:  wa4dsy@wa4dsy.radio.org
; if down try:  daheath@ibm.net
;
; Revision notes.
;
; 12-9-94  Started - I have no idea what the hell I'm doing!
; 12-27-94 Basic driver completed
; 12-28-94 Debuging....  
; 01-12-95 Added IOCtl functions and CPU speed measuring code.
; 01-14-95 Release version 0.3 beta with "A" side only.
; 01-16-95 Started work on adding the "B" side. (Dave didn't impliment the B side.)
;            This has become a major rework!
;
; 01-23-95 B side complete, debuging started.
;          B side will lock up when TX underrun errors happen at higher baud rates
;          Works OK up to 2400 baud on a 486-33.
;
; 01-26-95 Added automatic detection of PI2 and original PI card and set time
;               constants accordingly.
;
;01-28-95 More bugs found: A side locks up when TX delay is set too small.
;		           A side locks up when 56kb modem is *not* connected.
;
;02-02-95 Bugs of 1-28-95 have been fixed. Several failsafe stategies have been
;         inplemented.  Receive buffer changed from the original two buffer
;         scheme to the buffer pool scheme.  Buffer pool is shared between
;         transmitter and receiver now.  The version is now 0.5 .
;         The B side has succesfully received data at 19.2 kb that was
;         sent from side A!  (on a 486-33 machine)  Not bad for interrupt driven.
;
;02-03-95 Realized that if the driver is opened and the READ routine is not called
;         while connected to an active modem, the buffer pool will become exausted
;         which will leave the WRITE routine with no buffers. A buffer will
;         never become available unless the READ routine is called. This could
;         result in deadlock.
;         Fixed by adding counters to the buffer queue system.  The WRITE routine
;         can now steal a buffer from the RX queue if that's the only 
;         source of buffers and none have been allocated on the transmit queue.
;
;
;02-08-95 Version 0.6
;         Fixed bug which allowed interrupt nesting and stack crash (trap 8)
;         at 38400 baud.  The B side will now run at 38.4 kb on a 486-33 with
;         some TX underruns.  OS/2 does not trap now.  PMNOS will ax25 connect
;         from A side to B side at 38.4 kb and transfer data.
;
;02-16-95 Version 0.61
;         Devised a means of providing IOCTL functions through the normal
;         file system so DOS programs can control the driver. See "FileSysIOCtl".
;
;02-18-95 Version 0.62
;         Added hooks for Virtual Device Drivers.
;         Spent 2 days on this due to poor IBM documentation on the
;         VDD to PDD communication link. The driver name "PDDName"
;         must be upper case *alpha* characters! VDHOpenPDD not only
;         gets the PDD address but also calls the address with the
;         function number 0 !   Only 1 entry point can be registered.
;         These important facts are not documented in the Virtual
;         Device Driver reference by IBM.
;
;02-27-95 Version 0.70
;	  Finally got the VDD & PDD to work together properly.
;
;03-04-95 Version 0.71
;         Fixed yet another bug in the A channel TX interrupt code
;         which caused TX to hang when running on a s-l-o-w machine.
;
;03-08-95 Version 0.72
;         Fixed a transmitter bug in the A channel which caused the
;         data to get stuck in the tx queue forever after sending
;         several hundred packets.  When the transmitter was in DEFER
;         due to other traffic on the channel and there were no free
;         buffers the receiver couldn't get a buffer.  The error handler
;         shut off EXT interrupts when this happened which caused an
;         infinite wait in DEFER!
;
;03-09-95 Testing - Channel A has worked flawlessly at 56 KB.
;                    Channel B works up to 19.2 KB on a 486-33 
;                    running DOS JNOS 110i with the custom PI driver
;                    and VPI2.SYS :-)   
;                    PMNOS B channel code doesn't work correctly.  System
;                    hangs when PMNOS is shut down if B rx thread is running.
;
;03-10-95 Version 0.73  
;          Fixed problem where ExInts counter didn't reset when driver is OPENed.
;          Raised MAXBFRS and default number of buffers to 15.  Lowered max buffer
;          size to 3072 (3k).
;
;03-11-95 Released to hydra.carleton.ca as a beta 
;
;03-13-95 Version 0.80
;         Corrected problem with PMNOS hanging OS/2 on exit.  The READ
;         request function failed to test for invalid file handle after
;         "wakeup" and transfered data to invalid user memory after user
;         closed the driver.  Problem didn't show up with JNOS because
;         it doesn't use blocking read.
;
;         The driver will now reject multiple OPEN requests instead of
;         accepting them then screwing up later.
;
;         Added version number reporting.  * Released version 0.80 *
;
;07-03-95 Version 0.90
;         Discovered that DOS-JNOS and this driver sometimes won't
;         accept back to back received packets which the transmitter
;         can emit.  Altered TXINT code to cause txdelay to always
;         be inserted between packets even it TX is already on.
;
;**still working on this... see line 2460  and 5265
;
;11-26-95 Version 0.92
;	 Added code to detect TX underrun error condition in Chan A.
;	 Fixed bug which caused TX underrun about 3% of the time.
;	 This was caused by enabling the SCC chip before the DMA chip.
;	 This sequence is now reversed.
;

;
;---------------------------------------------
;The pi2drvr.def file looks like this:
;
; LIBRARY PI2DRVR
; PROTMODE
; CODE	PRELOAD
; DATA	PRELOAD FIXED
; SEGMENTS
;   _DATA    CLASS 'DATA' FIXED PRELOAD
;   _TEXT    CLASS 'CODE' PRELOAD
;
;
;----------------------------------------------
;
;The compile and link command lines are:
;
;  tasm -Mx pi2drvr,,pi2drvr.lst
;  link pi2drvr.obj,pi2drvr.sys,pi2drvr.map/map,os2.lib,pi2drvr.def
;
;The linker and os2.lib files are from Microsoft C v6.0
;tasm is from Borland C++ 3.1
;
;Advice for those who may want to write an OS/2 device driver -
;
; Buy "Physical Device Driver Reference for OS/2" from IBM.
; It's document number is: S10G-6266-01
; Obtain the sample device driver code from the
; Developer Connection CDROM.
;
;
;------------------------------------------------------
;   A limited subset of the dynamic link API functions (Dosxxx functions) can
;   be used by the physical device drivers at initialization time.  The
;   dynamic link functions available to a physical device driver at
;   initialization time include:
;
;   DosBeep             Generate sound from speaker
;   DosCaseMap          Perform case mapping
;   DosChgFilePtr       Change (move) file read/write pointer
;   DosClose            Close file handle
;   DosDelete           Delete file
;   DosDevConfig        Get device configuration
;   DosDevIOCtl         I/O control for devices
;   DosFindClose        Close find handle
;   DosFindFirst        Find first matching file
;   DosFindNext         Find next matching file
;   DosGetEnv           Get address of process environment string
;   DosGetInfoSeg       Get address of system variables segment
;   DosGetMessage       System message with variable text
;   DosOpen             Open file
;   DosPutMessage       Output message text to indicated handle
;   DosQCurDir          Query current directory
;   DosQCurDisk         Query current disk
;   DosQFileInfo        Query file information
;   DosQFileMode        Query file mode
;   DosRead             Read from file
;   DosSMRegisterDD     Register session switch notification
;   DosWrite            Synchronous write to file.
;
;-------------------------------------------------------------------------------------

	masm51
	.seq
	.286P

	.MODEL  SMALL

	INCLUDE PIINC.ASM
	INCLUDE 8530INC.ASM

	stdin   equ  0
        stdout  equ  1
        stderr  equ  2

        cr      equ  0dh
        lf      equ  0ah
	ht	equ  09h

extrn	DosWrite:far			; in OS2.lib

;----------------------------------------------------------
;these are for calls from the virtual device driver
;See "A_VDDEntry".
 Stack_Data      struc
          old_bp  dw      ?
          old_cs  dd      ?
          old_ip  dd      ?
          ul2     dd      ?
          ul1     dd      ?
          uFunc   dd      ?
  Stack_Data      ends

  Flat_Pointer    struc
          fp_offlo        DW      ?
          fp_offhi        DW      ?
          fp_sel          DW      ?
  Flat_Pointer    ends

  PhysAddr struc
          _lo     dw      (?)     ; low word of a 32-bit pointer
          _hi     dw      (?)     ; high word of a 32-bit pointer
  PhysAddr ends



;------------------------------------------------------------------------------------------------

;Define request packet structure.  Pointed to by es:bx on entry to stratagy routine.

REQPACKET STRUC
	PktLen		db	?	;length of packet in bytes
	PktUnit	db	?	;subnuit number if block device
	PktCmd		db	?	;Command to device driver
	PktStatus	dw	?	;Returned status word
	PktDOSLink	dd	?	;reserved
	PktDevLink	dd	?	;Device multiple-request link
	PktData	dw	?	;data words
REQPACKET ENDS

;PktStatus field bit equates

DONE_BIT			equ	0100h
BUSY_BIT			equ	0200h

ERROR_DEV_NOT_RDY		EQU	8102H	;Device not ready
ERROR_UNKNOWN_CMD		EQU	8103H	;Unknown command
ERROR_ACCESS_DENIED		EQU	8105H	;Access denied
ERROR_WRITE_FAULT		EQU	810AH	;Write fault
ERROR_READ_FAULT		EQU	810BH	;Read fault
ERROR_GEN_FAILURE		EQU	810CH	;General failure
ERROR_IOCALL_INTR		EQU	8111H	;Character I/O call interrupted.
ERROR_DEV_INUSE			EQU	8114H	;Device already in use

;--------------------------------------------
;Init request packet structure

INITPACKET STRUC
	IPktLen	db	?	;length of packet in bytes
	IPktUnit	db	?	;subnuit number if block device
	IPktCmd	db	?	;Command to device driver
	IPktStatus	dw	?	;Returned status word
	IPktDOSLink	dd	?	;reserved
	IPktDevLink	dd	?	;Device multiple-request link
	InitData1	db	?	;return number of devices here
	InitPtr1	dd	?	;pointer to DevHlp entry
	InitPtr2	dd	?	;pointer to init args
	InitData2	db	?	;driver num. for 1st block dev unit

INITPACKET ENDS
;---------------------------------------------------------------------------------
;   Request Block Format (DosDevIOCtl)
;
;   Ŀ
;    Field                       Length   
;   Ĵ
;    Request Header              13 BYTES 
;   Ĵ
;    Function Category           BYTE     
;   Ĵ
;    Function Code               BYTE     
;   Ĵ
;    Parameter Buffer Address    DWORD    
;   Ĵ
;    Data Buffer Address         DWORD    
;   Ĵ
;    System File Number          WORD     
;   

GIOPACKET STRUC
	GPktLen	db	?	;length of General I/O cntrl packet
	GpktUnit	db	?	;subnuit number if block device
	GPktCmd	db	?	;Command to device driver
	GPktStatus	dw	?	;Returned status word
	GPktDOSLink	dd	?	;reserved
	GPktDevLink	dd	?	;Device multiple-request link
;
	GIOCategory	db	?	;Gen I/O cntrl category
	GIOFunction	db	?	;function code
	GIOParmAdr	dd	?	;pointer to parameter buffer
	GIODataAdr	dd	?	;pointer to data buffer
	GIOSysFile	dw	?	;system file number
	GIOParmLen	dw	?	;Parameter buffer length
	GIODataLen	dw	?	;Data buffer length
	
GIOPACKET ENDS

;;Call from C: DosDevIOCtl(Devhandle, category, function, ParmList,
;			    ParmLengthMax, ParmLengthInOut, DataArea, DataLengthMax,
;				DataLengthInOut);

;
;---------------------------------------------------------------------------------
;READ/WRITE request packet structure
;
RWPACKET STRUC
	RWPktLen	db	?	;length of  packet
	RWpktUnit	db	?	;subnuit number if block device
	RWPktCmd	db	?	;Command to device driver
	RWPktStatus	dw	?	;Returned status word
	RWPktDOSLink	dd	?	;reserved
	RWPktDevLink	dd	?	;Device multiple-request link
;
	RWMedDesc	db	?	;Media Descriptor
	RWTransAddr	dd	?	;Transfer address (Physical)
	RWCount	dw	?	;Byte count
	RWSecNo	dd	?	;Starting sector number for block devices
	RWFileHandle	dw	?	;System file handle

RWPACKET ENDS
;---------------------------------------------------------------------------------
;Open/CLose Command packet

OCPACKET STRUC
	OCPktLen	db	?	;length of  packet
	OCpktUnit	db	?	;subnuit number if block device
	OCPktCmd	db	?	;Command to device driver
	OCPktStatus	dw	?	;Returned status word
	OCPktDOSLink	dd	?	;reserved
	OCPktDevLink	dd	?	;Device multiple-request link
;
	OCPktFileHndl	dw	?	;System file handle
;
OCPACKET ENDS

;---------------------------------------------------------------------------------
;used to store local variables in the stack frame
;
LOCALVAR STRUC

	var0		dw	?
	var1		dw	?
	var2		dw	?
	si_save	dw	?
	bx_save	dw	?
	es_save	dw	?
	ds_save	dw	?

LOCALVAR_SIZE	equ	$-LOCALVAR

LOCALVAR ENDS

;---------------------------------------------------------------------------------

CHAN_STRUC	STRUC

cs_int_no		dw	2 dup(?)	; Hardware Interrupt number
cs_io_addr		dw	2 dup(?)	; I/O address for card (jumpers)
cs_dma_channel		dw	2 dup(?)	; DMA channel for card (jumpers)
cs_speed		dw	2 dup(?)	; Baud rate (0 for external clock)
cs_txdelayparm		dw	2 dup(?)	; TX delay (length of flags before data)
cs_persist		dw	2 dup(?)	; P - persistance probability out of 256
cs_slottime		dw	2 dup(?)	; Slot time for backoff
cs_tailtime		dw	2 dup(?)	; time between end of frame and drop RTS
cs_clkmode		dw	2 dup(?)	; Clocking mode
cs_bufsiz		dw	2 dup(?)	; Buffer size
cs_numbufs		dw	2 dup(?)	; Number of buffers
;
cs_TXPackets		dd	?		;number of packets transmitted since OPEN
cs_RXPackets		dd	?		;number of good packets received since OPEN
cs_DCDState		dw	2 dup(?)	;1=rx carrier present
cs_RTSState		dw	2 dup(?)	;1=tx is on
cs_RcvState		db	4 dup(?)	;ACTIVE, etc
cs_TxState		db	4 dup(?)	;IDLE,DEFER, etc
cs_RxInts		dd	?		;Receive interrupts
cs_TxInts		dd	?		;Transmitter interrupts
cs_ExInts		dd	?		;External interrupts
cs_CrcErr		dd	?		;Number of CRC errors
cs_RxOvrs		dd	?		;Receiver overruns
cs_TxUndr		dd	?		;Transmitter underruns

cs_Extra1		dd	?
cs_Version		db	4 dup(?); Vminor, Vmajor, 0, 0  version numbers
cs_RDFlag		db	?	;1 means read in progress
cs_WRFlag		db	?	;1 means write operation waiting for buffer
cs_FlushFlag		db	?	;flush OUT buf in progress
cs_XferAddr		dd	?	;temp storage for callers data transfer address in WRITE
;
;  Buffer pool management pointers (see enqueue and dequeue)
;  structure is <pointer> <counter>    "counter" increments when buffer is added to queue
;
cs_rxbufptr		dw	2 dup(?)	; * Pointer to current rx buffer
cs_rxqueue		dw	2 dup(?) 	; Head of RX queue 
cs_txbufptr		dw	2 dup(?) 	; * Pointer to current tx buffer
cs_freelist		dw	2 dup(?)	; Head of free list
cs_allocptr		dw	2 dup(?)	; * Pointer to free buffer area
cs_txqueue		dw	2 dup(?)	; Head of transmit queue
;
num_ptrs equ ($-cs_rxbufptr) / 4

sizeof_pub_chan_struc equ $-cs_int_no
;
cs_bufstart		dw	?	; starting address of DMA buffers 
cs_DmaMemSize		dw	?	; total size of DMA buffer area for this channel
cs_txlength		dw	? 	; length of packet to be transmitted
cs_tstate		db	?	; transmitter state
cs_rstate		db	?	; receiver state
cs_txcnt		dw	?	; tx char counter
cs_rxcnt		dw	?	; rx char counter
cs_rx_tc		dw	?	; baud rate time const for receive.
cs_tx_tc		dw	? 	; Time constant for baud rate generator (transmit)
cs_handle		dw	?	; file handle
cs_opencounter		dw	?
cs_R8530WRT		db	16 dup(?) ; 16 scc WRITE registers for debugging
cs_R8530RD		db	16 dup(?) ; 16 scc READ registers for debugging
cs_watchdog		dw	?	; watchdog timer value
cs_NBReadMode		db	?	; 0=Blocking read  1=Non-Blocking read
cs_CmdBfr		db	5 dup(?) ;
cs_GioPkt			GIOPACKET <>	;synthetic Gen IOCtl packet
cs_V86INTENAB		db	?		;bit 0 = 1 - enable v86 interrupts
cs_PDDName		db	9 dup(?)	;asciiz name of this driver



CHAN_STRUC ENDS







;---------------------------------------------------------------------------------
;OS/2 Device Help calls
;
DH_DevDone		equ	1	;Device done
DH_Yield		equ	2	;yield cpu to equ or higher priority thread
DH_TCYield		equ	3	;Yield cpu to time critical thread
DH_ProcBlock		equ	4	;Block process
DH_ProcRun		equ	5	;Run a blocked process
DH_SemRequest		equ	6	;Claim a semaphore
DH_SemClear		equ	7	;Clear a semaphore
DH_SemHandle		equ	8	;Get sem handle
DH_Lock			equ	13h	;lock a segment or selector
DH_PhysToVirt		equ	15h	;Convert physical to virtual address
DH_VirtToPhys		equ	16h	;Convert virtual to physical address
DH_AllocPhys		equ	18h	;Allocate physical memory
DH_FreePhys		equ	19h	;Free physical memory
DH_SetIRQ		equ	1bh	;Set interrupt handler
DH_UnSetIRQ		equ	1ch	;Reset interrupt handler
DH_VerifyAccess		equ	27h	;verify access to memory
DH_AllocGDTSelector	equ	2dh	;Allocate GDT descriptors
DH_PhysToGDTSelector	equ	2eh	;Convert physical to virtual GDT address
DH_RealToProt		equ	2fh	;Switch from real to protect mode
DH_ProtToReal		equ	30h	;switch from protect to real mode
DH_EOI			equ	31h	;Issue end-of-interrupt
DH_UnPhysToVirt		equ	32h	;Mark Phys to Virt complete
DH_RegisterStackUsage	equ	3Ah	;register stack usage
DH_RegisterPDD		equ	50h	;register PDD entry point for VDD - PDD comm
DH_Beep			equ	52h	;DosBeep
DH_VirtToLin		equ	5bh	;Virtual to Linear address conversion
DH_AllocateCtxHook	equ	63h	;Allocate a context hook
DH_ArmCtxHook		equ	65h	;Arm a context hook
DH_FreeCtxHook		equ	64h	;Free a context hook

;----------------------------------------------------------------------------------

; transmitter states
IDLE		equ	0 ; Transmitter off
TXDELAY		equ	1 ; Sending leading flags
ACTIVE		equ	2 ; Transmitter on, sending data
UNDERRUN	equ	3 ; Transmitter on, flushing CRC
FLAGOUT		equ	4 ; CRC sent - attempt to start next frame
DEFER		equ	5 ; DCD Active - DEFER Transmit
CRCOUT		equ	6 ; Waiting for CRC bytes to clear the fifo
;
; receiver states
RXERROR		equ	2 ; Error -- Aborting current Frame
RXABORT 	equ	3 ; ABORT sequence detected 
TOOBIG 		equ	4 ; too large a frame to store



DEFAULTBUFSIZE	equ	2088
MAXBFRS		equ	15


CLKHI	equ	38h	; Values for PI2 card
CLKLO	equ	4000h

;CLKHI	equ	1ch     ; Values for original PI card
;CLKLO	equ	2000h


GENDEV		equ	11		;General Device Control category code


;-----------------------------------------------------------------------------------
%NEWPAGE
;******************** DATA SEGMENT STARTS HERE *************************


_DATA SEGMENT WORD PUBLIC 'DATA'

;Device driver header

dev_header0	equ	$
ptr_to_next0	dd	_DATA:dev_header1	;Pointer to the B side header
device_attr0	dw	8980h			;Device Attribute Bits  (level 3 char driver)
offst0		dw	_TEXT:A_STRATEGY	;address of A side strategy routine
reserved0	dw	-1
dev_name0	db	'pi0a    '		;device name (may be changed at INIT time)
res20		dw	4 dup(0)		;reserved
cap_bit_strip0	dd	1			;accept DosDevIOCtl2 req packets


dev_header1	equ	$
ptr_to_next1	dd	0ffffffffh		;End of linked list of headers
device_attr1	dw	8980h			;Device Attribute Bits  (level 3 char driver)
offst1		dw	_TEXT:B_STRATEGY	;address of B side strategy routine
reserved1	dw	-1
dev_name1	db	'pi0b    '		;device name (may be changed at INIT time)
res21		dw	4 dup(0)		;reserved
cap_bit_strip1	dd	1			;accept DosDevIOCtl2 req packets

hdr_size	equ	$-dev_header0

;-------------------end of device header ------------------------

;Device driver data area

;----------------------------------------------------------------

device_help	dd	?			;entry point of device help
drv_parms	dd	?			;pointer to drivers cmd line params
max_param	db	80			;max length of parameter string
save_bx		dw	?
save_es		dw	?

;-----------------------------------

;These defaults can be overridden by command line parameters
;all can be read as long ints.

ParamStart	label


int_no		dw	5,0		; Hardware Interrupt number
io_addr		dw	0380h,0	; I/O address for card (jumpers)
dma_channel	dw	1,0	 	; DMA channel for card (jumpers)
bufsiz		dw	DEFAULTBUFSIZE,0; Buffer size
numbufs		dw	MAXBFRS,0	; Number of buffers

sizeof_cardparms  equ $-ParamStart

A_speed		dw	0,0		; A Baud rate (0 for external clock)
A_clkmode	dw	0,0		; A ch Clocking mode
B_speed		dw	0,0		; B Baud rate
B_clkmode	dw	0,0		; B clock mode

;
NParms		equ	($-ParamStart) / 4  ;Number of parameters

SizeOfParms	equ	$-ParamStart
;
;
ParmRange	dw	2,7		;low, high HW interrupt IRQ
		dw	300h,380h	;I/O port
		dw	1,3		;DMA channel
		dw	128,3072	;Buffer size
		dw	8,MAXBFRS	;Number of buffers
		dw	0,57600	;A Baud rate
		dw	0,1		;A clocking mode
		dw	0,57600	;B Baud rate
		dw	0,1		;B clocking mode

;
BadValue	dw	0		;non zero if param out of range

;---------------------------------------------------------------------
;chA and chB are data structures of type CHAN_STRUC which have 
;all the variables for channels A and B.  The si register
;is set to point to chA or chB when this driver is
;called from the user or during interrupt servicing.
;In general, si must be preserved at all times!

public chA,chB

chA		CHAN_STRUC	<>	;channel A varaibles

sizeof_chan_struc	equ	$-chA

chB		CHAN_STRUC	<>	;channel B variables



;-----------------------------------------------------------------------

;These are the default Param values:

cha_defaults	label
;
cha_txdelay	dd	20		;20 ms
cha_persist	dd	128		;128/256
cha_slottime	dd	15		;15 ms
cha_tailtime	dd	3		;3 ms

sizeof_defaults	equ $-cha_defaults

chb_defaults	label
;
chb_txdelay	dd	30		;300 ms
chb_persist	dd	128		;128/256
chb_slottime	dd	10		;100 ms
chb_tailtime	dd	3		;30 ms

;--------------------------------------------------------------------
;
MsgPtr		dw	?
MsgCnt		dw	?
ParmPtr		dw	?
RangePtr	dw	?
;
dma_page_save	dw	0
dma_dest_save	dw	0
dma_wcr_save	dw	0

; The following 3 values are calculated at initialization and depend
; on which DMA channel has been selected

page_addr	dw	83h		; To be calculated from dma channel
dma_dest	dw	2		; Defaults are for channel 1
dma_wcr		dw	3
tc_mask		db	2		;terminal count mask for DMA status register

;
acc_delay 	dw	0,0	; cpu speed time constant
diff		dw	0,0	; acc_delay = 5000/diff
tick1		dw	0,0	; diff = tick1 - tick2
tick2		dw	0,0
T0tick1		dw	0
T0tick2		dw	0
T0diff		dw	0	; T0tick2 - T0tick1  (from PI card timer 0)
PItype		dw	0ffffh	; PI2 card = 1   original PI = 0
;
;
wlen		dw	?	;length of string written by DOSWRITE	
chrbuf		db	18 dup(0)
DmaMemSize	dw	0	;total length of all DMA buffers
;
dataseg_end	dw	0	;contains last valid address in data segment
lockhandle	dw	0,0
hdr_cksum	dw	?
IrqLoopLimiter	dw	?	;used in HWIntHandler to prevent ... 
				; ..infinite loop with interrupts disabled
random		db	0
;
PDDName		db	"PIPDD",0	;We're know by this name to the Virtual Device Driver
VDDEntryPtr	df	CODEPTR ptr ?	;16:32 pointer to VDD entry point
;
;
StackUsage	label
SU_cbStruct	dw	14	;size of this structure
SU_flags	dw	0	; 0001 indicates routine enables interrupts
SU_iIRQ		dw	?	; IRQ number serviced
SU_cbStackCLI	dw	1024	;bytes of stack used with ints disabled
SU_cbStackSTI	dw	1024	;bytes of stack used with ints enabled
SU_cbStackEOI	dw	0	;bytes of stack used after EOI issued
SU_cNest	dw	1	;max levels of nesting

;
;
; DMA buffer space
; Buffers consist of bufsize bytes, followed by a near next pointer (2 bytes),
; followed by a length count (2 bytes), followed by 32 bit physical address
; (4 bytes) for the DMA controller.

bufstart	label	byte
buffers		db	0F800h	dup(?) 	; Reserve 63488 bytes
;						; will be reduced after INIT time
;
SizeOfDMA	equ	$-bufstart

END_OF_DATA	equ	$

_DATA	ENDS


;------------------------------------------------------------------------------------------

%NEWPAGE
;                ***************CODE SEGMENT STARTS HERE **********



_TEXT SEGMENT WORD PUBLIC 'CODE'

assume cs:_TEXT, ds:_DATA, es:nothing

LOCALS					;@@ prefix means local symbol


		.386P			;Allow 386 32 bit instructions

;-------------------------------------------------------------------------
copyright	db	"(C) Copyright 1995 by Dale A. Heatherington",0
;-------------------------------------------------------------------------

last_command	equ	16			;codes > 16 illegal

command_table	dw	INIT			;0 calls init routine
		dw	BAD			;1 to 7 not supported
		dw	BAD			;2
		dw	BAD			;3
		dw	READ			;4 READ
		dw	BAD			;5
		dw	IN_STATUS		;6 Input Status
		dw	BAD			;7
		dw	WRITE			;8 WRITE
		dw	BAD			;9
		dw	OUT_STATUS		;10 Output Status
		dw	FLUSH			;11 FLUSH
		dw	BAD			;12
		dw	OPEN			;13 OPEN
		dw	CLOSE			;14 CLOSE
		dw	BAD			;15
		dw	GENIOCTL		;16 genioctl		
;
;-------------------------------------------------------------------

;
;Generic I/O control function command table

GenFuncTbl	dw	offset dummy		;0x40	function number
		dw	offset SysNote		;0x41
		dw	offset GetAllPiPrams	;0x42
		dw	offset SetPiSpeed	;0x43
		dw	offset SetPiTXDelay	;0x44
		dw	offset SetPiPersist	;0x45
		dw	offset SetPiSlotTime	;0x46
		dw	offset SetPiTailTime	;0x47
		dw	offset ClrPktCounters	;0x48
		dw	offset SetPiClkMode	;0x49
		dw	offset SetRdMode	;0x4a

GenFuncTblSize	equ	$-GenFuncTbl



;----------------------------------------------------------------------------------
A_STRATEGY PROC FAR

		call	checksum
		mov	[hdr_cksum],ax
		mov	si,offset ds:chA		;si point to channel A variables
		mov	al,byte ptr es:[bx].PktCmd	;get command code
		cmp	al,last_command		;check range
		ja	SHORT @@UNSUP
		cbw					;conver byte to word
		mov	di,ax				;move command to di
		mov	word ptr[si.cs_Extra1],ax	;save command for debug
		shl	di,1				;mpy by 2
		mov	ax,0				;0 in ax means A side call
		call	word ptr cs:command_table[di]	;call command routine
		call	checksum
		cmp	ax,[hdr_cksum]
		jne	TRAP0
		pushf
		pop	ax
		test	ax,0200h			;test int flag
		jz	trap0
		or	es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret

@@UNSUP:	call	BAD
		ret

TRAP0:		int 3			;device driver header is corrupted
		jmp @@unsup

A_STRATEGY ENDP
;---------------------------------------------------------------------

B_STRATEGY PROC FAR
		call	checksum
		mov	[hdr_cksum],ax
		mov	si,offset ds:chB		;si point to channel B variables
		mov	al,byte ptr es:[bx].PktCmd	;get command code
		cmp	al,last_command		;check range
		ja	SHORT @@UNSUP
		cbw					;conver byte to word
		mov	di,ax				;move command to di
		mov	word ptr[si.cs_Extra1],ax	;save command for debug
		shl	di,1				;mpy by 2
		mov	ax,1				;1 in ax means B side call
		call	word ptr cs:command_table[di]	;call command routine
		call	checksum
		cmp	ax,[hdr_cksum]
		jne	TRAP0
		pushf
		pop	ax
		test	ax,0200h			;test int flag
		jz	trap0

		or	es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret

@@UNSUP:	call	BAD
		ret

B_STRATEGY ENDP



;-----------------------------------------------------------------------

;Come here for all unimplimented stratagy commands

BAD	PROC	NEAR

		mov	es:[bx].PktStatus, ERROR_UNKNOWN_CMD
		ret

BAD	ENDP
;-------------------------------------------------------------------------
;

;Entry point used by Virtual Device Driver
;


VDDEntry	PROC FAR

	push	bp
	mov	bp,sp			;point bp to stack frame
	push	ds
	push	es
;;;;	pushad
	mov	ax,_DATA
	mov	ds,ax			;Get DS addressability
	call	VDDCmds		;execute command from VDD
;;;;	popad
	pop	es
	pop	ds
	pop	bp
	db	66h			;32 bit return
	ret	12			;clean stack



VDDEntry ENDP

;------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
;
; Execute commands from Virtual Device Driver

SETVDDADR	equ	0	;Set address of VDD entry point
RXIRQ		equ	4	; 4,5 - used to tell VDD to gen a V86 interrupt
INT_COMPLETE	equ	8	;A side is 6,  B side is 7
ENAB_V86_INTS	equ	0ch	;Allow us to generate virtual DOS interrupts, B is 0x0d
DISAB_V86_INTS	equ	10h	;Disable DOS interrutps, B is 0x11
GetName		equ	14h	; 14h = A   15h = B
GetIRQ		equ	18h	;get IRQ number of the driver
GetPDD_DS	equ	1ch
NONBLOCK	equ	20h	;set for non-blocking read




VDDCmds PROC NEAR

	mov	si, offset ds:chA		;assume channel A
	mov	ax,word ptr[bp.uFunc]		;get comand from VDD
	test	ax,1				;see if command is for channel B (lsb set)
	jz	short @@go
	mov	si,offset ds:chB		;Set for channel B if lsb is set
	
@@go:	cmp	ax,SETVDDADR			;command 0 - Get VDD Entry point
	jne	short @@0001
;						;Do A side VDD entry address store
	mov	ax,[bp].ul1._lo		;get 16 bit selector
	mov	[VDDEntryPtr].fp_sel,ax
	mov	ax,[bp].ul2._lo		;get low part of 32bit offset
	mov	[VDDEntryPtr].fp_offlo, ax
	mov	ax,[bp].ul2._hi		;get hi part of 32 bit offset
	mov	[VDDEntryPtr].fp_offhi,ax 	;16:32 address of VDD in VDDEntryPtr
	jmp	@@exit
;
;
@@0001:	cmp	ax,INT_COMPLETE		; data has been read (A side)
	jne	short @@0003
	jmp	short @@exit			;NOT IMPLEMENTED
;
@@0003:	cmp	ax,INT_COMPLETE+1		;B side INT complete
	jne	short @@0005
	jmp	short @@exit			;NOT IMPLEMENTED

;
@@0005: and 	ax,0fffch			;clear the A/B  bits  (use si only now)
	cmp	ax,ENAB_V86_INTS		;
	jne	short @@0006
	mov	[si.cs_V86INTENAB],1		;enable virtual 8086 interrupts
	jmp	short @@exit
;
@@0006:	cmp	ax,DISAB_V86_INTS
	jne	short @@0007
	mov	[si.cs_V86INTENAB],0		;disable virtual 8086 interrupts
	jmp	short @@exit

@@0007:	cmp	ax,GetIRQ
	jne	short @@0008
	mov	eax,0
	mov	ax,[si.cs_int_no]
	ret					;return interrupt number in eax
;
@@0008:	cmp	ax,GetName
	jne	short @@000A
	cmp	si,offset ds:chA
	jne	short @@0009
	mov	ax, offset ds:dev_name0
	ret				; offset address of nameA in eax
;
@@0009:	mov	ax, offset ds:dev_name1
	ret				; offset address of nameB in eax
;
@@000A: cmp	ax,GetPDD_DS
	jne	@@000B
	mov	ax,ds
	ret				;return data segment selector in ax
;
@@000B:	cmp	ax,NONBLOCK
	jne	@@error
	mov	[si.cs_NBReadMode],1	;set for non-blocking read
	jmp	short @@exit
;
@@error: xor	eax,eax			;return false if bad cmd
	 ret
;
@@exit: mov	eax,1				;return true if good cmd
	ret

VDDCmds ENDP
;-------------------------------------------------------------------------
;

GenV86Int	PROC NEAR

	pushad					;save all registers
	mov	ax,word ptr[VDDEntryPtr] 	;48 bit test for NULL
	or	eax,dword ptr[VDDEntryPtr+2]
	jz	@@exit				;don't do it if NULL pointer
	mov	eax,RXIRQ			;assume A side IRQ
	cmp	si,offset chA			;see if this is A or B interrupt
	je	short @@0001
	mov	eax,RXIRQ+1			;else B side
@@0001:
	push	eax				;push IRQ ID/cmd (32 bit)
	xor	eax,eax
	push	eax				;push 0  (32 bit)
	push	eax				;push 0  (32 bit)
	call	[VDDEntryPtr]			;call Virtual Device Driver
;	
@@exit:	popad
	ret
	


GenV86Int ENDP
;------------------------------------------------------------------------

;-------------------------------------------------------------------------

IN_STATUS PROC NEAR

	mov	es:[bx].PktStatus, DONE_BIT
	cmp	[si.cs_rxqueue+2], 0		;Anything in the receive queue?
	je	short @@exit			;yes - exit busy clear
	or	es:[bx].PktStatus, BUSY_BIT	; no - set busy
@@exit:	ret



IN_STATUS ENDP
;-------------------------------------------------------------------------

OUT_STATUS PROC NEAR

	mov	es:[bx].PktStatus, DONE_BIT
	cmp	[si.cs_txqueue+2], 0		;Anything in the transmit queue?
	jne	short @@exit			; no - exit busy clear
	or	es:[bx].PktStatus, BUSY_BIT	;yes - set busy
@@exit:	ret


OUT_STATUS ENDP

;----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
INIT PROC NEAR

	cmp	ax,0			;A or B ?
	jne	@@1
	call	A_INIT			;Do main A side init
	ret
@@1:	call	B_INIT			;Do minor B side init
	ret


INIT ENDP

;-------------------------------------------------------------------------------------

checksum	PROC NEAR

	push	cx
	push	bx
	mov	cx,hdr_size
	mov	bx, offset dev_header0
	mov	ax,0
@@1:	add	al,byte ptr [bx]
	adc	ah,0
	inc	bx
	loop	@@1
	pop	bx
	pop	cx
	ret			;return header checksum in ax

checksum ENDP

;-----------------------------------------------------------------------------------------------
FLUSH	PROC	NEAR

;		int 3
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret

FLUSH	ENDP

;-------------------------------------------------------------------------------------------------
;This OPENS the device
;
;
OPEN	PROC	NEAR

		push	bp				;save bp
		sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
		mov	bp,sp				;set bp to local variables
;
		mov	[bp].ds_save,ds		;save ds in stack frame
		mov	[bp].es_save,es		;save es
		mov	[bp].bx_save,bx		;save bx
;
		cmp	[si.cs_OpenCounter],0
		je	first_open
;;;;;		 inc	[si.cs_OpenCounter]		;Multiple opens not allowed in this version
		
		mov	word ptr es:[bx].PktStatus,ERROR_DEV_INUSE	; Device busy
		jmp	@@exit				;exit

first_open:	pushf
		cli					;interrupts off
		mov	ax,[lockhandle]
		or	ax,[lockhandle+2]
		jnz	locked				;Only do this once
							;Locking our own data segment may
							;be unnessasary.  Better safe than sorry.
		mov	ax,ds				;lock our data segment
		mov	bl,0				;block till available
		mov	bh,1				;normal lock
		mov	dl,DH_Lock
		call	[device_help]			;Tell OS/2 not to move this segment!
		jc	nolock
		mov	[lockhandle],ax
		mov	[lockhandle+2],bx
locked:
		call	CREATE_BUFFERS			;"format" the buffer memory
;		
		mov	eax,0
		mov	[si.cs_TXPackets],eax		;Clear PI status registers
		mov	[si.cs_RXPackets],eax
		mov	[si.cs_RxInts],eax
		mov	[si.cs_TxInts],eax
		mov	[si.cs_CrcErr],eax
		mov	[si.cs_RxOvrs],eax
		mov	[si.cs_TxUndr],eax
		mov	[si.cs_ExInts],eax
		mov	[si.cs_FlushFlag],al
		mov	[si.cs_RDFlag],al		;read not in progress
		mov	[si.cs_WRFlag],al		;Write not waiting for buffer
		mov	[si.cs_NBReadMode],al		;Blocking read is default
		
;
		call	scc_init			;inititalize SCC chip for this channel
		call	EnablePI			;Turn on PI interrupts
		mov	bx,[bp].bx_save		;get bx
		mov	ax, es:[bx].OCPktFileHndl	;get file handle
		mov	[si.cs_handle],ax		;remember it
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		inc	[si.cs_OpenCounter]
		popf
		jmp	SHORT @@exit

nolock:		pop	bx
		mov	word ptr es:[bx].PktStatus, ERROR_GEN_FAILURE
		popf
		
@@exit:
		add	sp,LOCALVAR_SIZE		;clean stack
		pop	bp
		ret


OPEN	ENDP

;--------------------------------------------------------------------------------------------------

CLOSE	PROC	NEAR

	pushf
	cli
;
	dec	[si.cs_OpenCounter]		;1 less OPEN around
	jns	@@ce1				;if counter > zero don't really close down
	mov	[si.cs_OpenCounter],0		;don't allow counter to go minus
;						; close for real now
	mov	[si.cs_V86INTENAB],0		;Disable simulated DOS interrupts
	mov	[si.cs_handle],0ffffh		;invalidate handle
	mov	[si.cs_WRFlag],0		;kill write

@@ce0:	test	[si.cs_RDFlag],1		; is a READ pending?
	jz	@@ce1				; no, don't wake up READ if it's not pending
	push	bx
	lea	bx, [si.cs_RDFlag]		;get event id to ax:bx
	mov	ax, ds
	mov	dl,DH_ProcRun			;Wake up the READ strategy routine
	call	[device_help]			;
	pop	bx
;
@@ce1:	popf					;restore interrupts
	mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
	ret


CLOSE	ENDP

;----------------------------------------------------------------------------------

;READ stratagy routine.
;
;If data is in [altbufptr] it reads it immediatly else
;it blocks until data arrives.  I have attempted to
;protect it from recursion.


READ	PROC	NEAR

;;;;	int 3
	push	bp				;save bp
	sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
	mov	bp,sp				;set bp to local variables

;
	mov	[bp].ds_save,ds		;save ds in stack frame
	mov	[bp].es_save,es		;save es
	mov	[bp].bx_save,bx		;save bx
	mov	[bp].si_save,si		;save si
;

	pushf
	cli				;interrupts off

	test	[si.cs_RDFlag],1		;see if we're already reading
	jz	readit
	mov	word ptr es:[bx].PktStatus, ERROR_DEV_NOT_RDY	;Not ready
@@01:	popf				;restore interrupt state
	jmp	r_exit			;exit
;
readit:
	lea	bx,[si.cs_rxqueue]
	call	dequeue			;see if we have data in the RX queue
	mov	[bp].var2,ax			;save buffer address to var2
	jnc	short nw0			; yes, data present - go get it now
						;  else sleep till some comes in
readit1:cmp	[si.cs_NBReadMode],0		; Non-Blocking Read mode?
	jne	@@NB				; no - exit now with byte count=0
	mov	ax,ds				; make event id from ds:offset RDFlag
	lea	bx,[si.cs_RDFlag]
	mov	di,-1				; no time-out - wait forever
	mov	cx,-1
	mov	dh,0				; sleep interruptable
	mov	dl,DH_ProcBlock		; block this process until packet is received
	mov	[si.cs_RDFlag],1		; indicate we're waiting for packet now
						;    interrupts enabled in device_help call
	call	[device_help]			; Snooze until a packet is received
	mov	bx,[bp].bx_save		; after wake-up restore bx
	jnc	normal_wakeup			; test reason for wake-up, jmp if normal
@@hiv:	mov	[bp].var1,ERROR_IOCALL_INTR	; return status code
	popf					; restore interrupts
	jmp	SHORT Zero_Rd			; Abnormal exit with zero bytes read
;
normal_wakeup:
	cmp	[si.cs_handle],0ffffh		;Handle invalid due to CLOSE request?
	je	short @@hiv			;yes exit - invalid handle
	lea	bx,[si.cs_rxqueue]
	call	dequeue			;see if we have data in the RX queue
	mov	[bp].var2,ax			;save buffer address to var2
	jnc	short nw0
	popf
	jmp	short Zero_Rd			; Error if still no buffer in queue
;
nw0:	popf					;restore interrupt state
	mov	[bp].var1,DONE_BIT		;assume normal return status
	mov	bx,[bp].var2			;buffer address to bx
	mov	di,[si.cs_bufsiz]		;buffer size to di
	mov	cx,[bx+di+2]			;get length of data to cx
	cmp	cx,0
	je	Zero_Rd			;error if zero bytes in buffer
	mov	bx,[bp].bx_save
	mov	ax,word ptr es:[bx].RWCount	;get max number of bytes to xfer in ax
	cmp	ax,cx
	jae	nw1				;jmp if user buffer is larger than packet..
	mov	cx,ax				;..else truncate packet to user buffer size
nw1:	mov	word ptr es:[bx].RWCount,cx	;tell user how many bytes he's getting
	mov	[bp].var0,cx			;save byte count in local variable 0
	mov	ax,word ptr es:[bx].RWTransAddr+2 ;physical destination address (high) to ax
	mov	bx,word ptr es:[bx].RWTransAddr   ;physical dest. addr. (low) to bx
	mov	dh,1				;1= want result in es:di
	mov	dl,DH_PhysToVirt		;convert physical to virtual in es:di
	pushf
	cli					;interrupts off
	call	[device_help]			;do it
	jnc	p2vok				;no carry means OK
	popf					;restore interrupts
	mov	[bp].var1,ERROR_READ_FAULT
	jmp	SHORT Zero_Rd
;
p2vok:	jnz	p2vok2				;jmp if mode not changed and phys to virt OK
	mov	[bp].var1,ERROR_READ_FAULT
	popf					;restore interrupts
;						;Fall into Zero_Rd below
;
Zero_Rd:					;ax=return status code
	mov	bx,[bp].bx_save		;restore es:bx
	mov	es,[bp].es_save
	mov	ax,[bp].var1
	mov	word ptr es:[bx].PktStatus,ax	;set return code
	mov	word ptr es:[bx].RWCount, 0	;set xfer count to zero
	jmp	SHORT r_exit			;Operation failed
;
;
;Come here after normal wakeup and successful physical to virtual address conversion
;
p2vok2:
	mov	cx,[bp].var0			; recover count
	mov	si,[bp].var2			; get RX buffer address to si
	pop	dx				; pop saved flags to dx
	mov	[bp].var0,dx			;save flags in var0
	cld					; set to increment si and di
	rep	movsb		;** move data to user buffer ( ds:si to es:di cx=count) **
	mov	es,[bp].es_save
	mov	si,[bp].si_save		;restore si
	

	mov	ax,[bp].var2			;get rx buffer address to ax
	lea	bx,[si.cs_freelist]
	call	enqueue			;return the buffer to the free list
;
	cmp	[si.cs_rxbufptr],0		;was the receiver out of buffers?
	jne	short @@bufok			;no, jmp
	lea	bx,[si.cs_freelist]		;else get a new buffer for the receiver
	call	dequeue			;
	mov	[si.cs_rxbufptr],ax		; Save address of new buffer in rxbufptr
	jc	short @@bufok			; error if no buffers available
	call	TX_OFF				; start receiver again
;
@@bufok:
	mov	bx,[bp].bx_save			;restore bx
	mov	word ptr es:[bx].PktStatus,DONE_BIT	; Normal completion
	push	[bp].var0				;push saved flags
	popf						;popf to restore interrupt state
r_exit:
	add	sp,LOCALVAR_SIZE			;clean stack
	pop	bp
	ret

@@NB:	popf
	mov	bx,[bp].bx_save
	mov	es,[bp].es_save
	mov	word ptr es:[bx].PktStatus,DONE_BIT	; Normal completion
	mov	word ptr es:[bx].RWCount, 0	;set xfer count to zero
	jmp	short r_exit
	
READ ENDP
;--------------------------------------------------------------------------------


WRITE PROC NEAR


; Copy packet into local DMA approved buffer
; Enqueue it for transmission. If queue is full, wait for a buffer
; to become free.
;
;;;	int 3
	push	bp				;save bp
	sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
	mov	bp,sp				;set bp to local variables

	mov	[bp].ds_save,ds		;save ds in stack frame
	mov	[bp].es_save,es		;save es
	mov	[bp].bx_save,bx		;save bx
	mov	[bp].si_save,si		;save si
;
wrt:	mov	ax,word ptr es:[bx].RWTransAddr+2 ;physical source address (high) to ax
	mov	[bp].var1,ax		  	;save it in [bp+2]
	mov	ax,word ptr es:[bx].RWTransAddr   ;physical source address (low) to ax
	mov	[bp].var0,ax		  	;save in in [bp+0] ;

w_nw:	cmp	[si.cs_handle],0ffffh		;file handle invalid?
	je	short @@hiv			;yes - exit
	mov	bx,[bp].bx_save		;restore bx
	mov	ax,[si.cs_bufsiz]		;max number of bytes we can handle to ax
	mov	cx,word ptr es:[bx].RWCount	;get number of bytes to xfer in cx
;
;
@@nuc:	cmp	cx,03fffh			;arbitrary magic number
	jne	@@normal
;						;warning: major hack here...
	call	FileSysIOCtl			;if length=3fff then its a IOCtl command from DOS
	jmp	w_exit
;
@@normal:
	cmp	ax,cx
	jae	w_nw0				;jmp if our buffer will hold complete packet..
	mov	cx,ax				;..else truncate packet to our buffer size
w_nw0:	mov	word ptr es:[bx].RWCount,cx	;  and tell user how many bytes we sent
	cli					;interrupts off
	lea	bx,[si.cs_freelist]		; Get a buffer from the freelist
	call	dequeue			;buffer addr in ax
	mov	[bp].var2,ax			;save buffer address in stack frame
	jnc	w_nw1				;jmp if buffer available
	lea	bx,[si.cs_txqueue]		;No buffer available
	mov	ax,[bx+2]			;see if there's other stuff in TX queue
	cmp	ax,0
	jne	short @@001			;jmp if tx queue has at least 1 packet waiting
	lea	bx,[si.cs_rxqueue]		; else steal a buffer from rxqueue...
	call	dequeue			; ...to prevent deadlock
	mov	[bp].var2,ax			;save stolen buffer address in var2
	jc	w_err				;exit with zero bytes sent if no buffer there
	jmp	short w_nw1			;run with stolen receiver buffer now
;
;						;Wait a while for a buffer to become free
@@001:	mov	ax,ds				;make event id from ds:offset WRFlag
	lea	bx,[si.cs_WRFlag]
	mov	di,0				;set time-out to 10 sec
	mov	cx,10000
	mov	dh,0				;sleep interruptable
	mov	dl,DH_ProcBlock		;block this process until buffer available
	mov	[si.cs_WRFlag],1		; indicate we're waiting for buffer now
						;  interrupts enabled in device_help call
	call	[device_help]			; Snooze until a buffer is free or timeout
	sti					;interrupts on
;
						; Wake up when buffer is ready, restore bx, es
	jnc	w_nw				; try again to get a buffer
	jz	w_err2				;  error - timeout.
;
@@hiv:	mov	es,[bp].es_save		; restore es:bx
	mov	bx,[bp].bx_save
	mov	word ptr es:[bx].PktStatus, ERROR_IOCALL_INTR	;I/O call interrupted error
	mov	word ptr es:[bx].RWCount, 0	;set xfer count to zero
	jmp	SHORT w_exit
;
w_nw1:	;;;;sti					; interrupts on
;
	mov	di,[bp].var2			; DMA buffer address to di
	mov	bx,[si.cs_bufsiz]		; DMA buffer size to bx
 	mov	[bx+di+2],cx			; Tack on length
;
	mov	ax,ds
	mov	es,ax				; set es to data segment
	mov	ax,[bp].var1			; physical source address (high) to ax
	mov	bx,[bp].var0			; physical source address (low) to bx
	mov	dh,0				; 0 = want result in ds:si
	mov	dl,DH_PhysToVirt		; convert physical to virtual in ds:si
	call	[device_help]			; do it
	jc	w_err				;  carry means error
	cld					; direction is increment
	rep	movsb				; Copy memory ( ds:si to es:di cx=count)
	mov	ds,[bp].ds_save		; restore ds
	mov	si,[bp].si_save		; restore si
	mov	ax,[bp].var2			; recover buffer address in ax
	lea	bx,[si.cs_txqueue]		; Append it to the tx queue
	inc	[si.cs_TXPackets]		;count this packet (32 bit inc)
;
	cli					;interrupts off
	call	enqueue
	mov	al,[si.cs_tstate]		;see if transmitter is idle
	cmp	al,IDLE
	sti					;interrupts on
	jne	@@not_idle
	cmp	si,offset ds:cha		;A side or B side??
	je	short @@send_A			;if not idle, start sending on the A side
	call	B_TXINT			;....or the B side
	jmp	short @@not_idle
@@send_A:
	call	SEND_PKT_1			; Start transmitting on the A side
@@not_idle:
	mov	es,[bp].es_save
	mov	bx,[bp].bx_save
	mov	word ptr es:[bx].PktStatus,DONE_BIT	; Normal completion
	jmp	SHORT w_exit

w_err:	mov	ds,[bp].ds_save
w_err2: mov	es,[bp].es_save
	mov	bx,[bp].bx_save
w_err3:	mov	word ptr es:[bx].PktStatus, DONE_BIT	;Error is indicated by 0 bytes transmitted
	mov	word ptr es:[bx].RWCount,0		;tell user zero bytes sent
w_exit:	add	sp,LOCALVAR_SIZE		;clean stack
	pop	bp
	sti					;interrupts on
	ret
	

WRITE ENDP

;-----------------------------------------------------------------------------------
;  FileSysIOCtl Procedure:
;
;This major hack is called from the WRITE routine if the length parameter is 0x3fff.
;Since packets of this size are not allowed due to limitations in the buffer memory
;this shoud not present a problem.
;
;User code can send and receive IOCTL information via the DOS or OS/2 file
;system using this hack.  I never could get DOS IOCTL (int 21, func 44h) to pass
;any valid data to this OS/2 PDD so this bizare hack was devised.  It's
;really cleaner from the C code side because you don't have to
;do any INT 21 DOS calls.
;
;To change a parameter the user code simply prepares a 5 byte structure
;with the desired function and parameter, then does a _write() call with
;the length parameter set to 0x3fff.
;
;example:
;
; struct IOCTL {  unsigned char function;
;                 unsigned long parameter;
;              } ;
; struct IOCTL IOCtl;
; IOCtl.function = 0x43;    //set speed
; IOCtl.parameter = 9600;
; _write(hFile,&IOCtl,0x3fff);
;
; The PI card status information can be obtained with the same method except that
; the user must provide a PiInfo_IOCTL structure to receive the returned data. The structure
; is identical to the normal PiInfo struct except it has an IOCTL struct prepended
; to the beginning.  The users code sets the ioctl.function to 0x42 (GetAllPiParms)
; and does the _write() call.  The users PiInfo_IOCTL struct will be filled in with the
; PI data by magic.  What? You say didn't know you could *read* using a write function?
; It's all done with smoke and pointers.
;
;WARNING: When using function 0x42 you must be aware that you will be *reading*
;         into your buffer starting after the 5 byte IOCTL struct.  The buffer must be
;         large enough to hold it. That would be "sizeof_pub_chan_struc" bytes.
;
; Example of combined IOCTL and PiInfo structs:
;
;
;struct PiInfo {  unsigned char function; //Device driver command placed here (DOS only)
;		  long parameter;	  //command parameter (DOS only)
;					  //The following items are filled in by the driver...
;		  long int_no  	; // Hardware interrupt number
;		  long io_addr	        ; // I/O address of PI card
;		  long dma_chan	; // DMA channel
;		  long speed		; // Baud rate; 0=external clock
;		  long txdelayparm	; // TX Delay in milliseconds
;		  long persist		 ; // Persistance probability out of 256
;;		  long slottime	 ; // Slot time for back off
;		  long tailtime	 ; // Time from end of frame to drop RTS
;		  long clkmode		 ; // Clocking mode
;		  long bufsiz		 ; // DMA buffer size
;		  long numbufs		 ; // Number of DMA buffers
;		  long TXPackets  	 ; // Packets transmitted since driver OPENED
;		  long RXPackets  	 ; // Packets received since driver OPENED
;		  long DCDState	 ; // 1 = DCD true
;		  long RTSState	 ; // 1 = RTS true
;		  long RcvState	;
;		  long TxState		;
;		  long RxInts		 ; // receiver interrupt counter
;		  long TxInts		 ; // transmitter interrupt counter
;		  long ExInts		 ; // External interrupt counter
;		  long CrcErr		 ; // number of rx CRC errors
;		  long RxOvrs		 ; //  rx packets lost due to overruns
;		  long TxUndr		 ; // tx underrrun errors
;		  long Extra1;
;		  UCHAR Vminor;	//version numbers
;		  UCHAR Vmajor;
;		  USHORT extra2;
;
;		  char RDFlag;
;		  char WRFlag;
;		  char FlushFlag;
;		  long XferAddr;
;		  struct bfr rxbufptr;
;		  struct bfr rxqueue;
;		  struct bfr txbufptr;
;		  struct bfr freelist;
;		  struct bfr allocptr;
;		  struct bfr txqueue;
;		};
;
;
;/* IOCtl functions for PI card driver  */
;
;
;const UCHAR PI_GET_ALL	= 0x42;	// Read all PI card parameters
;const UCHAR PI_SPEED 	= 0x43;	// Set baud rate
;const UCHAR PI_TXDELAY	= 0x44;	// Set TX delay in milliseconds
;const UCHAR PI_PERSIST	= 0x45;	// Set persistance value 1 to 255
;const UCHAR PI_SLOTTIME= 0x46;		// Set slot time value in milliseconds
;const UCHAR PI_TAILTIME = 0x47;	// Set tail time value in milliseconds
;const UCHAR PI_CLR_CTRS = 0x48;	// Clear tx and rx packet counters
;const UCHAR PI_CLK_MODE = 0x49;	// Set PI clock mode 0 or 1
;const UCHAR PI_RD_MODE = 0x4a		// Set read mode for Blocking(0) or non-blocking(1)
;
;
;
;--------------------------------------------------------------------------
;
FileSysIOCtl PROC NEAR

sizeof_CmdBfr equ 5

	push	bp				;save bp
	sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
	mov	bp,sp				;set bp to local variables

	mov	[bp].ds_save,ds		;save ds in stack frame
	mov	[bp].es_save,es		;save es
	mov	[bp].bx_save,bx		;save bx
	mov	[bp].si_save,si		;save si
;
	mov	ax,word ptr es:[bx].RWTransAddr+2 ;physical source address (high) to ax
	mov	bx,word ptr es:[bx].RWTransAddr   ;physical source address (low) to bx
	mov	dh,0				; 0 = want result in ds:si
	mov	dl,DH_PhysToVirt		; convert physical to virtual in ds:si
	call	[device_help]			; do it
	jc	@@exit				;  carry means error
	mov	di,[bp].si_save		; cha/chb pointer to di
	mov	es,[bp].ds_save		; es now points to our data seg
	mov	word ptr es:[di.cs_GioPkt.GIODataAdr],si
	mov	word ptr es:[di.cs_GioPkt.GIODataAdr+2],ds ; save virtual address in synthetic req packet
	lea	di,es:[di.cs_CmdBfr]		; address of cmd buffer
	mov	cx,sizeof_CmdBfr		; Move 5 bytes from user to CmdBfr
	cld					;  direction is increment
	rep	movsb				;  Copy memory ( ds:si to es:di cx=count)
	mov	ds,[bp].ds_save		; restore ds - now es = ds
	mov	si,[bp].si_save		; restore si
	lea	bx,[si.cs_GioPkt]
	mov	byte ptr[bx.GPktCmd],16	; General I/O control cmd
	mov	byte ptr[bx.GPktLen],29	; length of packet
	mov	byte ptr[bx.GIOCategory], GENDEV ; All are category 11
	mov	al,[si.cs_CmdBfr]		; get users function command
	mov	[bx.GIOFunction],al
	lea	ax,[si.cs_CmdBfr+1]		
	mov	word ptr[bx.GIOParmAdr],ax	;Set pointer to users parameters which were...
	mov	word ptr[bx.GIOParmAdr+2],ds	;...obtained during the MOVSB operation
	mov	word ptr[bx.GIOParmLen],4	;length of ULONG parameter
	mov	word ptr[bx.GIODataLen],sizeof_pub_chan_struc
	add	dword ptr[bx.GIODataAdr],sizeof_CmdBfr	;skip the command header
	call	GENIOCTL			;fake a call from system to do IOCTL
	mov	es,[bp].es_save
	mov	bx,[bp].bx_save
;	
;
@@exit:	mov	word ptr es:[bx].PktStatus, DONE_BIT	;Error is indicated by 0 bytes transmitted
	mov	word ptr es:[bx].RWCount,0		;tell user zero bytes sent
;
	mov	bx,[bp].bx_save
	mov	es,[bp].es_save
	mov	ds,[bp].ds_save		; restore ds
	mov	si,[bp].si_save		; restore si
	add	sp,LOCALVAR_SIZE		;clean stack
	pop	bp
	ret


FileSysIOCtl ENDP


;-----------------------------------------------------------------------------------

;Device  I/O Control

;;Call from C: DosDevIOCtl(Devhandle, category, function, ParmList,
;			    ParmLengthMax, ParmLengthInOut, DataArea, DataLengthMax,
;				DataLengthInOut);
;
MinFuncCode	equ	40h		;minimum value of a function code
;
;GenDev functions
FLUSH_IN_BUF	equ	01		;Flush input buffer Function
FLUSH_OUT_BUF	equ	02		;Flush Output Buffer Function
SYS_NOTI	equ	41h		;System notifications
QUERY_MON_SUP	equ	60h		;Query Monitor Support

;; Note: Categories 0 to 127 defined by OS/2 or reserved

GENIOCTL	PROC	NEAR

		mov	al, es:[bx].GIOCategory	;get GIO category to al
		mov	ah, es:[bx].GIOFunction	;get GIO function to ah
		cmp	al,GENDEV			;General device control?
		je	SHORT CategoryOK		;yes, jump
GEN_BAD_FUNC:	mov	word ptr es:[bx].PktStatus, ERROR_UNKNOWN_CMD
		ret
;
CategoryOK:	mov	al,ah				;function to al
		cmp	al,FLUSH_IN_BUF
		jne	not_01
		call	FlushInBuf			;flush input buffer if func 01
		jmp	SHORT GEN_EXIT_OK
not_01:		cmp	al,FLUSH_OUT_BUF
		jne	not_02
		call	FlushOutBuf			;flush output buffer if func 02
		jmp	SHORT GEN_EXIT_OK
not_02:		xor	ah,ah				;clear ah
		sub	al,MinFuncCode
		jl	SHORT GEN_BAD_FUNC		;function less than min
		shl	ax,1				;mpy by 2
		cmp	ax, GenFuncTblSize  		;Too big??
		jae	SHORT GEN_BAD_FUNC		;Yes, exit
		mov	di,ax
		call	word ptr cs:GenFuncTbl.[di]	;call function
GEN_EXIT_OK:	mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret					;Leave this Procedure

;--------------------------

GENIOCTL  ENDP

;Put all generic I/O control functions here.

DUMMY	PROC NEAR

gfunc1:
gfunc2:
		ret

DUMMY ENDP

;--------------------------------------------------------------------------------------

;Category 11 function 0x41

SysNote PROC NEAR

		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret

SysNote ENDP

;--------------------------------------------------------------------------------------

;Category 11 function 0x02

FlushOutBuf PROC NEAR

		cmp	[si.cs_tstate],IDLE		;No flush if tx is idle
		je	FO_Done
;
		push	bx
		mov	ax,ds				;make event id from address of FlushFlag
		lea	bx,[si.cs_FlushFlag]
		mov	di,0				;
		mov	cx,5000			;5 sec timeout
		mov	dh,0				;sleep interruptable
		mov	dl,DH_ProcBlock		;block this process 
		mov	[si.cs_FlushFlag],1			; indicate we're waiting for tx buffers to empty
		call	[device_help]			; Snooze until a tx buffers are emptied
		pop	bx				; See "none_to_send:" for the wakeup code
		mov	[si.cs_FlushFlag],0
;
FO_Done:	ret

FlushOutBuf ENDP
;--------------------------------------------------------------------------------------


;Category 11 function 0x01

FlushInBuf PROC NEAR

		ret

FLushInBuf ENDP
;----------------------------------------------------------------------------

;  Catagory 11 function 0x42  
;  Fetch all pi card setup parameters and move them to users data structure


; Here's an example C structure to hold the data.
; Use this one for OS/2 programs.  You may truncate it
; if you don't need all the items in the structure.  You'll
; only get the number of bytes you specfied when calling this function.

;struct  bfr {  USHORT addr;     // address of buffer
;	  	USHORT nqueued;  // number of items queued
;	  };
;
; struct PiInfo {
;		  long int_no  	; // Hardware interrupt number
;		  long io_addr	        ; // I/O address of PI card
;		  long dma_chan	; // DMA channel
;		  long speed		; // Baud rate; 0=external clock
;		  long txdelayparm	; // TX Delay in milliseconds
;		  long persist		 ; // Persistance probability out of 256
;		  long slottime	 ; // Slot time for back off
;		  long tailtime	 ; // Time from end of frame to drop RTS
;		  long clkmode		 ; // Clocking mode
;		  long bufsiz		 ; // DMA buffer size
;		  long numbufs		 ; // Number of DMA buffers
;		  long TXPackets  	 ; // Packets transmitted since driver OPENED
;		  long RXPackets  	 ; // Packets received since driver OPENED
;		  long DCDState	 ; // 1 = DCD true
;		  long RTSState	 ; // 1 = RTS true
;		  long RcvState	;
;		  long TxState		;
;		  long RxInts		 ; // receiver interrupt counter
;		  long TxInts		 ; // transmitter interrupt counter
;		  long ExInts		 ; // External interrupt counter
;		  long CrcErr		 ; // number of rx CRC errors
;		  long RxOvrs		 ; //  rx packets lost due to overruns
;		  long TxUndr		 ; // tx underrrun errors
;		  long reserved1	 ;
;		  UCHAR Vminor;	//version numbers
;		  UCHAR Vmajor;
;		  USHORT extra2;
;		  UCHAR RDFlag		;//READ is pending
;		  UCHAR WRFlag		;//WRITE is pending
;		  UCHAR FlushFlag	;//Flush in progress
;		  ULONG XferAddr	;//callers data transfer buffer addr
;		  struct bfr rxbufptr	;//RX dma buffer
;		  struct bfr rxqueue	;//head of RX queue
;		  struct bfr txbufptr	;//TX dma buffer
;		  struct bfr freelist	;//head of free list
;;		  struct bfr allocptr	;//last mem address used
;		  struct bfr txqueue	;//head of TX queue
;		  USHORT bufstart	;// offset starting address of DMA buffers
;		  USHORT DmaMemSize	;//total size of dma memory for buffers
;		  USHORT txlength	;//length of current packet being sent
;		  UCHAR  tstate	;//transmitter state
;		  UCHAR rstate		;//receiver state
;		  USHORT txcnt		;//number of chars transmitted this frame
;		  USHORT rxcnt		;//chars received this frame
;		  USHORT rx_tc		;//recv. baud rate time constant
;		  USHORT tx_tc		;//tx baud rate time constant
;		  USHORT handle	;//file handle
;		  USHORT opencounter	;//counts opens
;		  UCHAR  R8530WRT[16]	;//16 scc write registers
;		  UCHAR R8530RD[16]	;//16 scc read registers
;		  USHORT watchdog	;//watch dog timer value
;		  USHORT watchdog_ctr	;//watchdog counter
;
;		};
;  End of OS/2 C example.
;
;-------------------------
;
;--------------------------------------------------------------

;  IOCTL
;  Catagory 11 function 0x42 

GetAllPiPrams PROC NEAR

		push	es
		push	bx
;
		mov	al,[si.cs_tstate]
		mov	[si.cs_TxState],al		;refresh TxState
		push	bx
		mov	bx,R0
		call	rdscc
		and	al,DCD
		shr	al,3
		mov	ah,0
		mov	[si.cs_DCDState],ax		;refresh DCD state
		pop	bx
;
		mov	cx,sizeof_chan_struc		;number of bytes in structure to cx
		mov	ax,word ptr es:[bx].GIODataLen	;get number of bytes user wants to ax
		cmp	ax,cx
		jae	short @@01			;jmp if user buffer will hold all the data..
		mov	cx,ax				;..else truncate data to user buffer size
@@01:		mov	word ptr es:[bx].GIODataLen,cx	;  and tell user how many bytes we sent
		les	di,DWORD PTR es:[bx].GIODataAdr ;  get address of users buffer to es:di
;
		mov	ax,es				;selector to ax
		mov	dh,1				;verify for r/w access
		mov	dl,DH_VerifyAccess
		call	[device_help]			;make sure caller can address this memory
		jc	short @@error
		push	si				; si points to pi card setup parameters
		rep	movsb				; Copy memory ( ds:si to es:di cx=count )
		pop	si
		pop	bx
		pop	es
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret
;
@@error:	pop	bx
		pop	es
		mov	word ptr es:[bx].PktStatus, ERROR_ACCESS_DENIED
		ret

GetAllPiPrams ENDP
;--------------------------------------------------------------------------

;Set one of the driver software setable parameters:
;    speed, txdelayparm, persist, slottime, tailtime
;
;Enter with di pointing to destination of data

SetPiValue PROC NEAR

		push	si
		push	es
		push	bx
;
		mov	ax,4				;number of bytes in long int
		mov	cx,word ptr es:[bx].GIOParmLen	;number of bytes user wants to give us
		cmp	ax,cx
		jae	spv_0				;jmp if user buffer will hold all the data..
		mov	cx,ax				;..else truncate data to user buffer size
spv_0:		mov	word ptr es:[bx].GIODataLen,cx	;  and tell user how many bytes we took
		les	si,DWORD PTR es:[bx].GIOParmAdr ;  get address of users buffer to es:si
;
		mov	ax,es				;selector to ax
		mov	dh,0				;verify for read access
		mov	dl,DH_VerifyAccess
		call	[device_help]			;make sure caller can address this memory
		jc	spv_error
		mov	ax,es
		push	ds				;swap es with ds
		pop	es				;   es:di point ot our data seg
		mov	ds,ax				;   ds:si point to users data
		rep	movsb				;Copy memory ( ds:si to es:di cx=count )
		mov	ax,es
		mov	ds,ax				;restore ds
		pop	bx				;restore bx
		pop	es				;restore es
		pop	si				;restore si
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		clc
		ret
;
spv_error:	pop	bx
		pop	es
		pop	si
		mov	word ptr es:[bx].PktStatus, ERROR_ACCESS_DENIED
		stc					;set carry = error
		ret





SetPiValue ENDP

;---------------------------------------------------------------------------

;Category 11 function 0x43

SetPiSpeed PROC NEAR

		lea	di,[si.cs_speed]
		call	SetPiValue		;Set speed to users value
		jc	@@exit
		call	CalcBaudRates		;calculate baud time constants
		call	scc_init		;set scc registers
@@exit:		ret

SetPiSpeed ENDP
;----------------------------------------------------------------------------
;Category 11  function 0x44

SetPiTXDelay PROC NEAR

		lea	di,[si.cs_txdelayparm]
		call	SetPiValue
		ret

SetPiTXDelay ENDP

;-----------------------------------------------------------------------------
; Category 11 funciton 0x45

SetPiPersist PROC NEAR

		lea	di,[si.cs_persist]
		call	SetPiValue
		ret

SetPiPersist ENDP
	
;------------------------------------------------------------------------------
;category 11 function 0x46

SetPiSlotTime PROC NEAR

		lea	di,[si.cs_slottime]
		call	SetPiValue
		ret

SetPiSlotTime ENDP

;--------------------------------------------------------------------------------
;category 11 function 0x47

SetPiTailTime PROC NEAR

		lea	di,[si.cs_tailtime]
		call	SetPiValue
		ret

SetPiTailTime ENDP
;-------------------------------------------------------------------------

SetPiClkMode PROC NEAR

		lea	di,[si.cs_clkmode]
		call	SetPiValue		;Set clkmode to users value
		jc	@@exit			;exit if error
		and	[si.cs_clkmode],1	;restrict range to 0 and 1
		call	CalcBaudRates		;calculate baud time constants
		call	scc_init		;set scc registers
@@exit:		ret

SetPiClkMode ENDP
;--------------------------------------------------------------------------

SetRdMode PROC NEAR       ;  0=Blocking read mode    1=Non-blocking read

		lea	di,[si.cs_NBReadMode]
		call	SetPiValue
		ret

SetRdMode ENDP

;-------------------------------------------------------------------------
;
;Clear the Packet counters  
;Category 11  function 0x48

ClrPktCounters PROC NEAR

		mov	eax,0
		mov	[si.cs_TXPackets],eax	;Clear PI status counters
		mov	[si.cs_RXPackets],eax
		mov	[si.cs_RxInts],eax
		mov	[si.cs_TxInts],eax
		mov	[si.cs_ExInts],eax
		mov	[si.cs_CrcErr],eax
		mov	[si.cs_RxOvrs],eax
		mov	[si.cs_TxUndr],eax
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret

ClrPktCounters ENDP


		

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;
;Hardware interrupt handler.  Called (far) from OS/2 kernel with registers saved and
;interrupts disabled.  The entry point was registered with the kernel at INIT time.
;
;Interrupts *must* remain disabled for the duration of this handler.
;
public HWIntHandler

HWIntHandler	PROC	FAR

	mov	si, offset ds:chA	;Int Pending bits only available from chA
	mov	[IrqLoopLimiter],32	;Don't stay here for more than 32 itterations
	mov	bx,R3			;8530 register R3 = Interrupt pending bits
	call	rdscc			;Read R3 into AL
	cmp	al,0			;see if any bits are set
	jne	short hwirq_1		;yes, it's our interrupt, ok to process it
	stc				;..if not ours, set carry to let OS/2 know
	ret
;
hwirq_0:
	mov	si, offset ds:chA	;Int Pending bits only available from chA
	mov	bx,R3			;8530 register R3 = Interrupt pending bits
	call	rdscc			;Read R3 into AL
	cmp	al,0
	jz	hwirq_exit		;All done if no bits set
hwirq_1:
	test	al,CHAEXT		; Is channel external/status int pending?
	jz	short hwirq_2		; no
	mov	si, offset ds:cha	; pointer to channel structure A
	inc	[si.cs_ExInts]
	call	A_exint		; yes, go process EXT interrupt
	jmp	SHORT hwirq_eoi
;
hwirq_2:
	test	al,CHATxIP		; Is channel A tx int pending?
	jz	short hwirq_3		; no
	mov	si, offset ds:cha	; pointer to channel structure A
	call	A_txint		; yes, go process TX interrupt
	jmp	SHORT hwirq_eoi
;
hwirq_3:
	test	al,CHARxIP		; Is channel A receive int pending?
	jz	short hwirq_4		; no
	mov	si, offset ds:cha	; pointer to channel structure A
	call	A_rxint		; yes, go process RX interrupt
	jmp	hwirq_eoi

hwirq_4:
	test	al,CHBRxIP		;channel B rx int pending?
	jz	short hwirq_5		;no
	mov	si, offset ds:chb	; pointer to channel structure B
	call	B_rxint
	jmp	SHORT hwirq_eoi
;
hwirq_5:
	test	al,CHBEXT		;channel B external int?
	jz	short hwirq_6		;no
	mov	si, offset ds:chb	; pointer to channel structure B
	inc	[si.cs_ExInts]
	call	B_exint
	jmp	short hwirq_eoi

;
hwirq_6:
	test	al,CHBTxIP		;Channel B tx int pending?
	jz	short hwirq_eoi	;no
	mov	si, offset ds:chb	; pointer to channel structure B
	call	B_txint
;
;
;
; Reset highest interrupt under service
hwirq_eoi:
	mov	bx,R0+RES_H_IUS
	call	wrtscc
	dec	[IrqLoopLimiter]	;Count number of times we loop here
	jnz	hwirq_0 		; Loop up to 32 times max then assume..
					; ...a stuck interrupt bit and exit
hwirq_exit:

;
	mov	ax,[int_no]
	mov	ah,0
	mov	dl,DH_eoi	;Signal End OF Interrupt
	call	[device_help]
	clc			;clear carry, tell os/2 we own interrupt
	mov	[IrqLoopLimiter], -1
	ret
;
;
HWIntHandler ENDP

;---------------------------------------------------------------------------
public A_RXINT

; On entry si must point to cha channel structures

A_RXINT	PROC	NEAR


	push	bp			;save bp
	sub	sp,LOCALVAR_SIZE	;allow space for local variables on stack
	mov	bp,sp			;set bp to local variables
;
	inc	[si.cs_RxInts]		; count this interrupt
	mov	bx,R1 			; Get special condition bits from R1
	call	rdscc
	mov	[bp].var0,ax		; Save special condition bits in var0

; save length of frame from 8237

	xor	al,al
	out	DMA_RESETFF,al		; Reset byte pointer flipflop
	mov	dx,dma_wcr		; Get address of word count register
	in	al,dx			; Input low byte of word
	mov	bl,al			; Save it
	in	al,dx			; Input high byte
	mov	bh,al			; Save it - bx = bytes left
	mov	[bp].var1,bx		;save frame length in var1
;
@@rxint1:
	mov	ax,[bp].var0		; Recover status from var0
	test	al,END_FR		; Is this an end of packet int?
	jz	@@rxint_exit		; no
	cmp	[si.cs_rxbufptr],0	; NULL buffer?
	je	short @@dma_setup
	test	al,CRC_ERR		; CRC ok?
	jz	@@crc_ok
	inc	[si.cs_CrcErr]		;count crc error
	jmp	SHORT @@dma_setup	;  then toss frame - setup for new one

@@crc_ok:
	mov	bx,[bp].var1		; Recover frame length from var1
	mov	ax,[si.cs_bufsiz]	; ax = buf size - 1
	sub	ax,1
	sub	ax,bx			; minus bytes left = byte count
	mov	[bp].var1,ax		; save byte count in var1
	cmp	ax,10			; Runt?
	jl	@@dma_setup		; Yes, ignore it - prepare for another packet

	mov	bx,[si.cs_rxbufptr]	; Buffer address to bx
	mov	di,[si.cs_bufsiz]	; Buffer size to di
	mov	ax,[bp].var1		; Byte count to ax
	sub	ax,2			; Subtract crc bytes from count
	mov	[bx+di+2],ax		; Put byte count in buffer header
	mov	ax,bx			; buffer address to ax
	lea	bx,[si.cs_rxqueue]	; rx queue to bx
	call	enqueue		; Put rx data on the receiver queue
;
; Valid frame

@@rx_valid:

	inc	[si.cs_RXPackets]	; Count this packet (32 bit inc)
	test	[si.cs_RDFlag],1	; is a READ pending?
	jz	@@next			; no, don't wake up READ if it's not pending
	lea	bx,[si.cs_RDFlag]	; get event id to ax:bx
	mov	ax, ds
	mov	dl,DH_ProcRun		; Wake up the READ strategy routine
	call	[device_help]		; ..and let it move the data to users buffer.
	mov	[si.cs_RDFlag],0	; read not pending anymore
	jmp	short @@next01		;skip dos int stuff
;
@@next:	test	[si.cs_V86INTENAB],1	;test V86 enable bit
	jz	short @@next01
	call	GenV86Int		;Generate a V86 interrupt
@@next01:
	lea	bx,[si.cs_freelist]
	call	dequeue		; Get a new receiver DMA buffer
	mov	[si.cs_rxbufptr],ax	; Save address of new buffer in rxbufptr
	jc	short @@no_buffers	; error if no buffers available - rxbufptr = NULL
;
@@dma_setup:
	mov	bx,R0+ERR_RES		; Error reset
	call	wrtscc
	cmp	[si.cs_tstate],IDLE
	jne	short @@no_buffers	;Shut down receiver if transmitter has been started
	mov	bx,[si.cs_rxbufptr]	; Setup for next receive
	cmp	bx,0			; NULL rxbufptr?
	je	short @@no_buffers
	mov	ax,[si.cs_bufsiz]
	call	setup_rx_dma		; Setup RX DMA
;
@@rxint_exit:

	add	sp,LOCALVAR_SIZE	; Clean stack
	pop	bp
	ret				; Return

@@no_buffers:				; Shut down receiver completely
					; ..when out of buffers or TX wants to send
	mov	[si.cs_rxcnt],0	; Zero the rxcnt
	mov	[si.cs_rstate],IDLE	;force receiver to be idle
	mov	bx,R3+Rx8		; Rx off
	call	wrtscc
	mov	bx,R1+RxINT_DISAB+EXT_INT_ENAB	; Rx ints off, Ext ints on
	call	wrtscc
	mov	bx,R0+ERR_RES
	call	wrtscc			; Error reset
	jmp	@@rxint_exit		; Receiver is completely shut down now


A_RXINT	ENDP

;----------------------------------------------------------------------------
;
;              Process A side transmitter interrupts.
;                 Should only be one per packet.
;
public A_TXINT

A_TXINT	PROC	NEAR			;Come here only in the CRCOUT TX state

	cmp	[si.cs_tstate],CRCOUT
	jne	short @@NotNow
	mov	ax,[si.cs_txbufptr]	; Free the tx buffer
	lea	bx, [si.cs_freelist]
	call 	enqueue
	inc	[si.cs_TxInts]		;Count this interrupt
	mov	[si.cs_tstate],FLAGOUT	;execute FLAGOUT routine on next CTS ext. interrupt

;uncomment next 2 statements for back to back xmit capability.
;	cmp	[si.cs_txqueue+2],0
;	jne	short @@more2send
;					;None to send...
@@None:	mov	bx,R0+RES_Tx_CRC+RES_Tx_P ; reset CRC, txint pending
	call	wrtscc
	mov	bx,R1+EXT_INT_ENAB
	call	wrtscc			;disable TXINT
	mov	bx,R15+CTSIE
	call	wrtscc			;enable CTS int
	mov	ax,[si.cs_tailtime]
	call	tdelay			;Gen a CTS interrupt after tailtime delay
@@exit:	ret
;
@@NotNow:
	mov	bx,R0+RES_Tx_P
	call	wrtscc
	ret
;
;
@@more2send:

	cmp	[si.cs_WRFlag],1	;see if WRITE is waiting for a buffer
	jne	@@0001			;jmp if not
	mov	ax,ds
	lea	bx,[si.cs_WRFlag]	;get event ID of write procedure
	mov	dl,DH_ProcRun		;get WRITE going again now that a buffer is free
	call	[device_help]
	mov	[si.cs_WRFlag],0	;WRITE is not waiting now
;

@@0001:	lea	bx,[si.cs_txqueue]	; Get next buffer from the txqueue
	call	dequeue
	jc	@@None			; None left - should never happen
	mov	[si.cs_txbufptr],ax	; Make it the active tx buffer
	push	di
	mov	bx,ax			;buffer pointer to bx
	mov	di,[si.cs_bufsiz]
	mov	ax,[bx+di+2]		; Get length to ax
	pop	di
	mov	[si.cs_txlength],ax
	call	setup_tx_dma
	mov	bx,R0+RES_Tx_CRC+RES_Tx_P ; reset CRC, txint pending
	call	wrtscc
	mov	ax,[si.cs_watchdog]	; get watchdog timer value
	call	tdelay			; CTS int if watchdog times out
	mov	bx,R15+TxUIE+CTSIE	; Allow underrun int and CTS int
	call	wrtscc
					; Enable TX DMA
	mov	bx,R1+WT_RDY_ENAB+WT_FN_RDYFN+EXT_INT_ENAB+TxINT_ENAB
	call	wrtscc
					; Unmask channel n (enable DMA controller chip)
	mov	al,Byte Ptr [ dma_channel] ; Enable DMA for this channel
	add	al,DMA_ENABLE
	out	DMA_MASK,al
	
	mov	bx,R0+RES_EOM_L 	; Send CRC on underrun
	call	wrtscc
	mov	[si.cs_tstate],ACTIVE	; Packet going out now

	ret

A_TXINT	ENDP

;-----------------------------------------------------------------------------
public A_EXINT

A_EXINT	PROC	NEAR

	push	bp			;save bp
	sub	sp,LOCALVAR_SIZE	;allow space for local variables on stack
	mov	bp,sp			;set bp to local variables
;
	mov	[bp].si_save,si	;save si
;
	pushf
	cli				;disable interrupts
;
	mov	bx,R0			; Get status
	call	rdscc
	mov	dl,al			;status to dl
;
; reset external status latch

exint_0:
	mov	bx,R0+RES_EXT_INT	;reset interrupt
	call	wrtscc
	mov	al,[si.cs_tstate]	; Is transmit IDLE?
	cmp	al,IDLE	
	jne	exint_1		; No
	test 	dl,BRK_ABRT		; Is it an abort from the receiver?
	jz	exint_exit		; No, ignore - must be spurious
;
	test	[si.cs_RTSState],1
	jnz	exint_exit		; Not if TX is on!
	mov	bx,R0+ERR_RES		; TX IDLE - unlock fifo to flush any garbage
	call	wrtscc
	mov	bx,[si.cs_rxbufptr]	; Assume abort - Reset receive DMA
	mov	ax,[si.cs_bufsiz]
	call	setup_rx_dma
	jmp	exint_exit		; exit
	
exint_1:				;Come here when transmitter underruns..
	mov	al,[si.cs_tstate]	;..at the end of a frame, after CRCOUT
	cmp	al,ACTIVE		;....or when watchdog times out.
	jne	exint_2
					; Transmitter was ACTIVE
	test	dl,TxEOM		; If not TX EOM then it must be watchdog
	jnz	short @@0001
	mov	al,FLAGOUT
	mov	[si.cs_tstate],al	; Skip the crcout state...
	jmp	short exint_2		; ...if the watchdog timed out
@@0001:	
	in	al,[8]			;read DMA status register (0x08)
	and	al,[tc_mask]		;logical AND with terminal count mask
	jnz	@@0002			;jmp if terminal cnt reached
	inc	[si.cs_TxUndr]		;Tx underrun if TC bit not set
	mov	ax,[si.cs_txbufptr]	; Free the tx buffer
	lea	bx, [si.cs_freelist]
	call 	enqueue
	mov	al,FLAGOUT
	mov	[si.cs_tstate],al	; Skip the crcout state...
	jmp	short exint_2		;
;
;
@@0002:	mov	[si.cs_tstate],CRCOUT	; execute CRCOUT routine on next Tx int
	mov	bx,R0+RES_EXT_INT
	call	wrtscc
	jmp	exint_exit
;
;
;
exint_2:
	cmp	al,FLAGOUT
	jne	exint_3
					; Transmitter in FLAGOUT state
	cmp	[si.cs_WRFlag],1	;see if WRITE is waiting for a buffer
	jne	exint_2a		;jmp if not
	mov	ax,ds
	lea	bx,[si.cs_WRFlag]	;get event ID of write procedure
	mov	dl,DH_ProcRun		;get WRITE going again now that a buffer is free
	call	[device_help]
	mov	[si.cs_WRFlag],0	;WRITE is not waiting now
;
exint_2a:
	
	call	send_pkt_1		; Go see if there are more to send

	jmp	SHORT exint_exit
;
;----------------
exint_3:
	cmp	al,TXDELAY
	jne	exint_4
					; Transmitter was in TXDELAY
	mov	ax,[si.cs_watchdog]	; get watchdog timer value
	call	tdelay			; CTS int if watchdog times out

	mov	al,Byte Ptr [ dma_channel] ; Enable DMA for this channel -first!!
	add	al,DMA_ENABLE
	out	DMA_MASK,al
					; Then setup 8530 chip after DMA
	mov	bx,R0+RES_Tx_CRC+RES_Tx_P ; reset CRC, txint pending
	call	wrtscc
	mov	bx,R15+TxUIE+CTSIE	; Allow underrun int and CTS int
	call	wrtscc
					
	mov	bx,R1+WT_RDY_ENAB+WT_FN_RDYFN+EXT_INT_ENAB+TxINT_ENAB
	call	wrtscc

	mov	bx,R0+RES_EOM_L 	; Send CRC on underrun
	call	wrtscc
	mov	[si.cs_tstate],ACTIVE	; Packet going out now
	jmp	exint_exit

;DEFER  tstate=5
exint_4:
					; Transmitter must be in DEFER
	call	CHECK_DCD		; See if we should DEFER again
	jc	exint_exit		; DEFER

	mov	bx,[si.cs_txbufptr]
	mov	ax,[si.cs_txlength]
	call	setup_tx_dma

	mov	[si.cs_tstate],TXDELAY
	call	tx_on			; Start sending flags
	mov	ax,[si.cs_txdelayparm]	; generate an exint after TXDELAY
	call	tdelay

exint_exit:
	popf
	add	sp,LOCALVAR_SIZE	;clean stack
	pop	bp
	ret


A_EXINT	ENDP


;---------------------------------------------------------------------------
;
public SEND_PKT_1

SEND_PKT_1  PROC  NEAR

	pushf
	cli				;interrupts off

	lea	bx,[si.cs_txqueue]	; Get a buffer from the txqueue
	call	dequeue
	jc	none_to_send		; None left

	mov	[si.cs_txbufptr],ax	; Make it the active tx buffer

	push	di
	mov	bx,ax
	mov	di,[si.cs_bufsiz]
	mov	cx,[bx+di+2]		; Get length
	pop	di


	mov	[si.cs_txlength],cx

; Check DCD - see if we should DEFER transmission

	call	CHECK_DCD
	jc	send_pkt_exit		; DEFER

	mov	bx,[si.cs_txbufptr]
	mov	ax,[si.cs_txlength]
	call	setup_tx_dma

	mov	dl,[si.cs_tstate]	; save tstate in dl
	mov	[si.cs_tstate],TXDELAY	; set tstate to TXDELAY
	call	tx_on			; Start sending flags
	cmp	dl,IDLE		; check previous tstate
	je	t_idle			; do normal txdelay if IDLE
	mov	ax,[si.cs_txdelayparm]	; ***** testing*** was 1 .very short txdelay if tx is *already* on
	call	tdelay			; CTS interrupt enabled in tdelay
	jmp	SHORT send_pkt_exit
t_idle:
	mov	ax,[si.cs_txdelayparm]	; generate an exint after TXDELAY
	call	tdelay

send_pkt_exit:
	popf
	clc	;  No error
	ret

none_to_send:
	call	tx_off
	mov	[si.cs_tstate],IDLE
;
	test	[si.cs_FlushFlag],1	; is a flush waiting?
	jz	nts_exit		; no, don't wake up FLUSH if it's not pending
	push	bx
	lea	bx, [si.cs_FlushFlag] 	;get event id to ax:bx
	mov	ax, ds
	mov	dl,DH_ProcRun		;Wake up the FLUSH gen i/o cntl routine
	call	[device_help]
	mov	[si.cs_FlushFlag],0	;reset flush flag
	pop	bx
nts_exit:
	popf
	clc	;  No error
	ret


SEND_PKT_1  ENDP




;---------------------------------------------------------------------------
; Check to see if we should transmit or DEFER
; Return: Carry set - DEFER
;
;trashes ax,bx

CHECK_DCD PROC NEAR

	cmp	[si.cs_tstate],FLAGOUT
	je	short @@go		; The transmitter is already on - don't defer
	mov	bx,R15			; Ints off - no latches in the path
	call	wrtscc
	mov	bx,R0
	call	rdscc
	test	al,DCD
	jne	short @@check_dcd_1	; Carrier detected - we have to DEFER
;
;
	call	RDTimer0		; Read value of timer 0 to get random number in ax

;;;	mov	al,21			;
;;;	mul	[random]
;;;	add	ax,53
;;;	mov	[random],al

	xor	ah,ah			; clear ah
	cmp	ax,[si.cs_persist]	; Should we DEFER?
	jb	short @@go		; if rnd number is < persist then key transmitter
	mov	[si.cs_tstate],DEFER	; We have to wait
	mov	ax,[si.cs_slottime]	; Yes - DEFER 1 slot time
	call	tdelay
	mov	bx,R1+EXT_INT_ENAB	;  Ext ints on
	call	wrtscc
	stc				; We are DEFERring
	ret

@@go:	clc				; We don't have to wait
	ret

@@check_dcd_1:
	mov	[si.cs_tstate],DEFER	; We have to wait
	mov	ax,1000		; In case DCD int. missed (shouldn't happen)
	call	tdelay
; Defer until dcd transition or 1S timeout or abort
	mov	bx,R15+CTSIE+DCDIE+BRKIE
	call	wrtscc
	mov	bx,R1+EXT_INT_ENAB	;  Ext ints on
	call	wrtscc
	stc				; We are DEFERring
	ret

CHECK_DCD ENDP

;-------------------------------------------------------------------------------------

; si must point to chA or chB struc.
;
B_DEFER	 PROC 	NEAR

	mov	bx,R0+RES_EXT_INT
	call	wrtscc
	call	wrtscc
	mov	bx,R0
	call	rdscc				;get scc status to al
	test	al,DCD
	jz	@@noDCD
	mov	[si.cs_tstate],DEFER		;carrier detect true, we must defer
	mov	ax,100
	call	tdelay				;wait 1 sec. or until DCD goes false
	mov	bx,R15+CTSIE+DCDIE+BRKIE	;enable CTS , BRK and DCD interrupts
	call	wrtscc
	ret
;
@@noDCD:
	mov	dx,[io_addr]		;read timer 0
	add	dx,TMR0
	in	al,dx			; LSB
	call delay8253			; Satisy access time restriction
	mov	ah,al
	in	al,dx			; MSB
	call delay8253			; Satisy access time restriction
	mov	al,ah
	mov	ah,0
	cmp	ax,[si.cs_persist]	;is al < persist ?
	jb	short @@nodefer	;if rnd number is < defer then key transmitter
	mov	ax,[si.cs_slottime]
	call	tdelay			;wait slottime if rnd number above persist
	mov	[si.cs_tstate],DEFER
	ret
;
@@nodefer:
	mov	[si.cs_tstate],TXDELAY	; change state to TXDELAY
	call	TX_ON			; Key the transmitter
	mov	ax,[si.cs_txdelayparm]
	call	tdelay			; Start txdelay timer
	ret

B_DEFER ENDP

;---------------------------------------------------------------------------
; Come here when a channel B TX interrupt happens.  Also called by the WRITE routine
; when it has data to send and the transmitter is idle.
;
; This code is based on PI.C in JNOS 110g. 
;
B_TXINT	PROC	NEAR

;;;;;;	int 3
	pushf
	cli					;interrupts off
;
	mov	bl,[si.cs_tstate]		;get transmitter state to bx
	mov	bh,0
	cmp	bx,CRCOUT
	ja	short @@exit			;exit if out of range
	sal	bx,1				;mpy bx by 2
	call	word ptr cs:[@@B_txint_tbl + bx]	;call subroutine in lookup table
	inc	[si.cs_TxInts]			;Count this interrupt
@@exit:	popf					;restore interrupts
	ret
;-----------------------
;
@@idle:	
	lea	bx,[si.cs_txqueue]		; Get a buffer from the txqueue
	call	dequeue
	jc	short @@nts			; none to send, exit
	mov	[si.cs_txbufptr],ax		; else Make it the active tx buffer
	mov	bx,ax
	mov	di,[si.cs_bufsiz]
	mov	cx,[bx+di+2]			; Get length
	mov	[si.cs_txlength],cx
	mov	[si.cs_txcnt],0		;clear tx character counter
	jmp	short @@defer
;
@@nts:	call	TX_OFF
	ret
;----------------------
;
@@defer:
	mov	bx,R0+RES_EXT_INT
	call	wrtscc
	call	wrtscc
	mov	bx,R0
	call	rdscc				;get scc status to al
	test	al,DCD
	jz	@@noDCD
	mov	[si.cs_tstate],DEFER		;carrier detect true, we must defer
	mov	ax,100
	call	tdelay				;wait 1 sec. or until DCD goes false
	mov	bx,R15+CTSIE+DCDIE+BRKIE
	call	wrtscc				;enable CTS , BRK and DCD interrupts
	ret
;
@@noDCD:
	call	RDTimer0		;Read value of timer 0 to get random number in ax
	mov	ah,0
	cmp	ax,[si.cs_persist]	;is al < persist ?
	jb	short @@nodefer	;if rnd number is < defer then key transmitter
	mov	ax,[si.cs_slottime]
	call	tdelay			;wait slottime if rnd number above persist
	mov	[si.cs_tstate],DEFER
	ret
;
@@nodefer:
	mov	[si.cs_tstate],TXDELAY
	call	TX_ON			;Key the transmitter
	mov	ax,[si.cs_txdelayparm]
	call	tdelay			;start txdelay timer
	ret
;-------------------
;
@@active:
	mov	bx,[si.cs_txbufptr]	;get base address of tx buffer to bx
	mov	di,[si.cs_txcnt]	;char count to di
	cmp	di,[si.cs_txlength]	;see if we're done yet
	jae	short @@a1		;if above or equal we're done
;
	mov	bl,[bx+di]		;get a char from tx buffer to bl
	mov	bh,R8/256		;set bh to R8 (tx data register)
	call	wrtscc			;write char to scc
	inc	di			;count one more
	mov	[si.cs_txcnt],di	;save new char count value
	ret				;Normal return
;
@@a1:	mov	ax,[si.cs_txbufptr]		; Free the tx buffer
	lea	bx, [si.cs_freelist]
	call 	enqueue
	cmp	[si.cs_WRFlag],1	;see if WRITE is waiting for a buffer
	jne	@@a0			;jmp if not
	mov	ax,ds
	lea	bx,[si.cs_WRFlag]	;get event ID of write procedure
	mov	dl,DH_ProcRun		;get WRITE going again now that a buffer is free
	call	[device_help]
	mov	[si.cs_WRFlag],0	;WRITE is not waiting now
;
@@a0:	mov	bx,R0
	call	rdscc			;get scc status to al
	test	al,TxEOM		;unexpected underrun?
	jnz	short @@undr		;yes , handle it
	mov	[si.cs_tstate],UNDERRUN ;Now we expect an underrun next time
	mov	ax,[si.cs_speed]
	or	ax,[si.cs_speed+2]	;Is baud rate externally clocked?
	jz	short @@2		;Yes, jmp
	mov	bx,R10+CRCPS+NRZI	;No, CRC preset to 1s with NRZI coding
	jmp	@@3
@@2:	mov	bx,R10+CRCPS		;Yes, CRC preset 1s  with NRZ coding
@@3:	call	wrtscc
	mov	bx,R0+RES_Tx_P		;reset tx interrupt pending
	call	wrtscc
	ret
;
@@undr:
	inc	[si.cs_TxUndr]		;count TX underrun error
	mov	bx,R0+SEND_ABORT	;abort frame
	call	wrtscc
	mov	[si.cs_tstate],FLAGOUT	;set state to flagout
	mov	ax,[si.cs_tailtime]
	call	tdelay
	ret
;
@@crcout:
	mov	[si.cs_tstate],FLAGOUT
	cmp	[si.cs_txqueue+2],0		;see if anything is queued
	je	@@no_q
	call	B_EXINT			;yes - don't do tailtime, send now!
	ret
;
@@no_q:	mov	ax,[si.cs_tailtime]
	call	tdelay
	ret
;


@@txdelay:
@@underrun:
@@flagout:	ret
;
;
@@B_txint_tbl:
	dw	offset cs:@@idle
	dw	offset cs:@@txdelay
	dw	offset cs:@@active
	dw	offset cs:@@underrun
	dw	offset cs:@@flagout
	dw	offset cs:B_DEFER
	dw	offset cs:@@crcout	


B_TXINT	ENDP

;-----------------------------------------------------------------------------------------
; Process B channel RX interrupt
;
B_RXINT	PROC	NEAR

	
	push	bp				;save bp
	sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
	mov	bp,sp				;set bp to local variables
;
	pushf
	cli					;interrupts off
;
	inc	[si.cs_RxInts]			; count this interrupt

@@0:	mov	bx,R0
	call	rdscc				; read R0
	test	ax, Rx_CH_AV			; See if char available
	jz	@@exit				; EXIT if not
	mov	bx,R1 				; Get special condition bits from R1
	call	rdscc
	mov	[bp].var0,ax			; Save special condition bits in var0
	mov	bx,R8
	call	rdscc				;get contents of receive data register to al
	mov	[bp].var1,ax			;save received char in var1
;
	test	[bp].var0,Rx_OVR		;overrun error?
	jz	short @@1			;no, jmp if OK
	mov	[si.cs_rstate],RXERROR		;set error flag
	mov	[si.cs_rxcnt],0		;zero bytes in buffer
	inc	[si.cs_RxOvrs]			;count overrun error
	jmp	short @@3
;
@@1:	mov	ax,[si.cs_rxcnt]		;get number of chars received so far
	cmp	ax,[si.cs_bufsiz]		;compare to buffer size
	jb	@@2				;jmp if buffer not full yet
	mov	[si.cs_rstate],TOOBIG		;set error flag
	mov	[si.cs_rxcnt],0		;zero bytes in buffer
	jmp	short @@3			;
;
@@2:	cmp	[si.cs_rstate],ACTIVE		;if active then no errors yet
	jne	short @@3
	mov	bx,[si.cs_rxbufptr]
	cmp	bx,0				;null buffer ptr?
	je	short @@3			; ...error
	mov	di,[si.cs_rxcnt]
	mov	ax,[bp].var1			;get received char to ax
	mov	[bx+di],al			;store received byte at bx+di
	inc	[si.cs_rxcnt]			;add 1 to buffer length
;
@@3:	test	[bp].var0,END_FR		;Check for end of frame
	jz	 @@0				;go back and check for more chars in fifo
;
	cmp	[si.cs_rstate],ACTIVE		;error if EOF and rx state > active
	jne	short @@err
	cmp	[si.cs_rxcnt],10		;check for runt packet
	jb	short @@err			;error if count is less than 10
	cmp	[si.cs_rxbufptr],0		;NULL buffer ptr?
	je	@@err				; ...error
	test	[bp].var0,CRC_ERR		;check for CRC error
	jz	short @@rx_valid		;no errors so frame must be good
	inc	[si.cs_CrcErr]			;count a CRC error
@@err:	mov	bx,R0+ERR_RES			; Error reset
	call	wrtscc
	jmp	@@err_exit		;  then exit
;
@@rx_valid:	
;
	mov	bx,[si.cs_rxbufptr]	; Buffer address to bx
	mov	di,[si.cs_bufsiz]	; Buffer size to di
	mov	ax,[si.cs_rxcnt]	; Byte count to ax
	sub	ax,2			; Subtract crc bytes from count
	mov	[bx+di+2],ax		; Put byte count in buffer header
	inc	[si.cs_RXPackets]	; Count this packet (32 bit inc)
;
	lea	bx,[si.cs_rxqueue]
	mov	ax,[si.cs_rxbufptr]
	call	enqueue		; Put rx data on the receiver queue
;
	lea	bx,[si.cs_freelist]
	call	dequeue		; Get a new receiver buffer
	mov	[si.cs_rxbufptr],ax	; Save address of new buffer
	jc	short @@no_buffers	; If no buffers - error, shutdown receiver
;
;
	mov	bx,R0+ERR_RES		; Error reset
	call	wrtscc
	mov	[si.cs_rxcnt],0	; clear byte counter
	test	[si.cs_RDFlag],1	; is a READ pending?
	jz	short @@next		; no, don't wake up READ if it's not pending
	lea	bx,[si.cs_RDFlag]	; get event id to ax:bx
	mov	ax, ds
	mov	dl,DH_ProcRun		; Wake up the READ strategy routine
	call	[device_help]		; ..and let it move the data to users buffer.
	mov	[si.cs_RDFlag],0	; read not pending now
	cmp	[si.cs_tstate],IDLE
	jne	short @@no_buffers	;Shut down receiver if transmitter has been started
	jmp	short @@eof_exit
;
@@next:	test	[si.cs_V86INTENAB],1	;test V86 enable bit
	jz	short @@eof_exit
	call	GenV86Int		;Generate V86 interrupt for virtual DOS machine
	cmp	[si.cs_tstate],IDLE
	jne	short @@no_buffers	;Shut down receiver if transmitter has been started
	jmp	short @@eof_exit
;
@@no_buffers:
	mov	[si.cs_rstate],IDLE	;force receiver to be idle if no buffers
	mov	[si.cs_rxcnt],0	;zero bytes in buffer
	mov	bx,R3+Rx8		; Rx off
	call	wrtscc
	mov	bx,R1+RxINT_DISAB+EXT_INT_ENAB	; Rx ints off, Ext ints on
	call	wrtscc
	mov	bx,R0+ERR_RES
	call	wrtscc			; Error reset
	jmp	short @@exit
;
;
@@err_exit:
	mov	[si.cs_rxcnt],0	;zero bytes in buffer
;
@@eof_exit:
	mov	[si.cs_rstate],ACTIVE
@@exit:
	popf				;restore interrupts
	add	sp,LOCALVAR_SIZE	;clean stack
	pop	bp
	ret
;

B_RXINT ENDP

;----------------------------------------------------------------------------------------------
;
;                Channel B external interrupts are processed here
;
; This code is based on PI.C from JNOS 110g.    Some changes have been made
; to correct a flaw which limited the baud rate to 2400 or less. The changes
; in B_EXINT are in @@send_first and @@txdelay.  On a 486-33, 19200 baud seems
; to work fine now.

;


B_EXINT		PROC	NEAR

;;;;;	int 3
	push	bp				;save bp
	sub	sp,LOCALVAR_SIZE		;allow space for local variables on stack
	mov	bp,sp				;set bp to local variables
;
	mov	[bp].si_save,si		;save si
;
	pushf
	cli					;interrupts off
	mov	bx,R0
	call	rdscc				;get scc status
	mov	[bp].var0,ax			;save status in var0
	mov	bx,R0+RES_EXT_INT		;
	call	wrtscc				;reset ext interrupts
;
	mov	bl,[si.cs_tstate]		;get transmitter state to bx
	mov	bh,0
	cmp	bx,CRCOUT
	ja	short @@exit			;exit if out of range
	sal	bx,1				;mpy bx by 2
	call	word ptr cs:[@@B_exint_tbl + bx]	;call subroutine in lookup table
;
	cmp	[si.cs_rstate],ACTIVE		;is receiver active?
	jne	short @@exit			;no, quit
	test	[bp].var0, BRK_ABRT		;is this an abort?
	jz	short @@exit			;no, quit
	mov	bx,R8
	call	rdscc				;else clean trash from rx fifo
	call	rdscc
	call	rdscc
	mov	[si.cs_rxcnt],0		;zero the rxbuffer
	mov	bx,R0+ERR_RES
	call	wrtscc
;
;
@@exit:	popf					;restore interrupts
	add	sp,LOCALVAR_SIZE		;clean stack
	pop	bp
	ret


;-----------------------
;
@@active:
						; Unexpected Underrun comes here
	mov	ax,[si.cs_txbufptr]		; Free the tx buffer
	lea	bx, [si.cs_freelist]
	call 	enqueue
	mov	bx,R0+SEND_ABORT
	call	wrtscc				;start sending abort
	mov	[si.cs_tstate],FLAGOUT		;next state is flagout
	inc	[si.cs_TxUndr]			;count underrun
	cmp	[si.cs_WRFlag],1		;see if WRITE is waiting for a buffer
	jne	@@a0				;jmp if not
	mov	ax,ds
	lea	bx,[si.cs_WRFlag]		;get event ID of write procedure
	mov	dl,DH_ProcRun			;get WRITE going again now that a buffer is free
	call	[device_help]
	mov	[si.cs_WRFlag],0		;WRITE is not waiting now
;
@@a0:	mov	ax,[si.cs_tailtime]
	call	tdelay				;setup tail time delay
	ret
;
;
@@underrun:					;expected underrun
	mov	[si.cs_tstate],CRCOUT		;Next interrupt will be to b_txint - @@crcout
	ret
;
;
@@flagout:
	mov	bx,R0
	call	rdscc
	test	al,TX_BUF_EMP			;make sure tx is really empty
	jnz	short @@go			;yes - go ahead
	mov	ax,1
	call	tdelay				;no - wait another 10 ms
	ret
;
@@go:	lea	bx,[si.cs_txqueue]		; Get a buffer from the txqueue
	call	dequeue			; Buffer ptr returned in ax
	jc	@@nts				; cy set means none left, exit
;						; ...else send first char in buffer
	
@@send_first:
	push	ax				;save buffer pointer
	mov	bx,R10+CRCPS+ABUNDER		;assume external clock
	mov	ax,[si.cs_speed]		;get speed (32bits)
	or	ax,[si.cs_speed+2]
	jz	short @@fo1			;jmp if speed = 0 (ext. clock)
	mov	bx,R10+CRCPS+NRZI+ABUNDER	;NRZI if internal clock
@@fo1:	call	wrtscc				;set scc to proper clocking mode 
	mov	bx,R0+ERR_RES
	call	wrtscc
	mov	bx,R15+TxUIE			;TX underrun int only
	call	wrtscc
	mov	bx,R0+RES_EXT_INT		;reset external interrupts
	call	wrtscc
	mov	bx,R1+TxINT_ENAB+EXT_INT_ENAB	;enable tx and ext interrupts
	call	wrtscc
	mov	bx,R0+RES_Tx_P			;reset tx int pending
	call	wrtscc
;
	pop	bx				; pop buffer address to bx	
	mov	[si.cs_txbufptr],bx		; Make it the active tx buffer
	mov	di,[si.cs_bufsiz]
	mov	cx,[bx+di+2]			; Get length
	mov	[si.cs_txlength],cx
	mov	[si.cs_txcnt],1		;tx character counter will be 1 
	mov	bl,[bx]			;get first char from tx buffer to bl
	mov	bh,R8/256			;set bh to R8 (tx data register)
	call	wrtscc				;* Write first char to scc *
	mov	bx,R0+RES_EOM_L		;Reset end of message
	call	wrtscc
	mov	[si.cs_tstate],ACTIVE		;set tstate to active
	ret					;Normal return
;
;
@@nts:	call	TX_OFF
	mov	[si.cs_tstate],IDLE
	ret
;-------------------------
;note:  DEFER is a separate procedure shared by b_exint and b_txint.
;
;-------------------------
;
@@txdelay:					;Come here when tstate is TXDELAY
						;and we get a timer interrupt

	mov	bx,R0+RES_Tx_CRC
	call	wrtscc				;reset crc for next frame
;
	mov	bx,R10+CRCPS+ABUNDER		;assume external clock
	mov	ax,[si.cs_speed]		;get speed (32bits)
	or	ax,[si.cs_speed+2]
	jz	short @@txd1			;jmp if speed = 0 (ext. clock)
	mov	bx,R10+CRCPS+NRZI+ABUNDER	;NRZI if internal clock
@@txd1:	call	wrtscc				;configure scc to send abort on underrun
;
	mov	bx,R0+ERR_RES
	call	wrtscc
	mov	bx,R15+TxUIE			;TX underrun int only
	call	wrtscc
	mov	bx,R0+RES_EXT_INT		;reset external interrupts
	call	wrtscc
	mov	bx,R1+TxINT_ENAB+EXT_INT_ENAB	;enable tx and ext interrupts
	call	wrtscc
	mov	bx,R0+RES_Tx_P			;reset tx int pending
	call	wrtscc
;
	mov	bx,[si.cs_txbufptr]	;get tx buffer base to bx
	mov	di,[si.cs_txcnt]	;char count to di
	mov	bl,[bx+di]		;get a char from tx buffer to bl
	mov	bh,R8/256		;set bh to R8 (tx data register)
	call	wrtscc			;write char to scc
	inc	di			;count one more
	mov	[si.cs_txcnt],di	;save new char count value
	mov	bx,R0+RES_EOM_L	;Reset End Of Message
	call	wrtscc
;
	mov	[si.cs_tstate],ACTIVE	;set tx state to active
	ret

@@idle:
;;;;	int 3
	ret
@@crcout:
;;;; int 3
	  ret




;-----------------------	
@@B_exint_tbl:
	dw	offset cs:@@idle
	dw	offset cs:@@txdelay
	dw	offset cs:@@active
	dw	offset cs:@@underrun
	dw	offset cs:@@flagout
	dw	offset cs:B_DEFER
	dw	offset cs:@@crcout	



B_EXINT	ENDP

;------------------------------------------------------------------------------
;
; Read the count value in timer 0.
; Timer 0 is clocked at 3.686. mHz in the PI-2 card 
; and  1.843 mHz in the older PI card.
; Timer value returned in ax.
;
RDTimer0  PROC NEAR
	pushf
	cli				; interrupts off
	push	dx
	mov	dx,[io_addr]		; PI base address
	add	dx,TMRCMD		; Timer command register
	mov	al,0
	out	dx,al			; latch the counter
	call delay8253			; Satisy access time restriction
	sub	dx,3			; point dx to timer 0
	in	al,dx			; Read LSB
	call delay8253			; Satisy access time restriction
	mov	ah,al
	in	al,dx			; Read MSB
	xchg	al,ah
	call delay8253			; Satisy access time restriction
	pop	dx
	popf				; restore interrupts
	ret				; return counter value in ax

RDTimer0 ENDP

;-------------------------------------------------------------------------------
; Enter with ax=time constant for timer 0
;
TimerSetup	PROC NEAR

	pushf
	cli
	push	dx
	push	ax			;save time constant
	mov	dx,[io_addr]
	add	dx,TMRCMD
	mov	al,SC0+LSB_MSB+MODE3 	; 500 uS square wave
	out	dx,al
	call delay8253			; Satisfy access time restriction
	pop	ax			;pop time constant
	mov	dx,[io_addr]
	add	dx,TMR0
	out	dx,al			; LSB
	call delay8253			; Satisy access time restriction
	mov	al,ah
	out	dx,al			; MSB
	call delay8253			; Satisy access time restriction
	pop	dx
	popf
	ret
;
TimerSetup ENDP
;
;----------------------------------------------------------------------------
;Read 8530 SCC register pointed to by [bh]
;return value in al.

;RDSCC & WRTSCC Procedures copied from PI2.asm by Dave Perry VE3IFB

RDSCC	PROC NEAR

	pushf
	cli
	push cx
	push dx
	push di
	push si
	push bp

	mov di,[acc_delay]	; Save acc_delay in di

	mov dx,[io_addr]	; Get card address
	cmp	si,offset ds:chb ;see what channel he wants
	je	@@B	
;
	add dx,CTL_A		; if cha then get channal A control register
	mov bp,dx		; Save it in bp
	jmp	SHORT @@rd
;
@@B:	add	dx,CTL_B	;if chb then do side  B
	mov	bp,dx
;
@@rd:	mov dx,[io_addr]	; get address of dma enable port
	add dx,DMAEN
	mov si,dx		; save it in si

	mov cx,di		; For loop below

	mov ax,100h		; Disable DMA while we touch the scc
	out dx,al

; ******** DMA off

Loop4:	loop Loop4		;[5]

	mov dx,bp		;[2] Get address of SCC control reg
	mov al,bh		;[2] Select register
	out dx,al;		;[8]

	mov cx,di		;[2]
Loop5:	loop Loop5		;[5]

	mov dx,si		;[2] get address of dma enable port
	mov al,ah		;[2] Enable DMA
	out dx,al		;[8]
;
;********* DMA on - was off for 36 cycles
;
	nop			; Leave extra time for XT ram refresh cycle to finish
	nop
	nop
	mov cx,di		; For loop below
	mov al,0
	out dx,al

;********* DMA off

Loop5a:	loop Loop5a		;[5]

	mov dx,bp		;[2] Get address of SCC control reg
	in al,dx		;[8] read register
	mov bl,al		;[2] save return value

	mov cx,di		;[2]
Loop6:	loop Loop6		;[5]

	mov dx,si		;[2] get address of dma enable port
	mov al,ah		;[2] Enable DMA
	out dx,al		;[8]
;
; ******** DMA on - was off for 36 cycles
;
	mov	al,bl		; recover return value

	pop	bp
	pop	si

	push 	bx
	mov	bl,bh
	mov	bh,0
	mov	[si.cs_R8530RD+bx],al 	;remember what we read for debug
	pop	bx

	pop	di
	pop	dx
	pop	cx
	popf
	ret

delay8253:
	nop
	nop
	nop
	nop
	nop
	ret

RDSCC	ENDP
;--------------------------------------------------------------------------------

; This routine is used for all writes to the SCC. It satisfies the
; The SCCs access time restriction by using delay loops. These loops
; are processor speed dependent and are determined by acc_delay.

; Enter with bh = register, bl = value
; si must point to either cha or chb channel structures

WRTSCC	PROC	NEAR

	pushf		; Save current interrupt state
	cli		; Wouldn't do to be interrupted now
	push ax
	push cx
	push dx
	push di
	push si
	push bp

	mov 	di,[acc_delay]; Load this into a register for speed

	mov 	dx,[io_addr]	; Get card address
	cmp	si,offset ds:chb ;see what channel he wants, jmp if B
	je	@@B	
;
	add 	dx,CTL_A	; if cha then get channal A control register
	mov 	bp,dx		; Save it in bp
	jmp	SHORT @@rd
;
@@B:	add	dx,CTL_B	;if chb then do side  B
	mov	bp,dx
;
@@rd:
	mov dx,[io_addr]	; get address of dma enable port
	add dx,DMAEN
	mov si,dx		; save it

	mov cx,di		; For loop below

	mov ax,100h		; Write a 0 to disable DMA while we touch the scc
	out dx,al

; ******** DMA off

Loop1: loop Loop1	;[5] wait acc_delay

	mov dx,bp	;[2] Get pointer to ch A control reg
	mov al,bh	;[2] Select register
	out dx,al	;[8]

	mov cx,di	;[2]
Loop2:	loop Loop2	;[5]  wait acc_delay

	mov dx,si	;[2] get address of dma enable port
	mov al,ah	;[2] Enable DMA in between accesses
	out dx,al	;[8]

; ******** DMA on - was off for 36 cycles

	nop		; Leave extra time for XT ram refresh cycle to finish
	nop
	nop
	mov cx,di	; For loop below
	mov al,0	; now disable DMA in between accesses
	out dx,al	;

; ******** DMA off

Loop2a:	loop Loop2a	;[5]

	mov dx,bp	;[2] Get pointer to ch A control reg
	mov al,bl	;[2] Output value
	out dx,al	;[8]

	mov cx,di	;[2]
Loop3:	loop Loop3	;[5]

	mov dx,si	;[2] get address of dma enable port
	mov al,ah	;[2] Enable DMA
	out dx,al	;[8]

; ******** DMA on - was off for 36 cycles

	pop bp
	pop si

	push	bx
	mov	al,bl
	mov	bl,bh
	mov	bh,0
	mov	[si.cs_R8530WRT+bx],al		;remember what we wrote
	pop	bx

	pop di 
	pop dx
	pop cx
	pop ax
	popf
	ret

WRTSCC	ENDP
;----------------------------------------------------------------------------------
; Setup for DMA
; Initializes certain DMA chip registers - called by setup_rx_dma
; and setup_tx_dma
; Enter with cx:bx = buffer, ax = length
; Note: * the CX:BX address is a PHYSICAL address *
;
; Writes the dma chip word count reg, dest reg, and the dma page reg
;

SETUP_DMA	PROC	NEAR

	
	pushf				; Save interrupt state
	cli				; Disable interrupts

	sub	ax,1			; adjust length for DMA chip
	push	ax			; Save it for later
	
	mov	ax,[dma_channel] 	 ; Disable DMA for this channel
	add	al,DMA_DISABLE
	out	DMA_MASK,al

	xor	al,al
	out	DMA_RESETFF,al		; Reset byte pointer flipflop

	mov	ax,bx			; low 16 bits of 32 bit phy. addr to ax
	mov	dx,[dma_dest]		; Output buf start (source) address
	out	dx,al			; A0..A7 to DMA address register
	mov	al,ah
	out	dx,al			; A8..A15 to DMA address register
	mov	ax,cx			; Get high 16 bits of phys addr to ax
	mov	dx,[page_addr]		; Point to DMA page register I/O port
	out	dx,al			; Put A16..A24 in page register

	mov	dx,[dma_wcr]		; Get address of word count register
	pop	ax			; Recover length and output it
	out	dx,al			;
	mov	al,ah
	out	dx,al

	popf	; restore interrupt state
	ret


SETUP_DMA	ENDP


;----------------------------------------------------------------------------------

; Setup receive dma
; Enter with ds:bx = buffer, ax = length
; Note: ds:bx is a virtual address.
;
SETUP_RX_DMA	PROC	NEAR

	pushf				; Save interrupt state
	cli				; Disable interrupts

	push	si
	push	di
	push	bx
	push	dx
;
	cmp	bx,[si.cs_bufstart]
	jl	@@panic		;error if dma is below ram limit
	mov	di,ax			;buffer size to di
	lea	ax,[bx+si]		;ax has highest DMA address requested
	mov	cx,[si.cs_DmaMemSize]
	add	cx,[si.cs_bufstart]	;cx has highest RAM address allowed
	cmp	ax,cx
	ja	@@panic		;error if DMA would exceed ram limits
;
	mov	ax,di			;buffer length to ax
	mov	di,[si.cs_bufsiz]	
	mov	cx,[bx+di+6] 		;get high word of physical address to cx
	mov	bx,[bx+di+4] 		;get low physical address word to bx
	
	call	setup_dma		;set up the DMA chip

; Get ready for RX DMA

	mov	bx,R1+WT_FN_RDYFN+WT_RDY_RT+INT_ERR_Rx+EXT_INT_ENAB
	call	wrtscc

; Set DMA mode register to single transfers, incrementing address,
; auto init, writes
	mov	ax,[dma_channel]	; Put dma chip in transmit for this channel
	add	al,DMA_RX_MODE
	out	DMA_MODE,al

; Unmask channel n (enable DMA controller chip)

	mov	ax,[dma_channel] ; Enable DMA for this channel
	add	al,DMA_ENABLE
	out	DMA_MASK,al

; If a packet is already coming in, this line is supposed
; to mess up the crc to avoid receiving a partial packet

	mov	bx,R0+RES_Rx_CRC
	call	wrtscc

; Enable RX dma in SCC chip

	mov	bx,R1+WT_RDY_ENAB+WT_FN_RDYFN+WT_RDY_RT+INT_ERR_Rx+EXT_INT_ENAB
				
	call	wrtscc		;0xf9 to WR1

@@exit:	pop	dx
	pop	bx
	pop	di
	pop	si
	popf

	ret

@@panic: int 3
	jmp @@exit

SETUP_RX_DMA	ENDP

;-------------------------------------------------------------------------------------

;
; Set up for transmit DMA
; Enter with ds:bx = buffer, ax = length,  ds:si -> channel structure
;
SETUP_TX_DMA	PROC	NEAR

	pushf			; Save interrupt state
	cli			; Disable interrupts

	push	di		;save di
	push	bx		;save bx
	mov	di,[si.cs_bufsiz]	;buffer size to si
	mov	cx,[bx+di+6] ;get high word of physical address to cx
	mov	bx,[bx+di+4] ;get low physical address word to bx
	call	setup_dma	;Setup DMA chip with phys. addr. passed in cx:bx

; Set DMA mode register to single transfers, incrementing address,
; no auto init, reads

	pop	bx
	pop	di
	mov	ax,[dma_channel]	; Put dma chip in transmit for this channel
	add	al,DMA_TX_MODE
	out	DMA_MODE,al
	popf
	ret

SETUP_TX_DMA	ENDP


;------------------------------------------------------------------------------------

; Set up 8254 chip for time delay
; Enter with time to delay (mS) in ax and si pointing to cha or chb.
;
;
TDELAY	PROC	NEAR

	push	bx
	push	cx
	push	dx

	push	ax			; Save delay time
	mov	dx,[io_addr]
	add	dx,TMRCMD
	mov	al,SC1+LSB_MSB+MODE0	; Setup timer sc
	cmp	si,offset ds:chA	;is this channel A?
	je	SHORT @@1
	mov	bx,R1+EXT_INT_ENAB	;no, assume B side
	call	wrtscc			;enable ext ints in B side
	mov	al,SC2+LSB_MSB+MODE0	;and point to B side timer
@@1:	out	dx,al
	call	delay8253		; Satisy access time restriction
	mov	dx,[io_addr]
	mov	ax,TMR1
	cmp	si,offset ds:chA	; channel A?
	je	SHORT @@2
	mov	ax,TMR2		; no, assume channel B
@@2:	add	dx,ax			; set for TMR1 or TMR2
	pop	ax			; Recover delay time
	sal	ax,1			; Times 2 to make milliseconds
	out	dx,al			; Write low byte
	call	delay8253
	mov	al,ah
	out	dx,al			; then high byte
;
	mov	bx,R15+CTSIE	 	; Enable interrupt for timeout
	call	wrtscc
	mov	bx,R0+RES_EXT_INT	; reset external interrupts
	call	wrtscc
;
	pop	dx
	pop	cx
	pop	bx
	ret

TDELAY	ENDP



;------------------------------------------------------------------------------
;
; Turn off the transmitter and setup for receiving.
;
; On entry si must point to chA or chB so the correct variables will be used.
;
TX_OFF	PROC	NEAR

	pushf
	cli				;disable interrupts
	push	bx

	mov	bx,R5+Tx8+DTR		; TX off
	call	wrtscc
	mov	[si.cs_RTSState],0	;remember it
	mov	[si.cs_tstate],IDLE	;set tstate to IDLE
;
	mov	ax,[si.cs_speed]	; Internally clocked?
	or	ax,[si.cs_speed+2]
	jz	short @@tx_off_1	; Externally clocked, don't change BRG
	mov	ax,[si.cs_clkmode]	; Clocking mode 1?
	cmp	ax,1
	jz	short @@tx_search	; Mode 1, don't change BRG
					; But enter search mode
; Reprogram BRG for 32x clock for receive DPLL
	mov	bx,R14+BRSRC		; BRG off, keep Pclk source
	call	wrtscc
	mov	ax,[si.cs_rx_tc]	; Get receive time constant for BRG
	mov	bx,R12			; Write low byte of time constant to R12
	mov	bl,al
	call	wrtscc
	mov	ax,[si.cs_rx_tc]	; Get receive time constant for BRG
	mov	bx,R13			; Write high byte of time constant to R13
	mov	bl,ah
	call	wrtscc
@@tx_search:
	mov	bx,R14+BRSRC+SEARCH 		; SEARCH mode, BRG source
	call	wrtscc
	mov	bx,R14+BRSRC+BRENABL 		; Enable the baud rate generator
	call	wrtscc
@@tx_off_1:
	mov	bx,R3+Rx8			;make sure RX is off
	call	wrtscc
	mov	bx,R0+ERR_RES			;error reset RX
	call	wrtscc
	mov	bx,R1				
	call	rdscc				;dummy read RX status
	mov	bx,R8				;flush RX fifo
	call	rdscc
	call	rdscc
	call	rdscc
	mov	bx,R3+RxENABLE+RxCRC_ENAB+Rx8	; RX on
	call	wrtscc
	mov	[si.cs_rstate],ACTIVE		;set rx state to active

	cmp	si,offset ds:chb		;is this channel B ?
	je	short @@B			;Yes, don't do DMA setup
;	
	mov	bx,[si.cs_rxbufptr]
	mov	ax,[si.cs_bufsiz]
	call	setup_rx_dma			;setup DMA rx for A side
	jmp	short @@C
;
@@B:	mov	[si.cs_rxcnt],0
	mov	bx,R1+INT_ALL_Rx+EXT_INT_ENAB	;set up for interrupt rx on B side
	call	wrtscc
;
@@C:	mov	bx,R15+BRKIE
	call	wrtscc				; allow abort interrupt
	mov	bx,R0+RES_EXT_INT
	call	wrtscc				;reset all ext ints
	mov	bx,R0+ERR_RES
	call	wrtscc
;
	cmp	[cha.cs_OpenCounter],0		;is A side driver open?
	jne	@@tx_off2			;yes, leave PI card enabled
	cmp	[chb.cs_OpenCounter],0		;is B side open?
	jne	@@tx_off2			;yes, leave card enabled	
	call	DisablePI			;no, turn off our interrupts
@@tx_off2:
	pop	bx
	popf
	ret

TX_OFF	ENDP

;------------------------------------------------------------------------------------------

TX_ON	PROC	NEAR

	pushf
	cli
	push	bx

	mov	bx,R15+0		; Exints off first to avoid abort interrupt
	call	wrtscc
	mov	bx,R3+Rx8		; Rx off
	call	wrtscc
;
	cmp	si, offset ds:cha	; channel A ?
	je	short @@A
	mov	bx,R1+0		; channel B has no dma
	jmp	short @@B
@@A:	mov	bx,R1+WT_FN_RDYFN+EXT_INT_ENAB	; Set up for ch A for TX DMA (0x41)
@@B:	call	wrtscc
	mov	ax,[si.cs_speed]	; Internally clocked?
	or	ax,[si.cs_speed+2]
	jz	short tx_on_1		; Externally clocked, don't change BRG
	mov	ax,[si.cs_clkmode]	; Clocking mode 1?
	cmp	ax,1
	je	short tx_on_1		; Clocking mode 1, don't change BRG
	mov	ax,[si.cs_tx_tc]	; Get transmit time constant for BRG
	mov	bx,R12			; Write low byte of time constant to R12
	mov	bl,al
	call	wrtscc
	mov	ax,[si.cs_tx_tc]	; Get transmit time constant for BRG
	mov	bx,R13			; Write high byte of time constant to R13
	mov	bl,ah
	call	wrtscc
tx_on_1:
	mov	bx,R5+TxCRC_ENAB+RTS+TxENAB+Tx8+DTR
	call	wrtscc
	mov	[si.cs_RTSState],1	;remember that TX is ON

	pop	bx
	popf
	ret

TX_ON	ENDP

;----------------------------------------------------------------------------------------------
;Enter with si pointing to chb or cha

; Return offset of a buffer which does not cross a DMA page boundary.
; Returns offset of buffer in ax. Buffers are in data segment.

GETBUFFER PROC NEAR

	push	cx
	push	bx

	mov	bx,[si.cs_allocptr]	; point to free area
get1:	mov	ax,[si.cs_bufsiz]
	call	test_buffer
	jnc	get_good		; found one
	mov	ax,[si.cs_bufsiz]
	add	ax,8	     		;Leave room for next pointer,length and phys address
	add	ax,[si.cs_allocptr]
	mov	[si.cs_allocptr],ax	; This one failed
	pop	bx
	pop	cx
;	call	Beep			;debug tool
	jmp	getbuffer
get_good:
	mov	ax,[si.cs_allocptr]
	mov	bx,ax			; Save pointer for return
	add	ax,[si.cs_bufsiz]
	add	ax,8	     		;Leave room for next pointer,length and phys address
	mov	[si.cs_allocptr],ax	; point to the next buffer
	mov	ax,bx			; recover pointer

	pop	bx
	pop	cx
	ret				; return buffer found in ax

GETBUFFER ENDP

;---------------------------------------------------------------------------

;Enter with si pointing to cha or chb

CREATE_BUFFERS	PROC	NEAR

	mov	bx, [si.cs_bufstart]
	mov	cx,[si.cs_DmaMemSize]
clr_buf:
	mov	byte ptr[bx],0		;fill dma buffers with NULs
	inc	bx
	loop	clr_buf
	
	mov	cx,num_ptrs
	lea	bx, [si.cs_rxbufptr]
	mov	eax,0
clr_ptrs:				;zero out the buffer pointers
	mov	dword ptr[bx],eax
	add	bx,4
	loop	clr_ptrs
	

	mov	ax,[si.cs_bufstart] 	; Initialize buffers
	mov	[si.cs_allocptr],ax	; [allocptr] has start of buffer area


; Set up DMA buffer pool

	mov	cx,[si.cs_numbufs]	; We want this many
et1:

	call	getbuffer		; Get a DMA buffer
	push	ax			;save buffer address on stack
	push	si			;save si !
	mov	si,ax			;buf addr to si
	mov	dl,DH_VirtToPhys	;Virtual to Physical
	call	[device_help]		;convert buffer address ds:si to physical address ax:bx
	jnc	cnv_ok			;OK, jump
	pop	si
	pop	ax
	ret				;can't convert  error, exit with carry set
;
cnv_ok: pop	si			;restore si (channel struc pointer)
	mov	di,[si.cs_bufsiz]
	mov	dx,bx			;low phys addr to dx
	pop	bx			;buffer address to bx
	mov	[bx+di+4],dx		;store low 16 bits of physical address for DMA
	mov	[bx+di+6],ax		;store high 16 bits.
	mov	ax,bx			;buffer address to ax
	lea	bx,[si.cs_freelist]	; Append it to the free list
	call	enqueue
	jc	cb_err
		
	loop	et1

	lea	bx,[si.cs_freelist]	;get a buffer from freelist
	call	dequeue
	jc	cb_err
	mov	[si.cs_rxbufptr],ax	;make it the first receive buffer
;
	mov	ax,[si.cs_allocptr]
	mov	bx,[si.cs_bufstart]
	sub	ax, bx			;compute new size of buffer area
	mov	[si.cs_DmaMemSize],ax
	clc				;success = carry clear
cb_err:	ret



CREATE_BUFFERS	ENDP

;-----------------------------------------------------------------------------
;Initialize PI card hardware and DMA buffers
;Called at device driver INIT time.
;returns with dx pointing to last used _DATA address

PI_INIT PROC NEAR

	call	DisablePI		;disable PI interrupts

;Figure RAM requirments for DMA buffers for A and B channels.
;
	mov	ax,[numbufs]
	shr	ax,1			;divide numbufs by 2 with remainder in carry flag
	mov	[chb.cs_numbufs],ax	;set the B side numbufs value
	adc	ax,0			;add in the remainder, if any, to the A side
	mov	[cha.cs_numbufs],ax	;set the A side
	mov	dx,[bufsiz]		;dx = bufsiz
	mov	[cha.cs_bufsiz],dx	;set channel A buffer size
	add	dx,8			;add 8 bytes overhead per buffer
	add	ax,1			;add 1 spare in case of DMA page crossing
	mul	dx			;dx:ax = (numbufs+1) * ( bufsize + 8)
	mov	[cha.cs_DmaMemSize],ax	;save DMA memory size value for A
	mov	dx, offset ds:bufstart
	mov	[cha.cs_bufstart],dx	;set A side buffer starting address
	add	ax,dx			;find the B starting address (bufstart+DmaMemSize)
	mov	[chb.cs_bufstart],ax	;save it in chb
;
	mov	ax,[chb.cs_numbufs]	;get B numbufs
	mov	dx,[bufsiz]		;dx = bufsiz
	mov	[chb.cs_bufsiz],dx	;set channel B buffer size
	add	dx,8			;add 8 bytes overhead per buffer
	add	ax,1			;add 1 spare in case of DMA page crossing
	mul	dx			;dx:ax = (numbufs+1) * ( bufsize + 8)
	mov	[chb.cs_DmaMemSize],ax	;save DMA memory size value for B


	

; Adjust scc delay for speed of host cpu

	mov	si,offset ds:chA		; si must be valid before call to wrtscc
	mov	bx,R9+FHWRES		; Hardware reset SCC
	call	wrtscc


	call	CalcDmaPage		;setup dma page register address
	mov	si,offset ds:chA
	call	CREATE_BUFFERS
	call	CalcBaudRates		;init baud rates for chA
	call	scc_init		;initialize A side of scc chip
;
	mov	si,offset ds:chB
	call	CREATE_BUFFERS
	call	CalcBaudRates		;init baud rates for chB
	call	scc_init		;init B side of scc
;
	mov	ax,1844		; PI2 time constant
	cmp	[PItype],1
	je	short @@pi2		; jmp if PI2
	mov	ax,922			; Original PI time constant
@@pi2:	call	TimerSetup		; Set up timer chip for 500us SQ wave
;
;if all is okay,
	mov	ax,[chb.cs_DmaMemSize]
	add	ax,[chb.cs_bufstart]
	add	ax,9			;add safety margin
	mov	dx,ax			;return last needed ram address in dx
	clc
	ret
etopen_error:
;if we got an error,
	stc
	ret
;
;----------------------------------------------------
;; Initialize the SCC registers

scc_init:
	pushf
	cli
	push	bx

	mov	bx,R1+0		; Deselect all Rx and Tx interrupts
	call	wrtscc
	mov	bx,R15+0		; Turn off external interrupts
	call	wrtscc
;
	mov	[si.cs_tstate],IDLE	; set tstate to IDLE
	mov	bx,R9+CHRA+MIE+NV	; assume channel A to reset
	cmp	si, offset ds:chA	; see if it is chA
	je	short @@sccA
	mov	bx,R9+CHRB+MIE+NV	; else reset channel B
@@sccA:	call	wrtscc			; Reset channel now
	mov	bx,R2+0ffh		; Set interrupt vector
	call	wrtscc
	mov	bx,R4+SDLC+X1CLK 	; SDLC mode and times 1 clock
	call	wrtscc

	mov	ax,[si.cs_speed]	; Get baud rate
	or	ax,[si.cs_speed+2]
	jz	short scc_init_1	; Jump if externally clocked
	mov	ax,[si.cs_clkmode]	; Clocking mode 1?
	cmp	ax,1
	jnz	short scc_init_5	; No - must be internal clocking

	mov	bx,R10+CRCPS 		; Clock mode 1, CRC preset, not NRZI mode
	call	wrtscc
					; Receive clock = RTxC pin
					; Transmit clock = baud rate generator
					; Transmit clock is output on TRxC pin
	mov	bx,R11+TCBR+RCRTxCP+TRxCOI+TRxCTC
	call	wrtscc 	
	jmp	short scc_init_2

scc_init_5:
	mov	bx,R10+CRCPS+NRZI 	; Internal clock, CRC preset, NRZI mode
	call	wrtscc
					; Receive clock = DPLL
					; Transmit clock = baud rate generator
					; Transmit clock is output on TRxC pin
	mov	bx,R11+TCBR+RCDPLL+TRxCOI+TRxCTC
	call	wrtscc 	
	jmp	short scc_init_2
scc_init_1:				; Externally clocked
	mov	bx,R10+CRCPS		; CRC preset
	call	wrtscc
					; Receive clock = RTxC pin
					; TRxC pin is input for transmit clock
	mov	bx,R11+TCTRxCP		; Rcv clk is from Rtxcl, TRxC pin is input
	call	wrtscc

scc_init_2:
	mov	bx,R6+0		; Null out SDLC start address
	call	wrtscc
	mov	bx,R7+FLAG		; SDLC flag
	call	wrtscc
	mov	bx,R5+Tx8+DTR		; Set up tx but don't enable it yet
	call	wrtscc
	mov	bx,R3+Rx8		; Initial rx setup
	call	wrtscc
	mov	bx,R14+BRSRC
	call	wrtscc

	mov	ax,[si.cs_rx_tc]	; Get receive time constant for BRG
	mov	bx,R12			; Write low byte of time constant to R12
	mov	bl,al
	call	wrtscc
	mov	ax,[si.cs_rx_tc]	; Get receive time constant for BRG
	mov	bx,R13			; Write high byte of time constant to R13
	mov	bl,ah
	call	wrtscc

	call	SetBRG
;
;
	call	tx_off			; Set up and enable RX
	pop	bx
	popf
	ret
;-------------------------

SetBRG:
	push	bx

	mov	ax,[si.cs_speed]	; Internal clocking?
	or	ax,[si.cs_speed+2]
	jz	short scc_init_3	; Jump if External
	mov	ax,[si.cs_clkmode]
	cmp	ax,1
	jne	short t1		;jmp if clk mode is 0

	mov	bx,R14+BRSRC+SSRTxC+BRENABL  ;Mode 1 clock
	call	wrtscc
	jmp scc_init_4
	
t1:
	mov	bx,R14+BRSRC+SSBR+BRENABL    ;Mode 0 clock
	call	wrtscc
	jmp scc_init_4
scc_init_3:
	mov	bx,R14+BRSRC+SSRTxC 	; Set DPLL source = RTxC
	call	wrtscc
scc_init_4:
	pop	bx
	ret


;----------------------------



; Calculate time constants for baud rate generator
;
CalcBaudRates:
;
	cmp	dword ptr [si.cs_speed], 0
	je	short @@br_exit	; no need to calc for external clk
	mov	edx,0
	mov	eax,7372800		; 7,372,800 Hz scc clock for PI2
	cmp	[PItype],1
	je	short @@br0		; jmp if PI2
	mov	eax,3686400		; 3,686,400 Hz scc clock for original PI
@@br0:	sar	eax,1			; divide scc clk by 2
	push	eax			; save this for later
	div	dword ptr[si.cs_speed]	; Divide by baud rate
	sub	eax,2			; sub 2 - this is the BRG time constant
	mov	[si.cs_tx_tc],ax	; for Transmit - save it

	pop	eax			; Load SCC clock freq/32 into dx:ax
	sar	eax,5			; divide by 32	
	div	dword ptr [si.cs_speed] ; Divide by baud rate
	sub	eax,2			; sub 2 - this is the BRG time constant
	mov	[si.cs_rx_tc],ax	; for receive - save it
@@br_exit:
	ret



; Calculate address of dma page register

CalcDmaPage:
	mov	ax,[dma_channel]
	cmp	al,2
	jne	short parse_1
	mov	[tc_mask],4		;MASK FOR TC2
	mov	ax,81h			;CH 2
	jmp	parse_3
parse_1:
	cmp	al,3
	jne	short parse_2
	mov	[tc_mask],8		;MASK FOR TC3
	mov	ax,82h			;CH 3
	jmp	short parse_3
parse_2:
	mov	ax,83h			;CH 1
	mov	[tc_mask],2		;MASK FOR TC 1
parse_3:
	mov	[page_addr],ax

; Calculate address of dma destination and dma word count regs
	mov	ax,[dma_channel]
	shl	ax,1
	mov	[dma_dest],ax
	add	ax,1
	mov	[dma_wcr],ax
	ret
	


PI_INIT  ENDP

;-----------------------------------------------------------------------------

;Enable PI card interrupts

EnablePI PROC NEAR

	push	bx
	mov	bx,R9+MIE+NV 		; master interrupt enable
	call	wrtscc	
	pop	bx	
	ret

EnablePI ENDP

;------------------------------------------------------------------------------

DisablePI PROC NEAR

	push	bx
	mov	bx,R9+NV		;disable master interrupt
	call	wrtscc
	pop	bx
	ret

DisablePI ENDP

;-----------------------------------------------------------------------------------
;
; Test a buffer to see if it crosses a DMA page boundary.
; Special thanks to Intel and IBM for the hardware designs
; which require this kludge!
;
; Enter with ds:bx = buffer address, ax = length
; Exit carry clear on success.
; 

TEST_BUFFER	PROC	NEAR


	push	ax			; save length
	push	si
	mov	si,bx			; offset to si, ds:si have virtual address
	mov	dl,DH_VirtToPhys	; convert virtual to physical address
	call	[device_help]		; 32 bit physical returned in ax:bx
	mov	cx,ax			; 32 bit address now in cx:bx
	pop	si
	pop	ax			; length back in ax again
	add	ax,bx			; add the buffer start address (physical)
					; if carry is set, we spilled over the page
	ret				; return carry clear on success


TEST_BUFFER	ENDP

;-----------------------------------------------------------------------------------
; Enqueue and dequeue copied from Dave Perrys Packet Driver source
; with modifications for OS/2.
;
; Append buffer pointed to by ax to queue specified by bx

ENQUEUE		PROC	NEAR

	pushf
	cli
	push	si
	push	bp
	push	cx

	mov	cx,MAXBFRS+2		;prevent infinite loops
	mov	si,[bufsiz]
	mov	bp,ax
	mov	word ptr ds:[bp+si],0	; Make sure next pointer is null

	cmp	word ptr [bx],0	; [bx]->freelist,  Is list empty?
	jne	en1			; No - find the end
	mov	[bx],ax		; Yes - add it
	inc	word ptr [bx+2]	; Count it

	pop	cx
	pop	bp
	pop	si
	popf
	clc
	ret
					; freelist to bp
en1:	mov	bp,word ptr [bx] 	; get pointer to first element
en2:
	cmp	word ptr ds:[bp+si],0	; Is next pointer null?
	je	en3			; Yes, append our buffer
	mov	bp,ds:[bp+si]		; No - advance to next element
	dec	cx			;no more than MAXBFRS buffers allowed to exist
	jz	panic
	jmp	en2	
en3:	mov	ds:[bp+si],ax
	inc	word ptr [bx+2]	;Count it

	pop	cx
	pop	bp
	pop	si
	popf
	clc
	ret
;
panic:	pop	cx			;come here if things are totally screwed
	pop	bp			; and break out of infinite loop
	pop	si
	popf				;enable interrupts
	stc				;set carry says we have a problem
	ret

ENQUEUE		ENDP


;-----------------------------------------------------------------------------

DEQUEUE		PROC	NEAR

	pushf
	cli
	push	si
	mov	si,[bufsiz]
	cmp	word ptr [bx],0	; Is list empty?
	jne	deq1
	xor	ax,ax			; Yes, return error
	pop	si
	popf
	stc
	ret
deq1:
	push	bp
	mov	bp,[bx]		; No, dequeue buffer
	mov	ax,ds:[bp+si]
	mov	[bx],ax
	dec	word ptr [bx+2]	; Reduce count by 1
	mov	ax,bp

	pop	bp
	pop	si
	popf
	clc
	ret

DEQUEUE		ENDP

;--------------------------------------------------------------------------

Beep PROC NEAR

	push	bx
	push	cx
	push	dx
	mov	bx,2600
	mov	cx,100
	mov	dl,DH_Beep
	call	[device_help]
	pop	dx
	pop	cx
	pop	bx
	ret

Beep ENDP

;----------------------------------------------------------------------------



END_OF_CODE	equ	$

; ** Everything after this point is discarded after INIT. **

;-----------------------------------------------------------------------------
A_DriverNameMsg	db	"A chan Name        "
B_DriverNameMsg db	"B chan Name        "

InitMsgs	db	"IRQ number         "	;all these are 19 bytes long
		db	"I/O Port           "
		db	"DMA Channel        "
		db	"Buffer size        "
		db	"Number of buffers  "
		db	"A chan Baud Rate   "
		db	"A chan clk mode    "
		db	"B chan Baud Rate   "
LastMsg		db	"B chan clk mode    "

InitMsgSize	equ	$-LastMsg			;size of each msg
NMsgs		equ	($-InitMsgs) / InitMsgSize	;number of messages

SignOnMsg	db	cr,lf
		db	"OS/2 PI Card driver version 0.93 by WA4DSY"
crlf		db	cr,lf

MsgLen		equ	$-SignOnMsg
;
;
InitErrMsg	db	"OS/2 PI Card driver initialization failure"
		db	7,cr,lf
ErrMsgLen	equ	$-InitErrMsg

IrqErrMsg	db	"Selected IRQ not available"
		db	cr,lf
IrqErrMsgSize	equ	$-IrqErrMsg

RangeErrMsg	db	"  Parameter out of range "
RangeErrMsgSize	equ	$-RangeErrMsg

DecMsg		db	" Dec "
DecMsgSize	equ	$-DecMsg
;
PI1Msg		db	"Card type is PI"
		db	cr,lf
PI1MsgSize	equ	$-PI1Msg
;
PI2Msg		db	"Card type is PI2"
		db	cr,lf
PI2MsgSize	equ	$-PI2Msg

;--------------------------------------------------------------------------------
;
;  This routine calculates the constant to be used in the delay loops
;  which satisfy the SCC's access recovery time.  This needs to be timed and
;  calculated because a fixed value would not work in a 4.77mhz XT
;  to a 40mhz 486 (and beyond).  This code from PI Packet Driver source.
;
;Counter 0 is set by the BIOS to divide 1.1932 mhz by 65536 which produces
;an interrupt at 18.207 HZ, the system clock.
;
;acc_delay = 5000 / (tick2 - tick1)
;
; The difference in tick1 and tick2 is the number of 1.1932 mhz ticks
; it takes to do a 1000 interation loop.  The delay loop using acc_delay
; should always wait about 4.2 microseconds regardless of cpu speed.
;
; We also determine which type PI card is installed, original PI or PI2.
; This is done by taking the ratio of the count rates from the system
; counter-timer chip and the counter-timer on the PI card.  The PI2
; countes twice as fast as an original PI card.
;
	public set_acc_delay

set_acc_delay PROC NEAR

	pushf
	cli				;interrupts off
	push	ax
	push	bx
	push	cx
	push	dx
;
	mov	ax,0
	call	TimerSetup		; Setup PI card timer 0
;
	mov	al,0			;latch system counter zero.
	out	43h,al
	in	al,40h			;read system counter zero.
	mov	ah,al
	in	al,40h
	xchg	ah,al
	mov	[tick1],ax		;current count saved to tick1
	call	rdtimer0		;read PI card timer 0 into ax
	mov	[T0tick1],ax		;save it
	mov	cx,1000

h1:	loop	h1			;loop here 1000 times

	mov	al,0			;latch counter zero.
	out	43h,al
	in	al,40h			;read counter zero.
	mov	ah,al
	in	al,40h
	xchg	ah,al
	mov	[tick2],ax		;save current count in tick2
	call	rdtimer0		;read PI card timer again
	mov	[T0tick2],ax		;save it
;
	mov	ax,[tick1]
	sub	ax,[tick2]
	mov	[diff],ax		; Elapsed counts to diff
	mov	bx,ax
	mov	dx,0
	mov	ax,5000		; Divide 5000 by
	div	bx			; the number of counts elapsed
	cmp	al,0
	jne	set_acc_2
	mov	al,1			; Delay constant must be at least 1
set_acc_2:
	xor	ah,ah
	mov	[acc_delay],ax		;CPU delay constant in acc_delay
;
	mov	ax,[T0tick1]		; Now figure out if we have a PI or PI2 card
	sub	ax,[T0tick2]
	mov	[T0diff],ax
	sal	ax,1
	mov	dx,0
	idiv	[diff]			;divide PI card T0 counts by system timer counts
	mov	[PItype],0ffffh
	cmp	ax,20
	jg	short @@exit		;return -1 in PItype if ratio is invalid
	cmp	ax,4
	jl	short @@exit
;
	cmp	ax,9			;values should be: PI = 6,  PI2 = 12
	ja	short @@PI2
	mov	[PItype],0		;PI  PIType = 0
	jmp	short @@exit
@@PI2:	mov	[PItype],1		;PI2 PIType = 1

;	
@@exit:	pop	dx
	pop	cx
	pop	bx
	pop	ax
	popf				;enable interrupts
	ret

set_acc_delay ENDP

;--------------------------------------------------------------------------------


printhex	PROC NEAR

	push	ax
	push	bx
	push	cx
	push	dx
	call	printword
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

printhex ENDP



;---------------------------------------------------------------------------------------



;GET_NUMBER is public domain by Russell Nelson, nelson@clutx.clarkson.edu
;with mods by Dale Heatherington WA4DSY

GET_NUMBER PROC NEAR

	mov	bp,10			;we default to 10.
	jmp	short get_number_0

get_hex:
	mov	bp,16
;get a hex number, skipping leading blanks.
;enter with si->string of digits,
;	di -> dword to store the number in.  [di] is not modified if no
;		digits are given, so it acts as the default.
;return cy if there are no digits at all.
;return nc, bx:cx = number, and store bx:cx at [di].
get_number_0:
	call	skip_blanks
	call	get_digit		;is there really a number here?
	jc	get_number_3
	xor	ah,ah
	cmp	ax,bp			;larger than our base?
	jae	get_number_3		;yes.
	or	al,al			;Does the number begin with zero?
	jne	get_number_4		;no.
	mov	bp,8			;yes - they want octal.
get_number_4:

	xor	cx,cx			;get a hex number.
	xor	bx,bx
get_number_1:
	seges
	lodsb				;use ES:SI  (wa4dsy change)
	cmp	al,'x'			;did they really want hex?
	je	get_number_5		;yes.
	cmp	al,'X'			;did they really want hex?
	je	get_number_5		;yes.
	call	get_digit		;convert a character into an int.
	jc	get_number_2		;not a digit (neither hex nor dec).
	xor	ah,ah
	cmp	ax,bp			;larger than our base?
	jae	get_number_2		;yes.

	push	ax			;save the new digit.

	mov	ax,bp			;multiply the low word by ten.
	mul	cx
	mov	cx,ax			;keep the low word.
	push	dx			;save the high word for later.
	mov	ax,bp
	mul	bx
	mov	bx,ax			;we keep only the low word (which is our high word)
	pop	dx
	add	bx,dx			;add the high result from earlier.

	pop	ax			;get the new digit back.
	add	cx,ax			;add the new digit in.
	adc	bx,0
	jmp	get_number_1
get_number_5:
	mov	bp,16			;change the base to hex.
	jmp	get_number_1
get_number_2:
	dec	si
	mov	[di],cx			;store the parsed number.
	mov	[di+2],bx
	clc
	jmp	short get_number_6
get_number_3:
	cmp	al,'?'			;did they ask for the default?
	stc
	jne	get_number_6		;no, return cy.
	add	si,2			;skip past the question mark.
	mov	cx,-1
	mov	bx,-1
	jmp	get_number_2		;and return the -1.
get_number_6:
	ret

get_digit:
;enter with al = character
;return nc, al=digit, or cy if not a digit.
	cmp	al,'0'			;decimal digit?
	jb	get_digit_1		;no.
	cmp	al,'9'			;. .?
	ja	get_digit_2		;no.
	sub	al,'0'
	clc
	ret
get_digit_2:
	cmp	al,'a'			;hex digit?
	jb	get_digit_3
	cmp	al,'f'			;hex digit?
	ja	get_digit_3
	sub	al,'a'-10
	clc
	ret
get_digit_3:
	cmp	al,'A'			;hex digit?
	jb	get_digit_1
	cmp	al,'F'			;hex digit?
	ja	get_digit_1
	sub	al,'A'-10
	clc
	ret
get_digit_1:
	stc
	ret

find_blank:
	mov	al,[max_param]
	or	al,al
	jz	fbexit			;limit search to [max_param] chars.

	seges				;search in the ES segment
	lodsb
	
	jz	SHORT fbexit
	cmp	al,' '			;a blank?
	je	SHORT fbexit
	cmp	al,HT			;a tab?
	je	SHORT fbexit
	cmp	al,0			;NUL=end of string
	je	fbexit
	dec	[max_param]
	jnz	find_blank
fbexit:	dec	si
	ret

skip_blanks:
	mov	al,[max_param]
	or	al,al
	jz	sbexit			;limit search to [max_param] chars.
	dec	[max_param]

	seges
	lodsb				;skip blanks.

	jz	SHORT sbexit
	cmp	al,' '
	je	skip_blanks
	cmp	al,HT
	je	skip_blanks
	dec	si
sbexit:	ret




GET_NUMBER ENDP
;------------------------------------------------------------------------------


;Prints a string in the code segment (cs:)


PRINTMSG	PROC	NEAR


	push	ax
	push	bx
	push	cx
	push	dx

         push stdout			;write to std out
         push cs
         push dx			;cs:dx points to message
         push cx			;cx has message length
         push ds
         push offset ds:wlen		;put number of bytes written here
         call DosWrite

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret



PRINTMSG ENDP
;------------------------------------------------------------------------------
;Prints a string in the data segment (ds:)
;
PRINTMSG_DS	PROC	NEAR


	push	ax
	push	bx
	push	cx
	push	dx

         push stdout			;write to std out
         push ds
         push dx			;ds:dx points to message
         push cx			;cx has message length
         push ds
         push offset ds:wlen		;put number of bytes written here
         call DosWrite

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret



PRINTMSG_DS ENDP

;---------------------------------------------------------------------
PRINTCRLF	PROC	NEAR

	mov	dx,offset cs:crlf
	mov	cx,2
	call	printmsg
	ret

PRINTCRLF ENDP
;----------------------------------------------------------------------
;
;Convert driver names to uppercase
;
strupr PROC NEAR

	push	si
	push	cx
	mov	si,0
	mov	cx,8
@@0001:	mov	al,[dev_name0+si]
	sub	al,20h
	cmp	al,'A'
	jc	@@0002
	cmp	al,'Z'+1
	jnc	@@0002
	mov	[dev_name0+si],al
@@0002:	mov	al,[dev_name1+si]
	sub	al,20h
	cmp	al,'A'
	jc	@@0003
	cmp	al,'Z'+1
	jnc	@@0003
	mov	[dev_name1+si],al
@@0003:	inc	si
	loop	@@0001
	pop	cx
	pop	si
	ret

strupr ENDP
;----------------------------------------------------------------------
; Set the A and B driver names from user supplied string in command line
; An "a" or "b" will be appended to the driver name.
; If user name is "pi0" then the A driver will be "pi0a" and B will be "pi0b"
;
;Two independent names can be enter if separated with a $ .
; example: hispeed$lospeed   sets the A side name to "hispeed"
; and the B side to "lospeed" .  "a" or "b" will not be appended.
;
; Enter with es:si pointing to user command line parameters
;
SetDriverName PROC NEAR

	push	bx
	mov	dx,si			;save si in dx
	call	@@Scan			;find $ or blank
	cmp	al,' '
	je	@@OneName
	call	@@TwoNames
	jmp	short @@done
;
@@OneName:
	mov	di, offset ds:dev_name0 ;di -> device name in A driver header
	mov	ah,'A'
	call	@@sdn			;set A side driver name
	mov	di, offset ds:dev_name1 ;di -> device name in B driver header
	mov	ah,'B'
	mov	si,dx			;rewind input pointer
	call	@@sdn			;set B side driver name
;
@@done:	call	strupr			;convert the names to upper case
	call	checksum
	mov	[hdr_cksum],ax		;Since we modified the DD header we must...
					; ...update the checksum
	mov	si,dx			;recover si
@@0001:	cmp	byte ptr es:[si], ' '	;look for a space at end of name
	je	@@0002			;quit when found
	inc	si
	jmp	@@0001
@@0002:	pop	bx
	ret				;exit now with si pointing to next arg
;
;
@@sdn:	mov	cx,7			;length of a driver name -1
@@sdn_0:
	mov	al,byte ptr es:[si]	;get a character from user supplied string
	cmp	al,' '			;is it a space?
	je	@@sdn_1			;yes, done here
	mov	byte ptr[di],al	;else store a character
	inc	si
	inc	di
	loop	@@sdn_0		;loop up to 7 times
	mov	byte ptr[di],ah	;stuff in an "a" or "b" for 8th char
	ret
;
@@sdn_1:
	mov	byte ptr[di],ah	;stuff in an "a" or "b"
	inc	di
	dec	cx
	call	PadWithBlanks
	ret
;
;
@@TwoNames:
	push	bx			;save offset to second name
	mov	cx,8
	mov	di, offset ds:dev_name0 ;di -> device name in A driver header
	mov	bx,0
@@tn0:	mov	al,es:[si+bx]		;get a char from user cmd line to al
	cmp	al,'$'
	je	short @@tn2
	mov	[di],al		;store in DD header
	inc	bx
	inc	di
	loop	@@tn0			;loop up to 8 times
@@tn2:	call	PadWithBlanks
	pop	bx			;recover offset to second name
	inc	bx
	mov	cx,8
	mov	di, offset ds:dev_name1 ;di -> device name in B driver header
@@tn3:	mov	al,es:[si+bx]		;get a char from second name
	cmp	al,' '			;a blank?
	je	short @@tn_done	; yes, quit
	mov	[di],al
	inc	bx
	inc	di
	loop	@@tn3			;up to 8 chars in device name
@@tn_done:
	call	PadWithBlanks
	call	strupr			;convert to upper case
	call	checksum
	mov	[hdr_cksum],ax		;Since we modified the DD header we must...
					; ...update the checksum
	ret
;
;
PadWithBlanks:
	cmp	cx,0
	jle	@@pwb1
@@pwb0:	mov	byte ptr [di],' '
	inc	di
	loop	@@pwb0
@@pwb1:	ret
;
;
@@Scan:	mov	bx,0
@@s_loop:
	mov	al,es:[si+bx]
	cmp	al,'$'
	je	@@s_exit
	cmp	al,' '
	je	@@s_exit
	inc	bx
	jmp	@@s_loop
@@s_exit:
	ret				;[si+bx] point to "$" or space, al has char.

SetDriverName ENDP	

;---------------------------------------------------------------------------

;This sets the nul terminated name string for setting up communication
;with a virtual device driver.

SetAsciizName PROC NEAR

	push	si
	push	di
	push	bx
	push	cx
	lea	di,[chA.cs_PDDName]
	mov	si,offset ds:dev_name0
	call	@@setname
	lea	di,[chB.cs_PDDName]
	mov	si,offset ds:dev_name1
	call	@@setname
	pop	cx
	pop	bx
	pop	di
	pop	si
	ret
;
@@setname:
	mov	cx,9
	mov	bx,0
	mov	al,0
@@0001:	mov	[di+bx],al		;fill with nuls first
	inc	bx
	loop	@@0001
	mov	cx,8
	mov	bx,0
@@0002:	mov	al,[si+bx]		;get char
	cmp	al,' '			;quit if blank
	je 	short @@done
	mov	[di+bx],al		;store it
	inc	bx
	loop	@@0002
@@done:	ret



SetAsciizName ENDP
;---------------------------------------------------------------------------
GET_PARAMS	PROC	NEAR

	les	si,[drv_parms]		;point es:si to parameter string
	mov	cx,80			;max length = 80
	mov	[max_param],cl
parse_param:
	call	find_blank		;find first blank
	cmp	[max_param],0
	je	SHORT no_more
	call	skip_blanks		;scan for first non blank
	cmp	[max_param],0
	je	no_more		;exceeded max length
	call	SetDriverName		;fetch driver name from cmd line
;
	mov	cx,NParms		;load counter with num. of parms
	mov	di,offset ds:ParamStart ;point di to first parameter
pp_loop:
	push	cx			;save counter
	call	get_number		;fetch number from cmd line, store in [di]
	pop	cx			;restore counter
	jc	no_more		;quit if no number found
	add	di,4			;point to next parameter
	loop	pp_loop		;loop til done
no_more:
	ret
;

GET_PARAMS ENDP


;---------------------------------------------------------------------------------

SET_CHAN_STRUCS PROC NEAR


	mov	cx,sizeof_chan_struc
	mov	ax,0
	mov	si,ax
@@clear:						;zero out the cha and chb structures
	mov	byte ptr [si + cha],al
	mov	byte ptr [si + chb],al
	inc	si
	loop	@@clear	

	mov	cx,sizeof_defaults/4
	mov	si,0
@@loop0:						;set A channel defaults
	mov	eax,[si+offset ds:cha_defaults]
	mov	dword ptr [si+offset ds:cha.cs_txdelayparm],eax
	add	si,4
	loop	@@loop0
;
	mov	cx,sizeof_defaults/4
	mov	si,0
@@loop1:						;set B channel defaults
	mov	eax,[si+  offset ds:chb_defaults]
	mov	dword ptr [si + offset ds:chb.cs_txdelayparm],eax
	add	si,4
	loop	@@loop1
;
	mov	ax,[A_speed]	
	mov	[cha.cs_speed],ax
	mov	ax,[B_speed]
	mov	[chb.cs_speed],ax
	mov	ax,[A_clkmode]
	mov	[cha.cs_clkmode],ax
	mov	ax,[B_clkmode]
	mov	[chb.cs_clkmode],ax
	mov	ax,int_no
	mov	[cha.cs_int_no],ax
	mov	[chb.cs_int_no],ax
	mov	ax,[io_addr]
	mov	[cha.cs_io_addr],ax
	mov	[chb.cs_io_addr],ax
	mov	ax,[dma_channel]
	mov	[cha.cs_dma_channel],ax
	mov	[chb.cs_dma_channel],ax
;
	mov	eax,0
	mov	[cha.cs_V86INTENAB],al
	mov	[chb.cs_V86INTENAB],al
	mov	dword ptr[VDDEntryPtr],eax
	mov	word ptr[VDDEntryPtr+4],ax
	;
	mov	ax,-1
	mov	[cha.cs_handle],ax
	mov	[chb.cs_handle],ax
	call	SetAsciizName		;Set driver asciiz name(s)
	ret

SET_CHAN_STRUCS ENDP
;
;---------------------------------------------------------------
;This prints the card type PI or PI2.
;The type is calculated in set_acc_delay at INIT time using the
;ratio of the count rates of the system timer
;and the PI card timer.  The PI2 counts twice as
;fast as the original PI.
;
PrintCardType	PROC NEAR

	call	printcrlf		;new line
	cmp	[PItype],0
	je	short @@3
	mov	dx, offset cs:PI2Msg	;&PI2 string
	mov	cx, PI2MsgSize
	cmp	[PItype],1		;PI is 0,   PI2 is 1
	je	short @@2
@@3:	mov	dx, offset cs:PI1Msg	;&PI string
	mov	cx,PI1MsgSize
@@2:	call	printmsg
	ret

PrintCardType ENDP	
;
;----------------------------------------------------------------

PRINT_PARAMS	PROC	NEAR

;
	call	printcrlf		;new line
	mov	dx,offset cs:A_DriverNameMsg
	mov	cx,InitMsgSize
	call	printmsg
	mov	dx,offset ds:dev_name0
	mov	cx,8
	call	printmsg_ds		;print A driver name
	call	printcrlf
;
	mov	dx,offset cs:B_DriverNameMsg
	mov	cx,InitMsgSize
	call	printmsg
	mov	dx,offset ds:dev_name1
	mov	cx,8
	call	printmsg_ds		;print B driver name
	call	printcrlf
;
	mov	ax,offset cs:InitMsgs	;pointer to param messages
	mov	[MsgPtr],ax
	mov	ax,NMsgs		;number of messages
	mov	[MsgCnt],ax
	mov	ax,offset ds:ParamStart	;point to first parm address
	mov	[ParmPtr],ax
	mov	ax,offset ds:ParmRange	;point to legal range table
	mov	[RangePtr],ax
	mov	[BadValue],0		;assume good parms
p_loop:	mov	dx,[MsgPtr]		;dx -> message
	mov	cx,InitMsgSize		;cx = size
	call	printmsg		;print a param message
	mov	bx,[ParmPtr]
	mov	ax,[bx]
	mov	dx,[bx+2]		;get a parameter number to ax,dx
	push	bx
	cmp	ax,9
	jbe	lt10			;jmp if less than 10
	push	ax
	mov	al,'0'
	call	chrout
	mov	al,'x'			;put optional leading "0x"
	call	chrout
	pop	ax
lt10:	call	dwordout		;print it in hex
	mov	al,' '
	call	chrout
	mov	al,'('
	call	chrout
	mov	ax,[bx]
	mov	dx,[bx+2]
	call	decout			;print it in decimal
	mov	al,')'
	call	chrout
	pop	bx	
;
	mov	ax,[bx]		;param to ax
	mov	si,[RangePtr]		;dx points to low range constant
	cmp	ax, [si]		;check low limit
	jae	ok1			;jump if above or equal - ok
	jmp	SHORT bad_range
ok1:	inc	si
	inc	si			;dx points to high range constant
	cmp	ax, [si]		;check high limit
	jbe	ok2			;jump if below or equal - ok
	jmp	SHORT bad_range
;
ok2:	call	printcrlf		;new line
	add	[MsgPtr],InitMsgSize	;point to next message
	add	[ParmPtr],4		;point to next Parameter
	add	[RangePtr],4		;point to next range value pair
	dec	[MsgCnt]		;count down to zero
	jnz	p_loop
	ret
;
bad_range:
	mov	dx,offset cs:RangeErrMsg
	mov	cx,RangeErrMsgSize
	call	printmsg
	mov	si,[RangePtr]
	mov	ax,[si]		;get low range limit
	mov	dx,0
	push	si
	call	decout			;print it (decout mangles si)
	mov	al,'.'
	call	chrout
	call	chrout
	pop	si			;restore si
	inc	si
	inc	si
	mov	ax,[si]		;get high limit
	mov	dx,0
	call	decout			;print it
	mov	dx,offset cs:DecMsg
	mov	cx,DecMsgSize
	call	printmsg
	mov	[BadValue], 0ffffh	;remember it was invalid
	jmp 	SHORT ok2
;
;
printbyte:				;print byte in al in hex
	push	cx
	push	ax
	mov	cx,-1
	call	 byteout
	pop	ax
	pop	cx
	ret
;
;
printword:
	mov	cx,'0'
	or	ax,ax
	jnz	wordout
	push	ax
	jmp	SHORT outzero
;
;
;dwordout & decout sections Copyright, 1988, 1989, 1990, 1991 Russell Nelson
;
;
dwordout:
	push	ax
	or	ax,dx
	jz	outzero		;if it's zero just print a 0
	pop	ax
	mov	cl,'0'			;prepare to eliminate leading zeroes.
	xchg	ax,dx			;just output 32 bits in hex.
	call	wordout		;output dx.
	xchg	ax,dx
wordout:
	push	ax
	mov	al,ah
	call	byteout
	pop	ax
byteout:
	mov	ah,al
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	digout
	mov	al,ah
digout:
	and	al,0fh
	add	al,90h			;binary digit to ascii hex digit.
	daa
	adc	al,40h
	daa
	cmp	al,cl			;leading zero?
	je	digout_1
	mov	cl,-1			;no more leading zeros.
	jmp	chrout
digout_1:
	ret

outzero:
	pop	ax
	mov	al,'0'
;
chrout:	push	ax
	push	cx
	push	dx

	mov	[chrbuf],al		;store al in buffer
	mov	dx,offset ds:chrbuf	;load dx with buffer address
	mov	cx,1			;1 char to print
	call	printmsg_ds		;print it from buffer

	pop	dx
	pop	cx
	pop	ax
	ret

;Decimal print procedure

decout:
	mov	si,ax			;get the number where we want it.
	mov	di,dx
	or	ax,dx			;is the number zero?
	jne	decout_nonzero
	mov	al,'0'			;yes - easier to just print it, than
	jmp	chrout			;  to eliminate all but the last zero.
decout_nonzero:

	xor	ax,ax			;start with all zeroes in al,bx,bp
	mov	bx,ax
	mov	bp,ax

	mov	cx,32			;32 bits in two 16 bit registers.
decout_1:
	shl	si,1
	rcl	di,1
	xchg	bp,ax
	call	addbit
	xchg	bp,ax
	xchg	bx,ax
	call	addbit
	xchg	bx,ax
	adc	al,al
	daa
	loop	decout_1

	mov	cl,'0'			;prepare to eliminate leading zeroes.
	call	byteout			;output the first two.
	mov	ax,bx			;output the next four
	call	wordout			;output the next four
	mov	ax,bp
	jmp	wordout

addbit:	adc	al,al
	daa
	xchg	al,ah
	adc	al,al
	daa
	xchg	al,ah
	ret


PRINT_PARAMS ENDP
;-----------------------------------------------------------------------


;-----------------------------------------------------------------------
;
;This is the INIT strategy routine.  It's called only once then discarded.
;
A_INIT	PROC	NEAR

		mov	ax,word ptr es:[bx].InitPtr1	;get 1st word of DevHlp routine address
		mov	word ptr device_help,ax	;save it
		mov	ax,word ptr es:[bx].InitPtr1+2	;get 2nd word
		mov	word ptr device_help+2,ax	;save it

		mov	ax,word ptr es:[bx].InitPtr2	;get 1st word of parameters address
		mov	word ptr drv_parms,ax		;save it
		mov	ax,word ptr es:[bx].InitPtr2+2	;get 2nd word
		mov	word ptr drv_parms+2,ax	;save it

		mov	[save_bx],bx			;save bx
		mov	[save_es],es			;save es

		lea	ax,END_OF_CODE
		mov	word ptr es:[bx].InitPtr1, ax	;return end of code offset
		lea	ax,END_OF_DATA
		mov	word ptr es:[bx].InitPtr1+2, ax  ;return end of data offset
		mov	[dataseg_end],ax		;remember it
		xor	ax,ax				;clear ax
		mov	word ptr es:[bx].InitPtr2, ax	;clear 2nd pointer
		mov	word ptr es:[bx].InitPtr2+2, ax	;
		mov	byte ptr es:[bx].InitData1, al	;clear num. logical devices

	
        ;Do initial sign-on message
        ;Init is done at ring three,some of the API's can be safely
        ;called from here
        ;

	push    es
       	push    bx

	mov	dx,offset cs:SignOnMsg	;Print sign on message
	mov	cx,MsgLen
	call	printmsg	
        
        pop     bx
        pop     es

	call	get_params		;get cmd line parameters
	call	print_params		;write 'em to screen, and validate
	mov	ax,[BadValue]
	or	ax,ax
	jnz	init_err		;abort if bad parameter given
	mov	[DmaMemSize],SizeOfDMA
	call	set_chan_strucs	;copy values into A and B channel structures
;
	mov	ax,offset cs:HWIntHandler
	mov	bx,[int_no]		;register hardware interrupt
	mov	dh,0			;hw int not shared
	mov	dl,DH_SetIRQ
	call	[device_help]		;register it now
	jnc	irq_ok			;carry flag set means error
;
	mov	dx,offset cs:IrqErrMsg
	mov	cx,IrqErrMsgSize
	call	printmsg		;Tell user IRQ is no good :-(
	jmp	SHORT init_err
;
irq_ok:
	mov	si,offset ds:chA	; si must be valid
	call	set_acc_delay		;determine CPU speed and PI card type
	cmp	[PItype],0ffffh	;No card present?
	je	init_err		; error if no card.
	call	PrintCardType		;Tell user which PI card he has
;
	call	PI_INIT		;Initialize hardware and buffers...
	push	dx			;Save end-of-ram address
	call	DisablePI		;PI interrupts off
;

	mov	si,offset ds:PDDName	;Get ptr to name VDD will use to access us (ds:si)
	mov	ax,_TEXT		;Get our code selector (Ring 3 because it's INIT time)
	and	al,0fch		;Convert it to ring 0
	mov	es,ax			;Ring 0 selector to es
	mov	di, offset cs:VDDEntry ; PDD entry address for VDD now in es:di 
	mov	dl,DH_RegisterPDD
	call	[device_help]		;Register the our entry point for VDD with OS/2
;
	mov	[chA.cs_OpenCounter],0	;clear OPENs counter
	mov	[chB.cs_OpenCounter],0	
	mov	[chA.cs_watchdog],2000	;
	mov	[chB.cs_watchdog],15000 ;
	mov	eax,0
	mov	al,Vminor
	mov	ah,Vmajor
	mov	dword ptr[chA.cs_Version],eax	;set version numbers
	mov	dword ptr[chB.cs_Version],eax
	mov	bx,[save_bx]		;  ...end of used data area returned in dx
	mov	es,[save_es]		
	pop	dx
	mov	word ptr es:[bx].InitPtr1+2, dx ;tell OS/2 where real end of data is
	mov	[dataseg_end],dx		;remember it
	mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
;
	ret				;** Successful INIT complete **
;
;-----------------------
;
init_err:
	mov	dx,offset cs:InitErrMsg	;Tell user INIT has failed
	mov	cx,ErrMsgLen
	call	printmsg		
;
	mov	bx,[save_bx]
	mov	es,[save_es]
	xor	ax,ax
	mov	word ptr es:[bx].InitPtr1, ax
	mov	word ptr es:[bx].InitPtr1+2,ax  ;clear Pointer1
	mov	word ptr es:[bx].PktStatus,  ERROR_GEN_FAILURE ;tell OS/2 we failed
	ret


A_INIT	ENDP
;---------------------------------------------------------------------------------------------------

B_INIT PROC NEAR

;Assumes the A side was already initialized and dataseg_end was set.


		lea	ax,END_OF_CODE
		mov	word ptr es:[bx].InitPtr1, ax	;return end of code offset
		mov	ax,[dataseg_end]
		mov	word ptr es:[bx].InitPtr1+2, ax  ;return end of data offset
		xor	ax,ax				;clear ax
		mov	word ptr es:[bx].InitPtr2, ax	;clear 2nd pointer
		mov	word ptr es:[bx].InitPtr2+2, ax	;
		mov	byte ptr es:[bx].InitData1, al	;clear num. logical devices
		mov	word ptr es:[bx].PktStatus,  DONE_BIT	;set done bit
		ret					;** Successful INIT complete **


B_INIT ENDP
;
;-----------------------





_TEXT	ENDS

end



