//
// $Header: d:\\32bits\\ext2-os2\\minifsd\\rcs\\fs_read.c,v 1.1 1997/03/15 22:31:04 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsd.h>
#include <fsh.h>

#include <os2/types.h>
#include <os2/os2misc.h>
#include <os2/os2proto.h>
#include <os2/volume.h>
#include <os2/errors.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>


/**********************************************************************************************/
/*** FS_READ() : This is the IFS entry point for the DosRead() system call                  ***/
/**********************************************************************************************/
_FS_RET _FS_ENTRY FS_READ(
                          struct sffsi   *psffsi,
                          union  sffsd   *psffsd,
                          char           *pData,
                          unsigned short *pLen,
                          unsigned short  IOflag
                         )
{
    int     rc, rc2, err;
    struct file        *filp;
    UINT32 BytesRead;
    char          lock[12];
    unsigned long lock_lin;

#ifndef MINIFSD
    if (trace_FS_READ) {
        kernel_printf("FS_READ( len = %d ) pre-invocation",  *pLen);
    }
#endif

    /*
     * Locks the user buffer to check write access and to prevent other threads from freing it
     * behind us when we are sleeping. (this is a long term verify lock)
     */
    if ((rc = LockUserBuffer(pData, *pLen, lock, LOCK_WRITE, &lock_lin)) == NO_ERROR) {
        /*
         * Gets the file structure from psffsd
         */
        if ((filp = psffsd->u.f) != 0) {
#ifdef FS_STRICT_CHECKING
            if (filp->f_magic == FILE_MAGIC) {
#endif
                /* 
                 * Tests if it is a regular file
                 */
                if (S_ISREG(filp->f_inode->i_mode)) {
                    /*
                     * If the file position in psffsi is not consistent with the
                     * one in the file structure in psffsd, something went wrong => panic
                     */
                    if (psffsi->sfi_position == (unsigned long)filp->f_pos) {
                        /*
                         * Now we do the actual read operation
                         */
                        err = VFS_read(filp, pData, (UINT32)*pLen, &BytesRead);
                        *pLen                 = (UINT16)BytesRead;
                        psffsi->sfi_tstamp   |= ST_PREAD;
                        psffsi->sfi_position  = filp->f_pos;
                        rc = err;

                    } else {
                        kernel_printf("FS_READ( %lu ) very weird : psffsi->sfi_position != filp->f_pos : %ld %ld", filp->f_inode->i_ino, psffsi->sfi_position, filp->f_pos);
                        *pLen = 0;
                        rc =  ERROR_READ_FAULT;        // Maybe we should FSH_INTERR ?
                    } /* sfi_position != f_pos */

                } else {
                    kernel_printf("Can't FS_READ( %lu ) - Not a regular file", filp->f_inode->i_ino);
                    *pLen = 0;
                    rc = ERROR_ACCESS_DENIED;
                } /* !S_ISREG */
#ifdef FS_STRICT_CHECKING
            } else {
                ext2_os2_panic(1, "FS_READ - filp with invalid magic nr %0X", filp->f_magic);
            }
#endif
        } else {
            kernel_printf("FS_READ() - filp is NULL");
            rc = ERROR_INVALID_PARAMETER;
        } /* filp = NULL */


        if ((rc2 = VMUnlock(lock_lin)) == NO_ERROR) {
           /* Nothing else to do */
        } else {
            kernel_printf("FS_READ : VMUnlock() returned %d", rc2);
            rc = rc2;
        } /* VMUnlock failed */
    } else {
        kernel_printf("FS_READ : LockUserBuffer() returned %d", rc);
    }


    /*
     * This is the unique return point of FS_READ
     */
#ifndef MINIFSD
    if (trace_FS_READ) {
        kernel_printf("FS_READ( len = %u ) post-inocatio (rc = %d)", *pLen, rc);
    }
#endif
    return rc;

}

