/*
 * $Header$
 */

/*
 * 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
 * access your Linux ext2fs partitions as normal drive letters.
 * Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/
/* REXX script to run e2fsprogs tests on OS/2                         */
/*                                                                    */
/* I wrote it mainly because I couldn't make the shells work properly */
/* with the OS/2 port of bash ... and I found faster to write this    */
/* rexx script rather than debugging the OS/2 version of bash !       */
/*                                                   M. Willm         */
/**********************************************************************/


call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

call SysFileTree 'f_*', test_dirs, DO

'@set TZ=GMT'

success = 0
failed  = 0
skipped.0 = 0

/*
 * Loop on all test case directories
 */
do i=1 to test_dirs.0
    dir = filespec('name', test_dirs.i)
    say 'Test ' dir ':'
    call SysFileTree dir'\script', script, FO
    if script.0 \= 0 then do
        call SysFileTree dir'\os2_script.cmd', script, FO
        if script.0 \= 0 then do      
	    /*
	     * There's a specific script : run it
	     */
	    '@cd ' dir
	    exit_status = os2_script()
	    '@cd ..'
	    if exit_status = 0 then do
		success = success + 1
	    end; else do
		failed = failed + 1
	    end 
        end; else do
            say 'Linux script found but no OS/2 script ... skipping'
    	    skipped.0 = skipped.0 + 1
            gleuh = skipped.0
	    skipped.gleuh = dir
	end
    end; else do
	/*
	 * Extracting image
	 */
	'@gunzip <' dir'\image.gz > ' dir'\test.img'

	/*
	 * First pass 
	 */
        '@..\e2fsck\e2fsck.exe -yf -N test_filesys ' dir'/test.img > 'dir'\out.1.new 2>&1'
        rc1 = rc
        call lineout dir'\out.1.new', "Exit status is" rc1
	call stream dir'\out.1.new', 'C', 'CLOSE'
        '@sed -e "s/..\\e2fsck\\e2fsck.exe/..\/e2fsck\/e2fsck/" -e "1d" 'dir'\out.1.new > 'dir'\out.1'
	'@diff -b 'dir'\out.1 'dir'\expect.1 > NUL 2>&1'
	diff1 = rc
        say 'first  E2FSCK returned ' rc1 '; diff status is ' diff1

	/*
	 * Second pass
 	 */
        '@..\e2fsck\e2fsck -yf -N test_filesys ' dir'/test.img > 'dir'\out.2.new 2>&1'
        rc2 = rc
        call lineout dir'\out.2.new', "Exit status is" rc2
	call stream dir'\out.2.new', 'C', 'CLOSE'
        '@sed -e "s/..\\e2fsck\\e2fsck.exe/..\/e2fsck\/e2fsck/" -e "1d" 'dir'\out.2.new > 'dir'\out.2'
	'@diff -b 'dir'\out.2 'dir'\expect.2 > NUL 2>&1'
	diff2 = rc
        say 'second  E2FSCK returned ' rc2 '; diff status is ' diff2


	'@del 'dir'\test.img'

	/*
	 * We compare both e2fsck return codes and diff outputs
	 */
        if (rc1 = 1) & (rc2 = 0) & (diff1 = 0) & (diff2 = 0) then do
            say 'Success !!!'
            success = success + 1

	    /*
 	     * When success we delete the output files
	     */
   	    '@del 'dir'\out.1.new'
	    '@del 'dir'\out.1'
	    '@del 'dir'\out.2.new'
	    '@del 'dir'\out.2'

        end; else do
            say 'Failed !!!'
            failed = failed + 1

	    /*
 	     * When failure we keep the output files
	     */
        end
    end
     
end

say '======================================'
say 'Passed  : ' success
say 'Failed  : ' failed
say 'Skipped : ' skipped.0

do i = 1 to skipped.0
    say '    ' skipped.i
end
