#define INCL_DOS
#include <drvlib.h>
#include <init.h>
#include "cdsetup.h"


/* *********************************************************** */
/* Hier wird das Code Segment nach der Init-Routine            */
/* abgetrennt                                                  */
/* Ab hier Ring 0 da, basedev                                  */
/* *********************************************************** */

#pragma code_seg("ITEXT");
#pragma data_seg("IDATA","INITDATA");

#define CD_MITSUMI   1
#define CD_SONY      2
#define CD_PANASONIC 3
#define CD_IDE       4
#define CD_NONE      0

#define PORT_320     3
#define PORT_330     1
#define PORT_340     0
#define PORT_360     2

#define IRQ_3        3
#define IRQ_5        1
#define IRQ_7        2
#define IRQ_9        4
#define IRQ_10       5
#define IRQ_11       6
#define IRQ_NONE     0

#define DMA_3        0
#define DMA_5        0
#define DMA_6        1
#define DMA_7        2
#define DMA_NONE     3

#define CfgPort      0x0f8f
#define SndCmd()     outByte((CfgPort),0xe3)

UCHAR detectSoundCard()
{
   UCHAR savedState=0;
   UCHAR readState;
Disable();
   SndCmd();
   savedState=inByte(CfgPort);
Enable();
Disable();
   SndCmd();
   outByte(CfgPort,0);
Enable();
Disable();
   SndCmd();
   readState=inByte(CfgPort);
Enable();
if (readState==2) {
   Disable();
      SndCmd();
      outByte(CfgPort,savedState);
   Enable();
   return 0;
}
return 1;
}

void Type(USHORT type)
{
   UCHAR cfg;
Disable();
   SndCmd();
   cfg=inByte(CfgPort-2);
Enable();
cfg &= 0xf1;
switch (type) {
   case CD_MITSUMI:
      cfg |= 4;
      break;
   case CD_SONY:
      cfg |= 2;
      break;
   case CD_PANASONIC:
      cfg |= 6;
      break;
   case CD_IDE:
      {
         UCHAR ideCfg;
      cfg |=8;
      Disable();
         SndCmd();
         ideCfg=inByte(CfgPort-2); // 0xf8e
      Enable();
         ideCfg &= 0x20;
         ideCfg |= 0x03;
      Disable();
         SndCmd();
         outByte(CfgPort-2,ideCfg);
      Enable();
      }
      break;
}
Disable();
   SndCmd();
   outByte(CfgPort-2,cfg);
Enable();
Disable();
   SndCmd();
   outByte(0xF91,0x80);
Enable();
}

void Port(USHORT t)
{
   UCHAR cfg;
Disable();
   SndCmd();
   cfg=inByte(CfgPort-1);
Enable();
cfg &=0x3f;
switch (t) {
   case PORT_320:
      cfg |= 0xc0;
      break;
   case PORT_330:
      cfg |= 0x40;
   case PORT_340:
      break;
   case PORT_360:
      cfg |= 0x80;
      break;
   default:
      break;
}
Disable();
   SndCmd();
   outByte(CfgPort-1,cfg);
Enable();
}


void Irq(USHORT t)
{
   UCHAR cfg;
Disable();
   SndCmd();
   cfg=inByte(CfgPort-1);
Enable();
cfg &= 0xe3;
switch (t) {
   case IRQ_3:
      cfg |= 0x0C;
      break;
   case IRQ_5:
      cfg |= 0x04;
      break;
   case IRQ_7:
      cfg |= 0x08;
      break;
   case IRQ_9:
      cfg |= 0x10;
      break;
   case IRQ_10:
      cfg |= 0x14;
      break;
   case IRQ_11:
      cfg |= 0x18;
      break;
   case IRQ_NONE:
   default:
      break;
}
Disable();
   SndCmd();
   outByte(CfgPort-1,cfg);
Enable();
}

void Dma(USHORT t)
{
   UCHAR cfg;
Disable();
   SndCmd();
   cfg=inByte(CfgPort-1);
Enable();
cfg &= 0xfc;
cfg |=(UCHAR)t;
Disable();
   SndCmd();
   outByte(CfgPort-1,cfg);
Enable();
}


USHORT CDInit(PREQPACKET rp)
{
   PDDD_Parm_List pList;
   PCHAR p;
   UCHAR d;
   UCHAR cdType=CD_NONE;
   UCHAR portCode=0;
   UCHAR irqCode=IRQ_NONE;
   UCHAR dmaCode=DMA_NONE;

   USHORT cdPort=0;
   USHORT irqNr=0;
   USHORT dmaNr=0;
DevHlp=(ULONG)rp->s.Init.DevHlp;  // DevHlp-entry
// Kommandozeilen-parameter
pList=(PDDD_Parm_List)rp->s.Init.args;
p=MAKEP(SELECTOROF(pList),pList->cmd_line_args);
while ((d=getOption(p,&p))!=0) {
   switch (d) {
      case 'T':
      case 't':
         if (*p==':') p++;
         switch (*p) {
         case 'M':
         case 'm':
            cdType=CD_MITSUMI;
            break;
         case 's':
         case 'S':
            cdType=CD_SONY;
            break;
         case 'P':
         case 'p':
            cdType=CD_PANASONIC;
            break;
         case 'I':
         case 'i':
            cdType=CD_IDE;
            break;
         default: 
            cdType=CD_NONE;
           break;
         } /* endswitch */
         break;
      case 'P':
      case 'p':
         if (*p==':') p++;
         cdPort=strtoul(p,&p,0);
         switch (cdPort) {
            case 0x320:
               portCode=PORT_320;
               break;
            case 0x330:
               portCode=PORT_330;
               break;
            case 0x340:
               portCode=PORT_340;
               break;
            case 360:
               portCode=PORT_360;
               break;
            default: 
               cdType=CD_NONE;
               break;
         } /* endswitch */
         break;
      case 'I':
      case 'i':
         if (*p==':') p++;
         irqNr=strtoul(p,&p,0);
         switch (irqNr) {
         case 3:
            irqCode=IRQ_3;
            break;
         case 5:
            irqCode=IRQ_5;
            break;
         case 7:
            irqCode=IRQ_7;
            break;
         case 9:
            irqCode=IRQ_9;
            break;
         case 10:
            irqCode=IRQ_10;
            break;
         case 11:
            irqCode=IRQ_11;
            break;
         default: 
            irqCode=IRQ_NONE;
           break;
         } /* endswitch */
         break;
      case 'D':
      case 'd':
         if (*p==':') p++;
         dmaNr=strtoul(p,&p,0);
         switch (dmaNr) {
         case 3:
            dmaCode=DMA_3;
            break;
         case 5:
            dmaCode=DMA_5;
            break;
         case 7:
            dmaCode=DMA_7;
            break;
         default: 
            dmaCode=DMA_NONE;
           break;
         } /* endswitch */
         break;
   }
} /* endwhile */
if (cdType==CD_PANASONIC || cdType==CD_SONY) {
   dmaCode=DMA_NONE;
   irqCode=IRQ_NONE;
} /* endif */
do {
   if (cdType==CD_NONE) break;
   if (detectSoundCard()) break;
   Type(cdType);
   if (cdType==CD_IDE) break;
   Port(portCode);
   Irq(irqCode);
   Dma(dmaCode);
} while ( 0 ); /* enddo */
rp->s.InitExit.finalCS=0;
rp->s.InitExit.finalDS=0;
rp->s.InitExit.units='\0';
return (RPDONE | RPERR | I24_QUIET_INIT_FAIL);
}


