
#*------------------------------------------------------------------*
#*                                                                  *
#*  Video Toolkit For OS/2 Version 1.0                              *
#*  Example Application No. 1                                       *
#*  Written by Stephen Sloan and Tony Hicketts.                     *
#*  Date : 22/02/95.                                                *
#*  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995.   *
#*                                                                  *
#*  Filename : ex1.inc                                              *
#*                                                                  *
#*------------------------------------------------------------------*/

.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .asm .hlp .itl .ipf

#===================================================================
# Compile switches  that are enabled
# /c      compile don't link
# /Gm+    use the multi-threaded libraries
# /ss     allow  "//" for comment lines
# /Mp     use the _optlink calling convention as the default
# /Se     allow C Set/2  extensions
# /Ti+    generate debugging information
# /Tm+    enable debug memory management support
# /W3     output all messages generated by compiler
# /G4     generate code to optimize its use on an 80486 processor
# /Gs-    stack probes are in the generated code
# /Wpro   produce diagnostic messages about unprototyped functions
#

# debug
CC      = icc /c /Ti+ /Tm+ /Se /Re /ss /Mp /Gm+ /W3 /G4 /Gs- /Wpro /DINCL_32
# no debug
#CC      = icc /c /Ti- /Tm- /Se /Re /ss /Mp /Gm+ /W3 /G4 /Gs- /Wpro

AFLAGS  = /Mx -t -z
ASM     = ml /c /Zm

# debug
LFLAGS  = /NOD /DEBUG /DOSSEG /ALIGN:4 /EXEPACK /M /BASE:0x10000 /NOI
# no debug
#LFLAGS  = /NOD /DOSSEG /ALIGN:4 /EXEPACK /M /BASE:0x10000 /NOI

LINK    = LINK386  $(LFLAGS)
LIBS    = DDE4MBS + OS2386
STLIBS  = DDE4SBS + OS2386
MTLIBS  = DDE4MBS + os2386
DLLLIBS = DDE4NBS + os2386
VLIBS   = DDE4SBS + vdh + os2386

.c.lst:
    $(CC) -Fc$*.lst -Fo$*.obj $*.c

.c.obj:
    $(CC) -Fo$*.obj $*.c

.asm.obj:
    $(ASM)   $*.asm

.ipf.hlp:
        ipfc $*.ipf /W3

.itl.hlp:
        cc  -P $*.itl
        ipfc $*.i
        del $*.i

.rc.res:
        rc -r $*.rc
