#ifndef _WTV_H
#define _WTV_H

#define WTV_NAME        ("WinCast TV (c) ASL, 1996-97 UK")

#define ID_MAINWND      (256)

#define IDD_NOTE        (500)
#define IDD_NOTE_BOOK   (IDD_NOTE + 1)

/* Here are the menus and there options                                     */
#define ID_FILE         (ID_MAINWND+1)      /* File menu                    */
#define ID_FILE_EXIT    (ID_FILE+1)         /* File menu ... exit           */
#define ID_NEWTEXT      (ID_FILE+2)        

#define ID_TV           (ID_FILE_EXIT+1)    /* TV menu                      */
#define ID_TV_SETUP     (ID_TV+1)           /* Setup the TV                 */
#define ID_TV_CONNECT   (ID_TV+2)           /* Connector menu               */

#define ID_TV_CON1      (ID_TV_CONNECT+1)   /* TV menu ... connector 1      */
#define ID_TV_CON2      (ID_TV_CONNECT+2)   /* TV menu ... connector 2      */
#define ID_TV_RF        (ID_TV_CONNECT+3)   /* TV menu ... rf connector     */
#define ID_TV_SVHS      (ID_TV_CONNECT+4)   /* TV menu ... svhs connector   */
#define ID_TV_TEST      (ID_TV_CONNECT+5)   /* TV menu ... testcard         */

#define BASE_CONNECTOR  (ID_TV_CON1)        /* The default connector        */

typedef struct
{
    BOOL    win_bliting;        /* Is the bliting thread running?           */
    BOOL    win_blit_halt;      /* Halt the bliting thread?                 */
    TID     win_blit_tid;       /* Thread ID for the bliting routine        */

    HWND    win_hwnd_frame;     /* Frame window handle                      */
    HWND    win_hwnd_client;    /* Client window handle                     */

    LONG    win_cxWidthWindow;  /* Size of width of frame window            */
    LONG    win_cyHeightWindow; /* Size of height of frame window           */
    LONG    win_cxWidthBorder;  /* Size of width of vertical border         */
    LONG    win_cyWidthBorder;  /* Size of width of horizontal border       */
    LONG    win_cyTitleBar;     /* Size of title bar                        */
    LONG    win_cyMenu;         /* Size of menu                             */
    LONG    win_cxWindowPos;    /* X position of frame window               */
    LONG    win_cyWindowPos;    /* Y position of frmae window               */

    char    win_vcai_name[15];  /* Device name to use                       */
    USHORT  win_vcai_no;        /* Device number to use                     */
    USHORT  win_vcai_connector; /* Connector number to use                  */

    HDIVE           win_dive_handle;    /* DIVE display device handle       */
    DRIVERHANDLE    win_vcai_handle;    /* VCAI capture device handle       */

    RECTL  win_rcls[50];        /* Visible region rectangles                */
    ULONG  win_rcl_cnt;         /* Number of visible region rectangles      */
    SWP    win_swp;             /* Standard window position structure       */

    ULONG   win_sizebytes;      /* Number of bytes per pel                  */
    ULONG   win_width;          /* Image dimensions                         */
    ULONG   win_height;

    ULONG   win_dive_width;
    ULONG   win_dive_height;
} WINDATA, *PWINDATA;

typedef struct _MOUSEPOS
{
    LONG mp_x;
    LONG mp_y;
} MOUSEPOS, FAR *PMOUSEPOS;

/* Functions defined in the source code of this program                     */
VOID APIENTRY    DiveTV (ULONG data_addr);
MRESULT EXPENTRY TVWindowProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY NotebookDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#endif
