//#define DEBUG
#define VCAI_ENABLED
#define DIVE_ENABLED
#define VCAI_MONITOR

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_GPI
#define INCL_WIN
#define INCL_32

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define  _MEERROR_H_
#include <mmioos2.h>                   /* It is from MMPM toolkit           */
#include <dive.h>
#include <fourcc.h>
#include <vcadd.h>
#include <vcai.h>

#include "dive.h"
#include "pmtv2rem.h"

PWINDATA DiveSetup (char *name, USHORT instance, USHORT connector);
int DiveRegister (HAB hab);
int DiveStop (void);

/* Information about the system                                             */
PFN             InsertAddr;                 /* Function for inserting?      */
static PSZ      InsertName = "InsertPage";  /* Function name                */
static HMODULE  HmodInsert;                 /* Module handle                */

static  PSZ     RemoteName = "RemoteDlgProc";   /* Remote control           */
static  PFN     RemoteAddr;
static  HMODULE HmodRemote;

static HWND     HwndRemote;         /* Remote control window hanle          */
// static BOOL     RemoteOpen = FALSE;
// extern BOOL     RemOpen;

/* This is the main function of the WinCast TV application.                 */
int main (int argc, char *argv[])
{
HAB     hab;                /* Something....                                */
HMQ     hmq;                /* Message queue handle                         */
QMSG    qmsg;               /* Message from message queue                   */
ULONG   rc;
PSZ     pmmbase, env = "MMBASE";    /* Multimedia base directory            */
char    mod_txt[256], txt[256], *p;
ULONG   connector = 0;
DRIVERHANDLE vhandle;
PWINDATA wtv_datap;


    /* Initialise the PM and create the message queue                       */
    hab = WinInitialize (0);
    hmq = WinCreateMsgQueue (hab, 0);

    /* Check the arguments and exit if necessary                            */
    if ((argc < 3) || (argc > 4))
    {
        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)"Usage: WTV <name> <number> <connector>",
                       (PSZ)WTV_NAME,
                       0, MB_OK | MB_INFORMATION);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }
    if (argc == 4)
        connector = (USHORT)atoi (argv[3]);

    wtv_datap = DiveSetup (argv[1], atoi(argv[2]), connector);
    if (!wtv_datap)
    {
        sprintf (txt, "Unable to setup DIVE");
        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       txt,
                       (PSZ)WTV_NAME,
                       0, MB_OK | MB_INFORMATION);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }


    /* Load the setup dialog DLL from the MMOS directory                    */
    if ((rc = DosScanEnv (env, &pmmbase)) != 0)
    {
        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)"Unable to locate the multimedia information",
                       (PSZ)WTV_NAME,
                       0, MB_OK | MB_INFORMATION);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }

#ifdef DEBUG
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP, (PSZ)pmmbase, (PSZ)WTV_NAME,
                   0, MB_OK | MB_INFORMATION);
#endif

    if (p = strstr (pmmbase, ";"))
        *p = '\0';

    sprintf (mod_txt, "%s\\DLL\\%5.5sNB.DLL", pmmbase, argv[1]);
    if ((rc = DosLoadModule (txt, sizeof (txt), mod_txt, &HmodInsert)) != 0)
    {
        sprintf (txt, "DosLoadModule <%s> - %ld", mod_txt, rc);

        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)txt, (PSZ)WTV_NAME, 0, MB_OK | MB_ERROR);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }

    if ((rc = DosQueryProcAddr (HmodInsert, 0L, InsertName, &InsertAddr)) != 0)
    {
        sprintf (txt, "DosQueryProcAddr (InsertPage) - %ld", rc);

        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)txt, (PSZ)WTV_NAME, 0, MB_OK | MB_ERROR);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }

    /* Now load the remote control into the program                         */
    sprintf (mod_txt, "%s\\DLL\\PMTV2REM.DLL", pmmbase);
    if ((rc = DosLoadModule (txt, sizeof (txt), mod_txt, &HmodRemote)) != 0)
    {
        sprintf (txt, "DosLoadModule (PMTV2REM.DLL) - %ld", rc);

        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)txt, (PSZ)WTV_NAME, 0, MB_OK | MB_INFORMATION);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }

    if ((rc = DosQueryProcAddr (HmodRemote, 0L, RemoteName, &RemoteAddr)) != 0)
    {
        sprintf (txt, "DosQueryProcAddr (RemoteDlgProc) - %ld", rc);

        WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                       (PSZ)txt, (PSZ)WTV_NAME, 0, MB_OK | MB_INFORMATION);

        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        return 1;
    }

    if (DiveRegister (hab) == FALSE)
    {
        WinDestroyMsgQueue (hmq);
        WinTerminate (hab);
        DosExit (EXIT_PROCESS, 1);
        return 1;
    }

    /* While there are still messages, dispatch them.                       */
    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
        WinDispatchMsg (hab, &qmsg);

#ifdef DEBUG
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
                   (PSZ)"Application closing down",
                   (PSZ)WTV_NAME, 0, MB_OK | MB_INFORMATION);
#endif

    DiveStop ();

    /* Process for termination                                              */
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    DosExit (EXIT_PROCESS, 0);
    return 0;
}


void remote_open (MOUSEPOS mousepos)
{
       /* if (RemOpen)    */
       /*     return;     */
        HwndRemote = WinLoadDlg (HWND_DESKTOP, HWND_DESKTOP, (PFNWP)RemoteAddr,
                                 HmodRemote, IDD_REM, (PVOID)&mousepos);
}
