program patch_pcmcia;

//  0  1  2  3  4  5  6  7  8  9 10
// 50 8B C7 80 CC 03 88 64 50 58
// 50 8B C7 80 E4 03 88 64 50 58

uses
  Dos,
  Objects,
  Strings,
  VpSysLow;

const
  b_e4          :byte=$e4;

var
  d             :file;
  dn,dnbak,
  path,nam,ext  :string;
  p             :pByteArray;
  g,i           :longint;
  anzahl        :longint=0;
  anzahl_gut    :longint=0;
  rc            :longint;

begin

  (* help *)

  dn:=ParamStr(1);
  if (dn='/?') or (ParamCount>1) then
    begin
      WriteLn('Correct pcmcia.sys to work with CardBus cards.');
      WriteLn('  PPcmcia [ X:\OS2\PCMCIA.SYS ]');
      Halt(255);
    end;


  (* locate file *)

  if dn='' then
    dn:=SysGetBootDrive+':\OS2\PCMCIA.SYS';
  Assign(d,dn);
  {$I-}
  Reset(d,1);
  {$I+}
  if IOResult<>0 then
    begin
      dn:=SysGetBootDrive+':\OS2\BOOT\PCMCIA.SYS';
      Assign(d,dn);
      {$I-}
      Reset(d,1);
      {$I+}
      rc:=IOResult;
      if rc<>0 then
        begin
          WriteLn('Can not find PCMCIA.SYS on the boot drive.');
          Halt(rc);
        end;
    end;
  Close(d);


  (* backup *)

  FSplit(dn,path,nam,ext);
  dnbak:=path+nam+'.org';

  if SysFileCopy(@(dn+#0)[1],@(dnbak+#0)[1],false) then
    WriteLn('backup file ',dnbak,' created.');


  (* patch *)
  Assign(d,dn);
  Reset(d,1);
  g:=FileSize(d);
  GetMem(p,g);
  BlockRead(d,p^,g);

  for i:=0 to g-10 do
    if (p^[i]=$50) then
      begin
        if StrLComp(@p^[i],#$50#$8B#$C7#$80#$CC#$03#$88#$64#$50#$58,10)=0 then
          begin
            Seek(d,i+4);
            BlockWrite(d,b_e4,1);
            Inc(anzahl);
          end
        else if StrLComp(@p^[i],#$50#$8B#$C7#$80#$E4#$03#$88#$64#$50#$58,10)=0 then
          Inc(anzahl_gut);
      end;

  Close(d);
  WriteLn(anzahl,' bytes changed.');
  if anzahl_gut>0 then
    WriteLn(anzahl_gut,' places were ok.');
end.
