; P6K7MTRR.asm - Intel P6 / AMD K7 MTRRs management IOCtl PDD, ver.0.06a
;   Copyright (c) 1999-2001 Takayuki 'January June' Suwa
;
; This library is free software; you can redistribute it and/or
; modify it under the terms of the GNU Library General Public
; License as published by the Free Software Foundation; either
; version 2 of the License, or (at your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; Library General Public License for more details.
;
; You should have received a copy of the GNU Library General Public
; License along with this library; if not, write to the
; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
; Boston, MA 02111-1307, USA.


  .686p


;
; DevHlp_Save_Message
;
DevHlp_Save_Message  equ  61
MSG_REPLACEMENT_STRING  equ  1178
MsgTable  struc
MsgID     dw  ?
NumItem   dw  ?
PtrItem   dd  ?
MsgTable  ends

;
; PDD packet header
;
PacketHeader     struc
PacketLength     db  ?
BlockDeviceUnit  db  ?
CommandCode      db  ?
PacketStatus     dw  ?
                 dd  ?
QueueLinkage     dd  ?
PacketHeader     ends

;
; PDD INIT command
;
HeaderINITin  struc
Header        PacketHeader  <>
              db  ?
DevHlpEntry   dd  ?
ArgumentPtr   dd  ?
FirstUnit     db  ?
HeaderINITin  ends
HeaderINITout  struc
Header         PacketHeader  <>
UnitNumber     db  ?
EndResCode     dw  ?
EndResData     dw  ?
BPBArray       dd  ?
               db  ?
HeaderINITout  ends

;
; PDD IOCTL command
;
HeaderIOCTL      struc
Header           PacketHeader  <>
Category         db  ?
Function         db  ?
ParameterPtr     dd  ?
DataPtr          dd  ?
SystemFileNum    dw  ?
ParameterLength  dw  ?
DataLength       dw  ?
HeaderIOCTL      ends

;
; PDD resident data segment
;
data_res  segment  public word use16 "DATA"
data_res  ends

;
; PDD resident code segment
;
code_res  segment  public word use16 "CODE"
code_res  ends

;
; PDD segment groups
;
DGROUP  group  data_res
CGROUP  group  code_res

;

;
; P6/K7 MSR indices
;
MSR_MTRRcap           equ  254
MSR_MTRRphysBase      equ  512
MSR_MTRRphysMask      equ  513
MSR_MTRRfix64K_00000  equ  592
MSR_MTRRfix16K_80000  equ  600
MSR_MTRRfix16K_A0000  equ  601
MSR_MTRRfix4K_C0000   equ  616
MSR_MTRRfix4K_C8000   equ  617
MSR_MTRRfix4K_D0000   equ  618
MSR_MTRRfix4K_D8000   equ  619
MSR_MTRRfix4K_E0000   equ  620
MSR_MTRRfix4K_E8000   equ  621
MSR_MTRRfix4K_F0000   equ  622
MSR_MTRRfix4K_F8000   equ  623
MSR_MTRRdefType       equ  767

;

;
; IOCtl category & functions
;
  public  IOCTL_P6K7MTRR
IOCTL_P6K7MTRR                 equ  0c4h
  public  P6K7MTRR_QRYMTRRCAP
P6K7MTRR_QRYMTRRCAP            equ  60h
  public  P6K7MTRR_QRYMTRRDEFTYPE
P6K7MTRR_QRYMTRRDEFTYPE        equ  61h
  public  P6K7MTRR_QRYMTRRFIXEDRANGE
P6K7MTRR_QRYMTRRFIXEDRANGE     equ  62h
  public  P6K7MTRR_QRYMTRRVARIABLERANGE
P6K7MTRR_QRYMTRRVARIABLERANGE  equ  63h
  public  P6K7MTRR_SETMTRR2DEFAULT
P6K7MTRR_SETMTRR2DEFAULT       equ  40h
  public  P6K7MTRR_SETMTRRDEFTYPE
P6K7MTRR_SETMTRRDEFTYPE        equ  41h
  public  P6K7MTRR_SETMTRRFIXEDRANGE
P6K7MTRR_SETMTRRFIXEDRANGE     equ  42h
  public  P6K7MTRR_SETMTRRVARIABLERANGE
P6K7MTRR_SETMTRRVARIABLERANGE  equ  43h

; P6K7MTRR_QRYMTRRCAP
data_MTRRCAP  struc
cap           dq  ?
data_MTRRCAP  ends

; P6K7MTRR_QRYMTRRDEFTYPE / P6K7MTRR_SETMTRRDEFTYPE
data_MTRRDEFTYPE  struc
deftype           dq  ?
data_MTRRDEFTYPE  ends

; P6K7MTRR_QRYMTRRFIXEDRANGE / P6K7MTRR_SETMTRRFIXEDRANGE
data_MTRRFIXEDRANGE  struc
r_00000_64k          dq  ?
r_80000_16k          dq  ?
r_a0000_16k          dq  ?
r_c0000_4k           dq  ?
r_c8000_4k           dq  ?
r_d0000_4k           dq  ?
r_d8000_4k           dq  ?
r_e0000_4k           dq  ?
r_e8000_4k           dq  ?
r_f0000_4k           dq  ?
r_f8000_4k           dq  ?
data_MTRRFIXEDRANGE  ends

; P6K7MTRR_QRYMTRRVARIABLERANGE / P6K7MTRR_SETMTRRVARIABLERANGE
parm_MTRRVARIABLERANGE  struc
idx                     db  ?
parm_MTRRVARIABLERANGE  ends
data_MTRRVARIABLERANGE  struc
r_base                  dq  ?
r_mask                  dq  ?
data_MTRRVARIABLERANGE  ends

;

;
; contents of data_res
;
data_res  segment

; PDD header
  dd  -1                            ; far pointer to next device header
  dw  1000000110000000b             ; device attribute
;     CIISO LE    CNSK                CHR, level=3
;     HDBHP  VE   LUCB
;     RCMRN   L   KLRD
  dw  offset entry_Strategy  ; 16bit offset to strategy routine
  dw  0                             ; 16bit offset to IDC entry point
  db  "P6MTRR$ "                    ; driver name
  db  8 dup(0)
  dd  10011b                        ; capabilities bit strip

; copy of BIOS default P6/K7 MTRR settings
  public  default_MTRRcaps
default_MTRRcaps           data_MTRRCAP  <>
  public  default_MTRRdeftype
default_MTRRdeftype        data_MTRRDEFTYPE  <>
  public  default_MTRRfixedrange
default_MTRRfixedrange     data_MTRRFIXEDRANGE  <>
  public  default_MTRRvariablerange
default_MTRRvariablerange  data_MTRRVARIABLERANGE  32 dup(<>)

; end of data_res residence
  public  last_data_res
last_data_res  label  byte

; argument switch flags
; bit 0 : quiet, no messages (include errors)
  public  switch_flags
switch_flags  dw  0

; CPUID vender ID strings
  public  CPUID_GenuineIntel
CPUID_GenuineIntel  db  "GenuineIntel"
  public  CPUID_AuthenticAMD
CPUID_AuthenticAMD  db  "AuthenticAMD"

; message strings
  public  string_Title
string_Title         db  1bh, "[1m", 0dh
                     db  "P6K7MTRR.sys - Intel P6 / AMD K7 MTRRs management IOCtl PDD, ver.0.06a", 0dh, 0ah
                     db  "Copyright (c) 1999-2001 Takayuki 'January June' Suwa"
                     db  0
  public  string_NotInstalled
string_NotInstalled  db  1bh, "[31m", 0dh
                     db  "Intel P6 / AMD K7 MTRR feature is NOT found. The driver has been ignored.", 0dh
                     db  1bh, "[0m"
                     db  0
  public  string_InstalledP6
string_InstalledP6   db  1bh, "[36m", 0dh
                     db  "Intel P6 MTRR feature is found. The driver has been installed.", 0dh
                     db  1bh, "[0m"
                     db  0
  public  string_InstalledK7
string_InstalledK7   db  1bh, "[36m", 0dh
                     db  "AMD K7 MTRR feature is found. The driver has been installed.", 0dh
                     db  1bh, "[0m"
                     db  0

; message tables
  public  msg_Title
msg_Title         MsgTable  <MSG_REPLACEMENT_STRING, 1, string_Title>
  public  msg_NotInstalled
msg_NotInstalled  MsgTable  <MSG_REPLACEMENT_STRING, 1, string_NotInstalled>
  public  msg_InstalledP6
msg_InstalledP6   MsgTable  <MSG_REPLACEMENT_STRING, 1, string_InstalledP6>
  public  msg_InstalledK7
msg_InstalledK7   MsgTable  <MSG_REPLACEMENT_STRING, 1, string_InstalledK7>

data_res  ends

;

;
_add  macro  reg, additive
      if  (additive) eq 1
      inc  reg
      else
      add  reg, additive
      endif
      endm

;
; contents of code_res
;
code_res  segment
  assume  cs:CGROUP, ds:DGROUP, es:nothing, ss:nothing, fs:nothing, gs:nothing

;  called before MTRR change
  public  pre_MTRRchange
pre_MTRRchange  proc  near
  cli                        ; disable maskable interrupts
  mov  eax, cr0              ; disable caching
  or  eax, 1 shl 30
  mov  cr0, eax
  wbinvd                     ; flush all cache contents
  mov  eax, cr3              ; flush all TLBs
  mov  cr3, eax
  mov  ecx, MSR_MTRRdefType  ; disable MTRR feature
  rdmsr
;  and  eax, not (1 shl 11)
  and  ax, not (1 shl 11)
  wrmsr
  ret
pre_MTRRchange  endp

;  called after MTRR change
  public  post_MTRRchange
post_MTRRchange  proc  near
  wbinvd                     ; flush all cache contents
  mov  eax, cr3              ; flush all TLBs
  mov  cr3, eax
  mov  ecx, MSR_MTRRdefType  ; enable MTRR feature
  rdmsr
;  or  eax, 1 shl 11
  or  ax, 1 shl 11
  wrmsr
  mov  eax, cr0              ; enable caching
  and  eax, not (1 shl 30)
  mov  cr0, eax
  sti                        ; enable maskable interrupts
  ret
post_MTRRchange  endp

; MTRR memory type checker
  public  check_MemType
check_MemType  proc  near
  or  al, al       ; UC
  jz  short check_MemType_0
  cmp  al, 1       ; WC
  je  short check_MemType_0
  cmp  al, 4       ; WT
  je  short check_MemType_0
  cmp  al, 5       ; WP
  je  short check_MemType_0
  cmp  al, 6       ; WB
check_MemType_0:
  ret
check_MemType  endp

; query MTRR fixed range
  public  query_MTRRFixedRange
query_MTRRFixedRange  proc  near
  mov  ecx, MSR_MTRRfix64K_00000
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix16K_80000 - MSR_MTRRfix64K_00000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix16K_A0000 - MSR_MTRRfix16K_80000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_C0000 - MSR_MTRRfix16K_A0000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_C8000 - MSR_MTRRfix4K_C0000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_D0000 - MSR_MTRRfix4K_C8000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_D8000 - MSR_MTRRfix4K_D0000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_E0000 - MSR_MTRRfix4K_D8000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_E8000 - MSR_MTRRfix4K_E0000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_F0000 - MSR_MTRRfix4K_E8000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRfix4K_F8000 - MSR_MTRRfix4K_F0000>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  ret
query_MTRRFixedRange  endp

; set MTRR fixed range
  public  set_MTRRFixedRange
set_MTRRFixedRange  proc  near
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_00000_64k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_00000_64k][4]
  mov  ecx, MSR_MTRRfix64K_00000
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_80000_16k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_80000_16k][4]
  _add  cx, <MSR_MTRRfix16K_80000 - MSR_MTRRfix64K_00000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_a0000_16k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_a0000_16k][4]
  _add  cx, <MSR_MTRRfix16K_A0000 - MSR_MTRRfix16K_80000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_c0000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_c0000_4k][4]
  _add  cx, <MSR_MTRRfix4K_C0000 - MSR_MTRRfix16K_A0000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_c8000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_c8000_4k][4]
  _add  cx, <MSR_MTRRfix4K_C8000 - MSR_MTRRfix4K_C0000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_d0000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_d0000_4k][4]
  _add  cx, <MSR_MTRRfix4K_D0000 - MSR_MTRRfix4K_C8000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_d8000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_d8000_4k][4]
  _add  cx, <MSR_MTRRfix4K_D8000 - MSR_MTRRfix4K_D0000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_e0000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_e0000_4k][4]
  _add  cx, <MSR_MTRRfix4K_E0000 - MSR_MTRRfix4K_D8000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_e8000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_e8000_4k][4]
  _add  cx, <MSR_MTRRfix4K_E8000 - MSR_MTRRfix4K_E0000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_f0000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_f0000_4k][4]
  _add  cx, <MSR_MTRRfix4K_F0000 - MSR_MTRRfix4K_E8000>
  wrmsr
  mov  eax, dword ptr [si][data_MTRRFIXEDRANGE.r_f8000_4k][0]
  mov  edx, dword ptr [si][data_MTRRFIXEDRANGE.r_f8000_4k][4]
  _add  cx, <MSR_MTRRfix4K_F8000 - MSR_MTRRfix4K_F0000>
  wrmsr
  ret
set_MTRRFixedRange  endp

; strategy entry
  public  entry_Strategy
entry_Strategy  proc  far
  push  bx  ; move bx value to bp
  pop  bp   ;   to reserve general purpose
  push  es  ; move es value to gs
  pop  gs   ;   to reserve string operations
            ; do not modify gs:bp
  mov  al, gs:[bp][PacketHeader.CommandCode]
  or  al, al             ; INIT
  je  near ptr cmd_INIT
  cmp  al, 16            ; IOCTL
  je  short cmd_IOCTL
  cmp  al, 28            ; SHUTDOWN
  je  short exit_Done
  cmp  al, 31            ; INITCOMPLETE
  je  short cmd_INITCOMPLETE
;
  public  exit_UnknownCommand
exit_UnknownCommand  label near
  mov  ax, 8103h  ; unknown command
  jmp  short exit_Error
;
  public  exit_Invalid
exit_Invalid  label near
  mov  ax, 8113h  ; invalid parameter
;
  public  exit_Error
exit_Error  label near
  mov  gs:[bp][PacketHeader.PacketStatus], ax
  stc
  ret
;
  public  cmd_INITCOMPLETE
cmd_INITCOMPLETE  label near
  mov  di, offset default_MTRRcaps
  push  ds
  pop  es
  mov  ecx, MSR_MTRRcap
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  mov  cx, MSR_MTRRdefType
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  call  query_MTRRFixedRange
  movzx  bx, byte ptr default_MTRRcaps[data_MTRRCAP.cap][0]
  mov  cx, MSR_MTRRphysBase
cmd_INITCOMPLETE_1:
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  dec  bx
  jnz  short cmd_INITCOMPLETE_1
;
  public  exit_Done
exit_Done  label near
  mov  gs:[bp][PacketHeader.PacketStatus], 100h
  clc
  ret
entry_Strategy  endp

; IOCTL routine
  public  cmd_IOCTL
cmd_IOCTL  proc  near
  cmp  gs:[bp][HeaderIOCTL.Category], IOCTL_P6K7MTRR
  jne  short exit_Invalid
  mov  al, gs:[bp][HeaderIOCTL.Function]
  cmp  al, P6K7MTRR_QRYMTRRCAP
  je  short cmd_IOCTL_QRYMTTRCAP
  cmp  al, P6K7MTRR_QRYMTRRDEFTYPE
  je  short cmd_IOCTL_QRYMTRRDEFTYPE
  cmp  al, P6K7MTRR_QRYMTRRFIXEDRANGE
  je  short cmd_IOCTL_QRYMTRRFIXEDRANGE
  cmp  al, P6K7MTRR_QRYMTRRVARIABLERANGE
  je  short cmd_IOCTL_QRYMTRRVARIABLERANGE
  cmp  al, P6K7MTRR_SETMTRR2DEFAULT
  je  short cmd_IOCTL_SETMTRR2DEFAULT
  cmp  al, P6K7MTRR_SETMTRRDEFTYPE
  je  near ptr cmd_IOCTL_SETMTRRDEFTYPE
  cmp  al, P6K7MTRR_SETMTRRFIXEDRANGE
  je  near ptr cmd_IOCTL_SETMTRRFIXEDRANGE
  cmp  al, P6K7MTRR_SETMTRRVARIABLERANGE
  je  near ptr cmd_IOCTL_SETMTRRVARIABLERANGE
  jmp  near ptr exit_Invalid
;
  public  cmd_IOCTL_QRYMTTRCAP
cmd_IOCTL_QRYMTTRCAP  label  near
  mov  si, offset default_MTRRcaps
  les  di, gs:[bp][HeaderIOCTL.DataPtr]
  movsd
  movsd
  jmp  short exit_Done
;
  public  cmd_IOCTL_QRYMTRRDEFTYPE
cmd_IOCTL_QRYMTRRDEFTYPE  label  near
  les  di, gs:[bp][HeaderIOCTL.DataPtr]
  mov  ecx, MSR_MTRRdefType
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  jmp  short exit_Done
;
  public  cmd_IOCTL_QRYMTRRFIXEDRANGE
cmd_IOCTL_QRYMTRRFIXEDRANGE  label  near
  les  di, gs:[bp][HeaderIOCTL.DataPtr]
  call  query_MTRRFixedRange
  jmp  short exit_Done
;
  public  cmd_IOCTL_QRYMTRRVARIABLERANGE
cmd_IOCTL_QRYMTRRVARIABLERANGE  label  near
  les  di, gs:[bp][HeaderIOCTL.ParameterPtr]
  movzx  ecx, es:[di][parm_MTRRVARIABLERANGE.idx]
  cmp  cl, byte ptr default_MTRRcaps[data_MTRRCAP.cap][0]
  jnb  near ptr exit_Invalid
  les  di, gs:[bp][HeaderIOCTL.DataPtr]
  shl  cx, 1
  add  cx, MSR_MTRRphysBase
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  rdmsr
  stosd
  xchg  eax, edx
  stosd
  jmp  near ptr exit_Done
;
  public  cmd_IOCTL_SETMTRR2DEFAULT
cmd_IOCTL_SETMTRR2DEFAULT  label  near
  call  pre_MTRRchange
;  mov  eax, dword ptr default_MTRRdeftype[data_MTRRDEFTYPE.deftype][0]
;  and  eax, 11111111111111111111011111111111b
  movzx  eax, word ptr default_MTRRdeftype[data_MTRRDEFTYPE.deftype][0]
  and  ax, 1111011111111111b
  mov  edx, dword ptr default_MTRRdeftype[data_MTRRDEFTYPE.deftype][4]
  mov  ecx, MSR_MTRRdefType
  wrmsr
  mov  si, offset default_MTRRfixedrange
  call  set_MTRRFixedRange
  mov  si, offset default_MTRRvariablerange
  movzx  bx, byte ptr default_MTRRcaps[data_MTRRCAP.cap][0]
  mov  cx, MSR_MTRRphysBase
cmd_IOCTL_SETMTRR2DEFAULT_1:
  mov  eax, dword ptr [si][data_MTRRVARIABLERANGE.r_base][0]
  mov  edx, dword ptr [si][data_MTRRVARIABLERANGE.r_base][4]
  wrmsr
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  mov  eax, dword ptr [si][data_MTRRVARIABLERANGE.r_mask][0]
  mov  edx, dword ptr [si][data_MTRRVARIABLERANGE.r_mask][4]
  wrmsr
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  add  si, size data_MTRRVARIABLERANGE
  dec  bx
  jnz  short cmd_IOCTL_SETMTRR2DEFAULT_1
  call  post_MTRRchange
  jmp  near ptr exit_Done
;
  public  cmd_IOCTL_SETMTRRDEFTYPE
cmd_IOCTL_SETMTRRDEFTYPE  label  near
  lds  si, gs:[bp][HeaderIOCTL.DataPtr]
  assume  ds:nothing
  mov  al, byte ptr [si][data_MTRRDEFTYPE.deftype][0]
  call  check_MemType
  jnz  near ptr exit_Invalid
  call  pre_MTRRchange
;  mov  eax, dword ptr [si][data_MTRRDEFTYPE.deftype][0]
;  and  eax, 00000000000000000000010011111111b
  movzx  eax, word ptr [si][data_MTRRDEFTYPE.deftype][0]
  and  ax, 0000010011111111b
;  mov  edx, dword ptr [si][data_MTRRDEFTYPE.deftype][4]
  xor  edx, edx
  mov  ecx, MSR_MTRRdefType
  wrmsr
  call  post_MTRRchange
  jmp  near ptr exit_Done
  assume  ds:DGROUP
;
  public  cmd_IOCTL_SETMTRRFIXEDRANGE
cmd_IOCTL_SETMTRRFIXEDRANGE  label  near
  lds  si, gs:[bp][HeaderIOCTL.DataPtr]
  assume  ds:nothing
  mov  cx, size data_MTRRFIXEDRANGE
cmd_IOCTL_SETMTRRDEFTYPE_0:
  lodsb
  call  check_MemType
  jnz  near ptr exit_Invalid
  loop  cmd_IOCTL_SETMTRRDEFTYPE_0
  sub  si, size data_MTRRFIXEDRANGE
  call  pre_MTRRchange
  call  set_MTRRFixedRange
  call  post_MTRRchange
  jmp  near ptr exit_Done
  assume  ds:DGROUP
;
  public  cmd_IOCTL_SETMTRRVARIABLERANGE
cmd_IOCTL_SETMTRRVARIABLERANGE  label  near
  les  di, gs:[bp][HeaderIOCTL.ParameterPtr]
  movzx  ebx, es:[di][parm_MTRRVARIABLERANGE.idx]
  cmp  bl, byte ptr default_MTRRcaps[data_MTRRCAP.cap][0]
  jnb  near ptr exit_Invalid
  lds  si, gs:[bp][HeaderIOCTL.DataPtr]
  assume  ds:nothing
  mov  al, byte ptr [si][data_MTRRVARIABLERANGE.r_base][0]
  call  check_MemType
  jnz  near ptr exit_Invalid
  call  pre_MTRRchange
  mov  eax, dword ptr [si][data_MTRRVARIABLERANGE.r_base][0]
;  and  eax, 11111111111111111111000011111111b
  and  ax, 1111000011111111b
;  mov  edx, dword ptr [si][data_MTRRVARIABLERANGE.r_base][4]
;  and  edx, 00000000000000000000000000001111b
  movzx  edx, byte ptr [si][data_MTRRVARIABLERANGE.r_base][4]
  and  dl, 00001111b
  lea  cx, [ebx*2+MSR_MTRRphysBase]
  wrmsr
  mov  eax, dword ptr [si][data_MTRRVARIABLERANGE.r_mask][0]
;  and  eax, 11111111111111111111100000000000b
  and  ax, 1111100000000000b
;  mov  edx, dword ptr [si][data_MTRRVARIABLERANGE.r_mask][4]
;  and  edx, 00000000000000000000000000001111b
  movzx  edx, byte ptr [si][data_MTRRVARIABLERANGE.r_mask][4]
  and  dl, 00001111b
  _add  cx, <MSR_MTRRphysMask - MSR_MTRRphysBase>
  wrmsr
  call  post_MTRRchange
  jmp  near ptr exit_Done
  assume  ds:DGROUP
cmd_IOCTL  endp

; end of code_res residence
  public  last_code_res
last_code_res  label  near

; display message
  public  save_Message
save_Message  proc  near
  test  switch_flags, 1b
  jnz  short save_Message_0
  xor  bx, bx
  mov  dl, DevHlp_Save_Message
  call  gs:[bp][HeaderINITin.DevHlpEntry]
save_Message_0:
  ret
save_Message  endp

; P6/K7 MTRRs presence checker
  public  check_P6K7MTRR
check_P6K7MTRR  proc  near
  xor  si, si
  pushfd         ; CPUID availablity check
  pop  edx
  mov  eax, 1 shl 21
  xor  eax, edx
  push  eax
  popfd
  pushfd
  pop  eax
  xor  eax, edx
  jz  short check_P6K7MTRR_2
  xor  eax, eax  ; CPUID std.func. & vender check
  cpuid
  or  eax, eax
  jz  short check_P6K7MTRR_2
  cmp  ebx, dword ptr CPUID_GenuineIntel[0]
  jne  short check_P6K7MTRR_0
  cmp  edx, dword ptr CPUID_GenuineIntel[4]
  jne  short check_P6K7MTRR_0
  cmp  ecx, dword ptr CPUID_GenuineIntel[8]
  je  short check_P6K7MTRR_1
check_P6K7MTRR_0:
  cmp  ebx, dword ptr CPUID_AuthenticAMD[0]
  jne  short check_P6K7MTRR_2
  cmp  edx, dword ptr CPUID_AuthenticAMD[4]
  jne  short check_P6K7MTRR_2
  cmp  ecx, dword ptr CPUID_AuthenticAMD[8]
  jne  short check_P6K7MTRR_2
  inc  si
check_P6K7MTRR_1:
  inc  si
  mov  eax, 1    ; CPUID MTRR feature check
  cpuid
  shr  dx, 12+1
  sbb  ax, ax
  and  si, ax
check_P6K7MTRR_2:
  xchg  ax, si
  ret
check_P6K7MTRR  endp

; INIT routine
  public  cmd_INIT
cmd_INIT  proc  far
  les  si, gs:[bp][HeaderINITin.ArgumentPtr]
cmd_INIT_0:
  lodsb  es:[si]
  test  al, al
  jz  short cmd_INIT_1
  cmp  al, '/'
  jne  short cmd_INIT_0
  lodsb  es:[si]
  test  al, al
  jz  short cmd_INIT_1
  and  al, not ('a' - 'A')
  cmp  al, 'Q'
  jne  short cmd_INIT_0
  or  switch_flags, 1b
  jmp  short cmd_INIT_0
cmd_INIT_1:
  mov  si, offset msg_Title
  call  save_Message
  call  check_P6K7MTRR
  or  ax, ax
  jnz  short cmd_INIT_2
  mov  si, offset msg_NotInstalled
  call  save_Message
  xor  ax, ax
  mov  gs:[bp][HeaderINITout.EndResCode], ax
  mov  gs:[bp][HeaderINITout.EndResData], ax
  mov  ax, 8115h  ; initialization failed
  jmp  near ptr exit_Error
cmd_INIT_2:
  mov  si, offset msg_InstalledP6
  dec  ax
  jz  short cmd_INIT_3
  mov  si, offset msg_InstalledK7
cmd_INIT_3:
  call  save_Message
  mov  gs:[bp][HeaderINITout.EndResCode], offset last_code_res
  mov  gs:[bp][HeaderINITout.EndResData], offset last_data_res
  jmp  near ptr exit_Done
cmd_INIT  endp

code_res  ends


  end

