/* this is the installation program for goswish */

parse arg defdir     /* install here as default, otherwise default is current*/
dd0=defdir

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*  call check_emx - no longer required */


crlf='0d0a'x
copyall=0

ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " >>  Warning: Could not detect ANSI....  Install will look ugly ! "
  parse pull .
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the GoSwish 1.61 installation program (Apri 2001).     "
call lineout, "      (for use as a SRE-http addon, or as a CGI-BIN script)  "
call lineout, normal
call lineout,"      For those who like to do it themselve, please see "
call lineout,'      the installation instructions in GoSwish.DOC.     '
say "" 
say " This program will ask for the names of a few directories,"
say " and will copy a number of files to these directories.    "
say "  "

if yesno(" Are you ready to continue ")=1 then
 nop
else do
 say " See you later?.. "
 exit
end


ascgi=yesno(" Install as:  C= CGI-BIN script, or S=SRE-http addon ",,'CGI-BIN SRE')
nowdir=defdir
if defdir='' then
  nowdir=directory()

if ascgi=0 then do
   if defdir='' then do
     godir=filespec('d',nowdir)||'\GOSERVE'
     webdir=filespec('d',godir)||'\WWW'
   end
   else do
     godir=defdir'\goserve'
     webdir=defdir'\www'
   end
end
else do
  if defdir='' then do
     godir=filespec('d',nowdir)||'\SERVER'
     if dd0<>'' then godir=filespec('d',nowdir)||'\goserve'
     webdir=filespec('d',godir)||'\WWW'
  end
  else do
     godir=defdir||'\GOSERVE'
     webdir=defdir||'\WWW'
  end /* do */
end /* do */

gunky2:
say " "
if ascgi=0 then do
   call charout,  bold " Enter the GoServe working directory (that contains SREFILTR.80)" normal crlf
   call charout,"  ENTER= " godir  " ? "
  parse pull work_dir
  if work_dir="" then work_Dir=godir
  work_dir=strip(work_dir,'t','\')
  foo=aisdir(work_dir)
  if foo=0 then do
    say " >> Could not find directory: " work_dir
    signal gunky2
  end
  foo=work_dir||'\SREFILTR.80'
  if stream(foo,'c','query exists')=' ' then do
     say " >> Could not find SREFILTR.80.  Please reenter "
     signal gunky2
  end  /* Do */
end
else do

   call charout,  bold " Enter your server's root directory " normal crlf
   call charout,"  ENTER= " godir  " ? "
   parse pull work_dir
   if work_dir="" then work_Dir=godir
   work_dir=strip(work_dir,'t','\')
   foo=aisdir(work_dir)
   if foo=0 then do
      say " >> Could not find directory: " work_dir
      signal gunky2
   end
   godir=work_dir
  call charout,  bold " Enter your cgi-bin directory  " normal crlf
  say       '   (GOSWISH.CMD will be copied to it) '
   call charout,"  ENTER= " godir'\CGI-BIN  ? '
  parse pull work_dir
  if work_dir="" then work_Dir=godir'\CGI-BIN'
  work_dir=strip(work_dir,'t','\')
  foo=aisdir(work_dir)
  if foo=0 then do
    say " >> Could not find directory: " work_dir
    signal gunky2
  end
  addon_dir=work_dir
  call charout, bold" What is your server's CGI prefix " normal '(for some servers, this is case sensitive)' crlf
  call charout,"  ENTER= cgi-bin  ? "
  parse pull cgiprefix
  if  cgiprefix='' then cgiprefix='cgi-bin'
end /* do */

gunky2a:
if ascgi=0 then do
   addondir=work_dir||'\ADDON'
   say " "
   say  bold " Enter the SRE-http " normal reverse " addon " normal bold " directory " normal 
   call charout,"  ENTER= " addondir  " ? "
   parse pull addon_dir
   if addon_dir="" then addon_Dir=addondir
   addon_dir=strip(addon_dir,'t','\')
   foo=aisdir(addon_dir)
   if foo=0 then do
      say " >> Could not find directory: " addon_dir
      signal gunky2a
   end
end

gunky3a:
say " "
if ascgi=0 then
  say  bold " Enter the GoServe data directory (the root of your web tree)" normal
else
  say  bold " Enter your home-page's directory (the root of your web tree)" normal
  say  "     This is the directory that requests of the form "
  say  "     "bold"http://www.myserver.com/filename.ext"normal" point to"
call charout,"  ENTER= " webdir  " ? "
parse pull web_dir ; web_dir=strip(web_dir)
if web_dir="" then web_Dir=webdir
web_dir=strip(web_dir,'t','\')
foo=aisdir(web_dir)
if foo=0 then do
    say " >> Could not find directory: " web_dir
    signal gunky3a
end


shtmdir=web_dir||'\SWISH'
gunky4a:
say " "
call charout,  bold " Enter the SWISH documents directory" normal crlf
say '   ' reverse'*'normal' The GOSWISH "HTML front-end", and GOSWISH documentation, '
say '        will be copied to it'
say '   ' reverse'*'normal' It should be in a directory that is WWW-accessible by site adminstrators'
call charout,"  ENTER= " shtmdir  " ? "
parse pull shtm_dir ; shtm_dir=strip(shtm_dir)
if shtm_dir="" then shtm_dir=shtmdir
shtm_dir=strip(shtm_dir,'t','\')
foo=aisdir(shtm_dir)
if foo=0 then do
    say " Creating " shtm_dir
    wow=sysmkdir(shtm_dir)
    if wow<>0 then do
      say " >> Could not create " shtm_dir ' ('wow
       signal gunky4a
    end
end

gunky4b:
say " "
say bold ' What name should be used for the GoSWISH  "HTML front-end" document ' normal
call charout,"  ENTER= GOSWISH.HTM ? "
parse pull htmname ; 
if htmname="" then htmname="GOSWISH.HTM"
if verify(htname,':\/','M')>0 then do
   say "Please do not include path information (just enter a file name) "
   signal gunky4b
end /* do */
if pos('.',htmname)=0 then do
   say "Please enter an extension (or end the name with a period"
   signal gunky4b
end /* do */



a1=translate(web_dir)
a2=translate(shtm_dir)

shtm2=''
if abbrev(a2,a1)=1 then do
    shtm2=substr(shtm_dir,length(web_dir)+2)
end /* do */

gg=lastpos('\',addon_dir)
if gg=0 | gg<4 then do
   custdir=work_dir||'\SWISH'
end /* do */
else do
  custdir=left(addon_dir,gg)||'SWISH'
end

gunky4:
say " "
call charout,  bold " Enter the SWISH working directory" normal crlf
say '   ' reverse'*'normal'  SWISH-EXE, and a few other files, will be copied to it'
say '   ' reverse'*'normal"  It's GODATA/ subdirectory will also be used to store SWISH indices"
call charout,"  ENTER= " custdir  " ? "
parse pull custom_dir
if custom_dir="" then custom_Dir=custdir
custom_dir=strip(custom_dir,'t','\')
foo=aisdir(custom_dir)
if foo=0 then do
    say " Creating " custom_dir
    wow=sysmkdir(custom_dir)
    if wow<>0 then do
       say " >> Could not create " custom_dir '(' wow
       signal gunky4
    end
end
custom2=custom_dir'\GODATA'
foo=aisdir(custom2)
if foo=0 then do
    say " Creating " custom2
    wow=sysmkdir(custom2)
    if wow<>0 then do
       say " >> Could not create " custom2 '(' wow
       signal gunky4
    end
end

say " "
if yesno(" Are you ready to copy the files ")=0 then do
   say " Okay, you can try again later "
   exit
end  
    
say " "


/* 1) modify GOSWISH.CMD */
ain=charin('GOSWISH.CMD',1,chars('GOSWISH.CMD'))
foo=stream('GOSWISH.CMD','c','close')

aa="swish_directory"
ain=replacestrg(ain,aa,custom_dir,'ALL')

aa="web_root_directory"
ain=replacestrg(ain,aa,web_dir,'ALL')


domore=yesno("Would you like to set a few of the parameters in GOSWISH.CMD")
if domore=1 then do
  doover=yesno("Overwrite files (by default) when creating new indices?")
  if doover=1 then do
       ain=replacestrg(ain,'overwrite=0','overwrite=1')
  end /* do */
  dolnums=yesno("Display the match number (1,2...,#matches)")
  if dolnums=0 then do
      ain=replacestrg(ain,'Add_Hit_Num=1','Add_Hit_Num=0')
  end
  say bold"Enter list of HTML extensions"normal" (ENTER=use default list)"
  call charout,"  "reverse"?"normal' '
  pull htmexts
  if htmexts<>'' then do
     ain=replacestrg(ain,'def_Htmls="SHT SHTML HTM HTML HTM-SSI HTML-SSI"', ,
                     'def_Htmls="'htmexts'"')
  end
 say 
end /* setting goswish.cmd parameters */



foo=sysfiledelete('GOSWISH.$$$')
foo=charout('GOSWISH.$$$',ain,1)
if foo>0 then do
    say " >> ERROR: could not write temporary file (GOSWISH.$$$)"
    exit
end
foo=stream('GOSWISH.$$$','c','close')

say ' Modifying the GoSWISH "HTML front-end" file'

ain=charin('GOSWISH.HTM',1,chars('GOSWISH.HTM'))
foo=stream('GOSWISH.HTM','c','close')
aa="/goswish.cmd" 
if ascgi=0 then
  aanew='/GOSWISH'
else
  aanew='/'cgiprefix'/GOSWISH.CMD'

ain=replacestrg(ain,aa,aanew,'ALL')

shtm2=translate(shtm2,'/','\')
shtm20=shtm2
if shtm2<>'' then shtm2=shtm2'/'

boo=replacestrg(ain,'search_document_directory',shtm20,'ALL',1)
foo=sysfiledelete('GOHTM.$$$')
foo=charout('GOHTM.$$$',boo,1)
if foo>0 then do
    say " >> ERROR: could not write temporary file (GOHTM.$$$)"
    exit
end
foo=stream('GOHTM.$$$','c','close')

say ' Copying  GOSWISH.CMD and other stuff to ' addon_dir
foo=check_copy('GOSWISH.$$$',addon_dir'\GOSWISH.CMD',1)
if ascgi=1 then
   foo=check_copy('GOSWISH.$$$',custom_dir'\GOSWISH.CMD',1)

aa=sysfiledelete('GOSWISH.$$$')

say "Copying rxSWISH.DLL to " WORK_odir'\rxswish.dll'
foo=check_copy('rxSWISH.dll',WORK_dir'\rxswish.dll')

say " Copying SWISH-E.EXE and samples to " custom_dir
foo=check_copy('SWISH-E.EXE',custom_dir)

say "Copying samples to " custom_dir
foo=check_copy('SAMPLE.DCT',custom_dir)
foo=check_copy('SAMPLE.SWI',custom_dir)
foo=check_copy('SAMPLE.CON',custom_dir)

foo=check_copy('DESCRIBE.TXT',custom_dir)
foo=check_copy('MKDCT.CMD',custom_dir)
foo=check_copy('SWI_HTML.CMD',custom_dir)

foo=check_copy('MKDCT.IN',custom_dir)

Say " Copying documents to " shtm_dir
foo=check_copy('GOHTM.$$$',shtm_dir'\'htmname,1)
aa=sysfiledelete('GOHTM.$$$')
foo=check_copy('GOSWISH.DOC',shtm_dir)
foo=check_copy('SRCHSAMP.HTM',shtm_dir)

foo=check_copy('SWISH-E.GIF',shtm_dir)


say " "
say cy_ye " ------------------------------------------------- "normal
say bold " The GoSwish files and directories have been created. " normal
say " "
say cy_ye"Notes:"normal
say reverse"*"normal" The GoSWISH manual is : "bold"GOSWISH.DOC"normal
say reverse"*"normal' The "HTML front-end" to GoSWISH is: ' bold htmname normal
say "    You can use "htmname" to create, and then to search, SWISH indices."
say "     (by default, it's relative URL is: /swish/goswish.htm )"
say reverse"*"normal" If you want, you can rename "HTMNAME", or move it to a different directory"
say reverse"*"normal" These two files are in:" bold shtm_dir normal
say
say reverse"*"normal" Advanced users note: GOSWISH.CMD (in "addon_dir") contains "
say                 "                       several user-configurable parameters"








exit

/* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1
 
   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd
 
   "@ANSI 2>NUL | rxqueue 2>NUL"
 
   thisRC = 0
 
   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */
 
 InitAnsiEnd:
 signal off error
 RETURN thisRC


/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno:procedure expose normal reverse bold
parse arg fooa , allopt,altans
if altans<>" " & words(altans)>1 then do
   w1=strip(word(altans,1))
   w2=strip(word(altans,2))
   a1=left(w1,1) ; a2=left(w2,1)
   a1a=substr(w1,2) ; a2a=substr(w2,2)
end
else do
    a1='Y' ; a1a='es'
    a2='N' ; a2a='o'
end  /* Do */
ayn='  '||bold||a1||normal||a1a||'\'||bold||a2||normal||a2a
if allopt=1 then  ayn=ayn||'\'||bold||'A'||normal||'ll'

do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,a1)=1 then return 1
 if abbrev(anans,a2)=1 then return 0
 if allopt=1 & abbrev(anans,'A')=1 then return 2
end


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" | exactmatch=1 then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end


 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose copyall reverse bold normal
parse arg file1, dest1 , asis
amess=''

if asis="" then do
  dest2=strip(dest1,'t','\')||'\'
  filename=dest2||file1
end
else do
  filename=dest1
end /* do */

if copyall=1 then signal doit3

aa=sysfiletree(filename,isit,'F')

ok=1
if aa<>0 then do
   say " >> Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if isit.0>0 then do
  if pos('*',file1)=0 then do
      say " "
      say " A file exists with the name: " filename
      ok=yesno(" Do you want to overwrite this file? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end  /* Do */

end

if ok=2 then do
  say " "
  copyall=yesno(" Are you sure you want overwrite all files?")
  if copyall=0 then
      ok=yesno(" Do you want to overwrite the current file? ")
end

if ok=0  then return 0

doit3:          /* jump here if copyall is on, or noask=1 */
'@COPY ' file1 dest1 ' > NUL '
return 1


/* return 1 if adir is an existing (possibly empty) directory , 0 if not */
is_dir:procedure 
parse arg adir

adir=strip(adir)
adir=strip(adir,'t','\')
nowdir=directory()
nowdrive=filespec('d',nowdir'\')
nowpath=filespec('p',nowdir'\')
adr=filespec('d',adir)
if adr='' then do
   if abbrev(adir,'\')=0 then 
       adir=nowdrive||nowpath||adir
   else
       adir=nowdrive||adir
end /* do */

foo=sysfiletree(adir,goo,'D')
if  goo.0>0  then return 1
return 0


/* return 1 if adir is an existing (possibly empty) directory , 0 if not */
aisdir:procedure 
parse arg adir

adir=strip(adir)
adir=strip(adir,'t','\')
nowdir=directory()
nowdrive=filespec('d',nowdir'\')
nowpath=filespec('p',nowdir'\')
adr=filespec('d',adir)
if adr='' then do
   if abbrev(adir,'\')=0 then 
       adir=nowdrive||nowpath||adir
   else
       adir=nowdrive||adir
end /* do */

foo=sysfiletree(adir,goo,'D')
if  goo.0>0  then return 1
return 0


/**************************/
/* no longer required */
check_emx:

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  parse arg arg1 rest
  arg1 = strip( arg1, 'T')
  rest = strip( rest, 'T')
    i.1= emxrevision( 'emx')
    if i.1=0 then say ' Warning: could not find emx.dll'

    i.2= emxrevision( 'emxio')
    if i.2=0 then say " Warning: could not find emxio.dll"

    i.3=emxrevision( 'emxlibc')
    if i.3=0 then say " Warning: could not find emxlibc.dll"

    i.4= emxrevision( 'emxlibcm')
    if i.4=0 then say " Warning: could not find emxlibcm.dll"

    i.5= emxrevision( 'emxlibcs')
    if i.5=0 then say " Warning: could not find emxlibcs.dll"

    i.6= emxrevision( 'emxwrap')
    if i.6=0 then say " Warning: could not find emxwrap.dll"

if min(i.1,i.2,i.3,i.4,i.5,i.6)=0 then do
   say
   say "Warning: one or more of the EMX dynamic link libraries could not be found"
   say "SWISH 1.1 does NOT require EMX, but SWISH 1.3 does."  
   say "If you intend to use the (recommended) SWISH 1.3, you should"
   say "obtain, and install, the EMX  run time package (EMXRT.ZIP):"
   say "you can find it at http://hobbes.nmsu.edu, search for EMXRT.ZIP "
   say  " "
   say " ... hit ENTER to continue... "
    pull foo
   say
end /* do */
return 1

emxrevision: procedure
  arg pathname
  call RxFuncAdd emx_revision, pathname, emx_revision
  signal on syntax name emxerror
  tmp = emx_revision()
  signal off syntax
  call RxFuncDrop emx_revision
  return  tmp

emxerror:
  return 0
