/* 10 Nov 2002. danielh@crosslink.net

   SNDMAILX.CMD: A  simple sendmail like program for use with SREhttp/2.

Introduction:

   SNDMAILX reads standard input for email like messages.
   Thse "email like messages" should contain message headers, a blank line, 
   and the message body.
   SNDMAILX will parse out the address(es) contained in a To: header, 
   and email the message to these address(es).

   The SREhttp/2 SREH2_MAIL procedure is used to actually do the emailing.
   Since SREH2_MAIL is loaded into "macrospace" by SREhttp/2,
   you can run SNDMAILX as a "standalone" program if you are currently
   running (or have recently run) SRE2003 & SREhttp/2.


Notes on user configurable parameters:

   You MUST set the GATEWAY parameter.
   
   You probably need to set the SENDER_NAME parameter.


   SNDMAILX was first written to provide support for the FORMMAIL.PL
   "send an email via an HTML form" perl script
   (from http://nms-cgi.sourceforge.net/scripts.shtml).
   If this is the intended use, then you should set:
        end_message='-------------'
        end_message_2=1
   If you set end_message='' then SNDMAILX will use a heuristic to 
   determine when there is no  more "message body" coming through standard 
   input (it will wait a  few seconds).

*/


/****** Begin USER CONFIGURABLE PARAMETERS   ****/

/* Required. An SMTP gateway. */
GATEWAY='' 

/* optional: name of sender. If left blank, or =0, a generic name is used 
   Warning: If you are using your ISP's SMTP gateway, you may need to 
            use a recognized e-mail address (to identify yourself as 
            someone with email sending privileges) */
SENDER_NAME='' 


/* Use this to identify an "abbreviation" that signals "end of message".
   That is, end_message is compared to the beginning of a line, and if
   it matches, the message is assumed to be complete.
   If you set end_message='', then a "wait a few seconds" heuristic is used instead
   of this abbreviation matching.*/
END_MESSAGE='-------------'


/* If the end_message string is also used to signal "begin message" (or some other
   such division), setting end_message_2=1 means "message ends on 2nd match of
   the end_message string".  
   Set this to 0 and the first match will signal end-of-message. */
END_MESSAGE_2=1

/* optional: set verbose=1 to echo status stuff, 2 more stuff, 0 for quiet operation */
VERBOSE=0

/* Number of seconds to "wait". Only used if END_MESSAGE='' */
wait_seconds=2

/****** End USER CONFIGURABLE PARAMETERS   ****/


inhead=1
amess=''
end_message_match=0
waited=0

if end_message_2<>1 then end_message_2=0

do forever

   if end_message='' & waited>wait_seconds then leave

   parse pull goo

   if amess<>'' then
     amess=amess||'0d0a'x||goo
   else
     amess=goo
   
   if goo='' then do
      inhead=0
      call syssleep(1)
      waited=waited+1
      iterate
   end

   waited=0

   if end_message<>'' then do           /* use a special string to signal end of message */
     if abbrev(goo,end_message)=1 then do
        end_message_match=end_message_match+1
        if end_message_match>end_message_2 then leave
     end
   end 
   

   if inhead=1 then do
     tgoo=translate(strip(goo))
     if abbrev(tgoo,'TO:')=1 then do
        parse var goo . ':' address_list
     end
  end

end

foo=sreh2_mailit(address_list,amess, gateway,sender_name,verbose)

exit 

