/* simple example of an SREhttp/2 post-response procedure
   This will write a little report to the pmprintf window

Note: the following parameters are passed, by SREHTTP2.RXX, to
      all post-response procedures.

REQUEST_LINE: the request-line. Eg; "GET /foo.htm HTTP/1.0"' (without the quotes)
SOURCE  : Host and client port information 
SEL0    : Selector, after removal of !Special commands and after URL-decoding
SELUSE2 : Final selector, after internal redirection, ~ replacement, etc.
REQNUM  : The request number, using nnnA format.
USER    : the username, as pulled from an Authorization header. This will be
          empty if SREhttp/2 had no need to look up a username
FILEUSED: the actual file used returned to the client. Possibly with
          SSIs.  If Addon, this is blank. If Directory was created, this
          will be "!DIR x:\dir1\dir2\" (without the quotes)
RCODE   : The resposne code (as returned by SRE_COMMAND). Two words,
                  http_response_code' 'bytes_transmitted.
          Eg; "200 1521"  (without the quotes)
HOST_NICKNAME: host-nickname for this host
ID_INFO : The "id_info" of this transaction & request
POST_RESPONSE: Either a 1, or a message set by a POST_RESPONSE selector-specific
               attribute.
    
*/

parse arg request_line,source,sel0,seluse2,reqnum,user , ,
           fileused,rcode,host_nickname,id_info,post_response

foo=sre_pmprintf( "")
foo=sre_pmprintf("For request number "reqnum,1)
foo=sre_pmprintf('   '||reqnum": request= " ||request_line,1)
foo=sre_pmprintf('   '||reqnum": to host nickname= "host_nickname,1)
foo=sre_pmprintf('   '||reqnum":   Source= "source,1)
foo=sre_pmprintf('   '||reqnum":   Selector=" sel0,1)
foo=sre_pmprintf('   '||reqnum":   Selector after redirection=" seluse2,1)
foo=sre_pmprintf('   '||reqnum":   User= " user,1)
foo=sre_pmprintf('   '||reqnum":   FileUsed = " fileused,1)
foo=sre_pmprintf('   '||reqnum":   Response code: " rcode,1)
foo=sre_pmprintf('   '||reqnum":   Post_Response: "||post_response,1)
foo=sre_pmprintf('   '||reqnum":   ID_INFO: "||left(id_info,80)||' ...',0)
foo=sre_pmprintf(" ")
return 0


