/* this is the SREhttp/2 installation program */

call init_it
crlf='0d0a'x

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the SREhttp/2  (v 1.12) installation program (17 March 2004)."
call lineout, "... an http/1.1 compliant filter for the SRE2003 OS/2 Internet Server "
call lineout, normal


say " This program will ask for the names of a few directories,"
say " and will copy a number of files to these directories."
say "  "


aa=yesno(' Would you like to: ','Exit Continue View_Documentation','C')
if aa=0 then do
 say " See you later?.. "
 exit
end
if aa=2 then do
    say " Okay, viewing the SREhttp/2 manual ... "
     '@START  "The SREhttp/2 Manual" /C /F /WIN NETSCAPE FILE:///'||directory()||'/SREHTTP2.HTM'
    say ' '
end

/* check status of sre2003 and macrospace routines */
a=dospidlist(l1,l2)
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if foo='SRE2003' then do
     say bold " SRE2003 appears to be running " normal 
     say "(process list has: "l2.mm ')'
     say " Please shut down SRE2003 before you (re) install SREhttp/2! "
     exit
  end  /* Do */
end /* do */

/* check status of sre2003 and macrospace routines */
a=dosswitchlist(l2)
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if pos('SRE2003',foo)>0 then do
     say bold " SRE2003 appears to be running " normal
     say "(switchlist has: "l2.mm ')'
     say " Please shut down SRE2003 before you (re) install SREhttp/2! "
     exit
  end  /* Do */
end /* do */

call check_macro

is_upgrade=yesno(normal" Is this a: "bold" New installation (N), or an upgrade (U)",'New Upgrade')



/* -------- Working directory (must exist ) */
call make_def_dirs



/* -- Done with directory creation -- copy files ... */

/* but first, backup? */
aa=sysfiletree(srehttp2_dir'\SREHTTP2.RXX','goo','F')
if is_upgrade=1 & goo.0=0 then do         /*check for prior version */
      say bold"ERROR: "normal" Prior version of SREhttp/2 "bold"not"normal" detected! "
      exit
end

if goo.0>0  then do
 say " "
 foo=yesno(normal" "re_wh"Would you like to archive the various configuration files")
 if foo=1 then do
      say  " Where should SREhttp/2 archive these files"
      aa="\BK"||space(translate(date('o'),' ','/\'),0)
      backup_dir=get_dir(srehttp2_dir||aa)

/* files to backup*/
      in_workdir='NOTFOUND.SHT  SREHTTP2.RXX SREH2INI.RXX MTCHFILE.RXX  POSTRESP.RXX '
      in_cfgdir=' MIMETYPE.CFG MANAGER.CFG COUNTER.CFG USERS.CFG SSI_VARS.CFG ATTRIBS.CFG SREHTTP2.CFG HOSTDATA.CFG  PRELOADS.CFG CVT_PAGE.CFG  LOGS.CFG '
      in_helpdir='INDEX.SHT '
      in_adddir=' '
      call dobackup
      yooba=sysfiletree(srehttp2_dir||'\BK*','goos','OD')
      if goos.0>1  then do
          say bold' Reminder:'normal' you have 'goos.0 ' SREhttp/2 archive directories; you might  '
          say     '          want to remove some of the older ones. '
      end /* do */
 end
end

if is_upgrade=0 then
  foo=yesno(" SREhttp/2 will now be installed. Are you ready? ")
else
  foo=yesno(" SREhttp/2 will now be upgraded. Are you ready? ")

if foo=0 then do
  say " Try again later ??? "
  exit
end

say " "
say " Copying dynamic link libraries and helper executables .. "
if gotrxlib=1 then do
   say " Note: a copy of REXXLIB seems to be on your system "
end  /* Do */

say " Copying SREhttp/2 program files files to " srehttp2_dir

foo=check_copy('*.RXX',srehttp2_dir,,1)
foo=check_copy('SREHTTP2.RXL',srehttp2_dir,,1)
foo=check_copy('SREHTTP2.IDX',srehttp2_dir,,1)
foo=check_copy('SREH2PRC.ZIP',srehttp2_dir,,1)

if is_upgrade=0 then do
  foo=check_copy('NOTFOUND.SHT',srehttp2_dir,'This is the sample "not found" documents file',1)

  say " Copying configuration files "
  foo=check_copy('USERS.CFG',cfgdir,' (this is the username/password file')
  foo=check_copy('MIMETYPE.CFG',cfgdir,' (this is the extension-to-mimetype file')
  foo=check_copy('SREHTTP2.CFG',cfgdir,'(this is the configuration file)')
  foo=check_copy('ATTRIBS.CFG',cfgdir,'(this is the selector-specific attributes file')
  foo=check_copy('PRELOADS.CFG',cfgdir,'(this is the LOAD_ADDON file')
  foo=check_copy('LOGS.CFG',cfgdir,'(this is the LOG parameters file')
  foo=check_copy('SSI_VARS.CFG',cfgdir,'(this is the LOAD_ADDON file')
  foo=check_copy('HOSTDATA.CFG',cfgdir,'(this is the host description file')
  foo=check_copy('ADV_OPTS.SMP',cfgdir,,1)
  foo=check_copy('HTACCESS.SMP',cfgdir,,1)
  foo=check_copy('CVT_PAGE.CFG',cfgdir,,1)

  foo=check_copy('README.CFG',cfgdir,,1)
  foo=check_copy('ACC_FAIL.HTM',cfgdir,1)
  foo=check_copy('MAX_FAIL.HTM',cfgdir,1)
  foo=check_copy('SRE_UTIL.CFG' ,cfgdir,'(this is the SRE-utilties CFG file)') 
  foo=check_copy('MANAGER.CFG' ,cfgdir,'(this is the MANAGER cfg file)') 
  foo=check_copy('COUNTER.CFG' ,cfgdir,'(this is the COUNTER.REX cfg file)') 
  foo=check_copy('ADDONS.INI' ,addon_dir,,'(this is the registry for SREhttp/2 addons)') 
  foo=check_COPY('ROBOTS.TXT',datadir,,'This is the robot exclusion file')
end

say " Copying sample files to " helpdir
/* foo=check_COPY('INDEX.SHT',helpdir,,1)  -- use srehttp2.htm as default page */

foo=check_COPY('READ.ME',helpdir,,1)

foo=check_COPY('ADDONS.HTM',helpdir,,1)
foo=check_COPY('ATTRIBS.HTM',helpdir,,1)
foo=check_COPY('ADV_OPTS.HTM',helpdir,,1)
foo=check_COPY('AUDITCNT.HTM',helpdir,,1)
foo=check_COPY('CGI-BIN.HTM',helpdir,,1)
foo=check_COPY('CCDEFN.HTM',helpdir,,1)

foo=check_copy('_dir.key',helpdir,,1)
foo=check_copy('_dir.lst',helpdir,,1)
foo=check_COPY('ENCRYPT.HTM',helpdir,,1)
foo=check_COPY('HOSTDATA.HTM',helpdir,,1)
foo=check_COPY('HTACCESS.HTM',helpdir,,1)

foo=check_COPY('LOGS.HTM',helpdir,,1)
foo=check_COPY('MIMETYPE.HTM',helpdir,,1)
foo=check_copy('MULTSEND.CMD',helpdir,,1)

foo=check_COPY('NEGOTIAT.HTM',helpdir,,1)

foo=check_COPY('FEATURES.HTM',helpdir,,1)
foo=check_COPY('FILE_CSH.HTM',helpdir,,1)

foo=check_COPY('DOCFILES.HTM',helpdir,,1)

foo=check_COPY('OUTLINE.HTM',helpdir,,1)

foo=check_COPY('POSTRESP.HTM',helpdir,,1)
foo=check_COPY('PRE_RESP.HTM',helpdir,,1)
foo=check_COPY('PRELOAD.HTM',helpdir,,1)
foo=check_COPY('SECURITY.HTM',helpdir,,1)

foo=check_COPY('SREHTTP2.HTM',helpdir,,1)
foo=check_COPY('SREHTTP2.FAQ',helpdir,,1)

foo=check_COPY('SREH2CFG.HTM',helpdir,,1)
foo=check_COPY('SREH2PRC.HTM',helpdir,,1)
foo=check_COPY('SPECIAL.HTM',helpdir,,1)
foo=check_COPY('SSI_VARS.HTM',helpdir,,1)
foo=check_COPY('SSIcache.HTM',helpdir,,1)
foo=check_COPY('SSIS.HTM',helpdir,,1)

foo=check_COPY('USERS.HTM',helpdir,,1)
foo=check_COPY('ACCESS.HTM',helpdir,,1)

foo=check_COPY('LOGS.HTM',helpdir,,1)

foo=check_COPY('*.TXT',helpdir,,1)


foo=check_copy('SREH2A.GIF',helpdir,,1)
foo=check_copy('SREH2A.GIF',gifdir,,1)
foo=check_copy('NOVU.HTM',gifdir,,1)
foo=check_copy('IMGINTRO.HTM',gifdir,,1)

foo=check_copy('GIFS.ZIP',gifdir,,1)
foo=check_copy('DIGITS.ZIP',digitsdir,,1)

/* demos, and configuration tools, to demos_dir */
foo=check_COPY('CONFIGS.HTM',demos_dir,,1)
foo=check_COPY('_COMMAND.SHT',demos_dir,,1)
foo=check_COPY('CONGRESS.DAT',demos_dir,,1)
foo=check_COPY('CONGRESS.HTM',demos_dir,,1)

foo=check_copy('cntdemo1.SHT',demos_dir,,1)
foo=check_copy('cntdemo2.SHT',demos_dir,,1)

foo=check_copy('dointerp.SHT',demos_dir,,1)
foo=check_copy('_dir.sht',demos_dir,,1)
foo=check_copy('demos.HTM',demos_dir,,1)
foo=check_copy('DOSELECT.SHT',demos_dir,,1)
foo=check_copy('DOMIXED.CMD',demos_dir,,1)

foo=check_copy('DYNPTST*.SHT',demos_dir,,1)

foo=check_copy('ENC_FORM.RSP',demos_dir,,1)
foo=check_copy('ENC_SREB.RSP',demos_dir,,1)
foo=check_copy('ENC_test.SHT',demos_dir,,1)
foo=check_copy('ENC_test.txT',demos_dir,,1)
foo=check_copy('iftest.SHT',demos_dir,,1)
foo=check_copy('INTRO.TXT',demos_dir,,1)
foo=check_COPY('MESSAGES.SHT',demos_dir,,1)

foo=check_copy('restart.htm',demos_dir,,1)

foo=check_copy('replaces.SHT',demos_dir,,1)
foo=checK_COPY('SAMPMAP.*',demos_dir,,1)
foo=check_copy('showfile.SHT',demos_dir,,1)
foo=check_copy('TSTHTTPD.SHT',demos_dir,,1)
foo=check_COPY('UPLOAD.HTM',demos_dir,,1)
foo=check_COPY('SENDFILE.HTM',demos_dir,,1)

foo=check_COPY('TXT_FIND.HTM',demos_dir,,1)
foo=check_COPY('TXTFIND2.HTM',demos_dir,,1)

foo=check_COPY('VULOGS.HTM',demos_dir,,1)
foo=check_copy('xssi.SHT',demos_dir,,1)


say " Copying sample CGI-Bin scripts to " cgibin_dir
foo=check_copy('XCOUNT.CMD',cgibin_dir,,1)
foo=check_copy('JCOUNT.CMD',cgibin_dir,,1)
foo=check_copy('TEST-CGI.CMD',cgibin_dir,,1)
foo=check_copy('TXTCLOCK.PL',cgibin_dir,,1)
foo=check_copy('TEXTCLOCK.PL',cgibin_dir,,1)
foo=check_copy('SNDMAILX.CMD',cgibin_dir,,1)

/* SSI interpret files to addon_dir */
foo=check_copy('INTERP.REX' ,addon_dir,,1) 
foo=check_copy('SHOWFILE.REX' ,addon_dir,,1) 
foo=check_copy('DIRINFO.REX' ,addon_dir,,1) 
foo=check_copy('COUNTER.REX' ,addon_dir,,1) 
foo=check_copy('ADDONLST.CMD',addon_dir,,1)

say " Copying sample addons to " addon_dir

foo=check_copy('CHK_RED.CMD',sysaddon_dir,,1)
foo=check_copy('CHK_PENL.CMD',sysaddon_dir,,1)

foo=check_copy('MAKECNEG.CMD',sysaddon_dir,,1)
foo=check_copy('CLEANUP.CMD',sysaddon_dir,,1)

foo=check_copy('CHK_INIT.REX',bindir,,1)
foo=check_copy('CHK_PRE.REX',bindir,,1)

foo=check_copy('_COMMAND.CMD',addon_dir,,1)
foo=check_copy('MANAGER.CMD',addon_dir,,1)

foo=check_copy('_DIR.CMD',addon_dir,,1)
foo=check_copy('DYNP_LOG.CMD',addon_dir,,1)
foo=check_copy('ENC_TEST.CMD',addon_dir,,1)
foo=check_copy('MAPIMAGE.CMD',addon_dir,,1)
foo=check_copy('MULTSEND.CMD',addon_dir,,1)

foo=check_copy('SRE_UTIL.CMD' ,addon_dir,,1) 
foo=check_copy('STATUS.CMD',addon_dir,,1)

foo=check_copy('TSTDIGIT.CMD',addon_dir,,1)
foo=check_copy('TESTDYN.CMD',addon_dir,,1)
foo=check_copy('TXT_FIND.CMD',addon_dir,,1)

foo=check_copy('DYNPRIV.REX',addon_dir,,1)

foo=check_copy('TASKDEMO.ZIP',addon_dir,,1)

foo=check_copy('README.ADD',addon_dir,,1)

foo=check_copy('EXEC_SMP.REX',procs_dir,,1)
foo=check_copy('MAX_USER.REX',procs_dir,,1)

foo=check_copy('POSTMAIL.REX',procs_dir,,1)
foo=check_copy('POSTRCRD.REX',procs_dir,,1)
foo=check_copy('POSTRESP.REX',procs_dir,,1)

foo=check_copy('PROCS.REG',procs_dir,,1)

foo=check_copy('NEGOT.REX',procs_dir,,1)
foo=check_copy('MTCHFILE.REX' ,procs_dir,,1) 

foo=check_copy('README.PRC',procs_dir,,1)

foo=check_copy('PRE_RESP.REX',procs_dir,,1)
foo=check_copy('PACKBACK.REX',procs_dir,,1)
foo=check_copy('CVT_PAGE.REX',procs_dir,,1)

foo=check_copy('DYNPRIV.REX',procs_dir,,1)
foo=check_copy('ENCRYPT.REX',procs_dir,,1)
foo=check_copy('GZIP.REX',procs_dir,,1)

foo=check_copy('MULTPART.REX' ,procs_dir,,1) 


foo=check_copy('TESTDYN.RSP',procs_dir,,1)
foo=check_copy('DYNPWD.RSP',procs_dir,,1)
foo=check_copy('DYNPWD2.RSP',procs_dir,,1)

foo=check_copy('ENC_FORM.RSP',procs_dir,,1)
foo=check_copy('ENC_SREB.RSP',procs_dir,,1)

foo=check_copy('CHK_POST.REX',procs_dir,,1)


foo=check_copy('DE_*.CMD',procs_dir,,1)

foo=check_copy('CUST_USR.REX',procs_dir,,1)

foo=check_copy('EDIT-HTTP2.CMD',godir,,1)

dll_dir=godir||'\DLL'
sdoc_dir=godir||'\DOC'
foo=check_copy('UNZIPAPI.DLL',dll_dir,,1)
foo=check_copy('UNZIPAPI.TXT',sdoc_dir,,1)
foo=check_copy('RXCPAGE.DLL',dll_dir,,1)

/* system utilities */

oo=sysfiletree('*.CM2','cms','FO')
do mm=1 to cms.0
   parse var cms.mm afile '.' .
   afile=afile||'.CMD'
   tofile=sysaddon_dir||'\'||filespec('n',afile)
   foo=check_copy(cms.mm,tofile,,1)
end



meis=directory()


dufus:
say " "

if is_upgrade=0 then do
  call lineout, cy_ye ' ------------ Configuration: ' normal
  say " "
/* now modify sre2003.cfg */
  cfg1=stream(workdir||'\CFG\SRE2003.CFG','c','query exists')
  cfg1t=''
  if cfg1<>''  then do
    tt=workdir||'\CFG\OLD\SRE2003.???'
    cfg1t=dostempname(tt)
    do forever
     ii=yesno("Modify currently existing version of SRE2003.CFG ",'No Yes ?','?')
     if ii=2 then do
       say bold"YES"normal"  SRE2003 will be instructed to use the SREhttp/2 filter"
       say "     This is accomplished by modifying the working version of SRE2003.cfg"
       say "     ("cfg1")"
       say "     Note that the current version will be backed up "
       say '     (to 'cfg1t')'
       say bold"NO "normal"  You will have to make changes to SRE2003.CFG."
       say '     In particular, you will need to set the values of several parameters:'
       say'         DATADIR, FILTER, FILTER_VERSION, INIT_PROC, and EXIT_PROC.'

    end 
    else do             /* yes no */
      leave
    end
   end           /* do forever (yes no) */
 end            /* sre2003.cfg exists */
 else do             /* if here, no sre2003.cfg file */
   say "Setting up SRE2003.CFG "
   ii=1
 end 
 if ii=1 then call modify_cfg cfg1
  say " "

/* -- add entry to users.cfg file */
  foo=add_user(cfgdir)
  say " "
end

/* -- add to ADD_PLUG.DAT */
if is_upgrade<>1 then foo=add_plug(workdir||'\CFG')


/* unzip image containing zip files */
foo=unzip_it('GIFS',gifdir)

foo=unzip_it('DIGITS',digitsdir)


/* save some installation info in users.ini */

sre2003_dir=sysini('USER','SRE2K','SRV_DIR',workdir)
GG=STRIP(SREHTTP2_DIR,,'\')||'\SREHTTP2.RXX'
filtername=sysini('USER','SRE2K','FILTER',GG)
filter_dir=sysini('USER','SRE2K','FILTER_DIR',SREHTTP2_DIR)
datadir=sysini('USER','SRE2K','DATADIR',DATADIR)


done1: nop


call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")

done1A: nop

a=scrclear()

call lineout, bold cy_ye  " SREhttp/2 has been installed... " normal
say " "
say ' Your web site is now ready to be built!  '
say '      (just add documents, images, links, etc...)'
say ' '
say ' Notes:'
say '    * The 'bold'CFG'normal' directory is 'reverse||cfgdir||normal
say '      It contains several user-configurable (text) parameter files. '
say '      Hint: use 'godir'\EDIT-HTTP2.CMD to edit these files.'
say '      See README.CFG (in the 'bold'CFG'normal' directory) for the details.'
say '    * SREHTTP2.HTM (in 'helpdir') is the SREhttp/2 manual'
say '    * 'bold'Upgraders Note:'normal' If you modified advanced-user options in SREHTTP2.RXX,'
say '       SREH2INI.RXX, and elsewhere, you will need to re-enter those changes. '

exit

/********/
modify_cfg:
parse arg oldcfg
if oldcfg='' then oldcfg=stream('SRE2003.CF_','c','query exists')
if oldcfg='' then do
   say "ERROR: unable to find SRE2003.CF_"
   say "Perhaps the distribution file for SREhttp/2 is corrupted? "
   exit
end 

iff=stream(oldcfg,'c','query size')
stuff=charin(oldcfg,1,iff)
goo=stream(oldcfg,'c','close')

if cfg1t<>'' then do          /* rename prior version? */
  foo=dosrename(oldcfg,cfg1t)
  if foo=0 then do
      say "ERROR: unable to rename old version of SRE2003.CFG "
      say        "(" cfg1t ")"
      exit
   end
  else do
      say "Old version of SRE2003.CFG renamed to: "cfg1t
  end 
end

/* now set
   DATADIR
   FILTER
   FILTER_VERSION
   INIT_PROOC
   EXIT_PROC
*/
newstuff=''
do forever
   if stuff='' then leave
   parse var stuff aline '0d0a'x stuff ; aline=strip(aline)
   if aline='' |  abbrev(aline,';')=1 then do
       newstuff=newstuff||aline||'0d0a'x
       iterate
   end

   parse var aline avar '=' aval
   avar=strip(translate(avar))

   select
      when avar='DATADIR' then do
          newstuff=newstuff||'datadir='||datadir||'0d0a'x
      end 
      when avar='FILTER' then do    
          newstuff=newstuff||'FILTER=srehttp2\srehttp2.rxx'||'0d0a'x
      end 
      when avar='FILTER_VERSION' then do
          newstuff=newstuff||'FILTER_VERSION=SREhttp/2 ver 1.12d'||'0d0a'x
      end
      when avar='INIT_PROC' then do
          newstuff=newstuff||'init_proc=srehttp2\SREH2INI.RXX,srehttp2\STARTREQ.CMD'||'0d0a'x
      end
      when avar='EXIT_PROC' then do
          newstuff=newstuff||'exit_proc=srehttp2\sreh2exi.rxx'||'0d0a'x
      end
      otherwise do
         newstuff=newstuff||aline||'0d0a'x
      end
   end  /* select */
end /* do forever */


cfg1=workdir||'\CFG\SRE2003.CFG'
foo=sysfiledelete(cfg1)

oo=charout(cfg1,newstuff,1)
foo=stream(cfg1,'c','close')
say "Done writing to " cfg1 
return ' '

/********/
/* copy files to backup directory  */
dobackup:

do mm=1 to words(in_workdir)
     a1=strip(word(in_workdir,mm))
     cto=backup_dir||'\'||a1
     cfrom=srehttp2_dir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto ' > nul '
     end  /* Do */

end /* do */
do mm=1 to words(in_cfgdir)
     a1=strip(word(in_cfgdir,mm))
     cto=backup_dir||'\'||a1
     cfrom=cfgdir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */

do mm=1 to words(in_helpdir)
     a1=strip(word(in_helpdir,mm))
     cto=backup_dir||'\'||a1
     cfrom=helpdir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Copying ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */

do mm=1 to words(in_adddir)
     a1=strip(word(in_adddir,mm))
     cto=backup_dir||'\'||a1
     cfrom=addon_dir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Copying ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */



return 0


/****************************/
unzip_it:procedure 
parse arg afile,adir
say
say 'Copying files in '||afile||'.ZIP'||' to '||adir
ccmd='@UNZIP -qq -o  '||adir||'\'||afile||' '||' -d '||adir|| ' 1>> nul '
signal on error name goo1

address cmd ccmd
goo1:
res1=rc

if res1<>0 then do
   say 'Error unzipping '||afile||'.ZIP ('||res1||'). You should: '
   say '   CD to '||adir
   say '   UNZIP 'afile||'.ZIP'
   say '(press ENTER to continue)'
end 
return 1


/*****************/
/* Add a record  to the add_plug.dat file */
add_plug:procedure expose ipaddr expose reverse bold normal re_wh cy_ye aesc

parse arg cfgdir

/* read users.cfg, append uname pwd , write it*/
afile=strip(cfgdir,'t','\')||'\ADD_PLUG.DAT'

oof='0d0a0d0a'x
oof=oof||'Name: The SREhttp/2 Filter '||'0d0a'x
oof=oof||'Desc: SREhttp/2 is a full featured filter for SRE2003.'||'0d0a'x
oof=oof||'Desc: This will select SREhttp/2 with several defaults (any other currently active '||'0d0a'x
oof=oof||'Desc: plugins will be deselected)'||'0d0a'x

oof=oof||'Item: Filter srehttp2\srehttp2.rxx '||'0d0a'x
oof=oof||'Item: Fast_Filter 0 '||'0d0a'x
oof=oof||'Item: Filter_Version SREhttp/2 ver 1.12d '||'0d0a'x
oof=oof||'Item: INIT_PROC srehttp2\SREH2INI.RXX,srehttp2\startreq.cmd '||'0d0a'x
oof=oof||'Item: EXIT_PROC srehttp2\sreh2exi.rxx '||'0d0a'x
oof=oof||'Item: PRE_Transaction bin\badips.rxx  '||'0d0a'x
oof=oof||'Item: PRE_Request 0  '||'0d0a'x
oof=oof||'Item: IM_TYPES XRANGE bin\im\xrange.rxx '||'0d0a'x
oof=oof||'Item: IM_DEFAULT Range '||'0d0a0d0a'x

foo=append_file(afile,oof,2,1)
if foo<0 then 
  say 'Error ('foo') adding to 'afile
else
  say "Note: an SREhttp/2 record was added to the SREhttp/2 plug in database" 

return 1

/*****************/
/* Add an entry to the users.cfg file */
add_user:procedure expose ipaddr expose reverse bold normal re_wh cy_ye aesc

parse arg cfgdir

say " "
say  bold " Add a SUPERUSER to the UserName database " normal
say " "
say ' To facilitate resetting parameters, and other such actions, we recommend that '
say ' you add a  user, with SUPERUSER privileges, to the SREhttp/2 UserName database.'

ok=yesno(normal'    're_wh' Would you like add a SUPERUSER ','No Yes','N')
say " "
if ok=0 then do
   say " You can add a user with SUPERUSER privileges by editing USERS.CFG "
   return 0
end

bugs: nop
 call charout, bold " Enter a username: " normal
 uname=stringin(,23," ",80)
 say " "

 call charout, bold " Enter a password: " normal
 pwd=stringin(,23," ",80)
 say " "

if uname="" | pwd="" then do
    say " missing username or password: please reenter "
    signal bugs
end  /* Do */


/* read users.cfg, append uname pwd , write it*/
afile=strip(cfgdir,'t','\')||'\USERS.CFG'
oof=stream(afile,'c','open')
kk=stream(afile,'c','query size')
new1=uname' 'pwd' SUPERUSER '
if kk=0 | kk='' then do
  oog=charout(afile,new1,1)
  oof=stream(afile,'c','close')
end 
else do
  new1='0d0a'x||new1
  oof=charin(afile,kk,1)
  if oof='1a'x then kk=kk-1
  kk=kk+1
  afr=stream(afile,'c','seek 'kk)
  oog=charout(afile,new1)
  oof=stream(afile,'c','close')
end 
say " A SUPERUSER has been added, with: "
say bold uname normal " for the username, and " bold pwd normal " for the password "
return 1



/* ----------------------------------------------------------------------- */
/* HOST -- return the result of a HOST command  (a ping )                  */
/* ----------------------------------------------------------------------- */
  host: procedure
   parse arg eek
    do queued(); pull .; end                   /* flush */
    address cmd '@host' eek '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */
    return hostresult



/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye     mm0a listfile
parse arg amessage , altans,def,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

do forever
 foo1=normal||reverse||amessage||'? '||normal||aynn||': 'normal
 goo=amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 anans=translate(sysgetkey('echo'))

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0  then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end




/* ------------------------ */
/* ask for directory name,use defname2 as default */
/* give user opportunity to create it */

get_dir:procedure expose normal reverse bold re_wh
/* procedure expose reverse normal bold */
parse arg defname2 , mustsub
defname0=defname2

n2:
call charout ,  reverse ' <ENTER>=' defname2  normal ' ?'
pull godir

if godir=" " then godir=defname2
if godir="n.a." then signal n2


if mustsub<>"" then do    /* check 'must be subdirectory' option */
  if abbrev(godir,mustsub)=0 then do
     say " This directory MUST be under the " mustsub " directory! "
     say "  .. please re enter ! "
     signal n2
  end
end

godir=strip(godir,'t','\')
gdname=godir||"\*.*"


isme=directory()

isnew=directory(godir)
if isnew="" then do
   say "    Could not find  " godir
   if yesno(normal"        "re_wh"Would you like to create it")=1 then do
        oo=sysmkdir2(godir)
        if oo=0  then do
           say "      Directory created: " godir
        end
        else do
           say "      Could not create " godir "(error = " oo
           if godir=defname2 then defname2= "n.a."
           signal n2
        end
   end
   else do
        say " please reenter directory name ... "
        if godir=defname2 then defname2= "n.a."
        signal n2
   end
end  /* Do */


isme=directory(isme)



return godir

/* ------------- */
sysmkdir2:procedure
parse arg adir

adir=strip(adir,'t','\')
ff=sysmkdir(adir)
if ff=0 then return ff

/* make the tree */
f2=adir'\'
dd=filespec('d',f2)
pp=filespec('p',f2)
if pp='\' | pp='' then return -1

pp2=strip(translate(pp,' ','\'))

do mm=1 to words(pp2)
   a1=subword(pp2,1,mm)
   a1=translate(a1,'\',' ')
   dd2=dd'\'a1
   hoo=sysmkdir(dd2)
   if hoo=0 then say ' ... creating: 'dd2  
end /* do */

return hoo


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/* ----------------------------------------------------------------------- */
/* GRAB_FILE read in a file, but first check to see if openable, and if
.   openable, open and read it.
.    Returns with the file, or with 0 if file not obtainable.
.    Note that file is closed before returning
.   in,
.    usage:   afile_string=grab_file(the_file,seconds_to_try_for)
*/
/* ----------------------------------------------------------------------- */


grab_file: procedure

parse arg afile

ause=stream(afile,'c','open read')
if ause<>"READY:" then
  return 0

goo=charin(afile,1,chars(afile))
ause=stream(afile,'c','close')

/* get rid of ending ctl-z */
if c2d(right(goo,1))=26 then
  goo=left(goo,length(goo)-1)

return goo


/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose  reverse bold normal re_wh copyall
parse arg file1, dest1 , amess , noask
dest2=strip(dest1,'t','\')||'\'
filename=dest1
if pos('.',dest1)=0 then filename=dest2||file1


aa=sysfiletree(filename,isit,'F')
ok=1
if aa<>0 then do
   say " Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if noask=1 then signal doit3

if isit.0>0 then do
  if pos('*',file1)=0 then do
       if copyall=1 then do
             ok=1
       end 
       else do
           say " "
           say " A file exists with the name: " filename
           if amess<>'' & amess<>'1' then say " .... " amess
           ok=yesno(" Do you want to overwrite this file? ",'No Yes All')
           if ok=2 then do 
                ok=1 ; copyall=1
           end 
       end
  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ")
      if ok=1 & amess<>""  then ok=yesno(amess'No Yes All')
  end  /* Do */
end
if ok=0 then return 0

doit3:          /* jump here if noask=1 */
address cmd 'COPY ' file1 dest1 ' > NUL '

if rc<>0 then do
   say "Warning: unable to copy "file1
   say "(hit ENTER to continue) "
   pull goo
end /* do */


return 1




 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure expose re_wh
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname | rxqueue'

    parse pull hostname
    return hostname



/******/
get_sre2003_dir:

call lineout, bold  " What is SRE2003's "working" directory? " normal
say "    *  The SREhttp/2 program files will be copied to a subdirectory "


n1:
godir=get_dir(defname)

if godir=" " then godir=defname
if godir="n.a." then signal n1

godir=strip(godir,'t','\')
gsname=godir||"\SRE2003.CMD"

call sysfiletree gsname,gname2,'F'
if gname2.0=0 then do
   say
   say " Note: SRE2003.CMD is not currently installed in "godir
   foo=yesno("Are you sure you this is correct? ",,'Y')
   if foo=0 then exit
   say
end  

return 0

/**********/
get_www_dir:

say " "
call lineout, cy_ye" + + + + "normal BOLD " What is your data directory ?" normal
say  '    .. this is  the location of your "home page" document. '

datadir=get_dir(defname2)

return 0

/*********/
get_ip_address:
say "What is your IP address (it will be given OWNERS status)"
ipaddr=" "
thishost=get_hostname()
sagain:
call charout , BOLD "What is your IP address (ENTER="thishost "):? " normal
pull youraddr
if youraddr=' ' then youraddr=thishost

parse var youraddr t1 '.' .
isnum=0
if  datatype(t1)='NUM' then
  isnum=1
say " wait while that address is checked ... "
chk=host(youraddr)
if translate(word(chk,2))<>"IS" &  word(chk,2)<>"=" then do
    call lineout,re_wh " Unable to find  address: " youraddr normal
    say "    OWNER variable not assigned (but you can assign it later)"
    ipaddr=" "
end  /* Do */
else do
   if isnum then
     ipaddr=word(chk,1)
   else
     ipaddr=word(chk,3)

   say " Your IP address: " ipaddr
end
return 0

/***************/
init_it:

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

nowdir=directory()

initfilt_file=''
echo off


/* --- Load the tcp/ip function library, if necessary --- */
if RxFuncQuery("SockLoadFuncs")=1 then  do    /* not there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

thishost=' '
copyall=0

parse version  atype .
if atype<>"REXXSAA" then do
 say    " WARNING: SREhttp/2 is designed to work under Classic Rexx "
 say     " In particular, it does NOT work under Object Rexx. "
 say     " Other versions of REXX, such as Quercus's REXX, have not been tested."
 say " Note: You are using REXX version: " atype
 say " (hit ENTER to continue) "
  pull .
end  /* Do */


/*---- load the rexxlib library */
droprxlib=0 ; gotrxlib=1
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 droprxlib=1 ; gotrxlib=0
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find the REXXLIB procedure library (REXXLIB.DLL). "
    say "  Did you download it? "
    exit
end  /* Do */

if rxfuncquery('sref_fileread')<>0 then do
  ik=rxfuncadd('sref_fileread','rexxlib','LIB_FILEREAD')
  if ik<>0 then call pmprintff(' Warning: unable to register SREF_FILEREAD')
end

ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  Install will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

/* some defaults */
    datadir="your SRE2003 Data-directory"
    workdir="your SRE2003 Working-directory"
   workdir_notset=1
    helpdir='the SREhttp2 subdirectory of the SRE2003 Data-directory'
    useindex='  '


return 0


/*********/
check_macro:
if macroquery('SREH2_VALUE')<>"" then do
     say " "
     say bold "A prior version of the SREhttp/2 macrospace procedures"normal
     say " were detected. We recommend clearing macrospace before you install SREhttp/2."
     say " However, this might adversely impact other programs (that may also "
     say " use REXX's macrospace). "
     ok=yesno(" Clear macrospace now (Y) ?")
     if ok=1 then do
        say " .... clearing macrospace "
        foo=macroclear()
        say " "
     end  /* Do */
     else do
          say " "
          say  bold " Macrospace will not be cleared. " normal
          say " "
     end  /* Do */
end  /* Do */
return 0


/************/
make_def_dirs:

adir=filespec("drive",nowdir)
defname=sysini('USER','SRE2K','SRV_DIR')
if defname='' | abbrev(defname,'ERROR:')=1 then defname=''
defname2=sysini('USER','SRE2K','DATADIR')
if defname2='' | abbrev(defname2,'ERROR:')=1 then defname2=''

/* can we use values from a recent sre2003 install */
   if defname='' then do
     a=value('SREINSTALL_SRE2003_DIR',,'os2environment')
     if a<>'' then do
        defname=a
     end 
     else do
        defname=adir||'\SRE2003'
     end
   end


   if defname2='' then do
      a=value('SREINSTALL_WWW_DIR',,'os2environment')
      if a<>'' then do
         defname2=a
      end 
      else do
         defname2=adir||'\WWW'
      end
   end

say ' '
    call get_sre2003_dir        /* but ask for a few directories */
    call get_www_dir

    gosds.1='SREHTTP2 SREHTTP2\TEMP  SREHTTP2\TEMP\FILE_CSH '
    gosds.2='SREHTTP2\CGI-BIN SREHTTP2\ADDON SREHTTP2\ADDON\SYSTEM'
    gosds.3='SREHTTP2\CFG SREHTTP2\CFG\OLD SREHTTP2\LOG'
    gosds.4='SREHTTP2\LOG\OLD SREHTTP2\WORKDATA'
    gosds.5='SREHTTP2\WORKDATA\MESSAGE SREHTTP2\WORKDATA\MAIL'
    gosds.6='SREHTTP2\PROCS SREHTTP2\UPLOAD'

    gosds=gosds.1||' '||gosds.2||' '||gosds.3||' '||gosds.4||' '||gosds.5||' '||gosds.6

    wwwds.1='SRE2K\SREHTTP2  SRE2K\SREHTTP2\DEMOS '
    wwwds.2='SRE2K\SREHTTP2\IMGS SRE2K\SREHTTP2\IMGS\DIGITS '
    wwwds.3=' SRE2K\SREHTTP2\APPS '
    wwwds=wwwds.1||' '||wwwds.2||' '||wwwds.3

   say "The following sub directories will be created... "
   say  "    under "bold||godir||normal " : " gosds.1
    say  "                  ... " gosds.2
    say  "                  ... " gosds.3
    say  "                  ... " gosds.4
    say  "                  ... " gosds.5
    say  "                  ... " gosds.6
    say  "    under "bold||datadir||'\SRE2K'||normal" : "wwwds.1
    say  "                  ... "||wwwds.2
    say  "                  ... "||wwwds.3

    workdir=godir
    bindir=godir||'\BIN'

    srehttp2_dir=workdir'\srehttp2'
    addon_dir=workdir'\srehttp2\addon'
    procs_dir=workdir'\srehttp2\procs'

    workdata_dir=workdir'\srehttp2\workdata'

    sysaddon_dir=workdir'\srehttp2\addon\system'


    cfgdir=workdir||'\srehttp2\CFG'
    cgibin_dir=workdir||'\srehttp2\cgi-bin'
    tempdatadir=workdir'\srehttp2\temp'
    logdir=workdir'\srehttp2\log'

    gifdir=datadir'\sre2k\srehttp2\imgs'
    digitsdir=datadir'\sre2k\srehttp2\imgs\digits'

    helpdir=datadir'\sre2k\srehttp2'
    demos_dir=helpdir'\demos'

    workdir_notset=0
    do ii=1 to words(gosds)
       a1=strip(word(gosds,ii))
       mdd=workdir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir2(mdd)
          if oo<>0 then do 
            say 'ERROR 1: Could not create 'mdd ', error code= ' oo
            exit
         end /* do */
       end
    end /* do */
    do ii=1 to words(wwwds)
       a1=strip(word(wwwds,ii))
       mdd=datadir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir2(mdd)
          if oo<>0 then do 
            say 'ERROR 2: Could not create 'mdd ', error code= ' oo
            exit
          end /* do */
       end
    end /* do */
return 1



/********************/
append_file:procedure
parse arg filename,astring,ntries,addcrlf

if ntries='' | ntries=0 then ntries=1
isnew=0

fulln=stream(filename,'c','query exists')

if fulln<>'' then do    /* does exist, get size */
 do ll=1 to ntries               /* sometimes file exists but hasn't been written */
   asize=stream(fulln,'c','query size')
   if asize=''  then do
     if ll=ntries then  return '-1 '||filename' problem reading size '
     call syssleep(1)
     iterate
   end
   leave
 end
end
else do
   fulln=filename               /* create file */
   isnew=1
end

/* now open it */
do jj=1 to ntries
   astat=stream(fulln,'c','open')
   if abbrev(strip(translate(astat)),'READY')=0 then do
     if jj=ntries  then  return '-1 '||fulln' could not be opened'
     call syssleep(1)
     iterate
   end
   leave
end
  
/* if no such file, create it now */
if isnew=1 | asize=0  then do
   if addcrlf=1 then astring=astring||'0d0a'x
   foo=charout(fulln,astring,1)
   foo2=stream(fulln,'c','close')
   if foo<>0 then return '-2 unable to write 'foo' bytes '
   asize=length(astring)
   return asize
end

/* now get last 3 characters  */
iat=asize-2
toget=3
if iat<3 then do 
   toget=1   /* just look for 1a */
   iat=asize
end
aa=charin(fulln,iat,toget)

iwrite=asize+1          /* where to write astring */

checkcrlf=addcrlf
if toget=1 then do      /* just check 1a */
  if aa='1a'x then iwrite=asize
  checkcrlf=0
end 
else do         /* check last char for 1a */
  if right(aa,1)='1a'x then do
     iwrite=asize
     aa=left(aa,2)
  end 
  else do
    aa=right(aa,2)      /* no 1a, so check last two chars for crlf */
  end 
end 

if checkcrlf=1 then do
  if toget=3 then do      /* look for termainating crlf */
    if aa<>'0d0a'x then astring='0d0a'x||astring
  end
end
if addcrlf=1 then astring=astring||'0d0a'x

/* ready to write */

foo=charout(fulln,astring,iwrite)
foo2=stream(fulln,'c','close')
if foo<>0 then return '-2 problem writing 'foo' bytes '
asize=length(astring)+iwrite-1
return asize


