/* A sample of a SREhttp/2 INTERPRET SSI keyphrase "rexx code block"

   This will display the file that contains the html file that invokes this keyphrase.

   Syntax:
        <!-- Interpret file SHOWFILE.REX  -->
    or
        <!-- Interpret file SHOWFILE.REX  notable , filename , title -->

   The first case will result in the own file (the file containing the
   <!-- INTERPRET ... --> element) being display within a table, using
   PRE formatting, and using the selector as a title.

   Otherwise:

         notable: if not specified: use a table and PRE formatting
                  if notable=1, do NOT use a table and PRE formatting 
                  (unless it's in the document itself, surrounding the
                  <!-- INTERPRET ... --> element).

         filename: fully qualified file to display. This is NOT a selector --
                   it is a fully qualified file name.

         title: if specified, this is displayed as a title. Otherwise, either
                the selector, or filename's  name (without path) is used
                as a title

   Thus, if /FOO/HELLO.SHTML is mapped to  e:\www\foo\hello.shtml, 
   and hello.shtml contains <!-- Interpret file showfile.rex -->
   then the contents of hello.shtml will be displayed.

Note: in the above examples, showfile.rex
      is assumed to be in the (possibly host specific) ADDON directory

*/

tfile=usedfile
if interp_args.2<>'' then do
   tfile=strip(interp_args.2)
end
vsel=''
if interp_args.3<>'' then do
   vsel=strip(interp_args.3)
end

if vsel='' then do 
   vsel=selector
   if tfile<>usedfile then vsel=filespec('n',tfile)
end 

nopre=strip(interp_args.1)
goop=sre_read_file(tfile,1,2) 
if goop<>'' then do 
   goop=sre_html_encode(goop) 
   if nopre<>'1' then do
     return '<table border=1><tr><th align="left">Contents of this file ('||vsel||')</th>'||'<tr><td><pre>'||goop||'</pre></td></table>'||'0d0a'x
   end
   else do
     return goop
   end
end


