/* sample of an SREhttp/2 "pre response" procedure -- add a servername/time tag (or
  response header) to most responses (it is NOT called for addons, cgi-bin
  scripts, and !special commands).

General Info:  

Pre-response  procedures are called (by SREhttp/2) as:

  stuff=sre_preresp_proc(contents,fileflag,mimetype,astring,request,seluse2,privset,host_nickname,id_info)

where:

  contents = the actual contents to be sent to the client, or the fully
             qualified file name
  fileflag = 1 if this is a file, 0 if this is actual contents 
  mimetype = the mime type For example, image/gif or text/plain.
   astring = an optional "selector specific" string
   request = the original request string
   seluse2 = the selector, after redirection, etc.
   privset = client privileges 
   host_nickname = host-nickname of this server
   id_info = useful when using sre2003 procedure

This procedure should reeither
   ''   == when the procedure does nothing (SREhttp/2 will then take care of the response)
   0 rcode  == when the procedure response. rcode is the several word
               response code provided by SRE2003 (when it sent the response)
   1  info '0d0a'x contents == the contents to be sent to the client, 
                                            Info can contain the following SRE_COMMAND("FILE ...") style directives:
                                                  TYPE type/subtype
                                                  EXPIRES nnn
                                                  MD5 or NOMD5
       If INFO is not specified, the content-type (and Expiration and Content-MD5 headers) will not
        be modified.             


Notes on this example:

This procedure will label the origin of this contents:
  text/plain -- a line is added at the top
  text/html  -- an html comment is added at the top
  image/gif -- a gif comment is added at the end
otherwise
  a x-sre_message response header is added

*/


/* Note that the "sre_preresp_proc" procedure name is an arbitrary name
used by srehttp/2 when saving this procedure file to macrospace; you do NOT 
have to use this as a label anywhere in your procedure. */

sre_preresp_proc:
parse arg contents,fileflag,mimetype,astring,req_string,seluse2

if fileflag=1 then 
   jlen=stream(contents,'c','query size')
else
   jlen=length(contents)

call pmprintf('SREhttp/2 pre-response: 'fileflag' content-length = 'jlen ', and content-type= ' mimetype)
tmime=translate(strip(mimetype))

if wordpos(tmime,'TEXT/PLAIN TEXT/HTML IMAGE/GIF')=0 then do
    addaa='X-sre_message: From '||sre_servername()||' on  '||time('n')||' '||date('n')
    foo=sre_command('HEADER ADD 'addaa)
    return ''          /* let sre handle it (though this header will also be sent */
end

if fileflag=1 then do
    cfile=contents
    contents=sre_read_file(cfile,2,5,1)
    if contents='' then do 
          vv=sreh2_value('VERBOSE')
          if vv>0 then call sre_write_error('Empty file in PRE_RESP: 'cfile,,1)
          return ''                  /* something is wierd, so give up */
    end 
end        

select
  when tmime='TEXT/PLAIN'  then do
       addaa='From '||sre_servername()||' on  '||time('n')||' '||date('n')||'0d0a'x||'0d0a'x
       aa=addaa||contents
  end
  when tmime='TEXT/HTML' then do
       addaa='<!-- From '||sre_servername()||' on  '||time('n')||' '||date('n')||'-->'||'0d0a'x
       aa=addaa||contents
  end
  when translate(mimetype)='IMAGE/GIF' then do
     addaa=make_comment('From '||sre_servername()||' on  '||time('n')||' '||date('n'))
     aa=left(contents,jlen-1)||addaa||'3b'x   
  end
  otherwise nop           /* should never happen */
end
return '1 '||'0d0a'x||aa


/***********/
make_comment:procedure
parse arg acomment
aa='21fe'x
aa=aa||chunkit(acomment)
return aa

/***********/
/* make a chewable chunk of data */
chunkit:procedure
parse arg astr,klen
if klen='' then klen=250
mkit=''
lenstr=length(astr)
do mm=1 to lenstr by 250 
   iget=min(250,1+lenstr-mm)
   a1=substr(astr,mm,iget)
   a0=d2c(iget)
   mkit=mkit||a0||a1
end
mkit=mkit||'00'x   
return mkit

