/* 15 March 2004. The combined SRE2003 & SREhttp/2 installation program */


filter_version='1.12d'     /* The current "SREhttp/2 filter" version (used when modifying sre2003.cfg) */

call init_it
crlf='0d0a'x

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the SRE2003 & SREhttp/2 (v 1.12) installation program (17 March 2004)."
call lineout, "... an http/1.1 server for OS/2 "
call lineout, normal


say cy_ye"  Short disclaimer: "normal
say "    SRE2003  & SREhttp/2 are free, and open source -- and we want to hear"
say "    comments & complaints. However, it is NOT warranteed against "
say "    misuse, abuse, security related problems, and other forms of failure."
if yesno(" Would you like to view the disclaimer?",'No Yes','N')=1 then call show_disclaim

say " This installation program program will ask for the names of a few directories,"
say " and will copy a number of files to these directories."
say "  "

aa=yesno(' Would you like to: ','Exit Continue View_Documentation','C')
if aa=0 then do
 say " See you later?.. "
 exit
end
if aa=2 then do
    say " Okay, viewing the SRE2003 manual ... "
     '@START  "The SRE2k Manual" /C /F /WIN NETSCAPE file:///'||directory()||'/SRE2003.HTM'
/* uncomment this to also view srehttp2.htm manual 
     '@START  "The SREhttp/2 Manual" /C /F /WIN NETSCAPE FILE:///'||directory()||'/SREHTTP2.HTM'
*/
    say ' '
end

call check_ip_version   /* check the IP version */
call check_sre_running  /* don't install if sre2003 is running */

call check_macro  /* clear macrospace? */

is_upgrade=yesno(normal" Is this a: "bold" New installation (N), or an upgrade (U)",'New Upgrade')

/* -------- Create directories */
call make_def_dirs

foo=sysfiletree(workdir'\SRE2003.CMD','goo','F')
if is_upgrade=1 & goo.0=0 then do         /*check for prior version */
      say bold"ERROR: "normal" Prior version of SRE2003 "bold"not"normal" detected! "
      exit
end
if goo.0>0  then do             /* backup ? even if "new" installation */
  call do_backup
end

/* --- copy files ... */

if is_upgrade=0 then
  foo=yesno(" SRE2003 & SREhttp/2 will now be installed. Are you ready? ")
else
  foo=yesno(" SRE2003 & SREhttp/2 will now be upgraded. Are you ready? ")

if foo=0 then do
       say "Installation discontinued. "
       say " Please see SRE2003.HTM for more detailed installation instructions."
       exit
end


/** dirs used by sre2003 */

 dlldir=strip(work_dir,,'\')||'\DLL'

 bindir=strip(work_dir,,'\')||'\BIN'

 imdir=strip(work_dir,,'\')||'\BIN\IM'

 cfgdir=strip(work_dir,,'\')||'\CFG'

 logdir=strip(work_dir,,'\')||'\LOG'
 docdir=strip(work_dir,,'\')||'\DOC'
 simpledir=strip(work_dir,,'\')||'\SIMPLE'
 scriptdir=strip(work_dir,,'\')||'\SIMPLE\SCRIPTS'

 sre2kdir=strip(datadir,,'\')||'\SRE2K'
 imgdir=strip(datadir,,'\')||'\SRE2K\IMGS'

/******  dirs used by srehttp2 */
 srehttp2_dir=workdir'\srehttp2'
 h2_addon_dir=workdir'\srehttp2\addon'
 h2_procs_dir=workdir'\srehttp2\procs'
 h2_workdata_dir=workdir'\srehttp2\workdata'
 h2_sysaddon_dir=workdir'\srehttp2\addon\system'

 h2_cfgdir=workdir||'\srehttp2\CFG'
 h2_cgibin_dir=workdir||'\srehttp2\cgi-bin'
 h2_tempdatadir=workdir'\srehttp2\temp'
 h2_ssicachedir=workdir'\srehttp2\temp\ssicache'
 h2_logdir=workdir'\srehttp2\log'

 h2_gifdir=datadir'\sre2k\srehttp2\imgs'
 h2_digitsdir=datadir'\sre2k\srehttp2\imgs\digits'

 h2_helpdir=datadir'\sre2k\srehttp2'
 h2_demos_dir=h2_helpdir'\demos'

/* --- start copying files -- */

say " "
say " Copying  SRE2003 program files "

if gotrxlib=1 then do
   say " Note: a copy of REXXLIB seems to be on your system "
end 

foo=check_copy('filerexx.dll',dlldir,,1)
foo=check_copy('rexxlib.dll',dlldir,,1)
foo=check_copy('rxgzlib.dll',dlldir,,1)
foo=check_copy('srxfunc.dll',dlldir,,1)
foo=check_copy('rxproc.dll',dlldir,,1)
foo=check_copy('mkey.dll',dlldir,,1)
foo=check_copy('unzipapi.dll',dlldir,,1)

foo=check_copy('SRE2003.CMD',workdir,,1)
foo=check_copy('ADD_PLUG.CMD',workdir,,1)
foo=check_copy('SREWATCH.CMD',workdir,,1)
foo=check_copy('DO*.CMD',workdir,,1)
foo=check_copy('GOS2SRE*.CMD',workdir,,1)
foo=check_copy('READ_2K.ME',workdir||'\READ.ME',,1)

adrive=left(workdir,1)
htype=translate(dosfilesys(adrive))
if abbrev(htype,'H')=0 then do
  foo=check_copy('EDIT-2003.CMD',workdir'\EDT-2003.CMD',,1)
  foo=check_copy('EDIT-HTTP2.CMD',workdir'\EDT-HTTP.CMD',,1)
end
else do
  foo=check_copy('EDIT-2003.CMD',workdir,,1)
  foo=check_copy('EDIT-HTTP2.CMD',workdir,,1)
end

/* copy to BIN dir */
foo=check_copy('*.EXE',bindir,,1)
foo=check_copy('SRE_*.RXX',bindir,,1)
foo=check_copy('XRANGE.RXX',imdir,,1)
foo=check_copy('BADIPS.RXX',bindir,,1)
foo=check_copy('BALANCE1.RXX',bindir,,1)
foo=check_copy('TOO_BUSY.RXX',bindir,,1)
foo=check_copy('README.BIN',bindir,,1)

foo=check_copy('SRE2003.RXL',bindir,,1)
foo=check_copy('SRE2003.IDX',bindir,,1)
foo=check_copy('SRE2003A.RXL',bindir,,1)
foo=check_copy('SRE2003A.IDX',bindir,,1)

foo=check_copy('INIT1.RXX',bindir,,1)
foo=check_copy('INITHOST.RXX',bindir,,1)

foo=check_copy('SRE2PRC.ZIP',bindir,,1)
foo=check_copy('MOD_INI.CMD',bindir,,1)

say " Copying  SRE2003 documentation "

foo=check_copy('rxproc.txt',docdir,,1) 
foo=check_copy('rxgzlib.txt',docdir,,1) 
foo=check_copy('srxfunc.txt',docdir,,1) 
foo=check_copy('sre_dmn.txt',docdir,,1) 
foo=check_copy('upgrader.txt',docdir,,1) 
foo=check_copy('sre_dcsh.txt',docdir,,1) 
foo=check_copy('sreapi.txt',docdir,,1) 

foo=check_copy('SRE2003.HTM' ,docdir,,1) 
foo=check_copy('SRE2PRC.HTM' ,docdir,,1) 
foo=check_copy('im_use.HTM' ,docdir,,1) 

/* web accessible documentation */

foo=check_copy('rxproc.txt',sre2kdir,,1)
foo=check_copy('rxgzlib.txt',sre2kdir,,1)
foo=check_copy('srxfunc.txt',sre2kdir,,1)
foo=check_copy('sre_dmn.txt',sre2kdir,,1)
foo=check_copy('sre_task.htm',sre2kdir,,1)
foo=check_copy('im_use.htm',sre2kdir,,1)
foo=check_copy('upgrader.txt',sre2kdir,,1)
foo=check_copy('sre_dcsh.txt',sre2kdir,,1)
foo=check_copy('sreapi.txt',sre2kdir,,1)
foo=check_copy('simple.txt',sre2kdir,,1)

foo=check_copy('index.htm',sre2kdir,,1)
foo=check_copy('sre2003.htm',sre2kdir,,1)
foo=check_copy('sre2prc.htm',sre2kdir,,1)

foo=check_copy(' sre_gos.gif',imgdir,,1)
foo=check_copy(' sre2001.gif',imgdir,,1)
foo=check_copy(' sre2002.gif',imgdir,,1)
foo=check_copy(' sreweb1.gif',imgdir,,1)
foo=check_copy(' sre_bkg.gif',imgdir,,1)
foo=check_copy(' sre2003.gif',imgdir,,1)
foo=check_copy(' sre2k.gif',imgdir,,1)
foo=check_copy(' sre2.gif',imgdir,,1)
foo=check_copy(' sre2anim.gif',imgdir,,1)

say "Copying SRE2003 configuration files "

if is_upgrade=0 then do
  foo=check_copy('HOSTINFO.CFG' ,CFGdir,,1) 
  foo=check_copy('SRE2003.CFG' ,CFGdir,,1) 
  foo=check_copy('BADIPS.IN' ,CFGdir,,1) 
  foo=check_copy('ADD_PLUG.DAT' ,CFGdir,'Are you sure (this is the SRE2003 plugin database)') 
end

say "Copying SIMPLE filter  "

oo=sysfiletree('*.CM_','cms','FO')
foo=check_copy('SIMPLE.*',simpledir,,1)
foo=check_copy('FASTFILT.RXX',simpledir,,1)
do mm=1 to cms.0
   parse var cms.mm afile '.' .
   afile=afile||'.CMD'
   tofile=scriptdir||'\'||filespec('n',afile)
   foo=check_copy(cms.mm,tofile,,1)
end
   
say "  ---- Installing SREhttp/2 components -- "

say " Copying SREhttp/2 program files files to " srehttp2_dir

foo=check_copy('sreh2exi.rxx',srehttp2_dir,,1)
foo=check_copy('attribs.rxx',srehttp2_dir,,1)
foo=check_copy('htaccess.rxx',srehttp2_dir,,1)

foo=check_copy('ssis.rxx',srehttp2_dir,,1)
foo=check_copy('users.rxx',srehttp2_dir,,1)
foo=check_copy('file_csh.rxx',srehttp2_dir,,1)

foo=check_copy('logs.rxx',srehttp2_dir,,1)
foo=check_copy('sreh2ini.rxx',srehttp2_dir,,1)
foo=check_copy('srehttp2.rxx',srehttp2_dir,,1)

foo=check_copy('SREHTTP2.RXL',srehttp2_dir,,1)
foo=check_copy('SREHTTP2.IDX',srehttp2_dir,,1)
foo=check_copy('SREH2PRC.ZIP',srehttp2_dir,,1)
foo=check_copy('STARTREQ.*',srehttp2_dir,,1)

foo=check_copy('CHK_INIT.REX',bindir,,1)
foo=check_copy('CHK_PRE.REX',bindir,,1)


foo=check_copy('ADV_OPTS.SMP',h2_cfgdir,,1)

if is_upgrade=0 then do
  foo=check_copy('NOTFOUND.SHT',srehttp2_dir,'This is the sample "not found" documents file',1)
  say " Copying SREhttp/2 configuration files "
  foo=check_copy('USERS.CFG',h2_cfgdir,' (this is the username/password file')
  foo=check_copy('MIMETYPE.CFG',h2_cfgdir,' (this is the extension-to-mimetype file')
  foo=check_copy('SREHTTP2.CFG',h2_cfgdir,'(this is the configuration file)')
  foo=check_copy('ATTRIBS.CFG',h2_cfgdir,'(this is the selector-specific attributes file')
  foo=check_copy('PRELOADS.CFG',h2_cfgdir,'(this is the LOAD_ADDON file')
  foo=check_copy('LOGS.CFG',h2_cfgdir,'(this is the LOG parameters file')
  foo=check_copy('SSI_VARS.CFG',h2_cfgdir,'(this is the LOAD_ADDON file')
  foo=check_copy('HOSTDATA.CFG',h2_cfgdir,'(this is the host description file')
  foo=check_copy('README.CFG',h2_cfgdir,,1)

  foo=check_copy('SRE_UTIL.CFG' ,h2_cfgdir,'(this is the SRE-utilties CFG file)') 
  foo=check_copy('MANAGER.CFG' ,h2_cfgdir,'(this is the MANAGER cfg file)') 
  foo=check_copy('COUNTER.CFG' ,h2_cfgdir,'(this is the COUNTER.REX cfg file)') 

  foo=check_copy('ACC_FAIL.HTM',h2_cfgdir,,1)
  foo=check_copy('MAX_FAIL.HTM',h2_cfgdir,,1)

  foo=check_copy('ADDONS.INI' ,h2_addon_dir,,'(this is the registry for SREhttp/2 addons)') 

  foo=check_COPY('ROBOTS.TXT',datadir,,'This is the robot exclusion file')

end

say " Copying SREhttp/2 doc & demo files to " h2_helpdir

foo=check_COPY('READ_h2.ME',h2_helpdir||'\READ.ME',,1)

foo=check_COPY('ADDONS.HTM',h2_helpdir,,1)
foo=check_COPY('ATTRIBS.HTM',h2_helpdir,,1)
foo=check_COPY('ADV_OPTS.HTM',h2_helpdir,,1)
foo=check_COPY('ACCESS.HTM',h2_helpdir,,1)

foo=check_COPY('AUDITCNT.HTM',h2_helpdir,,1)
foo=check_COPY('CCDEFN.HTM',h2_helpdir,,1)

foo=check_COPY('CGI-BIN.HTM',h2_helpdir,,1)
foo=check_COPY('ENCRYPT.HTM',h2_helpdir,,1)
foo=check_COPY('HOSTDATA.HTM',h2_helpdir,,1)
foo=check_COPY('HTACCESS.HTM',h2_helpdir,,1)

foo=check_COPY('LOGS.HTM',h2_helpdir,,1)
foo=check_COPY('MIMETYPE.HTM',h2_helpdir,,1)
foo=check_copy('MULTSEND.CMD',h2_helpdir,,1)

foo=check_COPY('NEGOTIAT.HTM',h2_helpdir,,1)

foo=check_COPY('FEATURES.HTM',h2_helpdir,,1)
foo=check_COPY('DOCFILES.HTM',h2_helpdir,,1)

foo=check_COPY('OUTLINE.HTM',h2_helpdir,,1)

foo=check_COPY('POSTRESP.HTM',h2_helpdir,,1)
foo=check_COPY('PRE_RESP.HTM',h2_helpdir,,1)
foo=check_COPY('PRELOAD.HTM',h2_helpdir,,1)
foo=check_COPY('SECURITY.HTM',h2_helpdir,,1)

foo=check_COPY('SREHTTP2.HTM',h2_helpdir,,1)
foo=check_COPY('SREHTTP2.FAQ',h2_helpdir,,1)
foo=check_COPY('SREH2CFG.HTM',h2_helpdir,,1)
foo=check_COPY('SREH2PRC.HTM',h2_helpdir,,1)
foo=check_COPY('SPECIAL.HTM',h2_helpdir,,1)
foo=check_COPY('SSI_VARS.HTM',h2_helpdir,,1)
foo=check_COPY('SSIcache.HTM',h2_helpdir,,1)
foo=check_COPY('SSIS.HTM',h2_helpdir,,1)

foo=check_COPY('USERS.HTM',h2_helpdir,,1)
foo=check_COPY('ACCESS.HTM',h2_helpdir,,1)

foo=check_COPY('counter.txt',h2_helpdir,,1)
foo=check_COPY('chk_404.txt',h2_helpdir,,1)
foo=check_copy('dir.txt',h2_helpdir,,1) 
foo=check_copy('_dir.key',h2_helpdir,,1)
foo=check_copy('_dir.lst',h2_helpdir,,1)

foo=check_COPY('disclaim.txt',h2_helpdir,,1)
foo=check_COPY('dynpwd.txt',h2_helpdir,,1)
foo=check_COPY('dynpriv.txt',h2_helpdir,,1)
foo=check_COPY('enc_Test.txt',h2_helpdir,,1)
foo=check_COPY('FILE_CSH.HTM',h2_helpdir,,1)
foo=check_COPY('home_dir.txt',h2_helpdir,,1)
foo=check_COPY('intro.txt',h2_helpdir,,1)
foo=check_COPY('multsend.txt',h2_helpdir,,1)
foo=check_COPY('mtchfile.txt',h2_helpdir,,1)
foo=check_COPY('manager.txt',h2_helpdir,,1)
foo=check_COPY('perl.txt',h2_helpdir,,1)

foo=check_COPY('timefmt.txt',h2_helpdir,,1)


foo=check_COPY('todo.txt',h2_helpdir,,1)
foo=check_COPY('unzipapi.txt',h2_helpdir,,1)

foo=check_copy('SREH2A.GIF',h2_helpdir,,1)
foo=check_copy('SREH2A.GIF',h2_gifdir,,1)
foo=check_copy('SC*.GIF',h2_gifdir,,1)

foo=check_copy('GIFS.ZIP',h2_gifdir,,1)
foo=check_copy('DIGITS.ZIP',h2_digitsdir,,1)
foo=check_copy('NOVU.HTM',h2_gifdir,,1)
foo=check_copy('IMGINTRO.HTM',h2_gifdir,,1)


/* demos, and configuration tools, to h2_demos_dir */
foo=check_COPY('CONFIGS.HTM',h2_demos_dir,,1)

foo=check_COPY('_COMMAND.SHT',h2_demos_dir,,1)

foo=check_copy('cntdemo1.SHT',h2_demos_dir,,1)
foo=check_copy('cntdemo2.SHT',h2_demos_dir,,1)
foo=check_COPY('CONGRESS.DAT',h2_demos_dir,,1)
foo=check_COPY('CONGRESS.HTM',h2_demos_dir,,1)

foo=check_copy('dointerp.SHT',h2_demos_dir,,1)
foo=check_copy('demos.HTM',h2_demos_dir,,1)
foo=check_COPY('_dir.sht',h2_demos_dir,,1)

foo=check_copy('DYNPTST*.SHT',h2_demos_dir,,1)

foo=check_copy('DOSELECT.SHT',h2_demos_dir,,1)
foo=check_copy('ENC_FORM.RSP',h2_demos_dir,,1)
foo=check_copy('ENC_SREB.RSP',h2_demos_dir,,1)
foo=check_copy('ENC_test.SHT',h2_demos_dir,,1)
foo=check_copy('ENC_test.txT',h2_demos_dir,,1)
foo=check_copy('iftest.SHT',h2_demos_dir,,1)
foo=check_copy('INTRO.TXT',h2_demos_dir,,1)
foo=check_COPY('MESSAGES.SHT',h2_demos_dir,,1)
foo=check_copy('replaces.SHT',h2_demos_dir,,1)
foo=check_copy('restart.htm',h2_demos_dir,,1)

foo=checK_COPY('SAMPMAP.*',h2_demos_dir,,1)
foo=check_copy('showfile.SHT',h2_demos_dir,,1)
foo=check_copy('TSTHTTPD.SHT',h2_demos_dir,,1)

foo=check_COPY('TXT_FIND.HTM',h2_demos_dir,,1)
foo=check_COPY('TXTFIND2.HTM',h2_demos_dir,,1)

foo=check_COPY('UPLOAD.HTM',h2_demos_dir,,1)
foo=check_COPY('SENDFILE.HTM',h2_demos_dir,,1)
foo=check_copy('xssi.SHT',h2_demos_dir,,1)
foo=check_COPY('VULOGS.HTM',h2_demos_dir,,1)

say " Copying CGI-Bin scripts and addons "

foo=check_copy('XCOUNT.CMD',h2_cgibin_dir,,1)
foo=check_copy('JCOUNT.CMD',h2_cgibin_dir,,1)
foo=check_copy('TEST-CGI.CMD',h2_cgibin_dir,,1)
foo=check_copy('TXTCLOCK.PL',h2_cgibin_dir,,1)
foo=check_copy('TEXTCLOCK.PL',h2_cgibin_dir,,1)
foo=check_copy('SNDMAILX.CMD',h2_cgibin_dir,,1)


/* SSI interpret files to addon_dir */
foo=check_copy('SHOWFILE.REX' ,h2_addon_dir,,1) 
foo=check_copy('DIRINFO.REX' ,h2_addon_dir,,1) 
foo=check_copy('COUNTER.REX' ,h2_addon_dir,,1) 
foo=check_copy('INTERP.REX' ,h2_addon_dir,,1) 

/* addons */

foo=check_copy('ADDONLST.CMD',h2_addon_dir,,1)
foo=check_copy('_DIR.CMD' ,h2_addon_dir,,1) 
foo=check_copy('CHK_RED.CMD',h2_addon_dir,,1)
foo=check_copy('CHK_PENL.CMD',h2_addon_dir,,1)
foo=check_copy('DYNPRIV.REX',h2_addon_dir,,1)
foo=check_copy('DYNP_LOG.CMD',h2_addon_dir,,1)

foo=check_copy('ENC_TEST.CMD',h2_addon_dir,,1)
foo=check_copy('MAPIMAGE.CMD',h2_addon_dir,,1)
foo=check_copy('MULTSEND.CMD',h2_addon_dir,,1)
foo=check_copy('MANAGER.CMD',h2_addon_dir,,1)

foo=check_copy('README.ADD',h2_addon_dir,,1)

foo=check_copy('SRE_UTIL.CMD' ,h2_addon_dir,,1) 
foo=check_copy('STATUS.CMD',h2_addon_dir,,1)
foo=check_copy('TASKDEMO.ZIP',h2_addon_dir,,1)
foo=check_copy('TSTDIGIT.CMD',h2_addon_dir,,1)
foo=check_copy('TESTDYN.CMD',h2_addon_dir,,1)
foo=check_copy('TXT_FIND.CMD',h2_addon_dir,,1)


foo=check_copy('EXEC_SMP.REX',h2_procs_dir,,1)
foo=check_copy('PACKBACK.REX',h2_procs_dir,,1)
foo=check_copy('MAX_USER.REX',h2_procs_dir,,1)

/* copy pre-response, post-response, exec procs to h2_procs_dir */
foo=check_copy('CHK_POST.REX',h2_procs_dir,,1)
foo=check_copy('ENCRYPT.REX',h2_procs_dir,,1)
foo=check_copy('GZIP.REX',h2_procs_dir,,1) 
foo=check_copy('MTCHFILE.REX' ,h2_procs_dir,,1) 
foo=check_copy('NEGOT.REX',h2_procs_dir,,1)
foo=check_copy('PROCS.REG',h2_procs_dir,,1)
foo=check_copy('MTCHFILE.REX' ,h2_procs_dir,,1) 
foo=check_copy('MULTPART.REX' ,h2_procs_dir,,1) 

foo=check_copy('PRE_RESP.REX',h2_procs_dir,,1)

foo=check_copy('POSTMAIL.REX',h2_procs_dir,,1)
foo=check_copy('POSTRCRD.REX',h2_procs_dir,,1)
foo=check_copy('POSTRESP.REX',h2_procs_dir,,1)

foo=check_copy('README.PRC',h2_procs_dir,,1)

foo=check_copy('TESTDYN.RSP',h2_procs_dir,,1)
foo=check_copy('DYNPWD*.RSP',h2_procs_dir,,1)

foo=check_copy('ENC_FORM.RSP',h2_procs_dir,,1)
foo=check_copy('ENC_SREB.RSP',h2_procs_dir,,1)

foo=check_copy('DE_*.CMD',h2_procs_dir,,1)
foo=check_copy('CUST_USR.REX',h2_procs_dir,,1)

/* system utilities & on-line configurators */
oo=sysfiletree('*.CM2','cms','FO')
do mm=1 to cms.0
   parse var cms.mm afile '.' .
   afile=afile||'.CMD'
   tofile=h2_sysaddon_dir||'\'||filespec('n',afile)
   foo=check_copy(cms.mm,tofile,,1)
end


/* unzip image containing zip files */
foo=unzip_it('GIFS',h2_gifdir)

foo=unzip_it('DIGITS',h2_digitsdir)


say " --- Set a few SREhttp/2 parameters --- "


if is_upgrade=0 then do
  say " "
  say " Configuring SRE2003.CFG "
  cfgfile=cfgdir||'\SRE2003.CFG'
  call modify_cfg cfgfile
  foo=add_user(h2_cfgdir)          /*  add entry to users.cfg file */
  say " "
end

/* -- add to ADD_PLUG.DAT */
if is_upgrade<>1 then foo=add_plug(cfgdir)

sre2003_dir=sysini('USER','SRE2K','SRV_DIR',workdir)
GG=STRIP(SREHTTP2_DIR,,'\')||'\SREHTTP2.RXX'
filtername=sysini('USER','SRE2K','FILTER',GG)
filter_dir=sysini('USER','SRE2K','FILTER_DIR',SREHTTP2_DIR)
datadir=sysini('USER','SRE2K','DATADIR',DATADIR)



/* ----------------- installation complete --------- */

a=scrclear()

call lineout, bold cy_ye  " SRE2003 & SREhttp/2 have been installed... " normal
say " "
say ' Your web site is now ready to be built!  '
say '      (just add documents, images, links, etc...)'
say ' '
say ' Notes:'
say '    * To start, run SRE2003.CMD (in 'work_dir')'
say '    * The SRE2003.CFG configuration files are in: '||reverse||cfgdir||normal
say '      Hint: use 'workdir'\EDIT-2003.CMD to edit these files.'
say '    * The SREhttp/2 configuration files are in 'reverse||h2_cfgdir||normal
say '      Hint: use 'workdir'\EDIT-HTTP2.CMD to edit these files.'
say '    * SRE2003.HTM (in 'docdir') is the SRE2003 manual'
say '    * SREHTTP2.HTM (in 'h2_helpdir') is the SREhttp/2 manual'
say '      It contains links to more documents, on-line configurators, and demos.'
say '      To view it: point your browser at /SRE2K/SREHTTP2/SREHTTP2.HTM'
if is_upgrade=1 then do
  say '    * 'bold'Upgraders Note:'normal' If you modified advanced-user options in SRE2003.CMD  '
  say '      (and elsewhere), you will need to re-enter those changes. '
end
say '    * 'bold'Security Tip:'normal' The SECURITY_LEVEL parameter (in SRE2003.CFG) can be used'
say '      to disable the web-based configuration tools.'

exit



/* ----------------------------------------------------------------------- */
/* HOST -- return the result of a HOST command  (a ping )                  */
/* ----------------------------------------------------------------------- */
/* This need not be in the main filter program                             */
  host: procedure
   parse arg eek
    do queued(); pull .; end                   /* flush */
    address cmd '@host' eek '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */
    return hostresult

/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno0:procedure expose normal reverse bold
parse arg fooa , allopt
ayn='  '||bold||'Y'||normal||'es\'||bold||'N'||normal||'o'
do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,'Y')=1 then return 1
 if abbrev(anans,'N')=1 then return 0

end



/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye     mm0a listfile
parse arg amessage , altans,def,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

do forever
 foo1=normal||reverse||amessage||'? '||normal||aynn||': 'normal
 goo=amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 anans=translate(sysgetkey('echo'))

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0  then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end



/* ------------------------ */
/* ask for directory name,use defname2 as default */
/* give user opportunity to create it */

get_dir:procedure expose normal reverse bold re_wh
/* procedure expose reverse normal bold */
parse arg defname2 , mustsub, chkhpfs
defname0=defname2

n2:
call charout ,'   '  reverse ' <ENTER>=' defname2  normal ' ?'
pull godir

if godir=" " then godir=defname2
if godir="n.a." then signal n2


if mustsub<>"" then do    /* check 'must be subdirectory' option */
  if abbrev(godir,mustsub)=0 then do
     say " This directory MUST be under the " mustsub " directory! "
     say "  .. please re enter ! "
     signal n2
  end
end

godir=strip(godir,'t','\')


adrive=left(godir,1)
htype=translate(dosfilesys(adrive))
if abbrev(htype,'H')=0 then do
    say "Warning: although not required, we recommend installing SRE2003 on "
    say '         an HPFS drive. Your chosen drive, 'adrive', is 'htype
    yy=yesno('Would you like to choose a different directory')
    if yy=1  then signal n2
end 


isme=directory()

isnew=directory(godir)
if isnew="" then do
   say "    Could not find  " godir
   if yesno(normal"        "re_wh"Would you like to create it")=1 then do
        oo=sysmkdir2(godir)
        if oo=0  then
           say "      Directory created: " godir
        else do
           say "      Could not create " godir "(error = " oo
           if godir=defname2 then defname2= "n.a."
           signal n2
        end
   end
   else do
        say " please reenter directory name ... "
        if godir=defname2 then defname2= "n.a."
        signal n2
   end
end  /* Do */


isme=directory(isme)



return godir

/* ------------- */
sysmkdir2:procedure
parse arg adir

adir=strip(adir,'t','\')
ff=sysmkdir(adir)
if ff=0 then return ff

/* make the tree */
f2=adir'\'
dd=filespec('d',f2)
pp=filespec('p',f2)
if pp='\' | pp='' then return -1

pp2=strip(translate(pp,' ','\'))

do mm=1 to words(pp2)
   a1=subword(pp2,1,mm)
   a1=translate(a1,'\',' ')
   dd2=dd'\'a1
   hoo=sysmkdir(dd2)
   if hoo=0 then say ' ... creating: 'dd2  
end /* do */

return hoo


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/* ----------------------------------------------------------------------- */
/* GRAB_FILE read in a file, but first check to see if openable, and if
.   openable, open and read it.
.    Returns with the file, or with 0 if file not obtainable.
.    Note that file is closed before returning
.   in,
.    usage:   afile_string=grab_file(the_file,seconds_to_try_for)
*/
/* ----------------------------------------------------------------------- */


grab_file: procedure

parse arg afile

ause=stream(afile,'c','open read')
if ause<>"READY:" then
  return 0

goo=charin(afile,1,chars(afile))
ause=stream(afile,'c','close')

/* get rid of ending ctl-z */
if c2d(right(goo,1))=26 then
  goo=left(goo,length(goo)-1)

return goo


/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose  reverse bold normal re_wh cy_Ye COPYALL
parse arg file1, dest1 , amess , noask
dest2=strip(dest1,'t','\')||'\'

filename=dest1
if pos('.',dest1)=0 then filename=dest2||file1


aa=sysfiletree(filename,isit,'F')
ok=1
if aa<>0 then do
   say " Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if noask=1 then signal doit3

if isit.0>0 then do
  if pos('*',file1)=0 then do
       if copyall=1 then do
             ok=1
       end 
       else do
           say " "
           say " A file exists with the name: " filename
           if amess<>'' & amess<>'1' then say " .... " amess
           ok=yesno(" Do you want to overwrite this file? ",'No Yes All')
           if ok=2 then do 
                ok=1 ; copyall=1
           end 
       end
  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ")
      if ok=1 & amess<>""  then ok=yesno(amess'No Yes All')
  end  /* Do */
end
if ok=0 then return 0

doit3:          /* jump here if noask=1 */
'COPY ' file1 dest1 ' > NUL '
if rc<>0 then do
   say "Error: unable to copy "file1" to "dest1 
   iexit=yesno("Exit? ",'No Yes ','Y')
   if iexit=1 then  exit
end
return 1




 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure expose re_wh
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname | rxqueue'

    parse pull hostname
    return hostname



/******/
get_work_dir:

call lineout, bold  " What is SRE2003's working directory? " normal
say "    *  This is where the SRE2003 program files will be installed. "

n1:
work_dir=get_dir(defname)

return 0

/**********/
get_www_dir:

say " "
call lineout, BOLD " What is your data directory ?" normal
say  '    .. this is  the location of your "home page" document. '

datadir=get_dir(defname2)
return 0

/******* NOT CURRENTLY USED **/
get_ip_address:
say "What is your IP address (it will be given OWNERS status)"
h2_addon_dirdr=" "
thishost=get_hostname()
sagain:
call charout , BOLD "What is your IP address (ENTER="thishost "):? " normal
pull youraddr
if youraddr=' ' then youraddr=thishost

parse var youraddr t1 '.' .
isnum=0
if  datatype(t1)='NUM' then
  isnum=1
say " wait while that address is checked ... "
chk=host(youraddr)
if translate(word(chk,2))<>"IS" &  word(chk,2)<>"=" then do
    call lineout,re_wh " Unable to find  address: " youraddr normal
    say "    OWNER variable not assigned (but you can assign it later)"
    h2_addon_dirdr=" "
end  /* Do */
else do
   if isnum then
     ipaddr=word(chk,1)
   else
     ipaddr=word(chk,3)

   say " Your IP address: " ipaddr
end
return 0

/***************/
init_it:

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

nowdir=directory()

copyall=0
thishost=' '

initfilt_file=''
echo off


/* --- Load the tcp/ip function library, if necessary --- */
if RxFuncQuery("SockLoadFuncs")=1 then  do    /* not there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

thishost=' '


parse version  atype .
if atype<>"REXXSAA" then do
 say    " WARNING: SRE2003 is designed to work under Classic Rexx "
 say     " In particular, it does NOT work under Object Rexx. "
 say     " Other versions of REXX, such as Quercus's REXX, have not been tested."
 say " Note: You are using REXX version: " atype
 say " (hit ENTER to continue) "
  pull .
end  /* Do */


/*---- load the rexxlib library */
droprxlib=0 ; gotrxlib=1
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 droprxlib=1 ; gotrxlib=0
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find the REXXLIB procedure library (REXXLIB.DLL). "
    exit
end  


ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  Install will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

/* some defaults */
    datadir="your  Data-directory"
    workdir="your  Working-directory"


return 0


/*********/
check_macro:
if macroquery('SRE_COMMAND')<>"" then do
     say " "
     say bold "A prior version of the SRE2003 macrospace procedures"normal
     say " was detected. We recommend clearing macrospace before you install SRE2003."
     say " However, this might adversely impact other programs (that may also "
     say " use REXX's macrospace). "
     ok=yesno(" Clear macrospace now (Y) ?")
     if ok=1 then do
        say " .... clearing macrospace "
        foo=macroclear()
        say " "
     end  /* Do */
     else do
          say " "
        say  bold " Macrospace will not be cleared. " normal
        say " When you are ready to run SRE2003, we recommend "
        say " that you first reboot your server."
          say " "
     end  /* Do */
end  /* Do */
return 0


/************/
make_def_dirs:

    adir=filespec("drive",nowdir)
    defname=adir||'\SRE2003'
    defname2=adir||'\WWW'

    call get_work_dir        /* but ask for a few directories */
    workdir=work_dir

    call get_www_dir

    gosds='BIN DLL BIN\IM TEMP CFG CFG\OLD DATA LOG DOC SIMPLE BAK SIMPLE\SCRIPTS LOG\ARC'

    gosds.1='SREHTTP2 SREHTTP2\TEMP  SREHTTP2\TEMP\FILE_CSH '
    gosds.2='SREHTTP2\CGI-BIN SREHTTP2\ADDON SREHTTP2\ADDON\SYSTEM'
    gosds.3='SREHTTP2\CFG SREHTTP2\CFG\OLD SREHTTP2\LOG'
    gosds.4='SREHTTP2\LOG\OLD SREHTTP2\WORKDATA'
    gosds.5='SREHTTP2\WORKDATA\MESSAGE SREHTTP2\WORKDATA\MAIL'
    gosds.6='SREHTTP2\PROCS SREHTTP2\UPLOAD'


   do jj=1 to 6
      gosds=gosds||' '||gosds.jj
   end 

    wwwds.1='SRE2K SRE2K\IMGS SRE2K\SREHTTP2  SRE2K\SREHTTP2\DEMOS  '
    wwwds.2='SRE2K\SREHTTP2\IMGS SRE2K\SREHTTP2\IMGS\DIGITS  SRE2K\SREHTTP2\APPS '
    wwwds=wwwds.1||' '||wwwds.2

   say '   'bold||"Note:"||normal||" a number of sub-directories will be created under "
   say "           "work_dir 
   say "        and "
   say "           "datadir
   say ' '

    do ii=1 to words(gosds)
       a1=strip(word(gosds,ii))
       mdd=workdir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do 
            say 'ERROR: Could not create 'mdd ', error code= ' oo
            exit
         end /* do */
       end
    end /* do */
    do ii=1 to words(wwwds)
       a1=strip(word(wwwds,ii))
       mdd=datadir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do 
            say 'ERROR: Could not create 'mdd ', error code== ' oo
            exit
          end /* do */
       end
    end /* do */



return 1


/**************************************/
/* backup prior version */
do_backup:

 say " "
 foo=yesno(normal" "re_wh"Would you like to archive the various configuration files",,'Y')
 if foo=1 then do
      say  " Archive directory for some SRE2003 & SREhttp/2 files: "
      aa="\BAK\BK"||space(translate(date('o'),' ','/\'),0)
      backup_dir=strip(get_dir(workdir||aa),,'\')||'\'
/* files to backup*/

      baks='SIMPLE\SIMPLE.RXX SIMPLE\FASTFILT.RXX SRE2003.CMD CFG\SRE2003.CFG '
      baks=baks||' CFG\BADIPS.IN CFG\HOSTINFO.CFG SREWATCH.CMD'

      baks=baks||' SREHTTP2\NOTFOUND.SHT  SREHTTP2\SREHTTP2.RXX SREHTTP2\SREH2INI.RXX SREHTTP2\PROCS\MTCHFILE.REX  SREHTTP2\PROCS\POSTRESP.REX SREHTTP2\PROCS\PROCS.REG '
      baks=baks||' SREHTTP2\CFG\MIMETYPE.CFG SREHTTP2\CFG\SRE_UTIL.CFG SREHTTP2\CFG\USERS.CFG SREHTTP2\CFG\SSI_VARS.CFG '
      baks=baks||' SREHTTP2\CFG\ATTRIBS.CFG SREHTTP2\CFG\SREHTTP2.CFG SREHTTP2\CFG\HOSTDATA.CFG  SREHTTP2\CFG\PRELOADS.CFG  SREHTTP2\CFG\LOGS.CFG '

     nocopy=0 ; yescopy=0
     do mm=1 to words(baks)
          a1=strip(word(baks,mm))
          oldfile=workdir||'\'||a1
          goo=stream(oldfile,'c','query exists')
          if goo='' then do
                say "Could not find "oldfile
                nocopy=nocopy+1
                iterate
          end /* do */
          tfile=backup_dir||a1
          newname=filespec('n',tfile)
          newfile=backup_dir||newname
          foo=check_copy(oldfile,newfile,,1)    
          goo=stream(newfile,'c','query exists')
          if newfile<>'' then do
              yescopy=yescopy+1
          end
          else do
             say "Problem copying "oldfile " to " newfile
             nocopy=nocopy+1
          end
     end 
     if yescopy>0 then say yescopy||' files were copied to 'backup_dir
     if nocopy>0 then say nocopy||' files were NOT copied to 'backup_dir

     say
      yooba=sysfiletree(workdir||'\BK*','goos','OD')

      if goos.0>1  then do
          say bold' Reminder:'normal' you have 'goos.0 ' SRE2003 archive directories; you might  '
          say     '          want to remove some of the older ones. '
      end /* do */
 end
return 0


/********************/
append_file:procedure
parse arg filename,astring,ntries,addcrlf

if ntries='' | ntries=0 then ntries=1
isnew=0

fulln=stream(filename,'c','query exists')

if fulln<>'' then do    /* does exist, get size */
 do ll=1 to ntries               /* sometimes file exists but hasn't been written */
   asize=stream(fulln,'c','query size')
   if asize=''  then do
     if ll=ntries then  return '-1 '||filename' problem reading size '
     call syssleep(1)
     iterate
   end
   leave
 end
end
else do
   fulln=filename               /* create file */
   isnew=1
end

/* now open it */
do jj=1 to ntries
   astat=stream(fulln,'c','open')
   if abbrev(strip(translate(astat)),'READY')=0 then do
     if jj=ntries  then  return '-1 '||fulln' could not be opened'
     call syssleep(1)
     iterate
   end
   leave
end
  
/* if no such file, create it now */
if isnew=1 | asize=0  then do
   if addcrlf=1 then astring=astring||'0d0a'x
   foo=charout(fulln,astring,1)
   foo2=stream(fulln,'c','close')
   if foo<>0 then return '-2 unable to write 'foo' bytes '
   asize=length(astring)
   return asize
end

/* now get last 3 characters  */
iat=asize-2
toget=3
if iat<3 then do 
   toget=1   /* just look for 1a */
   iat=asize
end
aa=charin(fulln,iat,toget)

iwrite=asize+1          /* where to write astring */

checkcrlf=addcrlf
if toget=1 then do      /* just check 1a */
  if aa='1a'x then iwrite=asize
  checkcrlf=0
end 
else do         /* check last char for 1a */
  if right(aa,1)='1a'x then do
     iwrite=asize
     aa=left(aa,2)
  end 
  else do
    aa=right(aa,2)      /* no 1a, so check last two chars for crlf */
  end 
end 

if checkcrlf=1 then do
  if toget=3 then do      /* look for termainating crlf */
    if aa<>'0d0a'x then astring='0d0a'x||astring
  end
end
if addcrlf=1 then astring=astring||'0d0a'x

/* ready to write */

foo=charout(fulln,astring,iwrite)
foo2=stream(fulln,'c','close')
if foo<>0 then return '-2 problem writing 'foo' bytes '
asize=length(astring)+iwrite-1
return asize


/*********/
check_macro:
if macroquery('SREH2_VALUE')<>"" then do
     say " "
     say bold "A prior version of the SREhttp/2 macrospace procedures"normal
     say " were detected. We recommend clearing macrospace before you install SREhttp/2."
     say " However, this might adversely impact other programs (that may also "
     say " use REXX's macrospace). "
     ok=yesno(" Clear macrospace now (Y) ?")
     if ok=1 then do
        say " .... clearing macrospace "
        foo=macroclear()
        say " "
     end  /* Do */
     else do
          say " "
          say  bold " Macrospace will not be cleared. " normal
          say " "
     end  /* Do */
end  /* Do */
return 0


/*****************/
/* Add a record  to the add_plug.dat file */
add_plug:procedure 

parse arg cfgdir

/* read users.cfg, append uname pwd , write it*/
afile=strip(cfgdir,'t','\')||'\ADD_PLUG.DAT'

oof='0d0a0d0a'x
oof=oof||'Name: The SREhttp/2 Filter '||'0d0a'x
oof=oof||'Desc: SREhttp/2 is a full featured filter for SRE2003.'||'0d0a'x
oof=oof||'Desc: This will select SREhttp/2 with several defaults (any other currently active '||'0d0a'x
oof=oof||'Desc: plugins will be deselected)'||'0d0a'x

oof=oof||'Item: Filter srehttp2\srehttp2.rxx '||'0d0a'x
oof=oof||'Item: Fast_Filter 0 '||'0d0a'x
oof=oof||'Item: Filter_Version SREhttp/2 ver '||filter_version||'0d0a'x
oof=oof||'Item: INIT_PROC srehttp2\SREH2INI.RXX,srehttp2\STARTREQ.CMD '||'0d0a'x 
oof=oof||'Item: EXIT_PROC srehttp2\sreh2exi.rxx '||'0d0a'x
oof=oof||'Item: PRE_Transaction bin\badips.rxx  '||'0d0a'x
oof=oof||'Item: PRE_Request 0  '||'0d0a'x
oof=oof||'Item: IM_TYPES XRANGE bin\im\xrange.rxx '||'0d0a'x
oof=oof||'Item: IM_DEFAULT Range '||'0d0a0d0a'x

foo=append_file(afile,oof,2,1)
if foo<0 then 
  say 'Error ('foo') adding to 'afile
else
  say "Note: an SREhttp/2 record was added to the SREhttp/2 plug in database" 

return 1


/*****************/
/* Add an entry to the users.cfg file */
add_user:procedure expose  expose reverse bold normal re_wh cy_ye aesc

parse arg cfgdir

say " "
say  bold " Add a SUPERUSER to the UserName database " normal
say " "
say ' To facilitate resetting parameters, and other such actions, we recommend that '
say ' you add a  user, with SUPERUSER privileges, to the SREhttp/2 UserName database.'

ok=yesno(normal'    're_wh' Would you like add a SUPERUSER ','No Yes','N')
say " "
if ok=0 then do
   say " You can add a user with SUPERUSER privileges by editing USERS.CFG "
   return 0
end

bugs: nop
 call charout, bold " Enter a username: " normal
 uname=stringin(,23," ",80)
 say " "

 call charout, bold " Enter a password: " normal
 pwd=stringin(,23," ",80)
 say " "

if uname="" | pwd="" then do
    say " missing username or password: please reenter "
    signal bugs
end  /* Do */


/* read users.cfg, append uname pwd , write it*/
afile=strip(cfgdir,'t','\')||'\USERS.CFG'
oof=stream(afile,'c','open')
kk=stream(afile,'c','query size')
new1=uname' 'pwd' SUPERUSER '
if kk=0 | kk='' then do
  oog=charout(afile,new1,1)
  oof=stream(afile,'c','close')
end 
else do
  new1='0d0a'x||new1
  oof=charin(afile,kk,1)
  if oof='1a'x then kk=kk-1
  kk=kk+1
  afr=stream(afile,'c','seek 'kk)
  oog=charout(afile,new1)
  oof=stream(afile,'c','close')
end 
say " A SUPERUSER has been added, with: "
say bold uname normal " for the username, and " bold pwd normal " for the password "
return 1



/********/
modify_cfg:
parse arg oldcfg

iff=stream(oldcfg,'c','query size')
stuff=charin(oldcfg,1,iff)
goo=stream(oldcfg,'c','close')

/* now set
   DATADIR
   FILTER
   FILTER_VERSION
   INIT_PROOC
   EXIT_PROC
*/
newstuff=''
do forever
   if stuff='' then leave
   parse var stuff aline '0d0a'x stuff ; aline=strip(aline)
   if aline='' |  abbrev(aline,';')=1 then do
       newstuff=newstuff||aline||'0d0a'x
       iterate
   end

   parse var aline avar '=' aval
   avar=strip(translate(avar))

   select
      when avar='DATADIR' then do
          newstuff=newstuff||'datadir='||datadir||'0d0a'x
      end 
      when avar='FILTER' then do    
          newstuff=newstuff||'FILTER=srehttp2\srehttp2.rxx'||'0d0a'x
      end 
      when avar='FILTER_VERSION' then do
          newstuff=newstuff||'FILTER_VERSION=SREhttp/2 ver '||filter_version||'0d0a'x
      end
      when avar='INIT_PROC' then do
          newstuff=newstuff||'init_proc=srehttp2\SREH2INI.RXX,srehttp2\STARTREQ.CMD'||'0d0a'x
      end
      when avar='EXIT_PROC' then do
          newstuff=newstuff||'exit_proc=srehttp2\sreh2exi.rxx'||'0d0a'x
      end
      otherwise do
         newstuff=newstuff||aline||'0d0a'x
      end
   end  /* select */
end /* do forever */


cfg1=oldcfg
foo=sysfiledelete(cfg1)

oo=charout(cfg1,newstuff,1)
foo=stream(cfg1,'c','close')
say "Done writing to " cfg1 
return ' '



/*********************************/
/* display the disclaimer */

show_disclaim:
say
say reverse "          Summary of the SRE2003 & SREhttp/2 disclaimer"normal
say bold"The complete disclaimer is  contained in SRE2003.HTM"normal
say "  With some provisos, permission to use the SRE2003 family of programs "
say "  (including SRE2003, SREhttp/2, SREhttp/2 addons, etc.) for any "
say "  purpose is hereby granted without fee. These provisos include:" 
say "   * the author's name may not be used in advertising or "
say "     publicity pertaining to distribution of the software "
say "     without specific written prior permision."
say "   * The authors of the SRE2003 family of products, and any potentially "
say "     affiliated institutions disclaim any and all liability for damages due "
say "     to the use,  misuse, or failure of this product or related products."
say "         In particular, SRE2003 and related products are NOT "
say "         guaranteed to be secure.  Although we design and code our "
say "         product with attention to potential security holes, "
say "         we can NOT guarantee security."

    call charout , cy_ye ' (hit any key to continue) ' normal
    foo=SYSGETKEY("NOECHO")
say
return


/******************/
check_ip_version:procedure
/* first, check tcp/ip version -- suggest upgrade */
'@inetver | rxqueue '
oy=''
do until queued()=0
   pull oy 1
   oy=oy||oy1
end /* do */
parse var oy . ':' aver 
parse var aver mainver '.' subver
if mainver='4' then do
  if subver<'02T' then do
      say
      say bold"WARNING: " normal" Your TCP/IP version is "aver
      say "           We "bold"STRONGLY"normal" recommend upgrading to 4.02t (or above)"
     if yesno(" Continue installing SRE-http (and upgrade TCP/IP later)?")=1 then do
        say "   Okay, but you may experience sporadic errors."
        say ' '
     end
     else do
        say "As of 10 Dec 1998, 4.02t info can be found at: "
        say "   ftp://ps.software.ibm.com/ps/products/tcpip/rsu/stack/latestv4.html"
        say
        say "See you later.... "
        exit
     end /* do */
  end
end
return 1

/***********************/
check_sre_running:
/* check status of sre2003 and macrospace routines */
a=dospidlist(l1,l2)
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if foo='SRE2003' then do
     say bold " SRE2003 appears to be running " normal 
     say "(process list has: "l2.mm ')'
     say " Please shut down SRE2003 before you (re) install SREhttp/2! "
     exit
  end  /* Do */
end /* do */
/* check status of sre2003 and macrospace routines */
a=dosswitchlist(l2)
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if pos('SRE2003',foo)>0 then do
     say bold " SRE2003 appears to be running " normal
     say "(switchlist has: "l2.mm ')'
     say " Please shut down SRE2003 before you (re) install SREhttp/2! "
     exit
  end  /* Do */
end /* do */
return 1 


/****************************/
unzip_it:procedure 
parse arg afile,adir
say
say 'Copying files in '||afile||'.ZIP'||' to '||adir
ccmd='@UNZIP -qq -o  '||adir||'\'||afile||' '||' -d '||adir|| ' 1>> nul '
signal on error name goo1

address cmd ccmd
goo1:
res1=rc

if res1<>0 then do
   say 'Error unzipping '||afile||'.ZIP ('||res1||'). You should: '
   say '   CD to '||adir
   say '   UNZIP 'afile||'.ZIP'
   say '(press ENTER to continue)'
end 
return 1



