/* clean up temporary and semi-permanent (cache) files */
cleanup:


parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs

call sec_check
res1=result
if res1<>0 then return res1

desc.!TEMP='SRE2003 temporary files '
desc.!CFG='SRE2003 old configuration files '
desc.!LOG='SRE2003 old log files '
desc.!DELTA='SRE2003 delta-encoding-module file-cache '

desc.!H2TEMP='SREhttp/2 temporary files '
desc.!H2CFG='SREhttp/2 old configuration files'
desc.!H2LOG='SREhttp/2 old log files '

desc.!WD='SREhttp/2 counter and other working data files '
desc.!MESSAGES='SREhttp/2 message-box '
desc.!MAIL='SREhttp/2 mail '
desc.!UPLOADS='SREhttp/2 upload '
desc.!FILE_CSH='SREhttp/2 file-cache '


parse var uri thisaddon '?' .
dodel.=''
nfiles=0
vars.=''
vars.!DELETE=0

do until list=''
   parse var list a1 '&' list
   parse var a1 a1a '='a1b
   ee='!'||translate(strip(a1a))
   vv=sre_packur(translate(a1b,' ','+'))
   if ee='!FILE' then do
       nfiles=nfiles+1
       tvv='!'||strip(translate(vv))
       dodel.tvv=1
       vars.!DELETE=nfiles
   end
   else do
      vars.ee=strip(vv)
   end
end

if vars.!MODE=1 then do
   call mode1a
   return rcode
end 

if vars.!MODE=11 then do
   call mode11
   return rcode
end 

if vars.!MODE=12 then do
   call mode12a
   return rcode
end 


if vars.!MODE='12B' then do
   call mode12b
   return rcode
end 

if vars.!MODE=2 then do
   call mode2a
   return rcode
end 

if vars.!MODE=21 then do
   call mode21
   return rcode
end 

if vars.!MODE=22 then do
   call mode22
   return rcode
end 

if vars.!MODE='22B' then do
   call mode22b
   return rcode
end 

if vars.!MODE<>'' then return 'string huh 'vars.!mode

/******** INTRO *****/

/* the temporary directories are: */
sre2003_temp=sre_value('TEMPDIR',,'SRESYS')  /* sre2003\temp */

sre2003_delta=strip(sre2003_temp,,'\')||'\DELTA'
if dosisdir(sre2003_delta)=0 then sre2003_delta=''

sre2003_cfg=sre_value('cfg_dir',,'SRESYS')
   sre2003_cfgold=strip(sre2003_cfg,,'\')||'\OLD'

sre2003_log=sre_value('log_dir',,'sresys')
   sre2003_logold=strip(sre2003_log,,'\')||'\ARC'

srehttp2_temp=sre_value('H2_TEMP_DIR',,'SRE') /* sre2003\srehttp2\temp */

srehttp2_cfg=sre_value('H2_CFG_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
   srehttp2_cfgold=strip(srehttp2_cfg,,'\')||'\OLD'

srehttp2_log=sre_value('H2_LOG_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
   srehttp2_logold=strip(srehttp2_LOG,,'\')||'\OLD'

srehttp2_wd=sre_value('H2_WORKDATA_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
  srehttp2_wdmail=strip(srehttp2_wd,,'\')||'\MAIL'
  srehttp2_wdmessage=strip(srehttp2_wd,,'\')||'\MESSAGE'

srehttp2_upload=sre_value('H2_UPLOAD_DIR',,'SRE')

srehttp2_filecache=sre_value('H2_FILECACHE_DIR',,'SRE')


/* SRE2003_temp, sre2003_cfgold, sre2003_logold, srehttp2_temp, srehttp2_cfgold, srehttp2_logold,
   srehttp2_wd, srehttp2_wdmail, srehttp2_wdmessage, srehttp2_upload, srehttp2_filecache 
*/


/* And check addons.ini for TEMP entries. */
adir=sreh2_Value('ADDON_DIR',,host_nickname)
inifile=strip(adir,,'\')||'\ADDONS.INI'
foo=sysini(inifile,'ALL:','apps.')
itht=0
temps.=''
do mm=1 to apps.0
   anapp=apps.mm
   foo=sysini(inifile,anapp,'ALL:','astems')
   adesc='' ; atemp=''
   do jjj=1 to astems.0
      if translate(astems.jjj)='TEMP' then do
         itht=itht+1
         temps.itht=sysini(inifile,anapp,'TEMP')
         temps.itht.!name=anapp
      end
   end 
end
temps.0=itht

allfiles=0
allbytes=0

/* got all the temp files */
call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
nowtime=sre_datestamp()
call lout "<html><head><title>SREhttp/2: Cleanup temporary files</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'
call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Cleanup temporary &amp; transient files </h3>'
call lout '</table>'

call lout '<p>Click on a <u>link</u> to cleanup files in a directory.<p>'

/* SRE2003_temp, sre2003_cfgold, sre2003_logold, srehttp2_temp, srehttp2_cfgold,
   srehttp2_wd, srehttp2_wdmail, srehttp2_wdmessage, srehttp2_upload, srehttp2_filecache 
*/

call lout '<table border=1>'
call lout '<tr bgcolor="lightgrey">'

call lout '<td  colspan=2>SRE2003 <em>temporary</em> directories'
call lout '</td>'
call lout  '<td># of files, Kbytes</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=TEMP">'
call lout '<tr><td bgcolor="lightyellow">TEMP</td><td>'||aword2||'Temporary files</a>'
call lout '</td>'
call dir_stats sre2003_temp
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=CFG">'
call lout '<tr><td bgcolor="lightyellow">CFG\OLD</td><td>'||aword2||'Archive of SRE2003 configuration files</a>'
call lout  '</td>'
call dir_stats sre2003_cfgold
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=LOG">'
call lout '<tr><td bgcolor="lightyellow">LOG\ARC</td><td>'||aword2||'Archive of SRE2003 log files</a>'
call lout  '</td>'
call dir_stats sre2003_logold
call lout '<td>'||result||'</td>'

if sre2003_delta<>'' then do
  aword2='<a href="'||thisaddon||'?mode=1&dir=DELTA">'
  call lout '<tr><td bgcolor="lightyellow">TEMP\DELTA</td><td>'||aword2||'Delta-encoding cache-files</a>'
  call lout  '</td>'
  call dir_stats sre2003_delta
  call lout '<td>'||result||'</td>'
end 

call lout  ' <! ================== -->'
call lout '<tr bgcolor="lightgrey" ><td colspan=2><br>SREhttp/2 <em>temporary</em> directories'
call lout  '</td>'
call lout  '<td># of files, Kbytes</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=H2TEMP">'
call lout '<tr><td bgcolor="lightyellow">TEMP</td><td>'||aword2||'More temporary files</a>'
call lout  '</td>'
call dir_stats srehttp2_temp
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=H2CFG">'
call lout '<tr ><td bgcolor="lightyellow" >CFG\OLD</td><td>'||aword2||'Archive of SREhttp/2 configuration files</a>'
call lout  '</td>'
call dir_stats srehttp2_cfgold
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=H2LOG">'
call lout '<tr><td bgcolor="lightyellow">LOG\OLD</td><td>'||aword2||'Archive of SREhttp/2 log files</a>'
call lout  '</td>'
call dir_stats srehttp2_logold
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=WD">'
call lout '<tr><td bgcolor="lightyellow">WorkData</td><td>'||aword2
call lout 'Counters and other SREhttp/2 status files</a> <br>'
call lout '<em>Caution:</em> Several of these files are used to log hits and counts.'
call lout 'Delete them only if you do not care about these statistics.'
call lout  '</td>'
call dir_stats srehttp2_wd
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=MESSAGES">'
call lout '<tr><td bgcolor="lightyellow">WorkData\MESSAGE</td><td>'||aword2||'Message-box files</a>'
call lout '<br><em>Caution:</em> these message-box files can contain numerous messages (as recorded'
call lout 'by SREhttp/2''s <a target="NOTES" href="/sre2k/srehttp2/demos/MESSAGES.SHT">Message-Box</a> utility).'
call lout  '</td>'
call dir_stats srehttp2_wdmessage
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=MAIL">'
call lout '<tr><td bgcolor="lightyellow">WorkData\MAIL</td><td>'||aword2||'Mail (can be used by MessageBox utility)</a>'
call lout '<br><em>Caution:</em> these may include mail files (as recorded'
call lout 'by SREhttp/2''s <a target="NOTES" href="/sre2k/srehttp2/demos/MESSAGES.SHT">Message-Box</a> utility).'

call lout  '</td>'
call dir_stats srehttp2_wdmail
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=UPLOADS">'
call lout '<tr><td bgcolor="lightyellow">UpLoad</td><td>'||aword2||'default directory for file uploads </a>'
call lout  '</td>'
call dir_stats srehttp2_upload
call lout '<td>'||result||'</td>'

aword2='<a href="'||thisaddon||'?mode=1&dir=FILE_CSH">'
call lout '<tr><td bgcolor="lightyellow">File_CSH</td><td>'||aword2||' directory for SSI and other <em>cache</em> files</a> '
call lout  '</td>'
call dir_stats srehttp2_filecache
call lout '<td>'||result||'</td>'

call lout  ' <! ================== -->'

call lout '<tr bgcolor="lightgrey"><td  colspan=2><br>SREhttp/2 addon <em>temporary</em> directories</td>'
call lout  '<td># of files, Kbytes</td>'

do ll=1 to temps.0
  do ll2=1 to words(temps.ll)
     aword=strip(word(temps.ll,ll2))
     call dir_stats aword
     arf=result
     aww=''
     if ll2=1 then aww=temps.ll.!name
     aword2='<a href="'||thisaddon||'?mode=2&addon='||temps.ll.!name||'&dir='||aword||'">'||aword||'</a>'
     call lout '<tr ><td  bgcolor="lightyellow">'||aww||'</td>'
     call lout '<td><tt>'||aword2||'</tt><td>'||arf||'</td>'
  end
end 

call lout '</table>'
call lout 'Total # of files=<tt>'||allfiles||'</tt>, total kbytes=<tt>'||trunc(allbytes/1000)||'k</tt>'
call lout '</body></html>'
call lineout tempfile


return 'File type text/html erase name 'tempfile

/*************/
lout:
parse arg aline
call lineout tempfile,aline
return 1


/******************/
dir_stats:
parse arg toget
totsize=0
tt=strip(toget,,'\')||'\*.*'
aa=sysfiletree(tt,'dd','FT')
if dd.0=0 then return '&nbsp;&nbsp;&nbsp;0&nbsp;&nbsp;&nbsp;0k'
do jj=1 to dd.0
   parse var dd.jj . ss .
   totsize=totsize+strip(ss)
end 

allfiles=allfiles+dd.0
allbytes=allbytes+totsize

jj=right(dd.0,4,' ')
jj=sre_replacestrg(jj,' ','&nbsp;','ALL')

ksize=max(1,trunc(totsize/1000))
return jj||'&nbsp;&nbsp;&nbsp;'||ksize||'k'

/******************/
/******************/
/******************/

/* mode 2 (addons), step 1 */
mode2a:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files</title>"
call lout "</head><body>"
call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Cleanup temporary &amp; transient files </h3>'
call lout '</table>'


adir=vars.!dir
addon=vars.!addon
call lout 'Do you want to:'
call lout '<ul>'
call lout '<li><a href="'||thisaddon||'?mode=21&dir='||adir||'&addon='||addon||'">Delete all files</a>'
call lout '<li><a href="'||thisaddon||'?mode=22&dir='||adir||'&addon='||addon||'">Choose which files to delete</a>'
call lout '</ul>'
call lout 'From the <tt>'||adir||'</tt> directory<br>used by the <u>'||addon||'</u> addon? '

call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name 'tempfile
return 1



/******************/
/* mode 2, step 21 (delete all files) */
mode21:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- deleting</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Deleting all files </h3>'
call lout '</table>'

adir=strip(translate(vars.!DIR))
addon=strip(translate(vars.!ADDON))

tt='!'||adir
call lout '<p>Deleting all files from the <tt>'||adir
call lout '</tt> directory (used by the <em>'||addon||'</em> addon)'

idir=sreh2_Value('ADDON_DIR',,host_nickname)
inifile=strip(idir,,'\')||'\ADDONS.INI'
foo=sysini(inifile,'ALL:','apps.')
gotit=0
do mm=1 to apps.0
   a1=strip(translate(apps.mm))
   if a1=addon then do
      gotit=mm
      leave
   end 
end 
if gotit=0 then do
  call lout '<p><B>Error:</b> no such addon: <tt>'||addon||'</tt>'
  signal gooba4
end


/* see if the chosen directory is listed */
foo=sysini(inifile,apps.gotit,'ALL:','astems.')
thedirs=''
do jjj=1 to astems.0
  if translate(astems.jjj)='TEMP' then do
       thedirs=strip(translate(sysini(inifile,apps.gotit,'TEMP')))
       leave
  end
end 
if thedirs='' then do
   call lout '<p><B>Error:</b> no such dir: <tt>'||adir||'</tt>'
   signal gooba4
end
if wordpos(adir,thedirs)=0 then do
   call lout '<p><B>Error:</b> no such directory: <tt>'||adir||'</tt>'
   signal gooba4
end


/* delete'em */
ff=strip(adir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FO')


if goo.0=0 then do
    call lout  '<p><b>No files to delete!</b>'
end 
else do 
  call lout '<h4>Attempting to delete <tt>'||goo.0||'</tt> files'
  call lout '<ul>'
  do mm=1 to goo.0
    stt=sysfiledelete(goo.mm)
    if stt<>0 then do
       delbad=delbad+1
      call lout '<li>Error deleting <tt>'||goo.mm||'</tt>: <b>'||stt||'</b> '
    end
    else do
      delok=delok+1
    end
  end
  call lout '<hr width="50%"><p><li>File successfully deleted:<tt> '||delok||'</tt>'
  call lout '<li>Files <b>failed to</b> delete:<tt> '||delbad||'</tt>'
  call lout '</ul>'

end

gooba4:
call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name ' tempfile
return 1


/******************/
/* mode 2, step 22 (delete selected files, choose step) */
mode22:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- select files to delete</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Select files to delete </h3>'
call lout '</table>'

adir=strip(translate(vars.!DIR))
addon=strip(translate(vars.!ADDON))

tt='!'||adir
call lout '<p>Select files to delete from the <tt>'||adir
call lout '</tt> directory (used by the <em>'||addon||'</em> addon)'

idir=sreh2_Value('ADDON_DIR',,host_nickname)
inifile=strip(idir,,'\')||'\ADDONS.INI'
foo=sysini(inifile,'ALL:','apps.')
gotit=0
do mm=1 to apps.0
   a1=strip(translate(apps.mm))
   if a1=addon then do
      gotit=mm
      leave
   end 
end 
if gotit=0 then do
  call lout '<p><B>Error:</b> no such addon: <tt>'||addon||'</tt>'
  signal gooba4b
end



/* see if the chosen directory is listed */
foo=sysini(inifile,apps.gotit,'ALL:','astems.')
thedirs=''
do jjj=1 to astems.0
  if translate(astems.jjj)='TEMP' then do
       thedirs=strip(translate(sysini(inifile,apps.gotit,'TEMP')))
       leave
  end
end 
if thedirs='' then do
   call lout '<p><B>Error:</b> no such dir: <tt>'||adir||'</tt>'
   signal gooba4b
end
if wordpos(adir,thedirs)=0 then do
   call lout '<p><B>Error:</b> no such directory: <tt>'||adir||'</tt>'
   signal gooba4b
end


/* delete'em */
thedir=adir
ff=strip(adir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FT')
if goo.0=0 then do
    call lout  '<p><b>No files to delete in <tt>'||thedir||'</tt> !</b>'
    signal gooba1
end 
else do 
  call lout '<p>There are <tt>'||goo.0||'</tt> files in <tt>'||thedir||'</tt>'
  call lout '<form action="'||thisaddon||'" method="POST">'
  call lout '<input type="hidden" name="mode" value="22B">'
  call lout '<input type="hidden" name="addon" value="'||addon||'">'
  call lout '<input type="hidden" name="dir" value="'||adir||'">'
  call lout '<em>To delete a file, check its box </em>'
  call lout '<table>'
  do mm=1 to goo.0
     aee=goo.mm
     parse var aee adate asize . afile
     asize=sre_addcomma(trunc(asize/1000))||'k '
     afile1=filespec('n',afile)

    dafile=filespec('n',goo.mm)
    call lout '<tr><td><input type="checkbox" name="file" value="'||dafile||'">'
    call lout dafile||'</td><td><em>'||asize||'</em>&nbsp; </td><td> <tt>'||adate||'</tt></a></td>'
  end
end
call lout '</table>'
call lout '<input type="submit" value="Delete chosen files">'

call lout '</form>'

gooba4b:
call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name ' tempfile
return 1

/******************/
/* mode 2, step 22b (deleting selected files) */
mode22b:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- deleting selected files</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Deleting selected files </h3>'
call lout '</table>'



adir=strip(translate(vars.!DIR))
addon=strip(translate(vars.!ADDON))

tt='!'||adir
call lout '<p>Select files to delete from the <tt>'||adir
call lout '</tt> directory (used by the <em>'||addon||'</em> addon)'

idir=sreh2_Value('ADDON_DIR',,host_nickname)
inifile=strip(idir,,'\')||'\ADDONS.INI'
foo=sysini(inifile,'ALL:','apps.')
gotit=0
do mm=1 to apps.0
   a1=strip(translate(apps.mm))
   if a1=addon then do
      gotit=mm
      leave
   end 
end 
if gotit=0 then do
  call lout '<p><B>Error:</b> no such addon: <tt>'||addon||'</tt>'
  signal gooba5
end


/* see if the chosen directory is listed */
foo=sysini(inifile,apps.gotit,'ALL:','astems.')
thedirs=''
do jjj=1 to astems.0
  if translate(astems.jjj)='TEMP' then do
       thedirs=strip(translate(sysini(inifile,apps.gotit,'TEMP')))
       leave
  end
end 
if thedirs='' then do
   call lout '<p><B>Error:</b> no such dir: <tt>'||adir||'</tt>'
   signal gooba5
end
if wordpos(adir,thedirs)=0 then do
   call lout '<p><B>Error:</b> no such directory: <tt>'||adir||'</tt>'
   signal gooba5
end

/* delete'em */
thedir=adir
ff=strip(thedir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FO')

call lout '<p>Deleting <tt>'||vars.!DELETE||'</tt> of <tt>'||goo.0||'</tt> files in <tt>'||thedir||'</tt>'
call lout '<ul>'
/* for each file in goo.0, see if it's in dodel. */
do mm=1 to goo.0
   afile=goo.mm
   afile1=filespec('n',afile)
   taf='!'||strip(translate(afile1))
   if dodel.taf=1 then do
      stt=sysfiledelete(afile)
      if stt=0 then do
          delok=delok+1
      end 
      else do
        delbad=delbad+1
        call lout '<li>Error deleting <tt>'||afile1||'</tt>: <b>'||stt||'</b> '
      end 
   end 
end 
call lout '<hr width="50%"><p><li>File successfully deleted:<tt> '||delok||'</tt>'
call lout '<li>Files <b>failed to</b> delete:<tt> '||delbad||'</tt>'
call lout '</ul>'

gooba5:
call lout '</body></html>'
call lineout tempfile
rcode='file type text/html erase name ' tempfile
return 1



/******************/
/******************/
/******************/
/******************/
/* mode 1, step 1 */
mode1a:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'
call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Cleanup temporary &amp; transient files </h3>'
call lout '</table>'


adir=vars.!dir
tt='!'||strip(translate(adir))
call lout 'Do you want to:'
call lout '<ul>'
call lout '<li><a href="'||thisaddon||'?mode=11&dir='||adir||'">Delete all files</a>'
call lout '<li><a href="'||thisaddon||'?mode=12&dir='||adir||'">Choose which files to delete </a>'
call lout '</ul>'
call lout 'From the <tt>'||desc.tt||'</tt> directory? '

call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name 'tempfile
return 1

/**************/
/* mode 1, step 11 (delete all files) */
mode11:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- deleting</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Deleting all files </h3>'
call lout '</table>'

adir=strip(translate(vars.!DIR))
tt='!'||adir
call lout '<p>Deleting all files from the <tt>'||adir
call lout '</tt> directory (the <em>'||desc.tt||'</em> directory)'

thedir=which_dir(adir)
call lout '<br>&nbsp;&nbsp;&nbsp;<tt>--- '||thedir||'</tt><br>'


/* delete'em */
ff=strip(thedir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FO')
if goo.0=0 then do
    call lout  '<p><b>No files to delete!</b>'
end 
else do 
  call lout '<h4>Attempting to delete <tt>'||goo.0||'</tt> files'
  call lout '<ul>'
  do mm=1 to goo.0
    stt=sysfiledelete(goo.mm)
    if stt<>0 then do
       delbad=delbad+1
      call lout '<li>Error deleting <tt>'||goo.mm||'</tt>: <b>'||stt||'</b> '
    end
    else do
      delok=delok+1
    end
  end
  call lout '<hr width="50%"><p><li>File successfully deleted:<tt> '||delok||'</tt>'
  call lout '<li>Files <b>failed to</b> delete:<tt> '||delbad||'</tt>'
  call lout '</ul>'

end

call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name ' tempfile
return 1


/******************/
/* mode 1, step 12 (delete selected files, choose step) */
mode12a:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- select files to delete</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Select files to delete </h3>'
call lout '</table>'

adir=strip(translate(vars.!DIR))
tt='!'||adir
call lout 'Select files to delete from the <tt>'||adir
call lout '</tt> directory (the <em>'||desc.tt||'</em> directory)'

thedir=which_dir(adir)


/* delete'em */
ff=strip(thedir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FT')
if goo.0=0 then do
    call lout  '<p><b>No files to delete in <tt>'||thedir||'</tt> !</b>'
    signal gooba1
end 
else do 
  call lout '<p>There are <tt>'||goo.0||'</tt> files in <tt>'||thedir||'</tt>'
  call lout '<form action="'||thisaddon||'" method="POST">'
  call lout '<input type="hidden" name="mode" value="12B">'
  call lout '<input type="hidden" name="dir" value="'||adir||'">'
  call lout '<em>To delete a file, check its box </em>'
  call lout '<table>'
  do mm=1 to goo.0
     aee=goo.mm
     parse var aee adate asize . afile
     asize=sre_addcomma(trunc(asize/1000))||'k '
     afile1=filespec('n',afile)

    dafile=filespec('n',goo.mm)
    call lout '<tr><td><input type="checkbox" name="file" value="'||dafile||'">'
    call lout dafile||'</td><td><em>'||asize||'</em>&nbsp; </td><td> <tt>'||adate||'</tt></a></td>'
  end
end
call lout '</table>'
call lout '<input type="submit" value="Delete chosen files">'

call lout '</form>'

gooba1:
call lout '</body></html>'
call lineout tempfile

rcode='file type text/html erase name ' tempfile
return 1



/******************/
/* mode 1, step 12b (deleting selected files) */
mode12b:
call lout "<html><head><title>SREhttp/2: Cleanup temporary files -- deleting selected files</title>"
call lout "</head><body>"
call lout '<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> </font>'

call lout '<br><table align="center" bgcolor="lightblue"><tr><td>'
call lout ' <h3 >SREhttp/2: Deleting selected files </h3>'
call lout '</table>'

adir=strip(translate(vars.!DIR))
tt='!'||adir
call lout 'Deleting selected files from the <tt>'||adir
call lout '</tt> directory (the <em>'||desc.tt||'</em> directory)'

thedir=which_dir(adir)

/* delete'em */
ff=strip(thedir,,'\')||'\*.*'
delok=0
delbad=0
foo=sysfiletree(ff,'goo','FO')

call lout '<p>Deleting <tt>'||vars.!DELETE||'</tt> of <tt>'||goo.0||'</tt> files in <tt>'||thedir||'</tt>'
call lout '<ul>'
/* for each file in goo.0, see if it's in dodel. */
do mm=1 to goo.0
   afile=goo.mm
   afile1=filespec('n',afile)
   taf='!'||strip(translate(afile1))
   if dodel.taf=1 then do
      stt=sysfiledelete(afile)
      if stt=0 then do
          delok=delok+1
      end 
      else do
        delbad=delbad+1
        call lout '<li>Error deleting <tt>'||afile1||'</tt>: <b>'||stt||'</b> '
      end 
   end 
end 
call lout '<hr width="50%"><p><li>File successfully deleted:<tt> '||delok||'</tt>'
call lout '<li>Files <b>failed to</b> delete:<tt> '||delbad||'</tt>'
call lout '</ul>'

gooba2:
call lout '</body></html>'
call lineout tempfile
rcode='file type text/html erase name ' tempfile
return 1


/******/
/* which directory? */
which_dir:procedure
parse arg adir

select
   when adir='TEMP' then tmp=sre_value('TEMPDIR',,'SRESYS')

   when adir='DELTA' then do 
     tmp=sre_value('TEMPDIR',,'SRESYS')
     tmp=strip(tmp,,'\')||'\DELTA'
   end

   when adir='CFG'  then do 
        tmp=sre_value('cfg_dir',,'SRESYS')
        tmp=strip(tmp,,'\')||'\OLD'
   end

   when adir='LOG' then do
      tmp=sre_value('log_dir',,'sresys')
      tmp=strip(tmp,,'\')||'\ARC'
   end

   when adir='H2TEMP' then tmp=sre_value('H2_TEMP_DIR',,'SRE') /* sre2003\srehttp2\temp */

   when adir='H2CFG' then do
      tmp=sre_value('H2_CFG_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
      tmp=strip(tmp,,'\')||'\OLD'
    end

   when adir='H2LOG' then do
      tmp=sre_value('H2_LOG_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
      tmp=strip(tmp,,'\')||'\OLD'
    end

   when adir ='WD' then tmp=sre_value('H2_WORKDATA_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
   when adir ='MAIL' then do
      tmp=sre_value('H2_WORKDATA_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
      tmp=strip(tmp,,'\')||'\MAIL'
   end
   when adir ='MESSAGES' then do 
      tmp=sre_value('H2_WORKDATA_DIR',,'SRE')  /*  sre2003\srehttp2\cfg */
      tmp=strip(tmp,,'\')||'\MESSAGE'
   end 

   when adir ='UPLOADS' then tmp=sre_value('H2_UPLOAD_DIR',,'SRE')

   when adir ='FILE_CSH' then tmp=sre_value('H2_FILECACHE_DIR',,'SRE')

   otherwise tmp=''
end
return tmp


/******************/
/******************/
/******************/
/* access allowed? */
sec_check:
ss=sre_value('SECURITY_LEVEL',,'SRESYS')
if ss=0 then do
  foo=sre_command('String Sorry. Remote access to configuration utilities not permitted.',,idinfo)
  return foo
end

if ss=1 then do
    myaddr=sre_extract("clientaddr",idinfo)
    moreaddr=sre_value('SERVERADDR_INHOUSE',,'SRESYS')
    who=sre_extract("serveraddr",idinfo)||' '||moreaddr
    if wordpos(myaddr,who)=0 then do
      sfoo=sre_command('String External access to configuration utilities is not permitted' ,,idinfo)
      return sfoo
   end
end
/* else, normal superuser checking */
crlf='0d0a'x
parse upper var uri action '?' .
if wordpos('SUPERUSER',privset)=0 then do
  if aiter='' then return 'PRIVS_CHECK SUPERUSER , 'action' addon requires superuser privileges '
  return 'AUTH 'action'  addon requires that you have superuser privileges '
end 
return 0




