/* The SRE2003 installer.
   This utility facilitates the addition (and removal) of
   various SRE2003 components.  These included filters, initialization
   and exit procedures, pre-transaction and pre-request procedures, 
   and instance manipulation procedures.
   
   It uses the ADD_PART.DAT database (in the CFG directory).

*/

parse arg daname

call init1
if result<>1 then return result

/* get current values of plugin variables */
stuff0=stuff
vals.=''
do until stuff0=''
   parse var stuff0 aline '0d0a'x stuff0
   aline=strip(aline)
   if abbrev(aline,';')=1 | aline='' then iterate
   parse var aline avar '=' aval
   avar=strip(translate(avar))
   if wordpos(avar,varlist)=0 then iterate
   vv='!'||avar
   vals.vv=aval
end

 
do forever
say
ttaa=yesno(' Would you like to','Quit Save&exit View_Current Add Remove Help','V')

if ttaa=0 then do
    say "Quit -- changes are "bold"not"normal" saved."
    return 'Changes not made'
end 

if ttaa=1  then do
   if changes=0 then do
       say "No changes were made. Bye. "
       return 'No changes'
   end 
   ss=rename_cfg(daname)
   if ss=0 then return 'error unable to rename'
/* now write to daname */
   call write_cfg
   say
   if result=1 then
     say "Note: Your changes will take effect when you restart SRE2003."
   return 'Changes made'

end 


if ttaa=2 then do
 say bold "Current values of 'plugin' variables: "normal
 do mm=1 to words(varlist)
    vv=strip(word(varlist,mm))
    avv='!'||vv
    aval=vals.avv
    aline=''
    bll=" : "vv " = " aval
    ibll=length(bll)
    if ibll<78 then do
       say " : "||bold||vv||normal||" = "|| aval
       iterate
    end
    aline=" : "||bold||vv||normal||" = "
    bll=" : "||vv||" = "
    ibll=length(bll)
    newline=1
    do until aval=''
      parse var aval aword  ',' aval
      aword=strip(aword)
      if length(aline||aword)>77 then do
         say aline
         aline=copies(' ',ibll)||aword
         newline=0
       end
       else do
          if newline=1 then
            aline=aline||aword||' '
          else
            aline=aline||', '||aword||' '
          newline=0
       end 
    end
    if aline<>'' then say aline
  end 
end


if ttaa=3 then do
   call add1
end 

if ttaa=4 then do
    call remove1
end 

if ttaa=5 then do
    call help1
end 


end



/***** add a plugin */
add1:
say " "cy_ye"Add a plugin"normal
ii=yesno(" Choose from known plugins, or specify one 'by hand' ", ,
         "None Known Specify ",'K','  -')
if ii=0 then do
  return 0
end
if ii=1 then do
   call add1_a
   return 1
end 

/* custom add  */
say "   Choose one of these types of plugins:"
say "    "bold"1"normal"=Filter  "
say "    "bold"2"normal"=Fast Filter  "
say "    "bold"3"normal"=Initialization Procedure"
say "    "bold"4"normal"=Pre-transaction procecure "
say "    "bold"5"normal"=Pre-request procedure "
say "    "bold"6"normal"=Instance-manipulation procedure "
say "    "bold"7"normal"=Exit procedure "
say "    "bold"8"normal"=Instance-manipulation default "
say "    "bold"9"normal"=Change reported Filter-Version "

ll='None 1 2 3 4 5 6 7 8 9 '
aa=yesno(' Type of plugin to add:',ll,'N','   -- ')
if aa=0 then return 0


select
   when aa=1 then do
          say "   Current Filter=" vals.!FILTER
   end
   when aa=8 then do
          say "   Current Default Instance Manipulation=" vals.!im_default
   end
   when aa=9 then do
          say "   Current Filter-Version: " vals.!filter_version
   end

   when aa=2 then do
        if vals.!fast_filter=0 then 
                say "   Fast-filter is "bold"not"normal" currently enabled."
        else
           say  "   Current Fast-filter= "vals.!fast_filter
   end
   when aa=3 then foo=make_vals2( "Initialization Procedures ",vals.!INIT_PROC,'Currently specified',1)
   when aa=4 then foo=make_vals2( "Pre-transaction Procedures ",vals.!PRE_TRANSACTION,'Currently specified',1)
   when aa=5 then foo=make_vals2( "Pre-request Procedures ",vals.!PRE_REQUEST,'Currently specified',1)
   when aa=6 then foo=make_vals2( "Instance Manipulation Procedures ",vals.!IM_TYPES,'Currently specified',1)
   when aa=7 then foo=make_vals2( "Exit Procedures ",vals.!exit_proc,'Currently specified',1)
   otherwise nop
end  /* select */

goo=strip(word(varlist,aa))
select 
   when aa=1 then do
      say "    Enter the filename of the new filter: "
      call charout, "   "bold"? "normal
      parse pull newval
      if newval=''  then return 1
      vals.!Filter=newval
      changes=changes+1
      say "   FILTER_VERSION is currently: "
      say "    "vals.!FILTER_VERSION
      say "   Enter new value, or just hit ENTER to retain current value."
      call charout, "  "bold"?"normal
      parse pull yxx
      if yxx<>'' then do
         changes=changes+1          
         vals.!FILTER_VERSION=yxx
      end 
      return 1
   end
   when aa=2 then do
      say "    Enter the filename of the new fast-filter: "
      call charout, "     "bold"? "normal
      parse pull newval
      if newval=''  then return 1
      vals.!fast_Filter=newval
      changes=changes+1
      return 1
   end
   when aa=8 then do
      say "    Enter the name of the default IM module (or 0 or RANGE): "
      call charout, "    "bold"? "normal
      parse pull newval
      if newval=''  then return 1
      vals.!IM_DEFAULT=newval
      changes=changes+1
      return 1
   end
   when aa=9 then do
      say "    Enter the 'filter-version'. The filter-version is a short text string "
      say "    that identifies the name/version of the server software"
      call charout, "    "bold"? "normal
      parse pull newval
      if newval=''  then return 1
      vals.!FILTER_VERSION=newval
      changes=changes+1
      return 1
   end

   when aa=6  then do
       say "    Enter a IM name followed by the name of the IM procedure "
       call charout, "    "bold"? "normal
       parse pull newval
       if newval=''  then return 1
       if vals.!im_types='' | vals.!im_types=0 then
         vals.!im_types=newval
       else
         vals.!im_types=vals.!im_types', 'newval
       foo=make_vals2( "IM plugins modified to ",vals.!im_types)
       changes=changes+1
       return 1        
   end 
   otherwise do
      goo=strip(word(varlist,aa))
      say "    Enter the new "goo
      call charout, "    "bold"? "normal
      parse pull newval
      if newval=''  then return 1
      agoo='!'||goo
      if vals.agoo='' | vals.agoo=0 then
         vals.agoo=newval
      else
         vals.agoo=vals.agoo', 'newval
      changes=changes+1
   end 
end

foo=make_vals2( goo" plugins modified to ",vals.agoo)
return 1

/*******/
/* add a known plugin */
add1_a:

say
say "Please select one of the "plugs.0 || bold||' known 'normal' plugins '
ll='None '

select 
  when plugs.0<10 then do
    do jj=1 to plugs.0
     say "    "bold||jj||normal" : "plugs.jj
     ll=ll||jj||' '
    end
    ii=yesno("Select from above ",ll,'N','  -')
  end
  when plugs.0<18 then do
    do jj=1 to plugs.0 by 2
      o1=left("    "bold||jj||normal" : "plugs.jj,38,' ')
      if jj<>plugs.0 then do
        jj2=jj+1
        o1=o1||' | '||left("    "bold||jj2||normal" : "plugs.jj2,38,' ')
      end
      say o1
    end
    call charout,'  '||bold||'0'normal' for NONE, or a value between 'bold'1'normal' and 'bold||plugs.0||normal':'
    pull ii
    say
    if datatype(ii)<>'NUM' then ii=''
    if ii='' then ii=0
    if ii<0 | ii> plugs.0 then ii=0

  end
  otherwise do
    do jj=1 to plugs.0 by 3
      o1=left(" "bold||jj||normal" : "plugs.jj,34,' ')
      jj2=jj+1
      if jj2<=plugs.0 then do
        o1=o1||'| '||left(bold||jj2||normal" : "plugs.jj2,34,' ')
      end
      jj2=jj2+1
      if jj2<=plugs.0 then do
        o1=o1||'| '||left(bold||jj2||normal" : "plugs.jj2,34,' ')
      end
      say o1
    end
    call charout,'  '||bold||'0'normal' for NONE, or a value between 'bold'1'normal' and 'bold||plugs.0||normal':'
    pull ii
    say
    if datatype(ii)<>'NUM' then ii=''
    if ii='' then ii=0
    if ii<0 | ii> plugs.0 then ii=0
  end
end
if ii=0 then return 1

say "  "reverse||plugs.ii||normal" selected."
say "  "bold||"Description: "normal
adesc=plugs.ii.!desc
aline=''
do until adesc=''
    parse var adesc aword adesc
    if length(aline||aword)>72 then do
       say "    "aline
       aline=aword||' '
    end
    else do
       aline=aline||aword||' '
    end 
end 
if aline<>'' then say "    "aline

if plugs.ii.0='' then do
    say
   say "  "bold"Nothing to do"normal" (this record contains no modifications) "
   return 1
end 
/* now check items */
say
say "   There are "plugs.ii.0" items to be modified "
oo=yesno('Make these modifications ','No Yes','Y','   :')
if oo=0 then return 1
doappend=0
do ii2=1 to plugs.ii.0
   doappend=0

   aitem=plugs.ii.ii2
   parse var aitem aword  aitem
   aword=strip(translate(aword))
   if aword='APPEND' then do
      doappend=1
      parse var aitem aword  aitem
   end
   aword=strip(translate(aword))
   if wordpos(aword,varlist)=0 then do
         say "ERROR. Bad entry: "plugs.ii.ii2
         return 1
   end
   if doappend=1 then
      say "    Appending to: "aword
    else
      say "    Modifying: "aword

    vv='!'||aword
    if doappend=1 then do
         if vals.vv=0 | vals.vv='' then  
              vals.vv=aitem
         else
              vals.vv=vals.vv||', '||aitem
    end
    else do
         vals.vv=aitem
    end
   changes=changes+1
end
   
return 1

/***** remove a plugin */
remove1:
say
say " "cy_ye"Remove a plugin"normal

say "  Choose one of these types of plugins:"
say "    "bold"1"normal"=Filter  "
say "    "bold"2"normal"=Fast Filter  "
say "    "bold"3"normal"=Initialization Procedure"
say "    "bold"4"normal"=Pre-transaction procecure "
say "    "bold"5"normal"=Pre-request procedure "
say "    "bold"6"normal"=Instance-manipulation procedure "
say "    "bold"7"normal"=Exit procedure "
say "    "bold"8"normal"=Instance-manipulation default "

ll='None 1 2 3 4 5 6 7 8 '
aa=yesno(' Type of plugin to remove:',ll,'N','  -- ')
if aa=0 then return 0

select
   when aa=1 then do
          say "Current Filter=" vals.!FILTER
          say "Sorry, you are not remove the "bold"filter"normal"! "
          say "(you can use ADD to change it ....)"
          return 1
   end
   when aa=2 then do
        say "   There will be "bold"no"normal" Fast-filter selected."
        vals.!fast_filter=0
        return 1
   end
   when aa=8 then do
        say "   There will be "bold"no"normal" Default Instance Manipulaton module "
        vals.!im_default=0        
        return 1
   end

   when aa=3 then foo=make_vals2( "Initialization Procedures ",vals.!INIT_PROC,'Currently specified')
   when aa=4 then foo=make_vals2( "Pre-transaction Procedures ",vals.!PRE_TRANSACTION,'Currently specified')
   when aa=5 then foo=make_vals2( "Pre-request Procedures ",vals.!PRE_REQUEST,'Currently specified')
   when aa=6 then foo=make_vals2( "Instance Manipulation Procedures ",vals.!IM_TYPES,'Currently specified')
   when aa=7 then foo=make_vals2( "Exit Procedures ",vals.!exit_proc,'Currently specified')
   otherwise nop
end

/* if here, 3 to 7 was chosen */
if vals2.0=0 then return 0

ll='None '
do mm=1 to vals2.0
   ll=ll||' '||mm
end
opt=yesno('Remove which of these ',ll,'N','    ')
if opt=0 then return 0

changes=changes+1

/* remove plugins */
newval=vals2.1
if opt=1 then  newval=''

do jj=2 to vals2.0
   if jj=opt then iterate
   if newval='' then
      newval=vals2.jj
   else
      newval=newval||', '||vals2.jj
end
if newval='' then newval=0

select
   when aa=3 then vals.!init_proc=newval
   when aa=4 then vals.!pre_transaction=newval
   when aa=5 then vals.!PRE_REQUEST=newval
   when aa=6 then vals.!IM_TYPES=newval
   when aa=7 then vals.!exit_proc=newval
   when aa=8 then vals.!IM_DEFAULT=0
   otherwise nop
end
foo=make_vals2( "Plugins modified to ",newval)

return opt

/*********/
/* parse to vals2, and display, list of a type of plugins */
make_vals2:procedure expose vals2. bold normal reverse
parse arg aname,arf,aname0,justshow

if arf='' | arf=0 then do
   say "     "bold||aname||normal": None specified "
   vals2.0=0
   return 1
end

ith=0


say '    'aname0' ' reverse||aname||normal
do until arf=''
   parse var arf aval',' arf
   ith=ith+1
   vals2.ith=aval
   say "     "bold||ith||normal" = "||aval
end
vals2.0=ith


return 1


/***** some initializations **/
init1:

foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 foo=rxfuncadd( 'rexxlibregister','rexxlib', 'rexxlibregister')
  if foo=1 then do
     say "ERROR: could not find RexxLib.DLL "
     exit
  end /* do */
 call rexxlibregister
end



init1a:         /* signal here after cleanup */

/* enable ansi screen controls */
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

changes=0

/* The parameters that this procedure will modify: */
varlist='FILTER FAST_FILTER INIT_PROC  PRE_TRANSACTION PRE_REQUEST '|| ,
        'IM_TYPES EXIT_PROC IM_DEFAULT FILTER_VERSION '

call charout, '1b5b'x||'2J'
say "1B"x||"[2J"
say     "          " cy_ye "Add and Remove SRE2003 plugins"normal
say "(by modifying the SRE2003 configuration file) "
say


if daname='' then
   daname=strip(directory(),,'\')||'\CFG\SRE2003.CFG'

/* Read in cfg file */
stuff=read_file(daname,3)
parse var stuff isz ainfo '0d0a'x stuff
if isz<0 then do
   say reverse'ERROR:'normal' can not open initialization file: 'ainfo
   if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
   return 'no changes'
end 
if isz=0 then do
   say reverse'ERROR:'normal' empty initialization file: 'daname
   if aflag<>'' then foo=sre_flag_set(daflag,1,usepid)
   return 'no changes'
end 
say isz " bytes in the "daname" configuration file."


plugfile=strip(directory(),,'\')||'\CFG\ADD_PLUG.DAT'

/* Read in ADD_PLUG database */
pstuff=read_file(plugfile,3)
parse var pstuff isz ainfo '0d0a'x pstuff
if isz<0 then do
   say reverse'ERROR:'normal' can not open ADD_PLUG data file: 'ainfo
   return 'no changes'
end 
if isz=0 then do
   say reverse'ERROR:'normal' empty ADD_PLUG data  file: 'daname
   return 'no changes'
end 

/* parse the plugin file */
plugs.=''
iplugs=0
plugnames.=''
nwarnings=0

do until pstuff=''
   parse var pstuff aline '0d0a'x pstuff
   aline=strip(aline)

   if abbrev(aline,';')=1 | aline=' ' then iterate
/* if here, got the start of a record */
   iplugs=iplugs+1
   items=0

   do forever           /* keep reading lines until blank line or eof */
      if pos(':',aline)=0 then do
        say "Bad line in PLUGIN file: "aline
        return 0
      end 
      if abbrev(aline,';')=1 then 
         avar=''
      else
        parse var aline avar ':' aval
      avar=strip(translate(avar))
      if avar='NAME' then do 
         plugname=space(translate(strip(aval)))
         pp='!'||plugname
         if plugnames.pp='' then do
            plugnames.pp=iplugs
            plugs.iplugs=plugname
         end
         else do                /* same name, so rewrite old record */
           say "Warning: overwriting older version of "plugname
           nwarnings=nwarnings+1
           iplugs=plugnames.pp
         end
      end 
      if avar='DESC' then do
         if plugs.iplugs.!DESC='' then
            plugs.iplugs.!DESC=aval
         else
            plugs.iplugs.!DESC=plugs.iplugs.!DESC||' '||aval
      end
      if avar='ITEM' then do
          items=items+1
          plugs.iplugs.items=aval
          plugs.iplugs.0=items
      end 

/* get next line (fall to here if ;comment line) */
      if pstuff='' then leave           /* nothing to get */
      parse var pstuff aline '0d0a'x pstuff
      if aline='' then leave
      aline=strip(aline)
   end          /* forever */
end             /* pstuff */
say

if nwarnings>0 then do
 jj=yesno('Would you like to cleanup the "plugin" database ','No Yes','No')
 if jj=1 then do
     call cleanup_plugin
     if result<>1 then return result
     signal init1a
 end
end

plugs.0=iplugs
say "# of "bold"known"normal" addable plugins= " iplugs
say " (known plugins are specified in "plugfile ')'
return 1


/******/
/* cleanup the ADD_PLUG.DAT file (save current version to ADD_PLUG.BAK */
cleanup_plugin:

ik=lastpos('.',plugfile)
if ik=0 then do
    copyto=plugfile||'.BAK'
end
else do
    copyto=left(plugfile,ik)||'BAK'
end 
arf=doscopy(plugfile,copyto,'R')
if arf<>0 then do
    say "Problem ('arf') copying "plugfile " to " copyto
    return 'Error in backup'
end

/* Read in ADD_PLUG database */
pstuff=read_file(plugfile,3)
parse var pstuff isz ainfo '0d0a'x pstuff
if isz<0 then do
   say reverse'ERROR:'normal' can not open ADD_PLUG data file: 'ainfo
   return 'no changes'
end 
if isz=0 then do
   say reverse'ERROR:'normal' empty ADD_PLUG data  file: 'daname
   return 'no changes'
end 

/* parse the plugin file */
plugs.=''

plugnames.=''
ith=1
started=0

do until pstuff=''
   parse var pstuff aline '0d0a'x pstuff
   aline=strip(aline)
   if aline='' then do          /* start new block? */
      if started=0 then iterate /* skip consecutive blank lines */
      started=0
      ith=ith+1
      iterate
   end 
   started=1
   if plugs.ith.!text<>'' then
      plugs.ith.!text=plugs.ith.!text||'0d0a'x||aline
   else
      plugs.ith.!text=aline
   if abbrev(aline,';')=1 then iterate

/* see if this is a name*/

   parse var aline avar ':' aval
   avar=translate(strip(avar))
   if avar='NAME' then do 
       plugname=space(translate(strip(aval)))
       pp='!'||plugname
       plugnames.pp=ith         /* use latest block */
       plugs.ith.!NAME=pp
   end

end             /* pstuff */

/* got blocks, including comment blocks. Write them out, but only
   the "most recent" if multiple blocks with same NAME */
atxt=''
do jj=1 to ith
  pp=plugs.jj.!NAME
  if pp='' then do          /* comment block */
     atxt=atxt||plugs.jj.!TEXT||'0d0a'x||'0d0a'x
     iterate
  end
  if plugnames.pp<>jj then do
     say "skipping old version of: "||substr(pp,2)
     iterate
  end
  atxt=atxt||plugs.jj.!TEXT||'0d0a'x||'0d0a'x
end
arf=sysfiledelete(plugfile)
if arf<>0 then do
    say "Problem ('arf') removing "plugfile
    return 'Error removing add_plug.dat'
end
foo=charout(plugfile,atxt,1)
foo=stream(plugfile,'c','close')
return 1



  end /* do */
  else
end /* do */







/***/                
read_file:procedure
parse arg filename,ntries,status1

if ntries=0 | ntries='' then ntries=1

check0=0
if status1=3 then do
  status1=2 ; check0=1
end

fulln=stream(filename,'c','query exists')
if fulln='' then do
   if status1=2 then return ''
   return '-1 '||filename' was not found '
end

do ll=1 to ntries               /* sometimes file exists but hasn't been written */
  asize=stream(fulln,'c','query size')
  if asize=''  | asize=0  then do
    if ll=ntries | check0=0  then do
       if status1=2 then return ''
       return '-2 '||filename' could not be found '
    end
    call syssleep(1)
    iterate
  end
  leave
end

do ll=1 to ntries               /* sometimes file exists but hasn't been written */
  atime=stream(fulln,'c','query datetime')
  if atime='' then do
    if ll=ntries | check0=0 then do
      if status1=2 then return ''
      return '-2 '||filename' could not be found '
    end
    call syssleep(1)
    iterate
  end
  leave
end

parse var atime mon '-' day '-' yr ahr ':' amin ':' asec
if yr<80 then
    yr='20'||yr
  else
    yr='19'||yr
bb=yr||mon||day                 
cc=dateconv(bb,'S','B')-726467  /*  726467 is 1 jan 1990 */
ss=((strip(ahr)*3600)+(amin*60)+asec)/86400
parse var ss . '.' ss
adate=cc||'.'||ss

if asize=0 then do
  if status1=2 then return ''
  return '0 '||adate||' '||strip(fulln)||'0d0a'x
end

do jj=1 to ntries
   astat=stream(fulln,'c','open read')
   if abbrev(strip(translate(astat)),'READY')=0 then do
      if jj=ntries then do
         if status1=2 then return ''
         return '-3 Unable to open: 'astat
      end
      call syssleep(1)
      iterate
   end
   leave
end
   
/* if here, successful open */
if status1=1 | status1=11 then do            /* status line only */
       if status1=1 then aa=stream(fulln,'c','close')
      return asize||' '||adate||' '||strip(fulln)||'0d0a'x
end

/* if here, read the file */
stuff=charin(fulln,1,asize)
aa=stream(fulln,'c','close')

if status1=2 then return stuff
return asize||' '||adate||' '||strip(fulln)||'0d0a'x||stuff




/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye got_rexxutil opsys noansi varname preimg postimg
parse arg amessage , altans,def,preface0,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       if noansi=0 then
          aynn=aynn'  '
       else
          aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

if preface0='' then 
 preface=normal||reverse
else
 preface=normal||preface0||reverse
do forever
 foo1=preface||amessage||'? '||normal||aynn||': 'normal
 goo=preface0||amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||preface||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 if got_rexxutil =1 then do
    anans=translate(sysgetkey('echo'))
 end
 else do
    pull anans
    anans=left(strip(anans),1)
 end

 if anans='?' then do   /* asking for help */
     call online_help varname
     say
     signal ony2
 end 

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0 & got_rexxutil=1 then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end



/*************/
/* rename old cfg file */
rename_cfg:procedure 

parse arg daname
bdir=filespec('d',daname)||filespec('p',daname)
if dosisdir(bdir'old')=1 then
  dd=bdir'old\'||filespec('n',daname)
else
  dd=daname

ip=lastpos('.',dd)
if ip=0 then do
   bakfile=dd||'.???'
end
else do
   bakfile=left(dd,ip)||'???'
end

bakfile=dostempname(bakfile)
say daname ' is being renamed as '  bakfile
foo=dosrename(daname,bakfile)
if foo=0 then  do
   say " ERROR: Unable to rename "dname " to "bakfile
   say "Changes were not saved."
   return 0
end
return 1

/***************/
/* write cfg file, with changes */
write_cfg:

/* get current values of plugin variables */
do until stuff=''
   parse var stuff aline '0d0a'x stuff
   aline0=strip(aline)
   if abbrev(translate(aline),';LAST-MODIFIED:')=1 then do
        call lineout daname,';last-modified: '||date('n')||' '||time('n')
        iterate
   end
   if abbrev(aline0,';')=1 | aline0='' then do
      call lineout daname,aline
      iterate
   end 
   parse var aline0 avar '=' aval
   avar=strip(translate(avar))
   if wordpos(avar,varlist)=0 then do
      call lineout daname,aline
      iterate
   end
   vv='!'||avar         /* else, write possibly changed value */
   useval=vals.vv
   call lineout daname,avar '=' useval
end
call lineout daname
say "Changes saved to "daname
return 1


/**************/
/* short description */
help1:
say
say cy_ye "SRE2003 Plugins "normal
say
say "This utility is used to add and remove "bold"plugins"normal" to the SRE2003 web server."
say
say "SRE2003 supports several types of "bold"plugins"normal":"
say "  1 : "bold"Filter"normal" : For resolving requests "
say "  2 : "bold"Fast-Filter"normal" : For quickly resolving simple requests "
say "  3 : "bold"Initialization procedures"normal" : Procedures to run when SRE2003 starts "
say "  4 : "bold"Pre-request procedures"normal" : Procedures to run before processing a request"
say "  5 : "bold"Pre-transaction procedures"normal" : Procedures to run before resolving a request"
say "  6 : "bold"IM procedures"normal" : Procedures to run before transmitting a response"
say "  7 : "bold"Exit procedures"normal" : Procedures to run when SRE2003 exits  "

do forever
   ii=yesno('Enter which type of plugin you want more information about ', ,
            'Done 1 2 3 4 5 6 7 ','D')
if ii=0 then return

select
 when ii=1 then do
say "  "bold"Filter"normal" : REQUIRED. "
say "     The filter uses information from the client to resolve the request"
say "     Typically, this means determining which file to send to the client. "
say "     However, it can mean much more -- including authentication, auditing, "
say "     encryption, creation of dynamic content, etc. etc. etc. All this is "
say "     the responsibility of the filter."
  end
  when ii=2 then do
say "  "bold"Fast-filter"normal" : Optional. "
say "     If specified, the fast-filter is called before the Filter. "
say "     Fast-filters are just like filters, the only difference is that "
say "     if a fast-filter can not resolve a request, then the filter is called."
say "     Fast-filters are typically small & fast -- they are especially useful "
say "     when a significant fraction of recieved requests are simple, and do not "
say "     require potentially time consuming features available in the filter."
  end
  when ii=3 then do
say "  "bold"Initialization procedures"normal" : Optional, though often essential."
say "     Initialization procedures are called once -- when SRE2003 starts. "
say "     Note that some filters require specific initialization procedures "
say "     (otherwise, they will not execute properly). Initialization procedures "
say "     are used to initialize 'host' information, and to launch filter specific "
say "     daemons. "
  end
  when ii=4 then do
say "  "bold"Pre-transaction procedures"normal" : Optional."
say "     Pre-transaction procedures are called before anything is read from"
say "     the client (but after SRE2003 has detected an incomng request). "
say "     Pre-transaction procedures can be used to discard requests "
say "     from selected clients, or when the server is too busy."
  end
  when ii=5 then do
say "  "bold"Pre-request procedures"normal" : Optional."
say "     Pre-request  procedures are called after reading the client's request "
say "     but before attempting to resolve it. Pre-request procedures can be "
say "     used for load balancing, for redirecting large classes of requests, "
say "     and for some forms of auditing."
  end
  when ii=6 then do
say "  "bold"Instance-manipulation (IM) procedures"normal" : Optional."
say "      Instance-manipulation procedures are used to modify responses."
say "      These modification do not effect the content of the response, instead"
say "      they are meant to facilitate rapid and secure transmission. Instance-"
say "      manipulation can be used for range extraction, and for delta encoding."
  end
  when ii=7 then do
say "  "bold"Exit procedures"normal" : Optional, though often essential."
say "     Exit procedures are called once -- when SRE2003 exits (stops running). "
say "     Note that some filters require specific exit procedures to "
say "     properly tidy up, etc. "
  end
  otherwise nop
end
say
end


