/* A Rexx CMD to start Jigsaw WWW Server */
parse source operatingSystem commandType sourceFileName
if operatingSystem="OS/2" 
Then DO
	PARSE ARG userId userPass
	userId= strip(userId)
	userPass = STRIP(userPass) 


	select
	        When userId='/?'
	                then signal Usage
	        When LENGTH(userId) = 0 | LENGTH(userPass) = 0
	                then signal Usage
	        Otherwise
	END


	rc=setlocal()
	env='OS2ENVIRONMENT'
	javaPath=Value('CLASSPATH', ,env)
	
	if pos('jigsaw.zip',rc)=0 
	then do
		pathJigsaw=FileSpec(drive,sourceFileName ) || FileSpec(path,sourceFileName )
		javaPath=pathJigsaw  || "classes\" || "jigsaw.zip;" || javaPath  
	end
	if pos('jigadmin.jar',rc)=0 
	then do
		pathJigsaw=FileSpec(drive,sourceFileName ) || FileSpec(path,sourceFileName ) 
		javaPath=pathJigsaw|| "classes\" || "jigadmin.jar;" || javaPath  
	end
	
	rc=Value('CLASSPATH',javaPath ,env)
	'@java org.w3c.jigsaw.admin.JigKill -u ' || userId || ' -p ' ||  userPass || '  --stop http://localhost:8009/'
	n=endlocal()
	exit
END
	                                         
USAGE:
SAY ' USAGE: [1;37mJigKill.CMD <Your Admin ID> <Your Admin Passwd>[0m'
SAY
SAY ' That is, if your [1;37mAdmin Id[0m is [1;37madmin[0m, and [1;37mPasswd[0m'
SAY ' is [1;37mpasswd[0m , then you told the program:'
SAY
SAY '   [1;37mJigKill.CMD admin passwd[0m'
SAY
SAY ' This script will kill the Jigsaw Server, and save all '
SAY ' changes you made to the server!'
SAY


