/* A Rexx CMD to start Jigadm */
parse source operatingSystem commandType sourceFileName
if operatingSystem="OS/2" 
Then DO
	PARSE UPPER ARG wpsInst
	wpsInst= strip(wpsInst)
	pathJigsaw=FileSpec(drive,sourceFileName ) || FileSpec(path,sourceFileName )
	n=setlocal() 

	if wpsInst='W'
		then call wpsCreateObjs pathJigsaw
	else if wpsInst='/?'
		then Signal Usage
	else if LENGTH(wpsInst) = 0
	                then do
		call serverJigsawInstall pathJigsaw
		call wpsCreateObjs pathJigsaw
		END
	else
		call serverJigsawInstall pathJigsaw

	n=endlocal() 
	exit
END

serverJigsawInstall: Procedure
	ARG pathJigsaw
	env='OS2ENVIRONMENT'
	javaPath=Value('CLASSPATH', ,env)

	if pos('jigsaw.zip',rc)=0 
	then do
		'@copy *.props '|| pathJigsaw || 'Jigsaw\config'	
		'@cd ' || pathJigsaw || 'Jigsaw'
		javaPath=pathJigsaw  || "classes\" || "jigsaw.zip;" || javaPath  
	end
	rc=Value('CLASSPATH',javaPath ,env)
	'@java  Install' 
	RETURN 0

wpsCreateObjs: Procedure
	ARG pathJigsaw
	/* Create an object and update it */
	call RxFuncAdd "SysCreateObject", "REXXUTIL", "SysCreateObject"
 
	/* Create a folder object, and then create a program object */
	 /* in that folder.*/
	rc=SysCreateObject("WPFolder", "Jigsaw WWW Server", "<WP_DESKTOP>",,
                             "OBJECTID=<JigFolder>")
	rc=SysCreateObject("WPProgram", "Jigsaw", "<JigFolder>",,
                             "EXENAME=" || pathJigsaw || "jigstart.cmd;" || "PROGTYPE=WINDOWABLEVIO;" || "MINIMIZED=YES;")              
	rc=SysCreateObject("WPProgram", "Jigadm", "<JigFolder>",,
                             "EXENAME=" || pathJigsaw || "jigadm.cmd;" || "PROGTYPE=WINDOWABLEVIO;" || "MINIMIZED=YES;")              
	rc=SysCreateObject("WPProgram", "Kill Jigsaw", "<JigFolder>",,
                             "EXENAME=" || pathJigsaw || "jigkill.cmd;" || "PROGTYPE=WINDOWABLEVIO;"||"PARAMETERS=[Please Input Your Id and Passwd];")              

	call rxfuncdrop 'SysCreateObject'
	Return 0

USAGE:
SAY ' USAGE: [1;37mJigInst.CMD <optional argument> [0m'
SAY
SAY ' That is a simple installation script for Jigsaw.'
SAY ' The default way is to run this CMD without any '
SAY ' argument, both the setup of Jigsaw and the '
SAY ' creation of WPS objects procedurs will be called. '
SAY ' However, sometimes you may only want to'
SAY ' re-setup Jigsaw to let it restore the default '
SAY ' configuration  or just want to re-create the WPS  '
SAY ' objs. If this is your case, then you can issue '
SAY ' argument as shown below :' 
SAY
SAY '   [1;37mJigInst.CMD J[0m'
SAY
SAY ' This will restore the default configuration, and the '
SAY ' argument :'
SAY
SAY '   [1;37mJigInst.CMD W[0m'
SAY
SAY ' will re-create the WPS objs. '
SAY
exit

