/* MOVEAUD.CMD -- remote control of a GoServe server                   */
/* ------------------------------------------------------------------- */
/* This sample command program sends a HTTP (Web) request to a server, */
/* with the default being the '!save' request that the sample filter   */
/* uses to trigger a Move Audit command.  Easily modified for other    */
/* remote control actions, or to be a general 'home page retriever'.   */
/* ------------------------------------------------------------------- */
/* Call as:  MOVEAUD [serveraddress [requeststring]]                   */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */

call load /* load functions if necessary */

parse arg server request .
if server=''  then server='your.server.here'
if request='' then request="!save"

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")

/* Set up request [HTTP 0.9 style, for all servers] */
message="GET /"request''crlf

got=''
rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)

/* Now wait for the response */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  got=got||response
  /* say '>'rc'>' response */
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

say 'Got' length(got) 'bytes of response:'
say got
exit

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return
