/* machine parsable logging of events
 * Copyright (C) 1999  Cendio Systems AB.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: plutoevents.h,v 1.1 2000/11/18 00:30:22 bj Exp $
 */

#ifndef PLUTOEVENTS__H
#define PLUTOEVENTS__H


enum plutoevents {
    PE_NO_MESSAGE,
    PE_ISAKMP_SA_ESTABLISHED,
    PE_ISAKMP_SA_REPLACED,
    PE_ISAKMP_SA_EXPIRED,
    PE_ISAKMP_SA_FAILURE,
    PE_UNKNOWN_PHASE1_PEER,
    PE_IPSEC_SA_ESTABLISHED,
    PE_IPSEC_SA_REPLACED,
    PE_IPSEC_SA_EXPIRED,
    PE_IPSEC_SA_FAILURE,
    PE_UNKNOWN_PHASE2_CONNECTION,
};

enum plutoreasons {
    PR_NO_ERROR,
    PR_AUTHENTICATION_FAILED,
    PR_UNKNOWN_CONNECTION,
};


enum { PE_MAGIC = 0x100C1514 };		/* Ctrl-P Ctrl-L Ctrl-U Ctrl-T */
enum { PE_VERSION = 100 };


struct pe_end {
    struct in_addr	host;
    int			id_type;
    int			id_len;
    char		identity[256];
    struct in_addr	client_net;
    struct in_addr	client_mask;
};


struct pluto_event {
    u_int32_t		magic;
    int			version;
    int			msglen;

    enum plutoevents	event;
    char		connection[32];
    struct pe_end	me;
    struct pe_end	peer;
    enum plutoreasons	reason;
};


#endif	/* PLUTOEVENTS__H */
