//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#include "vwdefs.h"

BOOL EXPENTRY vwInflateRect(PRECTL prclRect,SHORT sDx,SHORT sDy)
//-------------------------------------------------------------------------
// This function inflates the rectangle by the specified amounts.
// Obviously, specifying a negative number deflates the rectangle in
// the appropriate direction.
//
// Input:  prclRect - points to the RECTL structure
//         sDx - amount to inflate horizontally
//         sDy - amount to inflate vertically
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   prclRect->xLeft-=sDx;
   prclRect->xRight+=sDx;
   prclRect->yBottom-=sDy;
   prclRect->yTop+=sDy;
   return TRUE;
}

BOOL EXPENTRY vwIsRectEmpty(PRECTL prclRect)
//-------------------------------------------------------------------------
// This function determines if a rectangle is empty or not.
//
// Input:  prclRect - points to the RECTL structure
// Returns:  TRUE if empty, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   return ((prclRect->xLeft>prclRect->xRight) ||
           (prclRect->yBottom>prclRect->yTop));
}

BOOL EXPENTRY vwIntersectRect(PRECTL prclDest,PRECTL prclSrc1,PRECTL prclSrc2)
//-------------------------------------------------------------------------
// This function calculates the intersection of two rectangles.
//
// Input:  prclDest - points to the RECTL structure to hold the
//                    the result
//         prclSrc1, prclSrc2 - points to the RECTL structures to
//                              calculate the intersection of
// Returns:  TRUE if the rectangles intersect, FALSE if they do not
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   if ((prclDest==NULL) || (prclSrc1==NULL) || (prclSrc2==NULL)) {
      return FALSE;
   } /* endif */

   *prclDest=*prclSrc1;

   if (prclDest->xLeft<prclSrc2->xLeft) {
      prclDest->xLeft=prclSrc2->xLeft;
   } /* endif */

   if (prclDest->xRight>prclSrc2->xRight) {
      prclDest->xRight=prclSrc2->xRight;
   } /* endif */

   if (prclDest->yBottom<prclSrc2->yBottom) {
      prclDest->yBottom=prclSrc2->yBottom;
   } /* endif */

   if (prclDest->yTop>prclSrc2->yTop) {
      prclDest->yTop=prclSrc2->yTop;
   } /* endif */

   return (!vwIsRectEmpty(prclDest));
}
