/************************************************************
    prince.cmd

    REXX procedure to play some audio CD tracks via MMPM


    Marc E.E. van Woerkom, 1/94
 ************************************************************/


rc = call RxFuncAdd('mciRxInit', 'MCIAPI',,         /* register MCI REXX API */
                    'mciRxInit')
rc = call mciRxInit()                               /* and initialize it */


rc = mciRxSendString('open CDaudio',                /* open CDaudio */
                     'alias cd wait',,
                     'RetStr', '0', '0')

rc = mciRxSendString('set cd time format',          /* count in tracks */
                     'tmsf wait ',,                 /* (tt:mm:ss:ff)   */
                     'RetStr', '0', '0')
say rc

rc = mciRxSendString('play cd from 1:3:40 to 2:0:20 wait',,   /* play file */
                     'RetStr', '0', '0')
if rc <> 0 then do
    rc2 = mciRxGetErrorString(rc, 'ErrStVar')
    say 'ERROR! rc =' rc ', ErrStVar =' ErrStVar
    exit rc2
end

rc = mciRxSendString('close cd wait',,              /* close device "cd" */
                     'RetStr', '0', '0')
say rc

call mciRxExit

exit rc                                             /* exit with rc code */
