#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <os2.h>
#include <stdio.h>
#include <string.h>


#pragma argsused
int main(int argc, char **argv, char **envp) {
   int rc;
   char buf[100];
   FSQBUFFER2 buf2[2];
   char drive;
   char drivename[] = "a:";
   ULONG buflen;

   if (argc != 1 && argc != 3) {
      printf("FSATT - Attach / Query a drive\n"
             "Last revised" __DATE__ " " __TIME__ " by Andre Asselin\n"
             "\n"
             "Usage:\n"
             "FSATT\n"
             "           <drive><path>\n"
             "\n"
             "<drive>   Drive letter to attach or query\n"
             "<path>    Path to attach the driver letter to\n");
      return 1;
   }

   if (argc == 3) {
      rc = DosFSAttach(argv[1], "EXR0R3", argv[2], strlen(argv[2]) + 1, FS_ATTACH);
      printf("ret = 0x%x %d\n", rc, rc);
   } else {
      rc = DosError(FERR_DISABLEHARDERR | FERR_ENABLEEXCEPTION);
      if (rc != NO_ERROR){
         printf("DosError=%d", rc);
      }

      for (drive = 'c'; drive <= 'z'; drive++) {
         drivename[0] = drive;
         buflen = sizeof(buf2);
         rc = DosQueryFSAttach(drivename, 0, FSAIL_QUERYNAME, &buf2[0], &buflen);
         if (rc != ERROR_INVALID_DRIVE && rc != ERROR_NOT_READY) {
            printf("%s rc: %d type:%d item data:'%s' FSD name:'%s'\n",
                   drivename, rc, buf2[0].iType, buf2[0].szName,
                   buf2[0].szFSDName+buf2[0].cbName);
         }
      }
   }

   return 0;
}
