/* Show LSN 16 & LSN 17 on a HPFS partition */
ARG drive .
IF drive = '' THEN CALL Help
IF WordPos(drive,'? /? /H HELP A: B:') \= 0 THEN CALL Help

CALL RxFuncAdd 'ReadSect','Sector','ReadSect' /*In SECTOR.DLL*/
CALL RxFuncAdd 'RxDate','RexxDate','RxDate'   /*In REXXDATE.DLL*/

sectorString = ReadSect(drive, 16)     /* SuperBlock is LSN 16 */

'@cls'
SAY
SAY "Inspecting drive" drive
SAY
SAY "SUPER BLOCK (sector 16):"
SAY "     Signature Qword: 0x00  0x"FourChars2Hex(1) FourChars2Hex(5)
hpfsVer = Strip(C2X(Substr(sectorString,9,1)),'L','0')
SAY "        HPFS version: 0x08 " hpfsVer

funcVer = Strip(C2X(Substr(sectorString,10,1)),'L','0')
SELECT
WHEN funcVer = "2" THEN dispStr = "2          (<=4GB)"
WHEN funcVer = "3" THEN dispStr = "3          (>4GB)"
OTHERWISE dispStr = ''
END

SAY "  Functional Version: 0x09 " dispStr

CALL ShowDword "Root Directory Fnode",13
CALL ShowDwordPlusSize "Sectors in Partition",17
CALL ShowDwordPlusSize "    Bad Sector Count",21
CALL ShowDword " List of Bitmap Secs",25
CALL ShowDword "Bmp Sec list (spare)",29
CALL ShowDword " List of Bad Sectors",33
CALL ShowDword "Bad Sec List (spare)",37

lastChkdskRun = FourChars2Hex(41)
dateTimeString = SubStr(sectorString,41,4)
CALL DecipherDateTime dateTimeString
SAY "  CHKDSK /F Last Run: 0x28  0x"lastChkdskRun dateString timeString

lastOpt = FourChars2Hex(45)
dateTimeString = SubStr(sectorString,45,4)
CALL DecipherDateTime dateTimeString
SAY "      Last Optimised: 0x2C  0x"lastOpt dateString timeString

CALL ShowDwordPlusSize " Directory Band Secs",49

CALL ShowDword "  Dir Band Start Sec",53
CALL ShowDword "    Dir Band End Sec",57
CALL ShowDword "     Dir Band Bitmap",61
CALL ShowDword "User ID secs (8 sec)",97

SAY
sectorString = ReadSect(drive, 17)   /* SpareBlock is LSN 17 */
SAY "SPARE BLOCK (sector 17):"
SAY "     Signature Qword: 0x00  0x"FourChars2Hex(1) FourChars2Hex(5)
CALL ShowPartitionStatusFlags
CALL ShowDword "   HotFix List Start",13
CALL ShowDword " HotFix Entries Used",17
CALL ShowDword "Total HotFix Entries",21
CALL ShowDword "     # Spare DirBlks",25
CALL ShowDword "  Free Spare DirBlks",29
CALL ShowDword "   Code Page Dir Sec",33
CALL ShowDword "        # Code Pages",37
SAY  "    SuperBlock CRC32: 0x28  0x"FourChars2Hex(41)
SAY  "    SpareBlock CRC32: 0x2C  0x"FourChars2Hex(45)
spareDirBlocks = C2D(Reverse(Substr(sectorString,25,4)))
CALL ShowDword "  First Spare DirBlk",109
CALL ShowDword "   Last Spare DirBlk",109+(4*(spareDirBlocks-1))

EXIT  /********************EXECUTION ENDS HERE******************/


DriveInfo:          /* Determine drive geometry */
PARSE VALUE QDrive(drive) WITH totalSec totalCyl totalHd secPerTrk .
RETURN


FourChars2Hex:
ARG  startPos
RETURN C2X(Reverse(Substr(sectorString,startPos,4)))


ShowDword:
PARSE ARG label, offset
hexStr = FourChars2Hex(offset)
SAY label": 0x"D2X(offset-1,2) " 0x"hexStr "("X2D(hexStr)")"
RETURN


ShowDwordPlusSize:
PARSE ARG label, offset
hexStr = FourChars2Hex(offset)
decStr = X2D(hexStr)
SAY label": 0x"D2X(offset-1,2) " 0x"hexStr "("WithCommas(decStr)")" WithCommas(decStr / 2) "KB"
RETURN


TwoChars2Hex:
ARG offset
RETURN C2X(Reverse(Substr(sectorString,offset,2)))


WithCommas:
ARG string
string = Format(string,,,,12)
strLen = Length(string)
IF strLen >= 4 THEN
   string = Left(string, strLen-3)","Right(string,3)
ELSE
   RETURN string

IF strLen >= 7 THEN
   string = Left(string, strLen-6)","Right(string,7)
ELSE
   RETURN string

IF strLen >= 10 THEN
   string = Left(string, strLen-9)","Right(string,11)

RETURN string


DecipherDateTime:
ARG hexNum
num=C2D(Reverse(hexNum))
IF num = 0 THEN
   DO
   dateString = "(Never)"
   timeString = ""
   END
ELSE
   DO
   days = (num%86400)  /* Int div to get whole days since 1970 */

   remainderSecs = (num//86400)  /* Mod division to get remainder.
                         This is # of secs in last (part) day. */

   h = remainderSecs%3600   /* Whole hours in last day. */
   /* Format(num,2) will ensure that if num is only a single char
      then a space will precede it. Since we can't force Format()
      to use a leading 0 instead, use Translate(string,replacestr,
      findstr) to fix this so mins & secs have leading zeros. */

   /* Total whole mins in last day - mins in whole hours */
   m = Translate(Format(remainderSecs%60 - h*60,2),"0"," ")

   /* Take secs in whole mins & in whole hours away from total last day secs */
   s = Translate(Format(remainderSecs - h*3600 - m*60,2),"0"," ")

   /* We're going to use RXDATE20.xxx by Barry Pederson to work
      out the date. It will convert # of days since 1/1/0001 to
      a formatted date. Add 719162 to days count to adapt OS/2's
      1970-based counting to this. */
   days = days + 719162
   dateString = rxDate(days,'%d-%b-%y')
   timeString = h':'m':'s
   END
RETURN


ShowPartitionStatusFlags:
byte = Substr(sectorString,9,1)
IF BitAnd(byte, '1'x) = '1'x THEN
   status = 'Dirty'
ELSE
   status = 'Clean'

IF BitAnd(byte, '02'x) = '02'x THEN status = 'SpareUsed,' status
IF BitAnd(byte, '04'x) = '04'x THEN status = 'Hotfix,' status
IF BitAnd(byte, '08'x) = '08'x THEN status = 'BadSec,' status
IF BitAnd(byte, '10'x) = '10'x THEN status = 'BadBmp,' status
IF BitAnd(byte, '20'x) = '20'x THEN status = 'FastFmt,' status
IF BitAnd(byte, '80'x) = '80'x THEN status = 'OldVer,' status
SAY '    Partition Status: 0x08  0x'C2X(byte) '      ('status')'
RETURN


Help:
SAY
SAY
SAY "Purpose:"
SAY "  ShowSuperSpare    Decodes the SuperBlock & SpaceBlock"
SAY "                       sectors on a HPFS partition"
SAY
SAY "Example:"
SAY "  ShowSuperSpare C:"
SAY
EXIT
