#define INCL_DOSFILEMGR
#include <os2.h>
#include <iostream.h>
#include <string.h>

void writeEAs(const char* filename, const char* longname, const char* subject)
{
   const unsigned fea2listsize = 6000;
   const char LONGNAME[] = ".LONGNAME";
   const char SUBJECT[] = ".SUBJECT";
   EAOP2 eaop2;
   eaop2.fpGEA2List = 0;
   eaop2.fpFEA2List = PFEA2LIST(new char[fea2listsize]);
   PFEA2 pFEA2 = &eaop2.fpFEA2List->list[0];

   // create .LONGNAME EA
   pFEA2->fEA = 0; // .LONGNAME is not needed
   pFEA2->cbName = sizeof(LONGNAME)-1; // skip \0 terminator
      
   pFEA2->cbValue = strlen(longname)+2*sizeof(USHORT);
   //                                      ^
   //                           space for the type and length field.
   //

   strcpy(pFEA2->szName, LONGNAME);
   char* pData = pFEA2->szName+pFEA2->cbName+1; // data begins at
                                                // first byte after
                                                // the name
   *(USHORT*)pData = EAT_ASCII;             // type
   *((USHORT*)pData+1) = strlen(longname);  // length
   strcpy(pData+2*sizeof(USHORT), longname);// content

   pFEA2->oNextEntryOffset = sizeof(FEA2)+pFEA2->cbName+1+pFEA2->cbValue;

   // point to next EA, the .SUBJECT EA
   pFEA2 = PFEA2(PCHAR(pFEA2)+pFEA2->oNextEntryOffset);
   pFEA2->fEA = 0; // .SUBJECT is not needed
   pFEA2->cbName = sizeof(SUBJECT)-1; // skip \0 terminator

   pFEA2->cbValue = strlen(subject)+2*sizeof(USHORT);
   //                                      ^
   //                           space for the type and length field.
   //

   strcpy(pFEA2->szName, SUBJECT);
   pData = pFEA2->szName+pFEA2->cbName+1; // data begins at
                                                // first byte after
                                                // the name
   *(USHORT*)pData = EAT_ASCII;            // type
   *((USHORT*)pData+1) = strlen(subject);  // length
   strcpy(pData+2*sizeof(USHORT), subject);// content

   pFEA2->oNextEntryOffset = 0; // no more EAs to write.

   eaop2.fpFEA2List->cbList = PCHAR(pData+2*sizeof(USHORT)+pFEA2->cbValue)-PCHAR(eaop2.fpFEA2List);
   APIRET rc = DosSetPathInfo(filename,
                              FIL_QUERYEASIZE,
                              &eaop2,
                              sizeof(eaop2),
                              0);
   if (rc) {
      cerr << "DosSetPathInfo => " << rc << endl;
      return;
   } /* endif */
}

int main(int argc, char* argv[])
{
   if (argc != 4) {
      cerr << "Usage: write filename longname subject" << endl;
      return -1;
   } /* endif */
   writeEAs(argv[1], argv[2], argv[3]);
   return 0;
}
