/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * Xened - xened.h
 */

#ifndef _XENED_H_
#define _XENED_H_

/** Include files ********************************************************/ /*FOLD00*/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if defined (__EMX__)

#include <conio.h>
#include <dos.h>
#include <io.h>

#include <malloc.h>
#include <graph.h>
#include <os2.h>
#include <sys/kbdscan.h>

#elif defined (__TURBOC__)

#include <conio.h>
#include <dos.h>
#include <io.h>

#include <alloc.h>
/*#include <graphics.h>*/
#include "turboc.h"

#elif defined (__LINUX__)

#include <unistd.h>

#include "vga.h"
#include "vgagl.h"
#include "vgakeyboard.h"

#endif

/** Private include files ************************************************/ /*FOLD00*/

#include "config.h"
#include "textid.h"

/** Defines **************************************************************/ /*FOLD00*/

#if defined (__EMX__) /*FOLD00*/

#define DIR_SEPERATOR_CHAR '\\'

typedef unsigned char UBYTE;
typedef char *STRPTR;

enum
{
    BLACK,
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE,
};

#define C_UP            K_UP
#define C_DOWN          K_DOWN
#define C_LEFT          K_LEFT
#define C_RIGHT         K_RIGHT
#define C_END           K_END
#define C_HOME          K_HOME
#define PAGE_UP         K_PAGEUP
#define PAGE_DOWN       K_PAGEDOWN
#define ESC             27

#define  BIT_SET(buffer,bit_n)  \
    (*(((UBYTE *)(buffer))+((bit_n)>>3)) & (1<< ((bit_n) & 0x07)))

#define  SET_BIT(buffer,bit_n)  \
    *(((UBYTE *)(buffer))+((bit_n)>>3)) = (*(((UBYTE *)(buffer))+((bit_n)>>3)) \
    | (1<< ((bit_n) & 0x07)))

#elif defined (__LINUX__) /*FOLD00*/

#define DIR_SEPERATOR_CHAR '/'

#define BOOL                    char
typedef char *                  STRPTR;
#define VOID                    void

#define CHAR                    char
#define BYTE                    signed char
#define SHORT                   signed short int
#define LONG                    signed long int
#define UBYTE                   unsigned char
#define USHORT                  unsigned short int
#define ULONG                   unsigned long int
#define FLOAT                   float
#define DOUBLE                  double
#define INT                     int

#define G_MODE_VGA_L            G320x200x256

typedef VOID *PVOID;
typedef BYTE *PBYTE;

#define PSZ                     STRPTR

#define FALSE                   0
#define TRUE                    1

enum
{
    BLACK,
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE,
};

#ifdef _XCHARS_

#define C_UP           1001
#define C_DOWN         1002
#define C_LEFT         1003
#define C_RIGHT        1004
#define C_END          1005
#define C_HOME         1006
#define PAGE_UP        1007
#define PAGE_DOWN      1008
#define ESC            27
#define K_BACKTAB      8
#define K_DEL          1009

#else

#define C_UP           SCANCODE_CURSORBLOCKUP
#define C_DOWN         SCANCODE_CURSORBLOCKDOWN
#define C_LEFT         SCANCODE_CURSORBLOCKLEFT
#define C_RIGHT        SCANCODE_CURSORBLOCKRIGHT
#define C_END          SCANCODE_END
#define C_HOME         SCANCODE_HOME
#define PAGE_UP        SCANCODE_PAGEUP
#define PAGE_DOWN      SCANCODE_PAGEDOWN
#define ESC            SCANCODE_ESCAPE
#define K_BACKTAB      8
#define K_DEL          SCANCODE_REMOVE
#define TAB            SCANCODE_TAB

#endif

#define  BIT_SET(buffer,bit_n)  \
    (*(((UBYTE *)(buffer))+((bit_n)>>3)) & (1<< ((bit_n) & 0x07)))

#define  SET_BIT(buffer,bit_n)  \
    *(((UBYTE *)(buffer))+((bit_n)>>3)) = (*(((UBYTE *)(buffer))+((bit_n)>>3)) \
    | (1<< ((bit_n) & 0x07)))

SHORT _read_kbd (int echo, int wait, int sig);

#define stricmp strcmp  /* FIXME */

#elif defined (__TURBOC__) /*FOLD00*/

#define DIR_SEPERATOR_CHAR '\\'

#endif /*FOLD00*/

enum
{
    /*** Map editor ***/
    ACT_MAP_SET_FIELD,
    ACT_TILES_PAGE_UP,
    ACT_TILES_PAGE_DOWN,
    ACT_MAP_UP,
    ACT_MAP_DOWN,
    ACT_MAP_PAGE_UP,
    ACT_MAP_PAGE_DOWN,
    ACT_MAP_HOME,
    ACT_MAP_END,
    ACT_SAVE_MAP,
    ACT_QUIT,
    ACT_MAP_CLEAR_FIELD,
    ACT_TILES_NEXT,
    ACT_TILES_PREV,
    ACT_TILES_UP,
    ACT_TILES_DOWN,
    ACT_CURSOR_UP,
    ACT_CURSOR_DOWN,
    ACT_CURSOR_LEFT,
    ACT_CURSOR_RIGHT,
    ACT_GADGET_NEXT,
    ACT_GADGET_PREV,
    ACT_GADGET_SHOOT,

    /*** Edit weapon prices ***/
    ACT_WEAPON_PREV,
    ACT_WEAPON_NEXT,
    ACT_WEAPON_10_MORE,
    ACT_WEAPON_10_LESS,
    ACT_WEAPON_100_MORE,
    ACT_WEAPON_100_LESS,
    ACT_WEAPONS_SAVE,
    ACT_WEAPONS_OK,

    /*** Main menu ***/
    ACT_MENU_UP,
    ACT_MENU_DOWN,
    ACT_MENU_HOME,
    ACT_MENU_END,
    ACT_MENU_SHOOT,

    /*** Text viewer ***/
    ACT_VIEW_UP,
    ACT_VIEW_DOWN,
    ACT_VIEW_NEXT,
    ACT_VIEW_PREV,
    ACT_VIEW_OK,

    /*** Edit sector events ***/
    ACT_SECTOR_PREV,
    ACT_SECTOR_NEXT,
    ACT_SECTOR_1_MORE,
    ACT_SECTOR_1_LESS,
    ACT_SECTOR_10_MORE,
    ACT_SECTOR_10_LESS,
    ACT_SECTOR_SAVE,
    ACT_SECTOR_OK,

    /*** Configuration ***/
    ACT_ENGLISH,
    ACT_GERMAN,

    ACT_DIR_BACK,
    ACT_DIR_INPUT,
    ACT_DIR_OK,
};

#define  MAPFILE_N                     "map.cmp"
#define  TILEFILE_N                    "mods.vga"
#define  EXEFILE_N                     "xenon2.exe"
#define  DATFILE_N                     "xened.dat"
#define  CONFIGFILE_N                  "xened.cfg"

#define  XS_TILE                       16
#define  YS_TILE                       16

#define  XC_TILES                      10
/*#define  XC_TILES                      8*/
#define  YC_TILES                      2

#define  XS_MAP                        20
#define  YS_MAP                        300

#define  WIN_XS                        20
#define  WIN_YS                        10

#define  MSG_XS                        200
#define  MSG_YS                        45

#define  MSG_X                         ((320-MSG_XS)/2+1)
#define  MSG_Y                         ((200-MSG_YS)/2+11)

#if defined (__EMX__)

#define  GFX_INIT(m)                   g_mode (m)
#define  GFX_CLOSE()                   g_mode (G_MODE_OFF)
#define  GFX_SET(x,y,c)                g_set (x, y, c)
#define  GFX_GET(x,y)                  g_get (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)       g_line (x1, y1, x2, y2, c)
#define  GFX_BOX(x1,y1,x2,y2,c)        g_box (x1, y1, x2, y2, c, G_FILL)
#define  GFX_RECT(x1,y1,x2,y2,c)       g_box (x1, y1, x2, y2, c, G_OUTLINE)
#define  GFX_LOCK()                    g_lock ()
#define  GFX_UNLOCK()                  g_unlock ()
#define  GFX_CLEAR(c)                  g_clear (c)

#elif defined (__TURBOC__)

#define  GFX_INIT(m)                   setgfxmode (m)
#define  GFX_CLOSE()                   setgfxmode (0x03)
#define  GFX_SET(x,y,c)                putpixel (x, y, c)
#define  GFX_GET(x,y)                  getpixel (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)       line2 (x1, y1, x2, y2, c)
#define  GFX_BOX(x1,y1,x2,y2,c)        fillrect2 (x1, y1, x2, y2, c)
#define  GFX_RECT(x1,y1,x2,y2,c)       rectangle (x1, y1, x2, y2, c)
#define  GFX_LOCK()
#define  GFX_UNLOCK()
#define  GFX_CLEAR(c)                  cls ()

#elif defined (__LINUX__)

/*#define  GFX_INIT(m)                   vga_setmode (G320x200x256); \
    gl_setcontextvga (CONTEXT_PAGED)
#define  GFX_CLOSE()                   vga_setmode (TEXT)
#define  GFX_SET(x,y,c)                gl_setpixel (x, y, c)
#define  GFX_GET(x,y)                  gl_getpixel (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)       gl_line (x1, y1, x2, y2, c)
#define  GFX_BOX(x1,y1,x2,y2,c)        gl_fillbox (x1, y1, x2-x1+1, y2-y1+1, c)
#define  GFX_RECT(x1,y1,x2,y2,c)       gl_hline (x1, y1, x2, c); \
    gl_line (x2, y1, x2, y2, c); gl_hline (x2, y2, x1, c); \
    gl_line (x1, y2, x1, y1, c)
#define  GFX_LOCK()
#define  GFX_UNLOCK()
#define  GFX_CLEAR(c)                  gl_clearscreen (c) */

#define  GFX_INIT(m)                   vga_setmode (G320x200x256); \
    gl_setcontextvga (CONTEXT_PAGED)
#define  GFX_CLOSE()                   vga_setmode (TEXT)
#define  GFX_SET(x,y,c)                my_set (x,y,c)
#define  GFX_GET(x,y)                  vga_getpixel (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)       my_line (x1,y1,x2,y2,c)
#define  GFX_BOX(x1,y1,x2,y2,c)        my_box (x1,y1,x2,y2,c)
#define  GFX_RECT(x1,y1,x2,y2,c)       my_rect (x1,y1,x2,y2,c)

#define  GFX_LOCK()
#define  GFX_UNLOCK()
#define  GFX_CLEAR(c)                  vga_clear ()

#endif

#define  ERROR                         0xff
#define  SIZEOF_MAPTILE                128

#define  RANDOM(r)                     (rand()%r)

#define  MAX_SECTORS                   5

#define  MAX_MESSAGES                  13
#define  MAX_ENTRIES                   14

enum
{
    LANG_ENGLISH, LANG_GERMAN,
    LANG_MAX,
};

#define  CURSOR_CHAR                   '*'

/** More includes ********************************************************/ /*FOLD00*/

#include "tiles.h"
#include "gadgets.h"

/** Function prototypes **************************************************/ /*FOLD00*/

BOOL     LoadConfig (PSZ pszFilename);
BOOL     SaveConfig (PSZ pszFilename);
BOOL     QueryConfig (PGADGETLIST pgadlist, USHORT xo, USHORT yo);
BOOL     QueryDirectory (VOID);

/* -- from config.c ---------------------------------------------------- */

BOOL     LoadTiles (VOID);
BOOL     LoadMessages (PSZ pszFilename);
BOOL     DoMessageLoad (VOID);
BOOL     CheckArgs (SHORT argc, STRPTR argv[]);
BOOL     IsVGA (VOID);

/* -- from xened.c ----------------------------------------------------- */

VOID     draw_stone (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col3,
                     USHORT col1, USHORT col2);
VOID     ShadowRect (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col1,
                     USHORT col2);
VOID     Rect (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT col);
VOID     write_anz (USHORT anz, FILE *map_file);
VOID     do_stars (USHORT x1, USHORT y1, USHORT x2, USHORT y2);
BOOL     message (PSZ psz, USHORT usColor, USHORT xo, USHORT yo);

/* -- from misc.c ------------------------------------------------------ */

PTILEBOX      create_tilebox (USHORT cTiles, USHORT xs, USHORT ys);
PTILEBOX      load_tilebox (PSZ pszFilename);
PTILEBOX      load_tilebox_raw (FILE *pfile);

BOOL     show_tile (PTILEBOX ptilebox, USHORT us, USHORT ox, USHORT oy);
BOOL     show_tile_raw (PBYTE pc, USHORT xs, USHORT ys, USHORT ox, USHORT oy);
VOID     delete_tilebox (PTILEBOX ptbox);

/* -- from tiles.c ----------------------------------------------------- */

BOOL     show_string (PTILEBOX ptbox, PSZ pszString, USHORT ox, USHORT oy,
                      USHORT xs);
BOOL     raw_show_string (PTILEBOX ptbox, PSZ pszString, USHORT ox, USHORT oy);
BOOL     show_char (PTILEBOX ptbox, CHAR ch, USHORT ox, USHORT oy);

/* -- from text.c ------------------------------------------------------ */

BOOL     load_xenon_map (STRPTR map_file_n, USHORT map[YS_MAP][XS_MAP]);
BOOL     save_xenon_map (STRPTR map_file_n, USHORT map[YS_MAP][XS_MAP]);
BOOL     display_xenon_map (USHORT map[YS_MAP][XS_MAP], USHORT mx, USHORT my,
                            USHORT ox, USHORT oy, USHORT xs, USHORT ys,
                            FILE *vga_file, USHORT cx, USHORT cy,
                            BOOL do_cursor);

/* -- from xen_map.c --------------------------------------------------- */

BOOL     read_xenon_tile (FILE *pfile, PVOID pv);
/*BOOL     show_xenon_tile (struct XenonTile *tile);
 BOOL     show_xenon_tile_gfx (struct XenonTile *tile, SHORT ox, SHORT oy);*/

/* -- from xen_tile.c -------------------------------------------------- */

BOOL     gadlist_next (PGADGETLIST pgadlist);
BOOL     gadlist_prev (PGADGETLIST pgadlist);
USHORT   gadlist_shoot (PGADGETLIST pgadlist);
BOOL     gadlist_draw (PGADGETLIST pgadlist);

/* -- from gadgets.c --------------------------------------------------- */

SHORT    MainMenu (USHORT xo, USHORT yo);

#ifdef _MSG_SCROLL_
VOID     shift_left (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT dx);
#endif
VOID     do_msg_line (USHORT xo, USHORT yo);

/* -- from mainmenu.c -------------------------------------------------- */

VOID     EditWeapons (PGADGETLIST pgadlist, PSZ pszPath, USHORT xo, USHORT yo);
BOOL     LoadWeaponPrices (PSZ pszPath, USHORT rgus[]);
BOOL     SaveWeaponPrices (PSZ pszPath, USHORT rgus[]);

/* -- from ed_weaps.c -------------------------------------------------- */

VOID     EditSectorMap (PGADGETLIST pgadlist, PSZ pszPath, USHORT usSector);
PTILEBOX LoadMapTiles (PSZ pszFilename, FILE **ppfile);

/* -- from ed_map.c ---------------------------------------------------- */

VOID     EditSectorEvents (PGADGETLIST pgadlist, PSZ pszPath, USHORT usSector,
                           USHORT xo, USHORT yo);
BOOL     ChangeSectorEvents (PSZ pszPath, USHORT usSector);
BOOL     GetMaxMinValues (PSZ pszPath, USHORT usSector, SHORT rgsLimits[7][2]);

/* -- from ed_events.c ------------------------------------------------- */

VOID     Viewer (PGADGETLIST pgadlist, USHORT xo, USHORT yo);

/* -- from viewer.c ---------------------------------------------------- */

BOOL     load_gif (PSZ pszFilename, USHORT x, USHORT y);

/*************************************************************************/

#ifdef __LINUX__
void my_set (int x, int y, int c);
void my_line (int x1, int y1, int x2, int y2, int c);
void my_rect (int x1, int y1, int x2, int y2, int c);
void my_box (int x1, int y1, int x2, int y2, int c);
#endif

#endif
