/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * Xened - turboc.h - Special include file for Turbo C++
 */

#ifndef _TURBOC_H_
#define _TURBOC_H_

#ifdef __TURBOC__

#include <incs\mydefs.h>

typedef VOID *PVOID;
typedef STRPTR PSZ;
typedef BYTE *PBYTE;
typedef CHAR *PCHAR;

#define C_UP            C_UP-SPECIAL_KEYS
#define C_DOWN          C_DOWN-SPECIAL_KEYS
#define C_RIGHT         C_RIGHT-SPECIAL_KEYS
#define C_LEFT          C_LEFT-SPECIAL_KEYS
#define PAGE_UP         PAGE_UP-SPECIAL_KEYS
#define PAGE_DOWN       PAGE_DOWN-SPECIAL_KEYS
#define K_BACKTAB       BACK_TAB-SPECIAL_KEYS
#define K_DEL           DELETE-SPECIAL_KEYS
#define C_HOME          C_HOME-SPECIAL_KEYS
#define C_END           C_END-SPECIAL_KEYS

/*#define CLOCKS_PER_SEC  CLK_TCK*/

#define G_MODE_VGA_L    0x13

#include "vga.c"

#pragma argsused

SHORT _read_kbd (int echo, int wait, int sig)
{
    if (! wait)
        if (! kbhit ())
            return (-1);

    if (echo)
        return (getche ());

    return (getch ());
}

#endif
#endif
