/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * tiles.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PSZ    *rgpsz;
extern CHAR   g_pszErr[];

/*************************************************************************/

PTILEBOX create_tilebox (USHORT cTiles, USHORT xs, USHORT ys)
{
    PTILEBOX   ptbox;

    if (cTiles == 0)
        return (NULL);

    if (! (ptbox = (PTILEBOX) malloc (sizeof (TILEBOX))))
    {
        message (rgpsz[TXT_COULD_NOT_ALLOCATE_TILEBOX], RED, MSG_X, MSG_Y);
        return (NULL);
    }

    ptbox->xs = xs;
    ptbox->ys = ys;
    ptbox->cTiles = cTiles;
    
    if (! (ptbox->pv = (PVOID) malloc (ptbox->xs * ptbox->ys
                                       * ptbox->cTiles)))
    {
        free (ptbox);
        message (rgpsz[TXT_COULD_NOT_ALLOCATE_TILE_BUFFER], RED, MSG_X, MSG_Y);
        return (NULL);
    }

    return (ptbox);
}
/*************************************************************************/

PTILEBOX load_tilebox (PSZ pszFilename)
{
    FILE       *pfile;
    PTILEBOX   ptbox;

    if (! (pfile = fopen (pszFilename, "rb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszFilename);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (NULL);
    }

    ptbox = load_tilebox_raw (pfile);

    fclose (pfile);
    return ptbox;
}
/*************************************************************************/

PTILEBOX load_tilebox_raw (FILE *pfile)
{
    USHORT     i, xs, ys, cTiles;
    PVOID      pv;
    PTILEBOX   ptbox;

    fread (&xs, 1, sizeof (xs), pfile);
    fread (&ys, 1, sizeof (ys), pfile);
    fread (&cTiles, 1, sizeof (cTiles), pfile);

    if (! (ptbox = create_tilebox (cTiles, xs, ys)))
    {
        message (rgpsz[TXT_COULD_NOT_ALLOCATE_TILEBOX], RED, MSG_X, MSG_Y);
        return (NULL);
    }

    pv = ptbox->pv;
    for (i = 0; i < ptbox->cTiles; i++)
    {
        fread (pv, 1, ptbox->xs * ptbox->ys, pfile);
        (PBYTE) pv += ptbox->xs * ptbox->ys;
    }

    return (ptbox);
}
/*************************************************************************/

BOOL show_tile (PTILEBOX ptbox, USHORT us, USHORT ox, USHORT oy)
{
    PBYTE   pc;

    if ((! ptbox) || (us > ptbox->cTiles))
        return FALSE;

    pc = ((PBYTE)(ptbox->pv))+us*ptbox->ys*ptbox->xs;
    show_tile_raw (pc, ptbox->xs, ptbox->ys, ox, oy);

    return TRUE;
}
/*************************************************************************/

BOOL show_tile_raw (PBYTE pc, USHORT xs, USHORT ys, USHORT ox, USHORT oy)
{
    SHORT   x, y;
    
    GFX_LOCK ();
    
    for (y = 0; y < ys; y++)
        for (x = 0; x < xs; x++)
#ifdef _NEWPALETTE_
            GFX_SET (x+ox, y+oy, (*pc++)+16);
#else
            GFX_SET (x+ox, y+oy, *pc++);
#endif

    GFX_UNLOCK ();
    return TRUE;
}
/*************************************************************************/

VOID delete_tilebox (PTILEBOX ptbox)
{
    if (ptbox)
    {
        if (ptbox->pv)
            free (ptbox->pv);
        free (ptbox);
    }
}
/*************************************************************************/
