/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

//#define _VERBOSE_
#define _TEST_

#include <graph.h>
#include <stdio.h>
#include <stdlib.h>

#include <os2.h>

/*************************************************************************/

#ifdef _TEST_
#define  GFX_INIT(m)              g_mode (m)
#define  GFX_CLOSE()              g_mode (G_MODE_OFF)
#define  GFX_SET(x,y,c)           g_set (x, y, c)
#define  GFX_GET(x,y)             g_get (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)  g_line (x1, y1, x2, y2, c)
#define  GFX_BOX(x,y,xs,ys,c)     g_box (x, y, x+xs-1, y+ys-1, c, G_FILL)
#define  GFX_RECT(x,y,xs,ys,c)    g_box (x, y, x+xs-1, y+ys-1, c, G_OUTLINE)
#define  GFX_LOCK()               g_lock ()
#define  GFX_UNLOCK()             g_unlock ()
#endif

#define GIF_ID_STR "GIF87a"
#define MAX_BITPLANES 8
#define IMAGE_DESC_CHAR ','

enum { IFO_SEQUENTIAL, IFO_INTERLACED };

struct GIFScreenDescr
{
    USHORT   xs, ys;
    BOOL     fGCM;
    USHORT   cBitplanes, cPixel;
    USHORT   colidxBack;
};

struct GIFImageDescr
{
    USHORT   x, y, xs, ys;
    BOOL     fLCM;
    USHORT   ifo;
    USHORT   cBitplanes;
};

/*************************************/

#include "decoder.c"

BOOL     load_gif (PSZ pszFilename, USHORT x, USHORT y);
USHORT   convert_tiles (PSZ pszFilename, USHORT xs, USHORT ys);

/*************************************/

FILE *g_pfile;
INT  g_ypos = 0;
INT  bad_code_count;

/*************************************/

#ifdef _TEST_

VOID main (INT argc, PCHAR argv[])
{
    USHORT   cTiles;
    
    GFX_INIT (G_MODE_VGA_L);

    if (argc > 1)
    {
        load_gif (argv[1], 0, 0);
        getchar ();
    }
    if (argc > 2)
    {
        cTiles = convert_tiles (argv[2], atoi (argv[3]), atoi (argv[4]));
        GFX_CLOSE ();
        printf ("%d tiles found.\n", cTiles);
    }
    else
        GFX_CLOSE ();

    exit (0);
}

USHORT convert_tiles (PSZ pszFilename, USHORT xs, USHORT ys)
{
    BOOL     f = TRUE;
    USHORT   c = 0, x = 0, y = 0, dx, dy;
    LONG     lPos;
    FILE     *pfile;

    if (! (pfile = fopen (pszFilename, "wb")))
        return c;

    fwrite (&xs, 1, sizeof (xs), pfile);
    fwrite (&ys, 1, sizeof (xs), pfile);
    lPos = ftell (pfile);
    fwrite (&c, 1, sizeof (c), pfile);
    
    /*** Read/Write tiles up to empty tile ***/
    while (f)
    {
        f = FALSE;
        for (dy = 0; dy < ys; dy++)
            for (dx = 0; dx < xs; dx++)
                if (putc (GFX_GET (x+dx, y+dy), pfile))
                    f = TRUE;
                    
        x += xs+1;
        if (x > 320-xs)
        {
            y += ys+1;
            x = 0;
        }
        c ++;
    }

    fseek (pfile, lPos, SEEK_SET);
    fwrite (&c, 1, sizeof (c), pfile);

    fclose (pfile);

    return c;
}

#endif

/*************************************************************************/

INT get_byte (void)
{
    return (getc (g_pfile));
}

INT out_line (BYTE pixels[], INT linelen)
{
    USHORT   i;

    for (i = 0; i < linelen; i++)
        GFX_SET (i, g_ypos, pixels[i]);
    g_ypos ++;

    return (1);
}
/*************************************************************************/

BOOL load_gif (PSZ pszFilename, USHORT x, USHORT y)
{
    CHAR   rgch[11];
    BYTE   b;
    USHORT check;
    LONG   l;
    FILE   *pfile;
    
    struct GIFScreenDescr   gscrdsc;
    struct GIFImageDescr    gimgdsc;

    // Open GIF-file
    if (! (pfile = fopen (pszFilename, "rb")))
    {
        fprintf (stderr, "ERROR: Could not open file \"%s\".\n", pszFilename);
        return (FALSE);
    }

    g_pfile = pfile;

    // Check ID-string at start of file
    fread (rgch, 1, strlen (GIF_ID_STR), pfile);
    rgch[strlen (GIF_ID_STR)] = '\0';
    if (strcmp (rgch, GIF_ID_STR) != 0)
    {
        fprintf (stderr, "ERROR: Not a (valid) GIF-file: \"%s\".\n",
                 pszFilename);
        fclose (pfile);
        return (FALSE);
    }

    // Read GIF-ScreenDescriptor
    fread (&(gscrdsc.xs), 1, 2, pfile);
    fread (&(gscrdsc.ys), 1, 2, pfile);
    b = getc (pfile);
    gscrdsc.fGCM = (b & 0x80) ? TRUE : FALSE;
    if ((gscrdsc.cBitplanes = (b & 0x07)) > MAX_BITPLANES)
    {
        fprintf (stderr, "WARNING: More than %d bitplanes?! (global)\n",
                 MAX_BITPLANES);
        gscrdsc.cBitplanes = MAX_BITPLANES;
    }
    gscrdsc.colidxBack = getc (pfile);
    b = getc (pfile);

#ifdef _VERBOSE_
    printf ("ScreenDescriptor:\n"
            "\txsScreen = %d\n"
            "\tysScreen = %d\n"
            "\tGlobalColorMap? %s\n"
            "\t#Bitplanes = %d\n"
            "\tColIndex Background = %d\n",
            gscrdsc.xs, gscrdsc.ys,
            gscrdsc.fGCM ? "yes" : "no",
            gscrdsc.cBitplanes,
            gscrdsc.colidxBack);
#endif
    
    // Read GlobalColorMap if exists
    if (gscrdsc.fGCM)
    {
        // FIXME do sth with this values!
        l = (1 << gscrdsc.cBitplanes) * 3L;
        fseek (pfile, l, SEEK_CUR);
    }

    // Look for ImageDescriptor
    while (getc (pfile) != IMAGE_DESC_CHAR)
        ;

    // Read GIF-ImageDescriptor
    fread (&(gimgdsc.x), 1, 2, pfile);
    fread (&(gimgdsc.y), 1, 2, pfile);
    fread (&(gimgdsc.xs), 1, 2, pfile);
    fread (&(gimgdsc.ys), 1, 2, pfile);
    b = getc (pfile);
    gimgdsc.fLCM = (b & 0x80) ? TRUE : FALSE;
    gimgdsc.ifo = (b & 0x40) ? IFO_SEQUENTIAL : IFO_INTERLACED;
    if ((gimgdsc.cBitplanes = (b & 0x07)) > MAX_BITPLANES)
    {
        fprintf (stderr, "WARNING: More than %d bitplanes?! (for image)\n",
                 MAX_BITPLANES);
        gimgdsc.cBitplanes = MAX_BITPLANES;
    }

#ifdef _VERBOSE_
    printf ("ImageDescriptor:\n"
            "\txsImage = %d\n"
            "\tysImage = %d\n"
            "\txImage = %d\n"
            "\tyImage = %d\n"
            "\tLocalColorMap? %s\n"
            "\tImageOrder = %s\n"
            "\t#Bitplanes = %d\n",
            gimgdsc.xs, gimgdsc.ys,
            gimgdsc.x, gimgdsc.y,
            gimgdsc.fLCM ? "yes" : "no",
            (gimgdsc.ifo = IFO_SEQUENTIAL) ? "Sequential" : "Interlaced",
            gimgdsc.cBitplanes);
#endif

    // Read LocalColorMap if exists
    if (gimgdsc.fLCM)
    {
        // FIXME do sth with this values!
        l = (1 << gscrdsc.cBitplanes) * 3L;
        fseek (pfile, l, SEEK_CUR);
    }

#ifdef _VERBOSE_
    getchar ();
#endif

    GFX_LOCK ();    
    if ((check = decoder (gimgdsc.xs)))
    {
        fprintf (stderr, "ERROR: Could not decode (ErrCode = %d)\n", check);
        fclose (pfile);
        return (FALSE);
    }
    GFX_UNLOCK ();
    
    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/
