!       NewLock         A replacement for Lock and Unlock to implement multiple
!                       keys and key-side definition.  By L. Ross Raszewski
!
! Ever wanted to have multiple keys for the same lockable object?  Instead of 
! using "with_key" on the lock, use "key_to" on the key.  "key_to" can hold
! a single value or an array, and works just as well as "with_key" 
!
! Before inclusion of "verblib.h", insert these two lines:
!       Replace LockSub;
!       Replace UnlockSub;
! Include this file shortly after Verblib.
!
! Example: Create a stone door which can be opened by a stone key or a skeleton
! key, which also unlocks a wood door.
!
! Object stonedoor "Stone Door"
!       has openable closed lockable door static;
!
! Object stone_key "Stone key"
!       with  key_to stonedoor;
!
! Object s_key "Skeleton Key"
!       with  key_to stonedoor wood_door;
!

property key_to $ffff;
[ TestforKey obj pkey j;
        if (obj.with_key==pkey) rtrue;
        for (j=0:j<=(pkey.#key_to):j++)
                if ((pkey.&key_to)-->j==noun) rtrue;
rfalse;
];
[ UnlockSub;
  if (noun hasnt lockable) return L__M(##Unlock,1);
  if (noun hasnt locked)   return L__M(##Unlock,2);
  if (TestForKey(noun,second)~=1) return L__M(##Unlock,3);
  give noun ~locked;
  if (AfterRoutines()==1) rtrue;
  if (keep_silent==1) rtrue;
  L__M(##Unlock,4,noun);
];
[ LockSub;
  if (noun hasnt lockable) return L__M(##Lock,1);
  if (noun has locked)     return L__M(##Lock,2);
  if (noun has open)       return L__M(##Lock,3);
  if (TestForKey(noun,second)~=1) return L__M(##Lock,4);
  give noun locked;
  if (AfterRoutines()==1) rtrue;
  if (keep_silent==1) rtrue;
  L__M(##Lock,5,noun);
];

