! FLAGS.H by Adam Cadre

! This is a simple system to provide on/off flags that only take up one bit of memory; thus,
! there's no need to waste memory by declaring a variable such as "doneflag" or some such,
! allocating an entire eight bits to a variable that will never be anything other than 0 or 1.

! Here's how to use it in your programs. First of all, every time you use a flag, make sure
! you make a note of what it means. I make a commented list, like so:

! 0: Has Beauford eaten the corn and fed the raccoon in the proper order?
! 1: Has Hildegard booked her plane tickets to Paraguay with the correct credit card?
! ...
! 53: Is the weasel hiding in the pantaloons?

! You get the idea. Note that the first flag is flag #0, not flag #1.

! Setting a flag on or off means calling the routing SetFlag -- 1 for on, 0 for off. So
! to indicate that the weasel is in fact hiding in the pantaloons, call "SetFlag(53,1);",
! and to turn off that flag, call "SetFlag(53,0);"  (Minus the quote marks, of course.)

! Testing a flag is accomplished by calling FlagOn. So if you have a piece of code that
! should only be run if the weasel is hiding in the pantaloons, you would enclose it in
! an "if (FlagOn(53)) { ... }" statement. Naturally, you can test if a flag is off by
! negating that condition, or checking if the flag == 0.

Array flag -> 1;  ! Change this number if you need more flags. Each element in the array
                  ! provides eight flags, so if you change the number to five, you get forty
                  ! flags, 0 through 39.

[ SetFlag x onoff y z;
  y = x / 8;
  z = x % 8;
  z = Power(2,z);
  if (onoff == 1) {
     flag->y = flag->y | z; }
  if (onoff == 0) {
     flag->y = flag->y & ~z; }
];

[ FlagOn x y z;
  y = x / 8;
  z = x % 8;
  z = Power(2,z);
  if (flag->y & z == z) { rtrue; }
  rfalse;
];

[ Power a b c sum;
  sum = a;
  if (b == 0) { return(1); }
  if (b == 1) { return(a); }
  for (c=0: c<b-1: c++) {
     sum = sum * a;
  }
  return(sum);
];
