!    WhatIs             An improvement upon "What is" commands such as 
!                       the Zork-like "What is a Grue" and "Who am I"
!                       By L. Ross Raszewski
!
! Give anything you wish to "What is" the attribute "queryable" and put the
! response in the "whatsit" property of that object.
! Whatsit can be a string or routine.
! you can change the queryable attribute throughout the game, allowing you to 
! do such things as only allowing a player to query an object he has seen 
! before.
!
! This library also responds to the question "Who am I" by printing "You are
! (the name of the player-object)" This can be useful for multiple player 
! games or games in which the player plays a predetermined character.
!
! The tokens IsAmAre and AllObjsScope can be used by verb grammar.  The former
! accepts the words "is" "am" or "are".  The second places all objects in 
! scope.
!
! Also included is the "queryobj", a place where you can put queryable 
! objects which do not appear in the game.  The only reason I include this
! is so you can have something such as your "ChoosObjs" entry point prefer
! objects in the "queryobj".  A sample question, "What is a Grue" is provided
!
!
Attribute queryable;
Property whatsit;
[ WhoAmISub;
        if (player has general) "Good Question";
        print_ret "You are ", object player, ".";
        ];
[ IsAmAre w;
        w=NextWord(); if (w=='is' or 'am' or 'are') return 0; return -1;];
[ AllObjsScope i;
        if (scope_stage==1) rfalse;
        if (scope_stage==2)
           {    for (i=selfobj:i<=top_object:i++) PlaceInScope(i); rtrue;};
           ];
[ WhatIsSub ;
        if (noun==player) <<WhoAmI>>;
        if (noun hasnt queryable) print_ret "Good Question";
        if (Zregion(noun.whatsit)==2 or 3)
        { PrintOrRun(noun,whatsit); rtrue;};
        "Good Question";
        ];
[ WhatIsESub;
 "What is what?";];
verb "who"  "what" 
           * IsAmAre                                    ->WhatIsE
           * IsAmAre "I"                                ->WhoAmI
           * IsAmAre "I?"                               ->WhoAmI
           * IsAmAre scope=AllObjsScope                 ->WhatIs;
Object queryobj "WhatIs Objects";
nearby qgrue "grue"
        with name "grue" "lurking",
        whatsit "A hideous creature which lurks in darkness, feeding on \
                adventurers foolish enough to enter a cave without their \
                brass lantern.",
        has queryable;
