/* Installationsskript zur Kreuzwortrtsel-Datenbank  */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree 'kwd_1.*', datei, 'FO'
IF datei.0 < 1 THEN
DO
   SAY "Bitte legen Sie die erste Installationsdiskette ins Disketten-"
   SAY "laufwerk und beginnen Sie nochmal."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installationsscript zur Kreuzwortrtel-Datenbank  (c) 1995 Uwe Schlenther"
SAY "========================================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "In welchem Pfad soll die Kreuzwortrtsel-Datenbank installiert werden ?"
SAY "(z.B. C:\KREUZ)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\KREUZ"
SAY " "
SAY "Die Kreuzwortrtsel-Datenbank wird im Pfad " pfad " installiert."
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch!"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Danke...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY KWD_1.EXE 'pfad"

CALL SysFileTree 'kwd.exp', datei, 'FO'

if datei.0>0 then
  INTERPRET "'COPY KWD.EXP 'pfad"

SAY " "
SAY "Bitte legen Sie die zweite Diskette ein und drcken Sie die Taste <return>."
PULL antwort

INTERPRET "'COPY KWD_2.EXE 'pfad"
INTERPRET "pfad'\KWD_1.EXE 'pfad' /o >NUL'"
INTERPRET "'DEL 'pfad'\KWD_1.EXE'"
INTERPRET "pfad'\KWD_2.EXE 'pfad' /o >NUL'"
INTERPRET "'DEL 'pfad'\KWD_2.EXE'"
INTERPRET "'DEL 'pfad'\Apply-EA.CMD'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr die Kreuzwortrtsel-Datenbank erstellt werden?"
SAY "Geben sie <J> oder <N> ein!"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."

/* Den Ordner anlegen */
klasse='WPFolder'
titel='Kreuzwortrtsel'
ort='<WP_DESKTOP>'
param='OBJECTID=<KR_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='Kreuzwortrtsel'
ort='<KR_ORDNER>'
param='PROGTYPE=PM;EXENAME='pfad'\KWD.EXE;ICONFILE='pfad'\KWD.ICO;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='Hilfe zur Kreuzwortrtsel-Datenbank'
ort='<KR_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\KWD.INF;'
mode='fail'
Location = "<WP_TEMPS>"
Title = "Hilfedatei"
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY "Die Kreuzwortrtsel-Datenbank ist jetzt installiert!"
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal!"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY "Schade, da Sie das Installationsprogramm abgebrochen haben!"
EXIT

