/*
 * PM Satellite/2 1.0 installation program copyright (c) Fredrik Ax 1995
 *
 * This program creates program objects for the files "pmsatsw.exe",
 * (Shareware version of PM Satellite/2), "shellsat.exe" (Shell Satellite) and
 * "pmsat.exe" (registered version) if the files exists.
 */

'@Echo off'
'cls'

say'     Ŀ'
say'                 PM Satellite/2 1.0 Installation Program                '
say'           PM Satellite/2 is copyrighted (c) 1995 by Fredrik Ax         '
say'                           All rights reserved                          '
say'     Ĵ'
say'     Ĵ'
say'                   Have you read the README.OS2 file yet?               '
say'            It tells you how to install, so you should read it.         '
say'     '


/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates objects for PM Satellite/2 (shareware and registered'
say 'version) and Shell Satellite.'
say ''

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* NOTE:  remove following 6 lines for unattended use... */
call charout ,'  Press [Enter] to continue...'
dummy = ''
do until dummy = '0d'x
  dummy = SysGetKey('NOECHO')
end
call charout ,'0d1b'x'[K'

/* save current directory */
curdir = directory()

/* create folder */
title = "Satellite/2"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<SAT_Folder>;OPEN=DEFAULT'
result = SysCreateObject(classname,title,location,setup,f)

/* create program object for "pmsat.exe" */
rc = stream('pmsat.exe','c','query exists')
if rc \= '' then
do
  title = "PM Satellite/2"
  classname = 'WPProgram'
  location = '<SAT_Folder>'
  setup = 'EXENAME='curdir'\pmsat.exe;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS='
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "pmsat.exe" (Registered version)."

/* create program object for "pmsatsw.exe" */
rc = stream('pmsatsw.exe','c','query exists')
if rc \= '' then
do
  title = "PM Satellite/2 ShareWare version"
  classname = 'WPProgram'
  location = '<SAT_Folder>'
  setup = 'EXENAME='curdir'\pmsatsw.exe;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS='
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "pmsatsw.exe" (Unregistered version)."

/* create program object for "shellsat.exe" */
rc = stream('shellsat.exe','c','query exists')
if rc \= '' then
do
  title = "Shell Satellite"
  classname = 'WPProgram'
  location = '<SAT_Folder>'
  setup = 'EXENAME=CMD.EXE;STARTUPDIR='curdir';PARAMETERS= /c "mode 100 40 & 'curdir'\shellsat.exe"'
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "shellsat.exe"."

/* create program object for "register.txt" */
rc = stream('register.txt','c','query exists')
if rc \= '' then
do
  title = "Register.TXT"
  classname = 'WPShadow'
  location = '<SAT_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "register.txt"."

/* create program object for "register.frm" */
rc = stream('register.frm','c','query exists')
if rc \= '' then
do
  title = "Register.FRM"
  classname = 'WPShadow'
  location = '<SAT_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "register.frm"."

/* create program object for "README.OS2" */
rc = stream('README.OS2','c','query exists')
if rc \= '' then
do
  title = "ReadMe.OS2"
  classname = 'WPShadow'
  location = '<SAT_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "README.OS2"."

/* create program object for "pmsat.inf" */
rc = stream('pmsat.inf','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter=';ASSOCFILTER=*.INF'
  title = "PM Satellite/2 Online Help"
  classname = 'WPProgram'
  location = '<SAT_Folder>'
  setup = 'EXENAME=VIEW.EXE;STARTUPDIR='curdir';PARAMETERS='curdir'\pmsat.inf'
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "pmsat.inf"."

/* create program object for "LICENSE.INF" */
rc = stream('LICENSE.INF','c','query exists')
if rc \= '' then
do
  if assocfilter \= '' then assocfilter=';ASSOCFILTER=*.INF'
  title = "License agreement for PM Satellite/2 "
  classname = 'WPProgram'
  location = '<SAT_Folder>'
  setup = 'EXENAME=VIEW.EXE;STARTUPDIR='curdir';PARAMETERS='curdir'\LICENSE.INF "License agreement for PM Satellite/2"'
  call SysCreateObject classname,title,location,setup,u
end
else
  say "Can't find "LICENSE.INF"."

/* Final words */
say 'Ŀ'
say ' Finaly I want to thank M. Kimes which "INSTALL.CMD" that comes with '
say '   his execellent FM/2 have helped me alot in making this file :-)   '
say 'Ĵ'
say '    To move PM Satellite/2 to another directory, move the files,     '
say '       delete the PM Satellite/2 folder, then rerun INSTALL.         '
say ''
say "I'm done now."
say ''

