
/* action.c */
void action_command(char *arg, struct session *ses);
void unaction_command(char *arg, struct session *ses);
void prepare_actionalias(char *string, char *result, struct session *ses);
void substitute_vars(char *arg, char *result);
void check_all_actions(char *line, struct session *ses);
int match_a_string(char *line, char *mask);
int check_one_action(char *line, char *action, struct session *ses);
int check_a_action(char *line, char *action, struct session *ses);

/* alias.c */
void alias_command(char *arg, struct session *ses);
void unalias_command(char *arg, struct session *ses);

/* antisub.c */
void parse_antisub(char *arg, struct session *ses);
void unantisubstitute_command(char *arg, struct session *ses);
int do_one_antisub(char *line, struct session *ses);

/* echo.c */
void init_echo(void);
void term_echo(void);
void term_noecho(void);
void term_echo(void);
void term_noecho(void);
void term_echo(void);
void term_noecho(void);

/* files.c */
void read_complete(void);
void log_command(char *arg, struct session *ses);
struct session *read_command(char *filename, struct session *ses);
struct session *write_command(char *filename, struct session *ses);
struct session *writesession_command(char *filename, struct session *ses);
void prepare_for_write(char *command, char *left, char *right, char *pr, char *result);
void prepare_quotes(char *string);

/* foobar.c */

/* glob.c */
int match(char *regex, char *string);

/* help.c */
FILE *check_file(char *filestring);
void help_command(char *arg);
   
/* highlight.c */
void parse_high(char *arg, struct session *ses);
int is_high_arg(char *s);
void unhighlight_command(char *arg, struct session *ses);
void do_one_high(char *line, struct session *ses);
void add_codes(char *line, char *result, char *htype, int flag);

/* history.c */
void history_command(struct session *ses);
void do_history(char *buffer, struct session *ses);
void insert_history(char *buffer, struct session *ses);
struct session *parse_history_command(char *command, char *arg, struct session *ses);

/* ivars.c */
void math_command(char *line, struct session *ses);
void if_command(char *line, struct session *ses);
int eval_expression(char *arg);
int conv_to_ints(char *arg);
int do_one_inside(int begin, int end);

/* llist.c */
struct listnode *init_list(void);
void kill_list(struct listnode *nptr);
void kill_all(struct session *ses, int mode);
struct listnode *copy_list(struct listnode *sourcelist, int mode);
void insertnode_list(struct listnode *listhead, char *ltext, char *rtext, char *prtext, int mode);
void deletenode_list(struct listnode *listhead, struct listnode *nptr);
struct listnode *searchnode_list(struct listnode *listhead, char *cptr);
struct listnode *searchnode_list_begin(struct listnode *listhead, char *cptr, int mode);
void shownode_list(struct listnode *nptr);
void shownode_list_action(struct listnode *nptr);
void show_list(struct listnode *listhead);
void show_list_action(struct listnode *listhead);
struct listnode *search_node_with_wild(struct listnode *listhead, char *cptr);
int check_one_node(char *text, char *action);
void addnode_list(struct listnode *listhead, char *ltext, char *rtext, char *prtext);
int count_list(struct listnode *listhead);

/* main.c */
void tstphandler(int sig, int code, void *nscp, char *addr);
void _Optlink tick_func_alarm(void *Unused);
void main(int argc, char **argv, char **environ);
void tintin(void);
int interpret_buffer(char *buffer, struct session *ses);
int read_mud(struct session *ses);
void do_one_line(char *line, struct session *ses);
void snoop(char *buffer, struct session *ses);
void tintin_puts(char *cptr, struct session *ses);
void tintin_puts2(char *cptr, struct session *ses);
void tintin_puts3(char *cptr, struct session *ses);
void split_command(char *arg);
void unsplit_command(void);

/* misc.c */
void cr_command(struct session *ses);
void version_command(void);
void verbatim_command(void);
struct session *all_command(char *arg, struct session *ses);
void redraw_command(void);
void bell_command(struct session *ses);
void boss_command(struct session *ses);
void char_command(char *arg, struct session *ses);
void echo_command(struct session *ses);
void end_command(char *command, struct session *ses);
void ignore_command(struct session *ses);
void presub_command(struct session *ses);
void togglesubs_command(struct session *ses);
void showme_command(char *arg, struct session *ses);
void loop_command(char *arg, struct session *ses);
void message_command(char *arg, struct session *ses);
void snoop_command(char *arg, struct session *ses);
void speedwalk_command(struct session *ses);
void system_command(char *arg, struct session *ses);
struct session *zap_command(struct session *ses);
void wizlist_command(struct session *ses);
void tablist(struct completenode *tcomplete);
void tab_add(char *arg);
void tab_delete(char *arg);
void display_info(struct session *ses);

/* net.c */
int connect_mud(char *host, char *port, struct session *ses);
void write_line_mud(char *line, struct session *ses);
int read_buffer_mud(char *buffer, struct session *ses);
void do_telnet_protecol(int dat0, int dat1, int dat2, struct session *ses);

/* parse.c */
struct session *parse_input(char *input, struct session *ses);
int is_speedwalk_dirs(char *cp);
void do_speedwalk(char *cp, struct session *ses);
struct session *parse_tintin_command(char *command, char *arg, struct session *ses);
char *get_arg_all(char *s, char *arg);
char *get_arg_with_spaces(char *s, char *arg);
char *get_arg_in_braces(char *s, char *arg, int flag);
char *get_arg_stop_spaces(char *s, char *arg);
char *space_out(char *s);
void write_com_arg_mud(char *command, char *argument, struct session *ses);
void prompt(struct session *ses);

/* path.c */
void mark_command(struct session *ses);
void map_command(char *arg, struct session *ses);
void savepath_command(char *arg, struct session *ses);
void path_command(struct session *ses);
void return_command(struct session *ses);
void unpath_command(struct session *ses);
void check_insert_path(char *command, struct session *ses);
void pathdir_command(char *arg, struct session *ses);

/* session.c */
struct session *session_command(char *arg, struct session *ses);
void show_session(struct session *ses);
struct session *newactive_session(void);
struct session *new_session(char *name, char *address, struct session *ses);
void cleanup_session(struct session *ses);

/* substitute.c */
void parse_sub(char *arg, struct session *ses);
void unsubstitute_command(char *arg, struct session *ses);
void do_one_sub(char *line, struct session *ses);

/* text.c */
void read_file(char *arg, struct session *ses);

/* ticks.c */
void tick_command(struct session *ses);
void tickoff_command(struct session *ses);
void tickon_command(struct session *ses);
void tickset_command(struct session *ses);
void ticksize_command(char *arg, struct session *ses);

/* utils.c */
int is_abrev(char *s1, char *s2);
char *mystrdup(char *s);
void syserr(char *msg);

/* variables.c */
void var_command(char *arg, struct session *ses);
void unvar_command(char *arg, struct session *ses);
void substitute_myvars(char *arg, char *result, struct session *ses);
void tolower_command(char *arg, struct session *ses);
void toupper_command(char *arg, struct session *ses);
