#include "diff.h"

/* #include <sys/types.h>
#include <malloc.h> */

/* by Thorsten Ohl */

void huge *hrealloc(void huge *ptr, long new_size, long old_size)
{
  void huge *value = halloc(new_size, (size_t) 1);

  if ( !value )
    fatal("virtual memory exhausted");
  else
  {
    char huge *dest = value;
    char huge *src = ptr;

    while ( old_size > 0L )
    {
      unsigned int bytes = (unsigned int) min(0x8000L, old_size);
      memcpy(dest, src, bytes);
      old_size -= (long) bytes;
      dest += (long) bytes;
      src += (long) bytes;
    }
  }

  hfree (ptr);

  return value;
}
