    //////////////////////////////////////////////////////////////////////
// File - pci_lib.h
//
// Library for accessing a PCI card.
// Code was generated by WinDriver Wizard.
// It accesses hardware via WinDriver functions.
// 
//////////////////////////////////////////////////////////////////////

#ifndef _PCI_LIB_H_
#define _PCI_LIB_H_

#include "../../include/windrvr.h"
#include "../shared/pci_regs.h"
#include "../shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

// put the your PCI card's Vendor ID and Device ID here
enum { PCI_DEFAULT_VENDOR_ID = 0x0 };
enum { PCI_DEFAULT_DEVICE_ID = 0x0 };

typedef enum
{
    PCI_MODE_BYTE   = 0,
    PCI_MODE_WORD   = 1,
    PCI_MODE_DWORD  = 2
} PCI_MODE;

typedef enum
{
    PCI_AD_BAR0 = 0,
    PCI_AD_BAR1 = 1,
    PCI_AD_BAR2 = 2,
    PCI_AD_BAR3 = 3,
    PCI_AD_BAR4 = 4,
    PCI_AD_BAR5 = 5,
    PCI_AD_EPROM = 6,
    PCI_ITEMS = 7
} PCI_ADDR;

typedef struct PCI_STRUCT *PCI_HANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
} PCI_INT_RESULT;
typedef void (WINAPI *PCI_INT_HANDLER)( PCI_HANDLE hPCI, PCI_INT_RESULT *intResult);

typedef struct
{
    WD_INTERRUPT Int;
    HANDLE hThread;
    WD_TRANSFER Trans[1];
    PCI_INT_HANDLER funcIntHandler;
} PCI_INT_INTERRUPT;

typedef struct
{
    DWORD index;
    DWORD dwMask;
    BOOL  fIsMemory;
    BOOL  fActive;
} PCI_ADDR_DESC;

typedef struct PCI_STRUCT
{
    HANDLE hWD;
    BOOL   fUseInt;
    PCI_INT_INTERRUPT Int;
    WD_PCI_SLOT pciSlot;
    PCI_ADDR_DESC addrDesc[PCI_ITEMS];
    WD_CARD_REGISTER cardReg;
} PCI_STRUCT;

// options for PCI_Open
enum { PCI_OPEN_USE_INT =   0x1 };

BOOL PCI_Open (PCI_HANDLE *phPCI, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD options);
void PCI_Close(PCI_HANDLE hPCI);
DWORD PCI_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL PCI_IsAddrSpaceActive(PCI_HANDLE hPCI, PCI_ADDR addrSpace);

// General read/write function
void PCI_ReadWriteBlock(PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset, BOOL fRead, PVOID buf, DWORD dwBytes, PCI_MODE mode);
BYTE PCI_ReadByte (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset);
WORD PCI_ReadWord (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset);
DWORD PCI_ReadDword (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset);
void PCI_WriteByte (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset, BYTE data);
void PCI_WriteWord (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset, WORD data);
void PCI_WriteDword (PCI_HANDLE hPCI, PCI_ADDR addrSpace, DWORD dwOffset, DWORD data);
// handle interrupts
BOOL PCI_IntIsEnabled (PCI_HANDLE hPCI);
BOOL PCI_IntEnable (PCI_HANDLE hPCI, PCI_INT_HANDLER funcIntHandler);
void PCI_IntDisable (PCI_HANDLE hPCI);
// access to PCI configuration registers
void PCI_WritePCIReg(PCI_HANDLE hPCI, DWORD dwReg, DWORD dwData);
DWORD PCI_ReadPCIReg(PCI_HANDLE hPCI, DWORD dwReg);

// this string is set to an error message, if one occurs
extern CHAR PCI_ErrorString[];


#ifdef __cplusplus
}
#endif

#endif
